/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.options;

import com.icafe4j.image.ImageType;
import com.icafe4j.image.options.ImageOptions;
import com.icafe4j.image.tiff.TiffFieldEnum;
import com.icafe4j.io.ByteOrder;

public class TIFFOptions
extends ImageOptions {
    private boolean isApplyPredictor;
    private TiffFieldEnum.Compression tiffCompression = TiffFieldEnum.Compression.PACKBITS;
    private TiffFieldEnum.PhotoMetric photoMetric = TiffFieldEnum.PhotoMetric.UNKNOWN;
    private TiffFieldEnum.ResolutionUnit resolutionUnit = TiffFieldEnum.ResolutionUnit.RESUNIT_INCH;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    private int defalteCompressionLevel = 4;
    private boolean writeICCProfile;
    private int jpegQuality = 90;
    private int xResolution = 72;
    private int yResolution = 72;

    public TIFFOptions() {
    }

    public TIFFOptions(TIFFOptions tIFFOptions) {
        this.isApplyPredictor = tIFFOptions.isApplyPredictor;
        this.tiffCompression = tIFFOptions.tiffCompression;
        this.photoMetric = tIFFOptions.photoMetric;
        this.resolutionUnit = tIFFOptions.resolutionUnit;
        this.byteOrder = tIFFOptions.byteOrder;
        this.defalteCompressionLevel = tIFFOptions.defalteCompressionLevel;
        this.writeICCProfile = tIFFOptions.writeICCProfile;
        this.jpegQuality = tIFFOptions.jpegQuality;
        this.xResolution = tIFFOptions.xResolution;
        this.yResolution = tIFFOptions.yResolution;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public int getDeflateCompressionLevel() {
        return this.defalteCompressionLevel;
    }

    @Override
    public ImageType getImageType() {
        return ImageType.TIFF;
    }

    public int getJPEGQuality() {
        return this.jpegQuality;
    }

    public TiffFieldEnum.PhotoMetric getPhotoMetric() {
        return this.photoMetric;
    }

    public TiffFieldEnum.Compression getTiffCompression() {
        return this.tiffCompression;
    }

    public TiffFieldEnum.ResolutionUnit getResolutionUnit() {
        return this.resolutionUnit;
    }

    public int getXResolution() {
        return this.xResolution;
    }

    public int getYResolution() {
        return this.yResolution;
    }

    public boolean isApplyPredictor() {
        return this.isApplyPredictor;
    }

    public boolean writeICCProfile() {
        return this.writeICCProfile;
    }

    public void setApplyPredictor(boolean bl) {
        this.isApplyPredictor = bl;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public void setDeflateCompressionLevel(int n) {
        if (n >= 0 && n <= 9) {
            this.defalteCompressionLevel = n;
        }
    }

    public void setJPEGQuality(int n) {
        this.jpegQuality = n;
    }

    public void setPhotoMetric(TiffFieldEnum.PhotoMetric photoMetric) {
        this.photoMetric = photoMetric;
    }

    public void setResolutionUnit(TiffFieldEnum.ResolutionUnit resolutionUnit) {
        this.resolutionUnit = resolutionUnit;
    }

    public void setTiffCompression(TiffFieldEnum.Compression compression) {
        this.tiffCompression = compression;
    }

    public void setWriteICCProfile(boolean bl) {
        this.writeICCProfile = bl;
    }

    public void setXResolution(int n) {
        if (n > 0) {
            this.xResolution = n;
        }
    }

    public void setYResolution(int n) {
        if (n > 0) {
            this.yResolution = n;
        }
    }
}

