/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.icc;

import com.icafe4j.image.meta.Metadata;
import com.icafe4j.image.meta.MetadataEntry;
import com.icafe4j.image.meta.MetadataType;
import com.icafe4j.image.meta.icc.ProfileTag;
import com.icafe4j.image.meta.icc.ProfileTagTable;
import com.icafe4j.io.IOUtils;
import com.icafe4j.string.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ICCProfile
extends Metadata {
    public static final int TAG_TABLE_OFFSET = 128;
    private static final Logger LOGGER = LoggerFactory.getLogger(ICCProfile.class);
    private ICCProfileHeader header;
    private ProfileTagTable tagTable;

    public static void showProfile(byte[] byArray) {
        if (byArray != null && byArray.length > 0) {
            ICCProfile iCCProfile = new ICCProfile(byArray);
            try {
                iCCProfile.read();
                for (MetadataEntry metadataEntry : iCCProfile) {
                    LOGGER.info(metadataEntry.getKey() + ": " + metadataEntry.getValue());
                    if (!metadataEntry.isMetadataEntryGroup()) continue;
                    String string = "    ";
                    Collection<MetadataEntry> collection = metadataEntry.getMetadataEntries();
                    for (MetadataEntry metadataEntry2 : collection) {
                        LOGGER.info(string + metadataEntry2.getKey() + ": " + metadataEntry2.getValue());
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void showProfile(InputStream inputStream) {
        try {
            ICCProfile.showProfile(IOUtils.inputStreamToByteArray(inputStream));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public ICCProfile(byte[] byArray) {
        super(MetadataType.ICC_PROFILE, byArray);
        this.ensureDataRead();
    }

    public ICCProfile(InputStream inputStream) throws IOException {
        this(IOUtils.inputStreamToByteArray(inputStream));
    }

    public boolean canBeUsedIndependently() {
        return (this.header.profileFlags[0] >> 6 & 1) == 0;
    }

    public String getAsString(ProfileTag profileTag) {
        throw new UnsupportedOperationException("getAsString() is not implemented for ICCProfile");
    }

    public String getBytesReserved() {
        return StringUtils.byteArrayToHexString(this.header.bytesReserved);
    }

    public String getColorSpace() {
        return new String(this.header.colorSpace).trim();
    }

    public String getDateTimeCreated() {
        int n = IOUtils.readUnsignedShortMM(this.header.dateTimeCreated, 0);
        int n2 = IOUtils.readUnsignedShortMM(this.header.dateTimeCreated, 2);
        int n3 = IOUtils.readUnsignedShortMM(this.header.dateTimeCreated, 4);
        int n4 = IOUtils.readUnsignedShortMM(this.header.dateTimeCreated, 6);
        int n5 = IOUtils.readUnsignedShortMM(this.header.dateTimeCreated, 8);
        int n6 = IOUtils.readUnsignedShortMM(this.header.dateTimeCreated, 10);
        return n + "/" + n2 + "/" + n3 + ", " + n4 + ":" + n5 + ":" + n6;
    }

    public String getDeviceAttributes() {
        return (this.isReflective() ? "reflective" : "transparency") + ", " + (this.isGlossy() ? "glossy" : "matte") + ", " + (this.isPositive() ? "positive" : "negative") + ", " + (this.isColor() ? "color" : "black & white");
    }

    public String getDeviceManufacturer() {
        return new String(this.header.deviceManufacturer).trim();
    }

    public String getDeviceModel() {
        return new String(this.header.deviceModel).trim();
    }

    public String getPCS() {
        return new String(this.header.PCS).trim();
    }

    public float[] getPCSXYZ() {
        float f = IOUtils.readS15Fixed16MMNumber(this.header.PCSXYZ, 0);
        float f2 = IOUtils.readS15Fixed16MMNumber(this.header.PCSXYZ, 4);
        float f3 = IOUtils.readS15Fixed16MMNumber(this.header.PCSXYZ, 8);
        return new float[]{f, f2, f3};
    }

    public String getPreferredCMMType() {
        return new String(this.header.preferredCMMType).trim();
    }

    public String getPrimaryPlatformSignature() {
        return new String(this.header.primaryPlatformSignature).trim();
    }

    public String getProfileClass() {
        switch (this.header.profileClass) {
            case 1935896178: {
                return "scnr";
            }
            case 1835955314: {
                return "mntr";
            }
            case 1886549106: {
                return "prtr";
            }
            case 1818848875: {
                return "link";
            }
            case 1936744803: {
                return "spac";
            }
            case 1633842036: {
                return "abst";
            }
            case 1852662636: {
                return "nmcl";
            }
        }
        return "unknown";
    }

    public String getProfileClassDescription() {
        switch (this.header.profileClass) {
            case 1935896178: {
                return "'scnr': input devices - scanners and digital cameras";
            }
            case 1835955314: {
                return "'mntr': display devices - CRTs and LCDs";
            }
            case 1886549106: {
                return "'prtr': output devices - printers";
            }
            case 1818848875: {
                return "'link': device link profiles";
            }
            case 1936744803: {
                return "'spac': color space conversion profiles";
            }
            case 1633842036: {
                return "'abst': abstract profiles";
            }
            case 1852662636: {
                return "'nmcl': named color profiles";
            }
        }
        throw new IllegalArgumentException("Unknown profile/device class: " + this.header.profileClass);
    }

    public String getProfileCreator() {
        return new String(this.header.profileCreator).trim();
    }

    public String getProfileFileSignature() {
        return new String(this.header.profileFileSignature).trim();
    }

    public String getProfileFlags() {
        return (this.isEmbeddedInFile() ? "embedded in file" : "not embedded") + ", " + (this.canBeUsedIndependently() ? "used independently" : "cannot be used independently");
    }

    public String getProfileID() {
        return StringUtils.byteArrayToHexString(this.header.profileID);
    }

    public long getProfileSize() {
        return this.header.profileSize;
    }

    public String getProfileVersionNumber() {
        int n = this.header.profileVersionNumber[0] & 0xFF;
        int n2 = this.header.profileVersionNumber[1] >> 4 & 0xF;
        int n3 = this.header.profileVersionNumber[1] & 0xF;
        return "" + n + "." + n2 + n3;
    }

    public int getRenderingIntent() {
        return this.header.renderingIntent & 0xFFFF;
    }

    public String getRenderingIntentDescription() {
        switch (this.header.renderingIntent & 0xFFFF) {
            case 0: {
                return "perceptual";
            }
            case 1: {
                return "media-relative colorimetric";
            }
            case 2: {
                return "saturation";
            }
            case 3: {
                return "ICC-absolute colorimetric";
            }
        }
        throw new IllegalArgumentException("Unknown rendering intent: " + (this.header.renderingIntent & 0xFFFF));
    }

    public ProfileTagTable getTagTable() {
        return this.tagTable;
    }

    public boolean isColor() {
        return (this.header.deviceAttributes[0] >> 4 & 1) == 0;
    }

    public boolean isEmbeddedInFile() {
        return (this.header.profileFlags[0] >> 7 & 1) == 1;
    }

    public boolean isGlossy() {
        return (this.header.deviceAttributes[0] >> 6 & 1) == 0;
    }

    public boolean isPositive() {
        return (this.header.deviceAttributes[0] >> 5 & 1) == 0;
    }

    public boolean isReflective() {
        return (this.header.deviceAttributes[0] >> 7 & 1) == 0;
    }

    @Override
    public Iterator<MetadataEntry> iterator() {
        this.ensureDataRead();
        ArrayList<MetadataEntry> arrayList = new ArrayList<MetadataEntry>();
        MetadataEntry metadataEntry = new MetadataEntry("ICC Profile", "Header", true);
        metadataEntry.addEntry(new MetadataEntry("Profile Size", this.getProfileSize() + ""));
        metadataEntry.addEntry(new MetadataEntry("CMM Type", this.getPreferredCMMType()));
        metadataEntry.addEntry(new MetadataEntry("Version", this.getProfileVersionNumber() + ""));
        metadataEntry.addEntry(new MetadataEntry("Profile/Device Class", this.getProfileClassDescription()));
        metadataEntry.addEntry(new MetadataEntry("Color Space", this.getColorSpace()));
        metadataEntry.addEntry(new MetadataEntry("PCS", this.getPCS()));
        metadataEntry.addEntry(new MetadataEntry("Date Created", this.getDateTimeCreated()));
        metadataEntry.addEntry(new MetadataEntry("Profile File Signature", this.getProfileFileSignature()));
        metadataEntry.addEntry(new MetadataEntry("Primary Platform Signature", this.getPrimaryPlatformSignature()));
        metadataEntry.addEntry(new MetadataEntry("Flags", this.getProfileFlags()));
        metadataEntry.addEntry(new MetadataEntry("Device Manufacturer", this.getDeviceManufacturer()));
        metadataEntry.addEntry(new MetadataEntry("Device Model", this.getDeviceModel()));
        metadataEntry.addEntry(new MetadataEntry("Device Attributes", this.getDeviceAttributes()));
        metadataEntry.addEntry(new MetadataEntry("Rendering Intent", this.getRenderingIntentDescription()));
        metadataEntry.addEntry(new MetadataEntry("PCS Illuminant [X]", this.getPCSXYZ()[0] + ""));
        metadataEntry.addEntry(new MetadataEntry("PCS Illuminant [Y]", this.getPCSXYZ()[1] + ""));
        metadataEntry.addEntry(new MetadataEntry("PCS Illuminant [Z]", this.getPCSXYZ()[2] + ""));
        metadataEntry.addEntry(new MetadataEntry("Profile Creator", this.getProfileCreator()));
        metadataEntry.addEntry(new MetadataEntry("Profile ID", this.getProfileID()));
        arrayList.add(metadataEntry);
        MetadataEntry metadataEntry2 = new MetadataEntry("ICC Profile", "Tag Table", true);
        metadataEntry2.addEntry(new MetadataEntry("Tag Count", this.tagTable.getTagCount() + ""));
        List<ProfileTagTable.TagEntry> list = this.tagTable.getTagEntries();
        Collections.sort(list);
        for (ProfileTagTable.TagEntry tagEntry : list) {
            metadataEntry2.addEntry(new MetadataEntry("Tag Name", (Object)((Object)ProfileTag.fromInt(tagEntry.getProfileTag())) + ""));
            metadataEntry2.addEntry(new MetadataEntry("Data Offset", tagEntry.getDataOffset() + ""));
            metadataEntry2.addEntry(new MetadataEntry("Data Length", tagEntry.getDataLength() + ""));
        }
        arrayList.add(metadataEntry2);
        return Collections.unmodifiableCollection(arrayList).iterator();
    }

    @Override
    public void read() throws IOException {
        if (!this.isDataRead) {
            this.header = new ICCProfileHeader();
            this.tagTable = new ProfileTagTable();
            this.readHeader(this.data);
            this.readTagTable(this.data);
            this.isDataRead = true;
        }
    }

    private void readHeader(byte[] byArray) {
        this.header.profileSize = IOUtils.readUnsignedIntMM(byArray, 0);
        System.arraycopy(byArray, 4, this.header.preferredCMMType, 0, 4);
        System.arraycopy(byArray, 8, this.header.profileVersionNumber, 0, 4);
        this.header.profileClass = IOUtils.readIntMM(byArray, 12);
        System.arraycopy(byArray, 16, this.header.colorSpace, 0, 4);
        System.arraycopy(byArray, 20, this.header.PCS, 0, 4);
        System.arraycopy(byArray, 24, this.header.dateTimeCreated, 0, 12);
        System.arraycopy(byArray, 36, this.header.profileFileSignature, 0, 4);
        System.arraycopy(byArray, 40, this.header.primaryPlatformSignature, 0, 4);
        System.arraycopy(byArray, 44, this.header.profileFlags, 0, 4);
        System.arraycopy(byArray, 48, this.header.deviceManufacturer, 0, 4);
        System.arraycopy(byArray, 52, this.header.deviceModel, 0, 4);
        System.arraycopy(byArray, 56, this.header.deviceAttributes, 0, 8);
        this.header.renderingIntent = IOUtils.readIntMM(byArray, 64);
        System.arraycopy(byArray, 68, this.header.PCSXYZ, 0, 12);
        System.arraycopy(byArray, 80, this.header.profileCreator, 0, 4);
        System.arraycopy(byArray, 84, this.header.profileID, 0, 16);
        System.arraycopy(byArray, 100, this.header.bytesReserved, 0, 28);
    }

    private void readTagTable(byte[] byArray) {
        this.tagTable.read(byArray);
    }

    private static class ICCProfileHeader {
        private long profileSize;
        private byte[] preferredCMMType = new byte[4];
        private byte[] profileVersionNumber = new byte[4];
        private int profileClass;
        private byte[] colorSpace = new byte[4];
        private byte[] PCS = new byte[4];
        private byte[] dateTimeCreated = new byte[12];
        private byte[] profileFileSignature = new byte[4];
        private byte[] primaryPlatformSignature = new byte[4];
        private byte[] profileFlags = new byte[4];
        private byte[] deviceManufacturer = new byte[4];
        private byte[] deviceModel = new byte[4];
        private byte[] deviceAttributes = new byte[8];
        private int renderingIntent;
        private byte[] PCSXYZ = new byte[12];
        private byte[] profileCreator = new byte[4];
        private byte[] profileID = new byte[16];
        private byte[] bytesReserved = new byte[28];

        private ICCProfileHeader() {
        }
    }
}

