/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.adobe;

import com.icafe4j.image.meta.MetadataEntry;
import com.icafe4j.image.meta.adobe.ColorSpaceID;
import com.icafe4j.image.meta.adobe.DDBEntry;
import com.icafe4j.image.meta.adobe.DataBlockType;
import com.icafe4j.io.ReadStrategy;
import java.util.Arrays;

public class FilterMask
extends DDBEntry {
    private int colorSpaceId;
    private int[] colors = new int[4];
    private int opacity;

    public FilterMask(int n, byte[] byArray, ReadStrategy readStrategy) {
        super(DataBlockType.FMsk, n, byArray, readStrategy);
        this.read();
    }

    public int[] getColors() {
        return (int[])this.colors.clone();
    }

    public int getOpacity() {
        return this.opacity;
    }

    public int getColorSpace() {
        return this.colorSpaceId;
    }

    public ColorSpaceID getColorSpaceID() {
        return ColorSpaceID.fromInt(this.colorSpaceId);
    }

    @Override
    protected MetadataEntry getMetadataEntry() {
        MetadataEntry metadataEntry = new MetadataEntry(DataBlockType.FMsk.name(), DataBlockType.FMsk.getDescription(), true);
        metadataEntry.addEntry(new MetadataEntry("Size", this.getSize() + ""));
        metadataEntry.addEntry(new MetadataEntry("Color Space", this.getColorSpaceID().name()));
        metadataEntry.addEntry(new MetadataEntry("Color Values", Arrays.toString(this.colors)));
        metadataEntry.addEntry(new MetadataEntry("Opacity", this.opacity + ""));
        return metadataEntry;
    }

    private void read() {
        int n = 0;
        this.colorSpaceId = this.readStrategy.readShort(this.data, n);
        this.colors[0] = this.readStrategy.readUnsignedShort(this.data, n += 2);
        this.colors[1] = this.readStrategy.readUnsignedShort(this.data, n += 2);
        this.colors[2] = this.readStrategy.readUnsignedShort(this.data, n += 2);
        this.colors[3] = this.readStrategy.readUnsignedShort(this.data, n += 2);
        this.opacity = this.readStrategy.readShort(this.data, n += 2);
    }
}

