/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.compression.lzw;

import com.icafe4j.image.compression.ImageEncoder;
import com.icafe4j.util.Updatable;
import java.io.OutputStream;
import java.util.Arrays;

public class LZWTreeEncoder
implements ImageEncoder {
    private int codeSize;
    private int codeLen;
    private int codeIndex;
    private int clearCode;
    private int endOfImage;
    private int limit;
    private boolean firstTime;
    private int[] child = new int[4097];
    private int[] siblings = new int[4097];
    private int[] suffix = new int[4097];
    private int parent = 0;
    private int bufIndex;
    private int empty_bits;
    private int buf_length;
    private byte[] bytes_buf;
    private OutputStream os;
    private boolean isTIFF = false;
    private Updatable<Integer> writer;
    private static final short[] MASK = new short[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
    int compressedDataLen = 0;

    public LZWTreeEncoder(OutputStream outputStream, int n, int n2) {
        this.codeSize = n;
        this.bytes_buf = new byte[n2];
        this.buf_length = n2;
        this.os = outputStream;
    }

    public LZWTreeEncoder(OutputStream outputStream, int n, int n2, Updatable<Integer> updatable) {
        this(outputStream, n, n2);
        this.isTIFF = true;
        this.writer = updatable;
    }

    @Override
    public void encode(byte[] byArray, int n, int n2) throws Exception {
        if (n < 0 || n2 <= 0) {
            return;
        }
        if (n + n2 > byArray.length) {
            n2 = byArray.length - n;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (this.firstTime) {
            this.parent = byArray[n++] & 0xFF;
            ++n6;
            this.firstTime = false;
        }
        block0: while (n6 < n2) {
            n5 = byArray[n++] & 0xFF;
            ++n6;
            n3 = this.child[this.parent];
            if (n3 > 0) {
                if (this.suffix[n3] == n5) {
                    this.parent = n3;
                    continue;
                }
                n4 = n3;
                while (this.siblings[n4] > 0) {
                    if (this.suffix[n4 = this.siblings[n4]] != n5) continue;
                    this.parent = n4;
                    continue block0;
                }
                this.siblings[n4] = this.codeIndex;
                this.suffix[this.codeIndex] = n5;
                this.send_code_to_buffer(this.parent);
                this.parent = n5;
                ++this.codeIndex;
                if (this.codeIndex <= (this.isTIFF ? this.limit - 1 : this.limit)) continue;
                if (this.codeLen == 12) {
                    this.send_code_to_buffer(this.clearCode);
                    this.init_encoder(this.codeSize);
                    continue;
                }
                ++this.codeLen;
                this.limit = 1 << this.codeLen;
                continue;
            }
            this.child[this.parent] = this.codeIndex;
            this.suffix[this.codeIndex] = n5;
            this.send_code_to_buffer(this.parent);
            this.parent = n5;
            ++this.codeIndex;
            if (this.codeIndex <= (this.isTIFF ? this.limit - 1 : this.limit)) continue;
            if (this.codeLen == 12) {
                this.send_code_to_buffer(this.clearCode);
                this.init_encoder(this.codeSize);
                continue;
            }
            ++this.codeLen;
            this.limit = 1 << this.codeLen;
        }
    }

    @Override
    public void finish() throws Exception {
        this.send_code_to_buffer(this.parent);
        this.send_code_to_buffer(this.endOfImage);
        this.flush_buf(this.bufIndex + 1);
        if (this.isTIFF && this.writer != null) {
            this.writer.update(this.compressedDataLen);
        }
    }

    private void flush_buf(int n) throws Exception {
        if (!this.isTIFF) {
            this.os.write(n);
        }
        this.os.write(this.bytes_buf, 0, n);
        this.bufIndex = 0;
        Arrays.fill(this.bytes_buf, 0, n, (byte)0);
        this.compressedDataLen += n;
    }

    @Override
    public int getCompressedDataLen() {
        return this.compressedDataLen;
    }

    private void init_encoder(int n) {
        Arrays.fill(this.child, 0);
        Arrays.fill(this.siblings, 0);
        this.codeLen = n + 1;
        this.limit = 1 << this.codeLen;
        this.codeIndex = this.endOfImage + 1;
    }

    @Override
    public void initialize() throws Exception {
        this.clearCode = 1 << this.codeSize;
        this.endOfImage = this.clearCode + 1;
        this.firstTime = true;
        this.empty_bits = 8;
        this.compressedDataLen = 0;
        this.init_encoder(this.codeSize);
        if (!this.isTIFF) {
            this.os.write(this.codeSize);
        }
        this.send_code_to_buffer(this.clearCode);
    }

    private void send_code_to_buffer(int n) throws Exception {
        int n2 = this.codeLen;
        if (this.isTIFF) {
            int n3 = this.bufIndex;
            this.bytes_buf[n3] = (byte)(this.bytes_buf[n3] | n >>> n2 & MASK[this.empty_bits]);
            for (n2 = this.codeLen - this.empty_bits; n2 > 8; n2 -= 8) {
                if (++this.bufIndex >= this.buf_length) {
                    this.flush_buf(this.buf_length);
                }
                int n4 = this.bufIndex;
                this.bytes_buf[n4] = (byte)(this.bytes_buf[n4] | n >>> n2 - 8 & MASK[8]);
            }
            if (n2 > 0) {
                if (++this.bufIndex >= this.buf_length) {
                    this.flush_buf(this.buf_length);
                }
                int n5 = this.bufIndex;
                this.bytes_buf[n5] = (byte)(this.bytes_buf[n5] | (n & MASK[n2]) << 8 - n2);
                n2 -= 8;
            }
        } else {
            int n6 = this.bufIndex;
            this.bytes_buf[n6] = (byte)(this.bytes_buf[n6] | (n & MASK[this.empty_bits]) << 8 - this.empty_bits);
            n >>= this.empty_bits;
            n2 -= this.empty_bits;
            while (n2 > 0) {
                if (++this.bufIndex >= this.buf_length) {
                    this.flush_buf(this.buf_length);
                }
                int n7 = this.bufIndex;
                this.bytes_buf[n7] = (byte)(this.bytes_buf[n7] | n & 0xFF);
                n >>= 8;
                n2 -= 8;
            }
        }
        this.empty_bits = -n2;
    }
}

