/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.compression.lzw;

public class LZWCompressionTable {
    private static final int RES_CODES = 2;
    private static final short EMPTY = -1;
    private static final int MAXBITS = 12;
    private static final int MAXSTR = 4096;
    private static final short HASHSIZE = 9973;
    private static final short HASHSTEP = 2039;
    byte[] strChr_ = new byte[4096];
    short[] strPref_ = new short[4096];
    short[] strHsh_ = new short[9973];
    short numStrings_;

    public int addCharString(short s, byte by) {
        if (this.numStrings_ >= 4096) {
            return 65535;
        }
        int n = LZWCompressionTable.hash(s, by);
        while (this.strHsh_[n] != -1) {
            n = (n + 2039) % 9973;
        }
        this.strHsh_[n] = this.numStrings_;
        this.strChr_[this.numStrings_] = by;
        this.strPref_[this.numStrings_] = s;
        short s2 = this.numStrings_;
        this.numStrings_ = (short)(s2 + 1);
        return s2;
    }

    public short findCharString(short s, byte by) {
        short s2;
        if (s == -1) {
            return by;
        }
        int n = LZWCompressionTable.hash(s, by);
        while ((s2 = this.strHsh_[n]) != -1) {
            if (this.strPref_[s2] == s && this.strChr_[s2] == by) {
                return s2;
            }
            n = (n + 2039) % 9973;
        }
        return -1;
    }

    public void clearTable(int n) {
        int n2;
        this.numStrings_ = 0;
        for (n2 = 0; n2 < 9973; ++n2) {
            this.strHsh_[n2] = -1;
        }
        n2 = (1 << n) + 2;
        for (int i = 0; i < n2; ++i) {
            this.addCharString((short)-1, (byte)i);
        }
    }

    private static int hash(short s, byte by) {
        return (((short)(by << 8) ^ s) & 0xFFFF) % 9973;
    }
}

