/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.compression.deflate;

import com.icafe4j.image.compression.ImageEncoder;
import com.icafe4j.util.Updatable;
import java.io.OutputStream;
import java.util.zip.Deflater;

public class DeflateEncoder
implements ImageEncoder {
    private byte[] buffer;
    private Deflater deflater;
    private OutputStream os;
    private Updatable<Integer> writer;
    private boolean isTIFF;

    public DeflateEncoder(OutputStream outputStream, int n, int n2) {
        this.os = outputStream;
        this.buffer = new byte[n];
        this.deflater = new Deflater(n2);
    }

    public DeflateEncoder(OutputStream outputStream, int n, int n2, Updatable<Integer> updatable) {
        this(outputStream, n, n2);
        this.writer = updatable;
        this.isTIFF = true;
    }

    @Override
    public void encode(byte[] byArray, int n, int n2) throws Exception {
        int n3;
        this.deflater.setInput(byArray, n, n2);
        this.deflater.finish();
        while (!this.deflater.finished() && (n3 = this.deflater.deflate(this.buffer)) > 0) {
            this.os.write(this.buffer, 0, n3);
        }
    }

    @Override
    public void finish() throws Exception {
        if (this.isTIFF && this.writer != null) {
            this.writer.update(this.deflater.getTotalOut());
        }
    }

    @Override
    public int getCompressedDataLen() {
        return this.deflater.getTotalOut();
    }

    @Override
    public void initialize() throws Exception {
        this.deflater.reset();
    }
}

