/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image;

import com.icafe4j.image.ImageColorType;
import com.icafe4j.image.options.ImageOptions;
import com.icafe4j.image.quant.DitherMethod;
import com.icafe4j.image.quant.QuantMethod;
import com.icafe4j.image.quant.QuantQuality;
import com.icafe4j.util.Builder;
import java.awt.image.BufferedImage;

public class ImageParam {
    private final int width;
    private final int height;
    private final int bitsPerPixel;
    private final ImageColorType colorType;
    private final int[] rgbColorPalette;
    private final byte[][] componentColorPalette;
    private final boolean hasAlpha;
    private final boolean isApplyDither;
    private final int[][] ditherMatrix;
    private final DitherMethod ditherMethod;
    private final QuantMethod quantMethod;
    private final QuantQuality quantQuality;
    private final boolean transparent;
    private final int transparentColor;
    private final boolean hasICCP;
    private final byte[] icc_profile;
    private final boolean containsThumbnail;
    private final BufferedImage[] thumbnails;
    private final ImageOptions imageOptions;
    public static final ImageParam DEFAULT_IMAGE_PARAM = new ImageParamBuilder().build();
    private static final DitherMethod DEFAULT_DITHER_METHOD = DitherMethod.FLOYD_STEINBERG;
    private static final QuantMethod DEFAULT_QUANT_METHOD = QuantMethod.POPULARITY;
    private static final QuantQuality DEFAULT_QUANT_QUALITY = QuantQuality.GOOD;
    private static final int[][] DEFAULT_DITHER_MATRIX = new int[][]{{1, 49, 13, 61, 4, 52, 16, 64}, {33, 17, 45, 29, 36, 20, 48, 32}, {9, 57, 5, 53, 12, 60, 8, 56}, {41, 25, 37, 21, 44, 28, 40, 24}, {3, 51, 15, 63, 2, 50, 14, 62}, {35, 19, 47, 31, 34, 18, 46, 30}, {11, 59, 7, 55, 10, 58, 6, 54}, {43, 27, 39, 23, 42, 26, 38, 22}};

    private ImageParam(ImageParamBuilder imageParamBuilder) {
        this.width = imageParamBuilder.width;
        this.height = imageParamBuilder.height;
        this.bitsPerPixel = imageParamBuilder.bitsPerPixel;
        this.colorType = imageParamBuilder.colorType;
        this.rgbColorPalette = imageParamBuilder.rgbColorPalette;
        this.componentColorPalette = imageParamBuilder.componentColorPalette;
        this.hasAlpha = imageParamBuilder.hasAlpha;
        this.isApplyDither = imageParamBuilder.applyDither;
        this.ditherMatrix = imageParamBuilder.ditherMatrix;
        this.ditherMethod = imageParamBuilder.ditherMethod;
        this.quantMethod = imageParamBuilder.quantMethod;
        this.quantQuality = imageParamBuilder.quantQuality;
        this.transparentColor = imageParamBuilder.transparentColor;
        this.transparent = imageParamBuilder.transparent;
        this.hasICCP = imageParamBuilder.hasICCP;
        this.icc_profile = imageParamBuilder.icc_profile;
        this.containsThumbnail = imageParamBuilder.containsThumbnail;
        this.thumbnails = imageParamBuilder.thumbnails;
        this.imageOptions = imageParamBuilder.imageOptions;
    }

    public boolean containsThumbnail() {
        return this.containsThumbnail;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public static ImageParamBuilder getBuilder() {
        return new ImageParamBuilder();
    }

    public ImageColorType getColorType() {
        return this.colorType;
    }

    public byte[][] getComponentColorPalette() {
        return this.componentColorPalette;
    }

    public int[][] getDitherMatrix() {
        int[][] nArrayArray = new int[this.ditherMatrix.length][];
        for (int i = 0; i < this.ditherMatrix.length; ++i) {
            nArrayArray[i] = (int[])this.ditherMatrix[i].clone();
        }
        return nArrayArray;
    }

    public DitherMethod getDitherMethod() {
        return this.ditherMethod;
    }

    public QuantMethod getQuantMethod() {
        return this.quantMethod;
    }

    public QuantQuality getQuantQuality() {
        return this.quantQuality;
    }

    public byte[] getICCProfile() {
        return this.icc_profile;
    }

    public int getImageHeight() {
        return this.height;
    }

    public ImageOptions getImageOptions() {
        return this.imageOptions;
    }

    public int getImageWidth() {
        return this.width;
    }

    public int[] getRGBColorPalette() {
        return this.rgbColorPalette;
    }

    public BufferedImage[] getThumbnails() {
        return this.thumbnails;
    }

    public int getTransparentColor() {
        return this.transparentColor;
    }

    public boolean hasAlpha() {
        return this.hasAlpha;
    }

    public boolean hasICCP() {
        return this.hasICCP;
    }

    public boolean isApplyDither() {
        return this.isApplyDither;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public static class ImageParamBuilder
    implements Builder<ImageParam> {
        private int width;
        private int height;
        private int bitsPerPixel;
        private ImageColorType colorType = ImageColorType.FULL_COLOR;
        private int[] rgbColorPalette;
        private byte[][] componentColorPalette;
        private boolean hasAlpha = false;
        private boolean applyDither = false;
        private DitherMethod ditherMethod = ImageParam.access$2000();
        private QuantMethod quantMethod = ImageParam.access$2100();
        private QuantQuality quantQuality = ImageParam.access$2200();
        private int[][] ditherMatrix = ImageParam.access$2300();
        private boolean transparent = false;
        private int transparentColor;
        private boolean hasICCP = false;
        private byte[] icc_profile;
        private boolean containsThumbnail = false;
        private BufferedImage[] thumbnails;
        private ImageOptions imageOptions;

        private ImageParamBuilder() {
        }

        public ImageParamBuilder applyDither(boolean bl) {
            this.applyDither = bl;
            return this;
        }

        public ImageParamBuilder bitsPerPixel(int n) {
            this.bitsPerPixel = n;
            return this;
        }

        @Override
        public ImageParam build() {
            return new ImageParam(this);
        }

        public ImageParamBuilder colorType(ImageColorType imageColorType) {
            this.colorType = imageColorType;
            return this;
        }

        public ImageParamBuilder componentColorPalette(byte[][] byArray) {
            this.componentColorPalette = byArray;
            return this;
        }

        public ImageParamBuilder containsThumbnail(boolean bl) {
            this.containsThumbnail = bl;
            return this;
        }

        public ImageParamBuilder ditherMatrix(int[][] nArray) {
            this.ditherMatrix = nArray;
            return this;
        }

        public ImageParamBuilder ditherMethod(DitherMethod ditherMethod) {
            this.ditherMethod = ditherMethod;
            return this;
        }

        public ImageParamBuilder quantMethod(QuantMethod quantMethod) {
            this.quantMethod = quantMethod;
            return this;
        }

        public ImageParamBuilder quantQuanlity(QuantQuality quantQuality) {
            this.quantQuality = quantQuality;
            return this;
        }

        public ImageParamBuilder hasAlpha(boolean bl) {
            this.hasAlpha = bl;
            return this;
        }

        public ImageParamBuilder hasICCP(boolean bl) {
            this.hasICCP = bl;
            return this;
        }

        public ImageParamBuilder height(int n) {
            this.height = n;
            return this;
        }

        public ImageParamBuilder iccProfile(byte[] byArray) {
            this.icc_profile = byArray;
            return this;
        }

        public ImageParamBuilder imageOptions(ImageOptions imageOptions) {
            this.imageOptions = imageOptions;
            return this;
        }

        public void reset() {
            this.width = 0;
            this.height = 0;
            this.bitsPerPixel = 0;
            this.colorType = ImageColorType.FULL_COLOR;
            this.rgbColorPalette = null;
            this.componentColorPalette = null;
            this.hasAlpha = false;
            this.applyDither = false;
            this.ditherMatrix = DEFAULT_DITHER_MATRIX;
            this.ditherMethod = DEFAULT_DITHER_METHOD;
            this.quantMethod = DEFAULT_QUANT_METHOD;
            this.quantQuality = DEFAULT_QUANT_QUALITY;
            this.transparent = false;
            this.transparentColor = 0;
            this.hasICCP = false;
            this.icc_profile = null;
            this.containsThumbnail = false;
            this.thumbnails = null;
            this.imageOptions = null;
        }

        public ImageParamBuilder rgbColorPalette(int[] nArray) {
            this.rgbColorPalette = nArray;
            return this;
        }

        public ImageParamBuilder thumbnails(BufferedImage[] bufferedImageArray) {
            this.thumbnails = bufferedImageArray;
            return this;
        }

        public ImageParamBuilder transparent(boolean bl) {
            this.transparent = bl;
            return this;
        }

        public ImageParamBuilder transparentColor(int n) {
            this.transparentColor = n;
            return this;
        }

        public ImageParamBuilder width(int n) {
            this.width = n;
            return this;
        }
    }
}

