/*
 * dcraw-aros.h - AROS stuff for dcraw
 *
 * AROS port by:
 *   Olivier Tigreat        olivier o tigreat a gmail o com
 *
 * Thanks to
 *   Dave Coffin
 *     for this wonderful tool
 *   Massimiliano Scarano   mscarano a libero o it
 *   Domenico Lattanzi      domenico o lattanzi a domenicolattanzi o it
 *     for the M680x0 AmigaOS port
 *   The AROS Team
 *     for the most promising OS
 *  
 * 07 jan 08
 */

#ifdef __AROS__

#include <exec/types.h>

/*
 *  mettre  jour  chaque nouvelle version/revision
 * to be updated before compiling a new version/revision
 */
#define REVISION "1.399"
#define DATEORIG "Mar  5 2008"

static const char version[] = "$VER: dcraw "VERSION" Revision "REVISION" from "DATEORIG" (port date: "__DATE__")";

/*
 * defined (to NO) until I find working ones...
 */
#define NO_JPEG
#define NO_LCMS

/*
 * Other miscellaneous defines...
 */
#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif
#ifndef strcasecmp
#define strcasecmp stricmp
#endif
#ifndef strncasecmp
#define strncasecmp strnicmp
#endif
#ifndef ftello
#define ftello ftell
#endif
#ifndef fseeko
#define fseeko fseek
#endif
#ifndef getc_unlocked
#define getc_unlocked fgetc
#endif

#endif // __AROS__
