
// #define DEBUG_MODE 1

#include <pptplugin.h>
#include "convolute.h"
#include <string.h>
#include <stdlib.h>

#include <exec/memory.h>

/*--------------------------------------------------------------------*/

/*
    Returns filter size or zero if filter is not OK
*/

int SetFilterSize( struct convargs *c )
{
    int i,j;
    int c3 = 0,c5 = 0,c7 = 0;

    for(i = 0; i < 7; i++) {
        for( j = 0; j < 7; j++ ) {
            if( i == 0 || i == 6 || j == 0 || j == 6) {
                if( c->weights[i][j] != 0) {
#ifdef DEBUG_MODE
                    PDebug("7:@%d,%d = %d\n",i,j,c->weights[i][j]);
#endif
                    c7++;
                }
            }
            if( ((abs(3-i) == 2) && (abs(3-j) <= 2)) ||
                ((abs(3-i) <= 2) && (abs(3-j) == 2))   ) {
                if(c->weights[i][j] != 0) {
#ifdef DEBUG_MODE
                    PDebug("5:@%d,%d = %d\n",i,j,c->weights[i][j]);
#endif
                    c5++;
                }
            }
            if( ((abs(3-i) == 1) && (abs(3-j) <= 1)) ||
                ((abs(3-i) <= 1) && (abs(3-j) == 1))    ) {
                if(c->weights[i][j] != 0) {
#ifdef DEBUG_MODE
                    PDebug("3:@%d,%d = %d\n",i,j,c->weights[i][j]);
#endif
                    c3++;
                }
            }
        }
    }

    if(c7) {
        c->size = 7;
        return 7;
    }
    if(c5) {
        c->size = 5;
        return 5;
    }
    if(c3) {
        c->size = 3;
        return 3;
    }
    if(c->weights[3][3] == 0)
        return 0;

    c->size = 1;
    return 1;
}

int LoadConvFilter( struct PPTBase *PPTBase, char *name, struct convargs *cargs )
{
    BPTR fh;
    APTR DOSBase = PPTBase->lb_DOS;
    char buf[128], *s, namebuf[256];
    int i,line = 0;
    BOOL quit = FALSE;

    /*
     *  Attempts to open files at the following order:
     *      1. filename
     *      2. PROGDIR:modules/convolutions/filename
     */

    fh = Open(name, MODE_OLDFILE);
    if(!fh) {
        strcpy( namebuf, "PROGDIR:modules/convolutions" );
        AddPart(namebuf, name, 255);
        if( !(fh = Open(namebuf, MODE_OLDFILE)) ) {
            return PERR_FILEOPEN;
        }
    }

    while(!quit) {
        if(FGets( fh, buf, 127 ) == NULL)
            quit = TRUE;
        else {
            if(buf[0] != ';' && buf[0] != '\n' && buf[0] != '\0') {
                char *f;

                switch(line) {
                    case 0:
                        cargs->size = atoi(buf);
                        break;
                    case 1:
                        cargs->bias = atoi(buf);
                        break;
                    case 2:
                        cargs->div = atoi(buf);
                        break;
                    default:
                        s = &buf[0];
                        for(i = 0; i < 7; i++) {
                            f = strchr(s,' ');
                            if(f) *f = '\0';
                            cargs->weights[line-3][i] = atoi(s);
                            s = f+1;
                        }
                        break;
                }
                line++;
            }
        }
    }
    Close(fh);
    return PERR_OK;
}

/*
    Write a filter on the disk
    BUG: Writes currently all weights, instead of just the necessary ones.
*/

void SaveConvFilter( struct PPTBase *PPTBase, char *name, struct convargs *cargs )
{
    APTR DOSBase = PPTBase->lb_DOS;
    BPTR fh;
    char buf[128];
    int i,j;

#ifdef DEBUG_MODE
    PDebug("SaveConvFilter()\n\tOpening file '%s'", name);
#endif

    fh = Open( name, MODE_NEWFILE );
    if(fh) {
#ifndef __PPC__
        sprintf(buf,"; PPT Convolution file\n; Generated by "MYNAME"\n" );
#endif
        FPuts(fh,buf);
        sprintf(buf,"%d\n%d\n%d\n",cargs->size,cargs->bias,cargs->div);
        FPuts(fh,buf);
        for(i = 0; i < 7; i++) {
            for(j = 0; j < 7; j++) {
                sprintf(buf,"%d ",cargs->weights[i][j]);
                FPuts(fh,buf);
            }
            FPutC(fh,'\n');
        }
        Close(fh);
    }
    /* BUG: Should warn! */
}

/*
    This does the real convolution.
    BUG: Does not adhere to my own specs... PutPixelRow() uses wrong arg dcp
*/

int DoConvolute( FRAME *src, FRAME *dest, struct convargs *cargs, struct PPTBase *PPTBase )
{
    UWORD row, xstart = src->selbox.MinX, xend = src->selbox.MaxX;
    WORD crow;
    int d;
    PERROR res = PERR_OK;
    UBYTE buf[40],cspace = src->pix->colorspace;
    ULONG xoffset;
    ROWPTR buffer[7]; /* Has room for 7x7 matrices */

#ifdef DEBUG_MODE
    PDebug("\tDoConvolute()\n");
#endif

    if(SetFilterSize( cargs ) == 0)
        return PERR_GENERAL;

    sprintf(buf,"Convolute: %s [%dx%d]...",cargs->name,cargs->size, cargs->size);

    InitProgress( src, buf, src->selbox.MinY, src->selbox.MaxY );

    d = cargs->size >> 1;
#ifdef DEBUG_MODE
    PDebug("\tConvolution matrix size is %d x %d (%d...%d)\n",cargs->size,cargs->size,-d,d);
#endif
    xoffset = xstart * src->pix->components;

    /*
     *  Do the convolute.
     */

    for( row = src->selbox.MinY; row < src->selbox.MaxY; row++ ) {
        ROWPTR dcp, dcp2;
        WORD col;

        dcp2 = dcp = GetPixelRow( dest, row );
        dcp += xoffset;
        if(GetNPixelRows( src, buffer, row - d, cargs->size ) == 0) {
            res = PERR_GENERAL;
            goto quit;
        }

        if(Progress( src, row )) {
            res = PERR_BREAK;
            goto quit;
        }

        for( col = xstart; col < xend; col++ ) {
            int i;
            LONG valr,valg,valb,vala;

            /*
             *  Now, go through all values
             */

            valr = valb = valg = vala = 0L;

            for(i = -d; i <= d; i++) {
                UBYTE *scp;

                crow = row + i;
                scp = buffer[ i + d ];

                if( crow >= 0 && crow < src->pix->height ) {
                    int j;

                    for(j = -d; j <= d; j++ ) {
                        WORD ccol;

                        ccol = (WORD)col + j;
                        if( ccol >= 0 && ccol < src->pix->width ) {
                            /* Actual convolution */
                            int wt;
                            if( ( wt = cargs->weights[i+3][j+3]) ) {
                                UBYTE *pptr;
                                switch(cspace) {
                                    case CS_RGB:
                                        pptr = scp + MULS16(ccol,3);
                                        valr += (*pptr++) * wt;
                                        valg += (*pptr++) * wt;
                                        valb += (*pptr++) * wt;
                                        break;

                                    case CS_GRAYLEVEL:
                                        pptr = scp + ccol;
                                        valr += (*pptr++) *wt;
                                        break;

                                    case CS_ARGB:
                                        pptr = scp + (ccol<<2);
                                        if( i == 0 && j == 0 ) vala = *pptr;
                                        pptr++; /* Skip alpha */
                                        valr += (*pptr++) * wt;
                                        valg += (*pptr++) * wt;
                                        valb += (*pptr++) * wt;
                                        break;
                                }
                            }
                        } /* if ccol */
                    }
                } /* if crow */
            }

            switch(cspace) {
                case CS_GRAYLEVEL:
                    valr = valr / cargs->div + cargs->bias;
                    if(valr < 0) valr = 0;
                    else { if(valr > 255) valr = 255; }
                    *dcp++ = (UBYTE)valr;
                    break;

                case CS_ARGB:
                    *dcp++ = vala;
                    /* FALLTHROUGH INTENDED */

                case CS_RGB:
                    /* RED  */
                    valr = valr / cargs->div + cargs->bias;
                    if(valr < 0) valr = 0;
                    else { if(valr > 255) valr = 255; }
                    *dcp++ = (UBYTE)valr;

                    /* GREEN*/
                    valg = valg / cargs->div + cargs->bias;
                    if(valg < 0) valg = 0;
                    else { if(valg > 255) valg = 255; }
                    *dcp++ = (UBYTE)valg;

                    /* BLUE */
                    valb = valb / cargs->div + cargs->bias;
                    if(valb < 0) valb = 0;
                    else { if(valb > 255) valb = 255; }
                    *dcp++ = (UBYTE)valb;
                    break;
            }

        }
        PutPixelRow( dest, row, dcp2 );

    }
quit:
    FinishProgress(src);

    return res;
}
