/*
    PROJECT: ppt
    MODULE:  C-code

    A new style loader.

    $Id: c-code.c,v 3.1 2000/11/17 03:02:28 jalkanen Exp $
*/

#include <pptplugin.h>
#include <ctype.h>
#include <string.h>

/*----------------------------------------------------------------------*/
/* Defines */

/*
    You should define this to your module name. Try to use something
    short, as this is the name that is visible in the PPT filter listing.
*/

#define MYNAME      "C-code"

/*----------------------------------------------------------------------*/
/* Global variables. Generally, you should keep these to the minimum,
   as it may well be that two copies of this same code is run at
   the same time. */

/*
    Just a simple string describing this effect.
*/

const char infoblurb[] =
    "Saves chunky C code.";

/*
    This is the global array describing your effect. For a more detailed
    description on how to interpret and use the tags, see docs/tags.doc.
*/

const struct TagItem MyTagArray[] = {

    /*
     *  Tells the capabilities of this loader/saver unit.
     */

    PPTX_Load,          FALSE,
    PPTX_ColorSpaces,   CSF_RGB|CSF_GRAYLEVEL|CSF_LUT,

    /*
     *  Here are some pretty standard definitions. All iomodules should have
     *  these defined.
     */

    PPTX_Name,          (ULONG) MYNAME,

    /*
     *  Other tags go here. These are not required, but very useful to have.
     */

    PPTX_Author,        (ULONG)"Janne Jalkanen 1997-1999",
    PPTX_InfoTxt,       (ULONG)infoblurb,

    PPTX_RexxTemplate,  (ULONG)"",

    PPTX_ReqPPTVersion, 4,

    PPTX_PreferredPostFix,(ULONG)".c",

    PPTX_SupportsGetArgs, TRUE,

    TAG_END, 0L
};


/*----------------------------------------------------------------------*/
/* Code */

#ifdef __SASC
/* Disable SAS/C control-c handling. */
void __regargs __chkabort(void) {}
void __regargs _CXBRK(void) {}
#endif


IOINQUIRE(attr,PPTBase,IOModuleBase)
{
    return TagData( attr, MyTagArray );
}

/*
    This must always exist!
*/

IOCHECK(fh,len,buf,PPTBase,IOModuleBase)
{
    D(bug("IOCheck()\n"));
    return FALSE;
}

IOLOAD(fh,frame,tags,PPTBase,IOModuleBase)
{
    D(bug("IOLoad()\n"));
    SetErrorCode(frame,PERR_MISSINGCODE);
    return PERR_ERROR;
}


PERROR fhprintf(BPTR fh, struct PPTBase *PPTBase, const char *c, ... )
{
    va_list va;
    char buf[4096];
    struct DosLibrary *DOSBase = PPTBase->lb_DOS;

    va_start(va,c);
    vsprintf(buf,c,va);
    va_end(va);

    if(FPuts(fh,buf))
        return PERR_FILEWRITE;

    return PERR_OK;
}

PERROR WriteHeader( FRAME *frame, STRPTR basename, BPTR fh, struct PPTBase *PPTBase )
{
    struct Extension *anno;
    PERROR res;

    anno = FindExtension(frame,EXTNAME_ANNO);

    res = fhprintf(fh,PPTBase,
                "/*\n"
                " *   This file automatically generated by PPT version %d.%d\n",
                PPTBase->lib.lib_Version, PPTBase->lib.lib_Revision );

    res = fhprintf(fh,PPTBase,
                " *\n"
                " *  %s\n"
                " */", anno ? anno->en_Data : "");

    res = fhprintf(fh,PPTBase,
                "\n\n"
                "#include <exec/types.h>\n"
                "\n\n");

    res = fhprintf(fh,PPTBase,
                "\n\n"
                "UWORD   %s_height = %d\n"
                "UWORD   %s_width  = %d\n"
                "UWORD   %s_components = %d\n",
                basename, frame->pix->width,
                basename, frame->pix->height,
                basename, frame->pix->components );


    return res;
}

PERROR WriteFooter( FRAME *frame, BPTR fh, struct PPTBase *PPTBase )
{
    PERROR res;

    res = fhprintf(fh,PPTBase,
                "\n};\n"
                "\n\n"
                "/* END OF FILE */\n");
    return res;
}

PERROR WriteColormap( FRAME *frame, STRPTR basename, BOOL alpha, BPTR fh, struct PPTBase *PPTBase )
{
    int i;
    PERROR res;

    res = fhprintf(fh,PPTBase,
                "\n"
                "UWORD   %s_colors = %d\n"
                "UBYTE   %s_alpha  = %d\n"
                "UBYTE   %s_cmap = {\n",
                basename,frame->disp->ncolors,
                basename,alpha,
                basename );

    for( i = 0; i < frame->disp->ncolors; i++ ) {
        if( alpha )  {
            res = fhprintf(fh,PPTBase,"    %u,",frame->disp->colortable[i].a);
        } else {
            res = fhprintf(fh,PPTBase,"    ");
        }

        res = fhprintf(fh,PPTBase,
                "%3u,%3u,%3u,\n",
                frame->disp->colortable[i].r,
                frame->disp->colortable[i].g,
                frame->disp->colortable[i].b );
    }

    res = fhprintf(fh,PPTBase,
                  "\n};\n");

    return res;
}

VOID remblanks( STRPTR src, STRPTR dst, ULONG len )
{
    ULONG i,j = 0;

    for( i = 0; i < strlen(src) && i < len; i++ ) {
        if( (j && isalnum(src[i])) || (!j && isalpha(src[i])) ) {
            dst[j++] = src[i];
        }
    }

    dst[j] = '\0';
}

/*
    Format can be any of CSF_* - flags
*/

IOSAVE(fh,format,frame,tags,PPTBase,IOModuleBase)
{
    WORD row, col;
    char basename[256];
    PERROR res;

    D(bug("IOSave(type=%08X)\n",format));

    remblanks( frame->name, basename, 255 );

    if( (res = WriteHeader( frame, basename, fh, PPTBase )) != PERR_OK ) {
        SetErrorCode(frame,res);
        return PERR_ERROR;
    }

    if( format == CSF_LUT ) {
        if( (res = WriteColormap( frame, basename, FALSE, fh, PPTBase )) != PERR_OK ) {
            SetErrorCode(frame,res);
            return PERR_ERROR;
        }
    }

    InitProgress(frame,"Writing C source code...",0,frame->pix->height);

    res = fhprintf(fh,PPTBase,
                    "\n\n"
                    "UBYTE %s_data[] = {",
                    basename);

    for( row = 0; row < frame->pix->height; row++ ) {

        if( Progress( frame, row )) {
            return PERR_BREAK;
        }

        if( format != CSF_LUT ) {
            ROWPTR cp;

            cp = GetPixelRow( frame, row );

            for( col = 0; col < frame->pix->width*frame->pix->components; col++ ) {
                if( col % 20 == 0 ) fhprintf(fh,PPTBase,"\n    ");
                res = fhprintf( fh, PPTBase, "0x%02X,", cp[col] );
            }
        } else {
            UBYTE *cp;

            cp = GetBitMapRow( frame, row );

            for( col = 0; col < frame->pix->width; col++ ) {
                if( col % 20 == 0 ) {
                    fhprintf(fh,PPTBase,"\n    ");
                }
                res = fhprintf( fh, PPTBase, "0x%02X,", cp[col] );
            }

        }

        if( res != PERR_OK ) {
            SetErrorCode( frame, res );
            return PERR_ERROR;
        }
    }

    if( (res = WriteFooter( frame, fh, PPTBase )) != PERR_OK ) {
        SetErrorCode( frame, res );
        return PERR_ERROR;
    }

    FinishProgress( frame );

    return PERR_OK;
}

IOGETARGS(format,frame,tags,PPTBase,IOModuleBase)
{
    return PERR_OK;
}

/*----------------------------------------------------------------------*/
/*                            END OF CODE                               */
/*----------------------------------------------------------------------*/

