/*
 * A Collection Of BOOPSI Classes
 *
 * Copyright  1996 Thomas Krehbiel
 * All Rights Reserved
 *
 * Written by Thomas Krehbiel
 *
 */

#ifndef BOOPSITEK_H


#ifndef INTUITION_CLASSES_H
#include <intuition/classes.h>
#endif

#ifndef INTUITION_GADGETCLASS_H
#include <intuition/gadgetclass.h>
#endif

#ifndef INTUITION_IMAGECLASS_H
#include <intuition/imageclass.h>
#endif

#ifndef INTUITION_ICCLASS_H
#include <intuition/icclass.h>
#endif

#ifndef UTILITY_TAGITEM_H
#include <utility/tagitem.h>
#endif


// starting here shouldn't conflict with any other OS tags:
#define BOOPSITEK_DUMMY       (TAG_USER + 0x40000000)


/**************************************************************
 *
 * tekValueMClass
 *
 **************************************************************/

extern Class *tekValueMClass;

#define TICA_Dummy            (BOOPSITEK_DUMMY + 0x0000)

#define TICA_Value            (TICA_Dummy + 0x01)
            /* (LONG) current value */
#define TICA_Lowest           (TICA_Dummy + 0x02)
            /* (LONG) lower limit */
#define TICA_Highest          (TICA_Dummy + 0x03)
            /* (LONG) upper limit */
#define TICA_Up               (TICA_Dummy + 0x04)
            /* (VOID) increase the value */
#define TICA_Down             (TICA_Dummy + 0x05)
            /* (VOID) decrease the value */
#define TICA_UpChange         (TICA_Dummy + 0x06)
            /* (LONG) amount that ICVM_Up changes the value */
#define TICA_DownChange       (TICA_Dummy + 0x07)
            /* (LONG) amount that ICVM_Down changes the value */
#define TICA_ValueString      (TICA_Dummy + 0x08)
            /* (char *) formatted string representing the value */
#define TICA_ValuePtr         (TICA_Dummy + 0x09)
            /* (LONG *) a pointer to the value */
#define TICA_StoragePtr       (TICA_Dummy + 0x0A)
            /* (LONG *) where to store the value */
#define TICA_Decimals         (TICA_Dummy + 0x0B)
            /* (LONG) decimal places in FloatMClass */


/* Because of the difficulty I'm having passing float values via. tags
   and such, I'm making my own pseudo-float format for the FloatMClass: */

typedef long               TFLOAT;
#define TDECIMAL_BITS      (9)
#define TDECIMAL_MULTIPLE  (512.0)
#define TO_TFLOAT(f)       (TFLOAT)((float)(f) * TDECIMAL_MULTIPLE)
#define GET_TFLOAT(f)      (float)((float)(f) / TDECIMAL_MULTIPLE)


#define ICVM_Value            TICA_Value
#define ICVM_LowerLimit       TICA_Lowest
#define ICVM_UpperLimit       TICA_Highest
#define ICVM_Up               TICA_Up
#define ICVM_Down             TICA_Down

/**************************************************************
 *
 * tekFloatMClass
 *
 **************************************************************/

extern Class *tekFloatMClass;


/**************************************************************
 *
 * tekGroupIClass
 *
 **************************************************************/

extern Class *tekGroupIClass;


/**************************************************************
 *
 * tekImageIClass
 *
 **************************************************************/

extern Class *tekImageIClass;

/*
 * These standard imageclass tags are recognized:
 *
 * IA_Width:
 *    (UWORD) width of the image, in pixels
 *
 * IA_Height:
 *    (UWORD) height of the image, in pixels
 *
 * IA_BGPen:
 *    (UBYTE) pen number in image data that is replaced with highlight color
 *    when the image is rendered as selected
 *
 * IA_Data:
 *    (UBYTE *) pointer to chunky image data, one byte per pixel
 *
 */

#define TIA_Dummy             (BOOPSITEK_DUMMY + 0x1000)

#define TIA_ColorMap          (TIA_Dummy + 0x01)
            /* (struct ColorMap *) destination colormap for pen remapping */
#define TIA_Precision         (TIA_Dummy + 0x02)
            /* (ULONG) precision to use when remapping colors (see ObtainBestPen) (V39) */
#define TIA_Palette           (TIA_Dummy + 0x03)
            /* (UBYTE *) palette given in RGB triplets */
#define TIA_Depth             (TIA_Dummy + 0x04)
            /* (ULONG) significant bitplanes of image data */
#define TIA_BytesPerRow       (TIA_Dummy + 0x05)
            /* (ULONG) bytes per scanline in the image data, normally = width */
#define TIA_NoSelectState     (TIA_Dummy + 0x06)
            /* (BOOL) if TRUE, don't bother generating a select state image */
#define TIA_StandardImage     (TIA_Dummy + 0x07)
            /* (ULONG) give us one of the standard images defined below.  The class
               will ignore all of IA_Data, IA_Width, IA_Height, IA_BGPen,
               TIA_Palette, TIA_Depth, TIA_BytesPerRow */
#define TIA_NormalBGPen       (TIA_Dummy + 0x08)
            /* (WORD) pen to fill unselected background of image with - defaults
               to BACKGROUNDPEN */
#define TIA_Background        (TIA_Dummy + 0x09)
            /* (BOOL) tells whether image has a background pen that needs to be
               replaced - default TRUE */

#define IAIC_ColorMap         TIA_ColorMap
#define IAIC_Precision        TIA_Precision
#define IAIC_Palette          TIA_Palette
#define IAIC_Depth            TIA_Depth
#define IAIC_BytesPerRow      TIA_BytesPerRow
#define IAIC_NoSelectState    TIA_NoSelectState
#define IAIC_StandardImage    TIA_StandardImage


/*
 * Standard image types for tekImageIClass's IAIC_StandardImage tag
 *
 */
#define TIASTD_LeftArrow      (0)            /* left arrow */
#define TIASTD_RightArrow     (1)            /* right arrow */
#define TIASTD_ScreenMode     (2)            /* screenmode selector */
#define TIASTD_Disk           (3)            /* file requester */

#define STDIC_LeftArrow       (0)            /* left arrow */
#define STDIC_RightArrow      (1)            /* right arrow */
#define STDIC_ScreenMode      (2)            /* screenmode selector */


/**************************************************************
 *
 * tekTextIClass
 *
 **************************************************************/

extern Class *tekTextIClass;

/*
 * These standard imageclass tags are recognized:
 *
 * IA_Left:
 *    (LONG) leftedge
 *
 * IA_Top:
 *    (LONG) topedge
 *
 * IA_FGPen:
 *    (UBYTE) pen number to draw text with
 *
 * IA_Data:
 *    (UBYTE *) pointer to a null-terminated text string
 *
 * IA_Font:
 *    (struct TextFont *) font with which to render the bloody thing,
 *       otherwise whatever is selected in the RastPort is used
 *
 * SYSIA_DrawInfo:
 *    (struct DrawInfo *) one of IA_Font or SYSIA_DrawInfo *must* be
 *       provided so that we can correctly determine the size of the text.
 *
 */


/**************************************************************
 *
 * tekRidgeIClass
 *
 **************************************************************/

extern Class *tekRidgeIClass;

/*
 * These standard imageclass tags are recognized:
 *
 * IA_Left:
 *    (LONG) leftedge
 *
 * IA_Top:
 *    (LONG) topedge
 *
 * IA_Width:
 *    (LONG) width of ridge frame
 *
 * IA_Height:
 *    (LONG) height of ridge frame
 *
 */


/**************************************************************
 *
 * Standardized Boopsitek Gadget tags
 *
 **************************************************************/

#define TGA_Dummy             (BOOPSITEK_DUMMY + 0x2000)

#define TGA_Labels            (TGA_Dummy + 0x201)
            /* (STRPTR *) pointer to an array of label strings, terminated by NULL */
#define TGA_Label             (TGA_Dummy + 0x202)
            /* (STRPTR) label string for gadget */
#define TGA_LabelPlacement    (TGA_Dummy + 0x203)
            /* (ULONG) placement of the label text */
#define TGA_Arrows            (TGA_Dummy + 0x204)
            /* (BOOL) provide up/down arrow gadgets */


/**************************************************************
 *
 * tekButtonGClass
 *
 **************************************************************/

extern Class *tekButtonGClass;

/*
 * GA_Image = render image
 * GA_LabelImage = label image
 * GA_Text = label text
 * GA_ToggleSelect = toggle gadget?
 * GA_Selected = select state
 */

#define TGA_ThinBevelLeft     (TGA_Dummy + 0x101)
         /* thin left border */
#define TGA_ThinBevelRight    (TGA_Dummy + 0x102)
         /* thin right border */
#define TGA_ToggleLock        (TGA_Dummy + 0x103)
         /* lock toggle buttons down when they are hit */
#define TGA_LabelJustify      (TGA_Dummy + 0x104)
         /* how to justify the gadget label */
#define TGA_NormalBGPen       (TGA_Dummy + 0x105)
         /* pen to fill background of gadget (defaults to BACKGROUNDPEN) */


/* settings for TGA_LabelJustify */
#define TGAJUSTIFY_CENTER     (0)         /* center justify (default) */
#define TGAJUSTIFY_LEFT       (1)         /* left justify */
#define TGAJUSTIFY_RIGHT      (2)         /* right justify */


#define GABC_ThinLeft         TGA_ThinBevelLeft
#define GABC_ThinRight        TGA_ThinBevelRight


/**************************************************************
 *
 * tekChildWindowGClass
 *
 **************************************************************/

extern Class *tekChildWindowGClass;

ULONG HandleChildWindowGadget (struct IntuiMessage *);

/*
 * You MUST supply GACW_Window if you want to be able to drag the
 * child window.  This is a pointer to the actual Window in which
 * the child window class gadget resides.  It is used to find the
 * screen RastPort to draw the complement rectangle when the child
 * window is dragged.
 */
#define TCHILDA_Window        (TGA_Dummy + 0x201)
#define TCHILDA_CloseGadget   (TGA_Dummy + 0x202)
#define TCHILDA_DepthGadget   (TGA_Dummy + 0x203)
#define TCHILDA_DragGadget    (TGA_Dummy + 0x204)
/*
 * When you get these attributes after you receive a GADGETUP with
 * Code == CHILDCODE_DRAG, you can get the new window position.
 */
#define TCHILDA_DragLeft      (TGA_Dummy + 0x205)
#define TCHILDA_DragTop       (TGA_Dummy + 0x206)
/*
 * Use these to find the size of the child window border imagery.
 */
#define TCHILDA_BorderLeft    (TGA_Dummy + 0x207)
#define TCHILDA_BorderTop     (TGA_Dummy + 0x208)
#define TCHILDA_BorderRight   (TGA_Dummy + 0x209)
#define TCHILDA_BorderBottom  (TGA_Dummy + 0x20A)


// Standard border sizes:
#define TCHILD_BLEFT          (3)
#define TCHILD_BTOP           (10)
#define TCHILD_BRIGHT         (3)
#define TCHILD_BBOTTOM        (2)

#define TCHILDCODE_CLOSE      (0x100)
#define TCHILDCODE_DEPTH      (0x101)
#define TCHILDCODE_DRAG       (0x102)


#define GACW_Window           TCHILDA_Window
#define GACW_NewLeft          TCHILDA_DragLeft
#define GACW_NewTop           TCHILDA_DragTop
#define GACW_BorderLeft       TCHILDA_BorderLeft
#define GACW_BorderTop        TCHILDA_BorderTop
#define GACW_BorderRight      TCHILDA_BorderRight
#define GACW_BorderBottom     TCHILDA_BorderBottom

#define CHILDCODE_CLOSE       TCHILDCODE_CLOSE
#define CHILDCODE_DEPTH       TCHILDCODE_DEPTH
#define CHILDCODE_DRAG        TCHILDCODE_DRAG


/**************************************************************
 *
 * tekButtonTabGClass
 *
 **************************************************************/

extern Class *tekButtonTabGClass;

/*
 * TGA_Labels
 *    (STRPTR *) pointer to an array of label strings, terminated by NULL
 */

#define TTABA_ActiveLabelPen     (TGA_Dummy + 0x301)
            /* not implemented */
#define TTABA_InactiveLabelPen   (TGA_Dummy + 0x302)
            /* not implemented */
#define TTABA_ActiveTabPen       (TGA_Dummy + 0x303)
            /* not implemented */
#define TTABA_InactiveTabPen     (TGA_Dummy + 0x304)
            /* not implemented */
#define TTABA_ActiveTab          (TGA_Dummy + 0x305)
            /* currently visible tab */
#define TTABA_TabFont            (TGA_Dummy + 0x306)
            /* font to render button tab text */

#define GABT_Labels           TGA_Labels


/**************************************************************
 *
 * tekRotate3DGClass
 *
 **************************************************************/

extern Class *tekRotate3DGClass;

#define TROTATEA_AxisPen      (TGA_Dummy + 0x401)     /* Pen to draw axes */
#define TROTATEA_AxisLabelPen (TGA_Dummy + 0x402)     /* Pen to draw XYZ axes labels */
#define TROTATEA_CubePen      (TGA_Dummy + 0x403)     /* Pen to draw cube */
#define TROTATEA_RotateX      (TGA_Dummy + 0x404)     /* Initial X Rotation */
#define TROTATEA_RotateY      (TGA_Dummy + 0x405)     /* Initial Y Rotation */
#define TROTATEA_RotateZ      (TGA_Dummy + 0x406)     /* Initial Z Rotation */


#define GAR3_AxisPen          TROTATEA_AxisPen
#define GAR3_AxisLabelPen     TROTATEA_AxisLabelPen
#define GAR3_CubePen          TROTATEA_CubePen
#define GAR3_RotateX          TROTATEA_RotateX
#define GAR3_RotateY          TROTATEA_RotateY
#define GAR3_RotateZ          TROTATEA_RotateZ


/**************************************************************
 *
 * tekTextGClass
 *
 **************************************************************/

extern Class *tekTextGClass;

/*
 * TGA_Label
 *       (STRPTR) label text to left of gadget
 */

#define TTEXTA_Justification  (TGA_Dummy + 0x501)
         /* justification of the text */


/**************************************************************
 *
 * tekIntegerGClass
 *
 **************************************************************/

extern Class *tekIntegerGClass;

/*
 * GA_Left, GA_Top, GA_Width, GA_Height
 *
 * STRINGA_Justification
 *          (ULONG) justification for the integer gadget (default right)
 *
 * STRINGA_MaxChars
 *          (ULONG) maximum chars in the integer gadget
 *
 * SYSIA_DrawInfo
 *          (struct DrawInfo *) required for label text
 *
 * TGA_Arrows
 *          (BOOL) provide left/right arrow pair to the right of the gadget
 *
 * TGA_Label
 *          (STRPTR) label text to the left of the gadget
 *
 * TIA_ColorMap
 *          (struct ColorMap *) required for arrow rendering
 *
 * TICA_Value
 *          (LONG) initial value of the integer gadget
 *
 * TICA_Lowest
 *          (LONG) lowest value of the gadget
 *
 * TICA_Highest
 *          (LONG) highest value of the gadget
 *
 * TICA_UpChange
 *          (LONG) amount of change when right arrow clicked
 *
 * TICA_DownChange
 *          (LONG) amount of change when left arrow clicked
 */

#define GAIN_Arrows           TGA_Arrows


/**************************************************************
 *
 * tekFloatGClass
 *
 **************************************************************/

extern Class *tekFloatGClass;


/**************************************************************
 *
 * tekDualFloatGClass
 *
 **************************************************************/

extern Class *tekDualFloatGClass;

#define TDUALA_LowValue       (TGA_Dummy + 0x601)     /* Low value */
#define TDUALA_HighValue      (TGA_Dummy + 0x602)     /* High value */


/**************************************************************
 *
 * tekScreenModeGClass
 *
 **************************************************************/

extern Class *tekScreenModeGClass;


/**************************************************************
 *
 * tekDropDownGClass
 *
 **************************************************************/

extern Class *tekDropDownGClass;

extern struct tekDropDownNode * AddDropDownNode (struct MinList *);
extern struct MinList *CreateDropDownList (void);
extern void DeleteDropDownList (struct MinList *);


#define TDROPA_List           (TGA_Dummy + 0x701)     /* Dropdown list */
#define TDROPA_Font           (TGA_Dummy + 0x702)     /* Font for dropdown list */


struct tekDropDownNode
{
   struct MinNode       Node;
   STRPTR               Label;
   struct Image        *Image;
   APTR                 UserData;
   UWORD                TopEdge;       // Maintained by the class
   UWORD                Height;        // Maintained by the class
};



#define BOOPSITEK_H
#endif //BOOPSITEK_H

