/*
 * Apptek
 * Copyright  1996 Thomas Krehbiel
 * All Rights Reserved
 *
 */

#ifndef EXEC_TYPES_H
#include <exec/types.h>
#endif

#ifndef UTILITY_TAGITEM_H
#include <utility/tagitem.h>
#endif

#ifndef INTUITION_INTUITION_H
#include <intuition/intuition.h>
#endif

#ifndef INTUITION_GADGETCLASS_H
#include <intuition/gadgetclass.h>
#endif

#ifndef INTUITION_IMAGECLASS_H
#include <intuition/imageclass.h>
#endif

#ifndef LIBRARIES_GADTOOLS_H
#include <libraries/gadtools.h>
#endif

#ifndef BOOPSITEK_H
#include <boopsitek.h>
#endif


/**********************************************************
 *
 * Application
 *
 **********************************************************/

/*
 * Tags for APT_NewApplication():
 */
enum aptNewApp_Tags
{
   APA_first = (int)TAG_USER + 0x40000000,
   APA_CmdTable,                          /* (APACommand) Arexx command table */
   APA_Extension,                         /* (STRPTR) Arexx extension */
   APA_ArexxPortName,                     /* (STRPTR) Arexx port name */
   APA_HelpFile,                          /* (STRPTR) Main help filename */
   APA_LocaleHook,                        /* (struct Hook *) Localization hook */
   APA_ToolTipHook,                       /* (struct Hook *) Process tool tips */
   APA_Screen,                            /* (struct Screen *) Main app screen */
   APA_Quit,                              /* (BOOL) Quit the application */
   APA_TextAttr,                          /* (struct TextAttr *) Default window font */
   APA_ToolTipAttr,                       /* (struct TextAttr *) Default tool tip font */
   APA_Name,                              /* (STRPTR) Application name */
   APA_AppIconName,                       /* (STRPTR) Name of appicon file to use */
   APA_HelpPath,                          /* (STRPTR) Path to look in for help files */
   APA_last
};


typedef LONG (*APACmdHandler)(APTR, struct RexxMsg *, ULONG *);

typedef struct
{
   STRPTR            Keyword;
   APACmdHandler     Handler;
   STRPTR            Template;
   LONG              pad;
}
APACommand;

/*
 * Useage:
 *
 * APACOMMAND( <callback_function_name> )
 */
#define APACOMMAND(FUN)     LONG __saveds FUN (APAHandle *app, struct RexxMsg *msg, ULONG *args)



enum
{
   APAERR_CmdNotFound = 200,           // 200 - command not found
   APAERR_BadArgTemplate,              // 201 - args given do not match template
   APAERR_NoMemoryTemplate,            // 202 - no memory to process template
   APAERR_UserCancel,                  // 203 - user cancelled
   APAERR_NoMemory,                    // 204 - out of memory
   APAERR_NoChipMemory,                // 205 - out of chip memory
   APAERR_FileNotFound,                // 206 - file not found

   APAERR_last
};


/**********************************************************
 *
 * Gadgets
 *
 **********************************************************/


/*
 * Kinds of Apptek gadgets:
 *
 */
//      (GadTools kinds are valid and processed by GadTools)
#define APG_VERTICAL_GROUP       ( 64)          /* Begin Vertical group */
#define APG_HORIZONTAL_GROUP     ( 65)          /* Begin Horizontal group */
#define APG_END_GROUP            ( 66)          /* End any group */
#define APG_ROOT                 ( 67)          /* Root object (PRIVATE) */
#define APG_GRID_GROUP           ( 68)          /* 2D Grid group */
#define APG_BUTTONTAB_GROUP      ( 69)          /* Special Button Tab group */
#define APG_BOOPSI_KIND          (127)          /* Generalized BOOPSI gadget */
#define APG_TOGGLE_KIND          (128)          /* Toggle gadget */
#define APG_FLOAT_KIND           (129)          /* Floating point string gadget */
#define APG_IMGBUTTON_KIND       (130)          /* Button with image label */
#define APG_PALETTEPOT_KIND      (131)          /* Palette pot with border */
#define APG_TIMELINE_KIND        (132)          /* Single Timeline display */
#define APG_BUTTONTAB_KIND       (133)          /* Button Tab gadget */
#define APG_IMGICON_KIND         (134)          /* Imageiclass icon */
#define APG_NULL_KIND            (135)          /* Placeholder for grid groups */
#define APG_GAUGE_KIND           (136)          /* Bargraph gauge */
#define APG_IGNORE_KIND          (137)          /* Ignore this one */
#define APG_SCREENMODE_KIND      (138)          /* Screenmode selector */
#define APG_RPORT_KIND           (139)          /* "RastPort" area */
#define APG_INCLUDE              (255)          /* Include another tag list */
#define APG_END                  (256)          /* End of specification array */
#define APG_DONE                 (256)          /* End of specification array */
#define APG_USER_KIND            (257)          /* User gadgets start here */

/*
 * Tags for defining Apptek gadgets:
 */
enum apgGadget_Tags
{
   APG_first = (int)TAG_USER + 0x40010000,
   APG_Kind,                              /* (UWORD) Kind of Guitek element */
   APG_ID,                                /* (UWORD) User ID */
   APG_Label,                             /* (STRPTR) Label text */
   APG_Callback,                          /* (GUTCallback) Callback to process events */
   APG_UserData,                          /* (ULONG) User data for callback */
   APG_ValueStore,                        /* (LONG *) Where to store gadget's value */
   APG_CloseCode,                         /* (LONG) Code to return when closing window */
   APG_EqualWidth,                        /* (BOOL) Equalize child gadget widths */
   APG_EqualHeight,                       /* (BOOL) Equalize child gadget heights */
   APG_EqualSpaced,                       /* (BOOL) Position gadgets evenly */
   APG_Frame,                             /* (LONG) Group border style */
   APG_TextAttr,                          /* (struct TextAttr *) Gadget font attr */
   APG_BorderLeft,                        /* (LONG) Amount to offset gadgets */
   APG_BorderTop,                         /* (LONG) Amount to offset gadgets */
   APG_ToolTip,                           /* (STRPTR) "Tool tip" text */
   APG_HelpNode,                          /* (STRPTR) Amigaguide help node */
   APG_HelpFile,                          /* (STRPTR) Amigaguide help file */
   APG_ArexxCmd,                          /* (STRPTR) Command to invoke */
   APG_CycleLabels,                       /* (STRPTR) Cycle labels, separated by tabs */
   APG_RightJustify,                      /* (BOOL) Right justify children */
   APG_FloatPtr,                          /* (float *) Initial floating point value */
   APG_Decimals,                          /* (LONG) Decimal places (default=3) */
   APG_ToolTipFont,                       /* (struct TextAttr *) Font for tool tips */
   APG_ToolTipHook,                       /* (struct Hook *) Process tool tips */
   APG_DefaultChoice,                     /* (BOOL) Highlight as default choice */
   APG_LabelString,                       /* (STRPTR) Label strings, separated by tabs */
   APG_LabelArray,                        /* (STRPTR *) Label strings, array form */
   APG_GridColumns,                       /* (ULONG) Columns in grid layout */
   APG_GridRows,                          /* (ULONG) Rows in grid layout */
   APG_FillWidth,                         /* (BOOL) */
   APG_FillHeight,                        /* (BOOL) */
   APG_Class,                             /* (Class *) BOOPSI Class pointer */
   APG_ClassName,                         /* (STRPTR) BOOPSI Class Name */
   APG_PassColorMap,                      /* (ULONG) Provide colormap tag */
   APG_PassTextFont,                      /* (struct TextFont *) Provide textfont tag */
   APG_CancelChoice,                      /* (BOOL) Cancel button (= ESC) */
   APG_CenterJustify,                     /* (BOOL) Center justify children */
   APG_MinValue,                          /* (LONG) Minimum value */
   APG_MaxValue,                          /* (LONG) Maximum value */
   APG_OnSuccessStore,                    /* (LONG *) Store value here on success only */
   APG_HelpChoice,                        /* (BOOL) This is a help gadget */
   APG_DoublePtr,                         /* (double *) Pointer to double for APG_FLOAT_KIND; implies
                                             that APG_ValueStore points to a double, too */
   APG_LeftSpace,                         /* (WORD) Spacing to add to left (pixels) */
   APG_RightSpace,                        /* (WORD) Spacing to add to right (pixels) */
   APG_TopSpace,                          /* (WORD) Spacing to add to top (pixels) */
   APG_BottomSpace,                       /* (WORD) Spacing to add to bottom (pixels) */
   APG_Link,                              /* (LONG) Link to this object ID */
   APG_EnabledBy,                         /* (LONG) Gadget ID that must be on to enable us */
   APG_ValuePtr,                          /* (LONG *) Pointer to value to init gadget with */
   APG_RMBCallback,                       /* (APGCallback) Callback on RMB click */
   APG_RMBArexxCmd,                       /* (UBYTE *) Arexx command to do on RMB click */
   APG_Percentage,                        /* (BOOL) APG_FLOAT_KIND is a percentage */
   APG_PalettePen,                        /* (LONG) Pen to render APG_PALETTEPOT_KIND */
   APG_TimeStartPtr,                      /* (FLOAT *) Pointer to timeline start (0.0-1.0) */
   APG_TimeEndPtr,                        /* (FLOAT *) Pointer to timeline end (0.0-1.0) */
   APG_RightLabel,                        /* (STRPTR) Label on right side of gadget */
   APG_ButtonTabArray,                    /* (LONG **) Gadget tags for each button tab */
   APG_ButtonTabLabels,                   /* (STRPTR) Labels for a button tab group */
   APG_DisabledBy,                        /* (LONG) Gadget ID that disables us when on */
   APG_TimeCallback,                      /* (APTR) Timeline drawing code */
   APG_Value,                             /* (LONG) Current value (for Gauges) */
   APG_AlignLeft,                         /* (BOOL) Align left margins (default TRUE) */
   APG_AlignRight,                        /* (BOOL) Align right margins (default TRUE) */
   APG_Translation,                       /* (APGXlateCallback) For APG_FLOAT_KIND, translation function */
   APG_FloatIsLong,                       /* (BOOL) Value provided to APG_FLOAT_KIND is a long */
   APG_RPortDraw,                         /* (APGRPortCallback) For APG_RPORT_KIND; callback to draw into the area */
   APG_ReadOnly,                          /* (BOOL) Gadget is read-only, cannot edit contents */
   APG_last
};

#define APGFRAME_Recessed     (0)         /* Standard recessed bevel box */
#define APGFRAME_ButtonTab    (1)         /* ButtonTab group */

/* Values for APG_Frame: */
#define APGFRAME_BUTTON          FRAME_BUTTON
#define APGFRAME_DIVIDERTOP      (256)    /* divider at top of group */
#define APGFRAME_DIVIDERBOTTOM   (257)    /* divider at bottom of group */


#define APG_FLUSH             (24321)     /* APG_#?Space = no spacing at all */


/*
 * Useage:
 *
 * APGTIMECALLBACK( <callback_function_name> )
 */
#define APGTIMECALLBACK(FUN)     LONG __saveds __asm FUN (register __a0 struct RastPort *rp, register __d0 WORD left, register __d1 WORD top, register __d2 WORD right, register __d3 WORD bottom)

typedef LONG __asm (*APGTimeCallback)(register __a0 struct RastPort *rp, register __d0 WORD left, register __d1 WORD top, register __d2 WORD right, register __d3 WORD bottom);


/*
 * Useage:
 *
 * APGXLATECALLBACK( <callback_function_name> )
 */
#define APGXLATECALLBACK(FUN)     void __saveds __asm FUN (register __a0 DOUBLE *ptr, register __d0 LONG type)

typedef void __asm (*APGXlateCallback)(register __a0 DOUBLE *ptr, register __d0 LONG type);

#define APGXLATE_TO     (0)      /* xlate to displayed format */
#define APGXLATE_FROM   (1)      /* xlate from displayed format */


/*
 * Useage:
 *
 * APGRPORTCALLBACK( <callback_function_name> )
 */
#define APGRPORTCALLBACK(FUN)     LONG __saveds __asm FUN (register __a0 struct RastPort *rp, register __d0 WORD left, register __d1 WORD top, register __d2 WORD width, register __d3 WORD height, register __a1 struct DrawInfo *dri)

typedef LONG __asm (*APGRPortCallback)(register __a0 struct RastPort *rp, register __d0 WORD left, register __d1 WORD top, register __d2 WORD width, register __d3 WORD height, register __a1 struct DrawInfo *dri);


/*
 * Tags for defining Apptek gadgets:
 */
enum apcContext_Tags
{
   APC_first = (int)TAG_USER + 0x40020000,
   APC_TextAttr,                          /* (struct TextAttr *) Gadget font attr */
   APC_BorderLeft,                        /* (LONG) Amount to offset gadgets */
   APC_BorderTop,                         /* (LONG) Amount to offset gadgets */
   APC_HelpNode,                          /* (STRPTR) Amigaguide help node */
   APC_HelpFile,                          /* (STRPTR) Amigaguide help file */
   APC_ToolTipFont,                       /* (struct TextAttr *) Font for tool tips */
   APC_ToolTipHook,                       /* (struct Hook *) Process tool tips */
   APC_Screen,                            /* (struct Screen *) Screen to open on */
   APC_NoBackShade,                       /* (BOOL) Don't shade background */
   APC_BackFillPen,                       /* (ULONG) Pen to draw backfill with */
   APC_LocaleHook,                        /* (struct Hook *) Localization hook */
   APC_last
};


typedef LONG __asm (*APGCallback)(register __a0 APTR msg, register __a1 struct APAWindowStruct *awin, register __d0 ULONG id, register __d1 ULONG userdata);

/*
 * Useage:
 *
 * APGCALLBACK( <callback_function_name>, <userdata_type> )
 */
#define APGCALLBACK(FUN,UDT)     LONG __saveds __asm FUN (register __a0 struct IntuiMessage *imsg, register __a1 APAWindow *awin, register __d0 ULONG id, register __d1 UDT userdata)



/*
 * Tags for APT_NewWindow():
 *
 * (Some Context tags are also valid.)
 */
enum apwWindow_Tags
{
   APW_first = (int)TAG_USER + 0x40030000,
   APW_TextAttr,                          /* (struct TextAttr *) Gadget font attr */
   APW_NewMenus,                          /* (struct NewMenu *) Menus */
   APW_MenusUseCommands,                  /* (BOOL) Menu's UserData is Arexx command */
   APW_Async,                             /* (BOOL) Return immediately */
   APW_ID,                                /* (LONG) Window ID */
   APW_State,                             /* (APWState *) Window position */
   APW_MenuTextAttr,                      /* (struct TextAttr *) TextAttr for menu font */
   APW_BorrowMenus,                       /* (ULONG) Use menus from this Window ID */
   APW_Menus,                             /* (struct Menu *) Attach this menu list */
   APW_ChildWindow,                       /* (BOOL) Use "Child" window borders */
   APW_Modal,                             /* (BOOL) Lock all other windows */
   APW_WindowPtr,                         /* (struct Window *) Window pointer */
   APW_Center,                            /* (BOOL) Center on parent screen (def TRUE) */
   APW_PrivateIDCMP,                      /* (BOOL) Create private IDCMP message port */
   APW_Handler,                           /* (APGCallback) Event handler callback */
   APW_RMBGadgets,                        /* (BOOL) Enable RMB click of gadgets */
   APW_ActivateID,                        /* (LONG) Initial gadget to activate */
   APW_CloseHandler,                      /* (APGCallback) Called when window closed */
   APW_OpenHandler,                       /* (APGCallback) Called when window opened */
   APW_last
};


typedef struct
{
   WORD        Left, Top;
   WORD        Width, Height;
   WORD        ZoomLeft, ZoomTop;
   WORD        ZoomWidth, ZoomHeight;
   UBYTE       Flags, pad;
   WORD        reserved[3];
}
APWState;

#define APWSF_OPEN      (0x01)
#define APWSF_VALID     (0x02)            /* State struct is initialized */


#ifndef APPTEK_PRIVATE

   typedef LONG APAHandle;
   typedef LONG APAWindow;
   typedef LONG APGContext;
   typedef LONG APGObject;

   extern struct LocaleInfo LI;

#endif

