/* Aladdin4D
 * Copyright  1996 Nova Design, Inc.
 * All Rights Reserved
 *
 * Structure Definitions
 *
 * Revision History:
 *
 *    31.03.96 tek   Replaced all compiler-specific types.
 *    04.05.96 tek   Removed all the "extern"s, for portability.
 */


struct PointInfo
{
   SHORT scrx;               /* these are points screen x & y coords */
   SHORT scry;
   struct PolygonInfo *poly;                        /* polygon number */
      /* may be type cast for special objects that use this structure */
   struct PointInfo *next;        /* address of next point in polygon */
   struct PointInfo *prev;        /* address of prev point in polygon */
   LONG x;                                       /* present 3d coords */
   LONG y;                                       /* present 3d coords */
   LONG z;                                       /* present 3d coords */
   /* TEK: are these really necessary? */
   LONG oldx;                                        /* old 3d coords */
   LONG oldy;                                        /* old 3d coords */
   LONG oldz;                                        /* old 3d coords */
   struct defpnt *dpt;         /* first deform point location if used */
   BYTE id;                     /* bit packed for point editing modes */
                       /* NOTE that the upper bit of id is kept fluid */
                 /* you may use it freely as a temporary tracking bit */
   UBYTE pool; /* for mem pooling */
};
/* 46 bytes */

/* reminders:
typedef float vector[3];
typedef double dvector[3];
typedef LONG lvector[3];
*/

/* 2.11 change: removed linked list */
typedef struct Ivector
{
   FLOAT a[2];          /* only holds screen x and y coords */
}
ivector;

/* 2.11 change: removed linked list and typedef'd */
typedef struct RPvect
{
   /* for rotated coords for complex polys */
   vector rpos;
}
rpvect;


struct procobject
{
   struct procobject *next;                                /* next object */
   struct procobject *prev;                                /* prev object */
   ULONG special;               /* special info structure for object type */
   USHORT in;                           /* type of object,0 to max ushort */
   /* alad.library, when freeing all procobjects checks this id and calls
      the appropriate library/function to free the special structures, then
      removes the object.
   */
   USHORT id;                   /* bit packed, selected, renderable, etc. */
                           /* NOTE that the upper bit of id is kept fluid */
                     /* you may use it freely as a temporary tracking bit */
   USHORT group[7];                                      /* grouping info */
};


struct splineobject
{
   struct procobject *obj;              /* the procobject this belongs to */
   struct PointInfo *controlpnt;         /* first control point in spline */
   struct PointInfo *firstpoint;                 /* first point in spline */
   /* note that there are always twice as many control points as points   */
   /* point 0 uses controlpnt 0,1, point 1 uses 2,3 point 2 uses 4,5, etc */
   /* if spline is not closed, first and last control points are not used */
   USHORT points;                         /* how many points in splineobj */
   USHORT id;                            /* an ID holder for various uses */
   struct PathInfo *path;                        /* animation information */
               /* note that the path is not used and is not saved to file */

   /* New in 5.0 */

   struct PolygonInfo *temppathpoly;   /* stores the polygon that this */
                                       /* spline path was converted into */
                                       /* (if it's a path, of course) */
};

struct csplineseg
{
   /* these are control splines, 2D */
   struct csplineseg   *next;
   struct csplineseg   *prev;
   DOUBLE               x[2], y[2], cx[2], cy[2];
};

struct cspline
{
   struct cspline *next;
   struct csplineseg *first;
   UBYTE name[80];
   LONG count;
   SHORT dpos;
   SHORT dsel;
   /* these are used for editing the csplines so always get a
      grid snap (and mag, etc) suited to the cspline
   */
   LONG gr[4]; /* snap and grid paint */
   DOUBLE rm[4]; /* reticle,magmult,offsetx,offsety */
};

struct defpnt
{
   /* this is for deforming poly for animations */
   struct defpnt *next;  /* allows multiple levels of deform */
   LONG x;               /* x,y,z coord of point at this level of deform */
   LONG y;
   LONG z;
};


/*******************************************************************
 *
 * BitMap And Procedural Textures
 *
 *******************************************************************/

/* NewBMR struct handles 32-bit, 24-bit, or 8-bit colormap only */
/* Any other bitmap loaded must be converted to this format */
struct NewBMR
{
   WORD     Width, Height;    /* pixel width/height */
   WORD     Depth, Type;      /* byte depth, type of bitmap */
   LONG     BytesPerRow;      /* bytes per scanline */
   UBYTE  **Data;             /* image data scanlines */
   UBYTE    Palette[768];     /* palette data */
   WORD     PixAspectX, PixAspectY;
   WORD     DPIX, DPIY;
   WORD     FgPen, BgPen;     /* foreground, background pens for masking (-1 = none) */
   UBYTE   *Scanline;         /* room for an ARGB scanline */
   APTR     MagicHandle;      /* MAGIC handle for public image */
   LONG     reserved[3];
};

#define NEWBMR_RGB   (0)      /* RGB 3 bytes per pixel */
#define NEWBMR_ARGB  (1)      /* ARGB 4 bytes per pixel */
#define NEWBMR_GREY  (2)      /* Greyscale 1 byte per pixel */
#define NEWBMR_CMAP  (3)      /* Colormap 1 byte per pixel */

struct BMResource
{
   // NOTE:  This struct needs to be more platform independant, I think.
   // It's also not very longword-aligned.

   struct BMResource *next;
   UBYTE *path;          /* directory to save*/
   UBYTE *fn;            /* filename to save, and use for requester */
   #ifdef AMIGA
   struct RastPort rp;  /* rastport, full structure */
   struct BitMap bm;    /* bitmap, full structure, only used with old iff code */
   #endif //AMIGA
   SHORT fx,lx;         /* special info for bitmaps with goobers */
   SHORT fy,ly;         /* special info for bitmaps with goobers */
                    /* note that these are saved and read with file! why? */
   SHORT wi;            /* its width */
   SHORT hi;            /* its height */
   LONG ba;             /* the number of colors in image, 2 to 16 mil */
   UBYTE planes;        /* if 6, assume ham */
   USHORT *pa;          /* 4 bit palette */
   ULONG *lpa;          /* 8 bit palette */
   UBYTE dpos;          /* directory position */
   UBYTE dsel;          /* directory select */
   USHORT available;    /* number of frames on the disk or in the anim */
   BYTE animtype;       /* 0-none, 1-individual, 2-opcode 5 */
   USHORT current;      /* if anim, frame number currently accessed */
   FLOAT init;          /* initial time to start play, frame 1 previous */
   FLOAT end;           /* end time of play, last frame after */
   FLOAT cycles;        /* number of times to play */
   UBYTE type;          /* cyclic or periodic play, forward or reverse */
   USHORT frames;       /* the extension number of the first frame loaded by user */
   #ifdef AMIGA
   struct DCTVCvtHandle *Handle; /* if non-null, this is a dctv image */
   ULONG DCTVError;     /* error report area */
   #endif //AMIGA
   ULONG ptr;           /* pointer for ilbminfo structs ?? */
   struct cspline *animspline; /* spline rate control for anim textures */

   #ifdef AMIGA
   APTR magichandle;    /* 5.0: MAGIC handle to make this bitmap public */
   #endif
   struct NewBMR *newBMR;

};

struct BMLmemb
{
   // NOTE:  This struct is not longword aligned.

   struct BMLmemb *next;
   struct BMResource *bmr; /* the bitmap this one uses */
                           /* if NULL, this is a procedural texture */
   UBYTE proc;             /* the procedural texture to apply */
                           /* if proc, some of these have other uses */
   ULONG info;             /* bitpacked information holder, see defines */
                           /* the entry values */
   FLOAT fstr;             /* Strength, range 0.0 to 1.0 */
   FLOAT fcol;             /* Color percentage to use range 0.0 to 1.0 */
                           /* for environ maps: */
   FLOAT fper;             /* amount of perspective division */
   FLOAT fsca;             /* scale of bitmap to use */
   FLOAT fscr;             /* amount of screen coordinate influence */
   FLOAT fnor;             /* amount of normal influence */
   FLOAT fpt1,fpt2,fpt3,fpt4,fpt5,fpt6,fpt7,fpt8; /* procedural */
   uvector fcolors[8];     /* first colors for proc textures */
   FLOAT fcolst[8];        /* first start percentage */
   FLOAT fcolen[8];        /* first end percentage */
   FLOAT frblend[8];       /* right blend for proc color */
   FLOAT flblend[8];       /* left blend for proc color */
                           /* the exit values */
   FLOAT lstr;             /* Strength, range 0.0 to 1.0 */
   FLOAT lcol;             /* Color percentage to use range 0.0 to 1.0 */
                           /* for environ maps: */
   FLOAT lper;             /* amount of perspective division */
   FLOAT lsca;             /* scale of bitmap to use */
   FLOAT lscr;             /* amount of screen coordinate influence */
   FLOAT lnor;             /* amount of normal influence */
   FLOAT lpt1,lpt2,lpt3,lpt4,lpt5,lpt6,lpt7,lpt8; /* procedural */
   uvector lcolors[8];     /* end colors for proc textures */
   FLOAT lcolst[8];        /* last start percentage */
   FLOAT lcolen[8];        /* last end percentage */
   FLOAT lrblend[8];       /* right blend for proc color */
   FLOAT llblend[8];       /* left blend for proc color */
   /* the constants */
   SHORT x;                /* remembered angles for free angle */
   SHORT y;
   SHORT z;
   FLOAT init;             /* % time begin */
   FLOAT end;              /* % time end */
   struct cspline *m;      /* spline rate control for this member */
   FLOAT cycles;           /* local cycles, inside this member */
   UBYTE type;             /* local type, bit packed periodic, etc */
   LONG numcol;            /* number of active colors in lower 8 bits */
           /* NOTE that the upper 24 bits are used for various other uses */
   LONG cpt[3];            /* center point of the procedural texture */
   /* the locals */
   SHORT wi;            /* useable width */
   SHORT hi;            /* useable height */
   FLOAT pocol;         /* rotation value */
   FLOAT chaxx;
   FLOAT chayy;
   FLOAT chazz;
   FLOAT firx;          /* span fir-end */
   FLOAT firy;
   FLOAT firz;
   FLOAT endx;
   FLOAT endy;
   FLOAT endz;
   FLOAT addx;          /* used for bitmap width/height, see setinten.c */
   FLOAT addy;          /* along with ostr */
   FLOAT addz;
   FLOAT str;   /* Strength, range 0.0 to 1.0 */
                /* note that if not in time range, set to 2? as flag! */
                /* now using colbufg as line of buffered strengths */
   FLOAT ostr;         /* old strength to make "clear" colors blend */
   FLOAT col;             /* Color percentage to use range 0.0 to 1.0 */
                           /* for environ maps: */
   FLOAT per;             /* amount of perspective division */
   FLOAT sca;             /* scale of bitmap to use */
   FLOAT scr;             /* amount of screen coordinate influence */
   FLOAT nor;             /* amount of normal influence */
   FLOAT pt1,pt2,pt3,pt4,pt5,pt6,pt7,pt8; /* procedural */
   FLOAT iper;             /* amount of perspective division */
   FLOAT isca;             /* scale of bitmap to use */
   FLOAT iscr;             /* amount of screen coordinate influence */
   FLOAT inor;             /* amount of normal influence */
   FLOAT ipt1,ipt2,ipt3,ipt4,ipt5,ipt6,ipt7,ipt8; /* procedural */
   uvector colors[8];      /* color array for procedural textures */
   FLOAT colst[8];         /* start percentage of color spacing */
   FLOAT colen[8];         /* end percentage of color spacing */
   FLOAT colctr[8];        /* center of color spacing */
   FLOAT rblend[8];        /* right blend for proc color */
   FLOAT lblend[8];        /* left blend for proc color */
   /* calculation vars */
   FLOAT irblend[8];
   FLOAT ilblend[8];
   SHORT spa;
   LONG *colbufr;  /* now packing rgb into longs here */
   LONG *colbufg;  /* and variable strengths as floats here */
   LONG *colbufb;  /* but using all three as position holders for procedurals */
                   /* and colbufb as packed rgb for bump maps */
};

struct BMList
{
   struct BMList *next;
   struct BMLmemb *first; /* first member pointer */
   SHORT dpos;            /* for selection */
   SHORT dsel;            /* for selection */
                          /* note that this var is also used
                             (low 2 bits, temporary storage)
                             to record bump or genlock textures for render
                          */
   LONG count;            /* members in this list */
   UBYTE name[64];        /* editable by user */
   FLOAT cycles;          /* number of times to repeat */
   UBYTE type;            /* cyclic, periodic */

   /*
    * New in 5.0
    */

   UBYTE pad[2];          /* Alignment */
   UBYTE lastTab;         /* Last ButtonTab active for this list */
   APTR  thumbnail;       /* Cached thumbnail information */
};



struct SmPoint
{
   struct SmPoint *next;
   struct PointInfo *pnt;
};

struct currentnodevalues
{
   // NOTE:  This struct is not longword-aligned.

   UBYTE v;
   UBYTE r;
   UBYTE g;
   UBYTE b;
   UBYTE t;
   vector lnormal;
};

/* why not just put a currentnodevalues structure in each SHNode, memory? */
/* normal could be calculated for poly net before render and
   inverted if needed??? */

struct SHNode
{
   // NOTE:  This struct is not longword-aligned.

   ULONG flag; /* for file saves */
   USHORT count;
   ULONG *po; /* allocation area for pointers to polys */
   USHORT pool; /* for mem pooling */
};

struct BMCoords
{
   struct BMCoords *next;
   FLOAT x;
   FLOAT y;
   FLOAT z;
};

struct BMPoint
{
   struct BMCoords *first;
   struct SHNode *sn; /* pointers to adjacent polygons */
   vector rpos;       /* actual rotated positions for fill */
                      /* complex polys use the poly->rpnts */
   FLOAT len;         /* precalculated length of side for % calculations */
};

struct PolyBMpoint
{
   /* for polys that have more than 4 points */
   FLOAT x[4];    /* real space temporary location */
   FLOAT y[4];    /* assigned at time of bitmap assignment */
   FLOAT z[4];    /* representing a bounding poly to reg poly */
   FLOAT oldx[4];    /* real space permanent location */
   FLOAT oldy[4];    /* assigned at time of bitmap assignment */
   FLOAT oldz[4];    /* representing a bounding poly to reg poly */
};
/* 96 bytes */

struct PolyBMInfo
{
   /* never drawn, just for textures, Gouraud */
   struct PolyBMpoint *pnt;    /* only if poly has more than 4 points */
   struct BMPoint bpt[4];      /* for texture coords */
   UBYTE init;                 /* unset just before painting a new frame */
   UBYTE flip;                 /* for phong, etc. */

   // NOTE:  Not longword-aligned at end
};
/* 390 bytes!!!! */

/* the temptation is strong to index bitmaps for complex polys based on
   their edges, but think hard! the intersection tests that set the
   firstside and endside would be defeated by a poly that had several
   edges on the same scanline, or would it? a rectangle can have
   4 edges on the same line, and they work!
   Well, I just tried it and they don't!
   rectangles cannot be concave to render properly!
*/

struct PolygonInfo
{
   struct PolygonInfo *next;                              /* next polygon */
   struct PolygonInfo *prev;                          /* previous polygon */
   struct PointInfo *firstpoint;                /* first point in polygon */
   UBYTE id;        /* bits: emp,emp,emp,texture,light,path,selected,show */
   UBYTE in;                         /* similar to id, information holder */
   USHORT points;                 /* maintained count of points for speed */
   USHORT group[7];           /* 0 to 4 if member of group, set to number */
                                /* group[5] is shading group, for reshade */
                                 /* group[6] is shadow group, for shadows */
      // not longword aligned
   struct BMList *bml;
   struct attlist *atl;                           /* polys attribute list */
      /* (38 bytes so far) */
   /* TEK: c needed? */
   ULONG c;         /* current color 8 bits each, ?????, red, green, blue */
        /* note that this is used in non-render operations as a temporary */
   /* TEK: t needed? */
   ULONG t;         /* current attr 8 bits each, ????, ?????, hard, trans */
   struct PathInfo *path;                                /* for animation */
      /* (50 bytes so far) */
   /* TEK: this is HUGE - and it isn't used until render time.
   /* there must be a way to trim this down, right? */
   struct PolyBMInfo bmp;           /* for bitmap poly, textures, Gouraud */
      /* (440 bytes so far) */

      // back to longword aligned
   /* TEK: if this is for lights, why is it in the polygon struct?? */
   vector lnormal;                                          /* for lights */
      /* (452 bytes so far) */
   FLOAT planeconstant;                                    /* for shadows */
   vector rpos;       /* polys rotated/translated center for local lights */
   FLOAT nearz;                                     /* nearest z for poly */
   FLOAT lx,hx;                  /* screen bounding box for intersections */
   ivector *vertex;                /* used in fill mode for clipping clip */
                                 /* examined in fill for NULL value which */
                                /* indicates that or clipped out of frame */
   struct PolygonInfo *special;            /* if meld, first poly in list */
                              /* or pointer light, gas, or wave structure */
   rpvect *rpnts;          /* if complex, records rotated coord in render */
      /* (492 bytes so far) */
   UBYTE pshow;                 /* bits 00111111 show, 01000000 meld flag */
   SHORT vertexcount;              /* when clipped, point count different */
                                      /* needed for increment and freeing */
      // not even shortword aligned now
   LONG *li;                                    /* light elimination bits */
   UBYTE pool; /* for mem pooling */
      // back to longword aligned

   /*
    * Additions in Aladdin 5.0:
    */

   struct PathInfo *originalPath;   /* Used when converting spline paths */
                                    /* to polygon paths to save the pointer */
                                    /* to the original spline path */

};
/* 504 bytes !!!! */

struct wavlist
{
   struct PolygonInfo *poly; /* pointer to the poly that is this wave poly */
   struct wavlist *next;    /* pointer to the next wavlist */
   struct wavmemb *first; /* first member of list */
   LONG count; /* how many members in list */
   FLOAT cycles; /* how many times to repeat the list */
   UBYTE fixed; /* reference static or moving position */
   UBYTE type; /* bit packed for periodic, etc. */
   UBYTE wavtype; /* sin or log type wave */
   UBYTE secoff; /* secondary offset */
   SHORT nwa; /* number of waves */
   FLOAT secspace; /* secondary offset spacing */
   LONG mir; /* minimum range */
   LONG mar; /* maximum range */
   FLOAT pha; /* phase */
   FLOAT fre; /* frequency */
   FLOAT amp; /* amplitude */
   LONG xspa; /* x spacing */
   LONG yspa; /* y spacing */
   LONG zspa; /* z spacing */
   LONG xrad; /* x radius */
   LONG yrad; /* y radius */
   LONG zrad; /* z radius */
   FLOAT inwa; /* inverse of nwa */
   FLOAT mirsq,marsq; /* squares of mir and mar */
   FLOAT marplusmir; /* (double)(wavl->mar+wavl->mir)>>1 */
   FLOAT imarminmir; /* 1.0/(double)(wavl->mar-wavl->mir)>>1) */
   FLOAT ixradsq; /* 1.0/(double)(wavl->xrad*wavl->xrad) */
   FLOAT iyradsq; /* 1.0/(double)(wavl->xrad*wavl->xrad) */
   FLOAT izradsq; /* 1.0/(double)(wavl->xrad*wavl->xrad) */
   FLOAT ixrad; /* inverse xrad */
   FLOAT iyrad; /* inverse yrad */
   FLOAT izrad; /* inverse zrad */
   FLOAT sxspa; /* (int)cwav->xspa*cwav->secspace; local x spacing */
   FLOAT syspa; /* (int)cwav->yspa*cwav->secspace; local y spacing */
   FLOAT szspa; /* (int)cwav->zspa*cwav->secspace; local z spacing */
   FLOAT sxxrad; /* 1.0/(cwav->xrad*cwav->xrad*cwav->secspace*cwav->secspace); x radius */
   FLOAT syyrad; /* 1.0/(cwav->yrad*cwav->yrad*cwav->secspace*cwav->secspace); y radius */
   FLOAT szzrad; /* 1.0/(cwav->zrad*cwav->zrad*cwav->secspace*cwav->secspace); z radius */
};

struct wavmemb
{
   struct wavmemb *next;
   /* the entry values */
   UBYTE fnwa; /* number of waves */
   LONG fmir; /* minimum range */
   LONG fmar; /* maximum range */
   FLOAT fpha; /* phase */
   FLOAT ffre; /* frequency */
   FLOAT famp; /* amplitude */
   LONG fxspa; /* x spacing */
   LONG fyspa; /* y spacing */
   LONG fzspa; /* z spacing */
   LONG fxrad; /* x radius */
   LONG fyrad; /* y radius */
   LONG fzrad; /* z radius */
   /* the exit values */
   UBYTE lnwa; /* number of waves */
   LONG lmir; /* minimum range */
   LONG lmar; /* maximum range */
   FLOAT lpha; /* phase */
   FLOAT lfre; /* frequency */
   FLOAT lamp; /* amplitude */
   LONG lxspa; /* x spacing */
   LONG lyspa; /* y spacing */
   LONG lzspa; /* z spacing */
   LONG lxrad; /* x radius */
   LONG lyrad; /* y radius */
   LONG lzrad; /* z radius */
   /* the constants */
   FLOAT init; /* % time begin */
   FLOAT end;  /* % time end */
   struct cspline *mspline; /* spline rate control */
   FLOAT cycles; /* local cycles, inside this member */
   UBYTE type; /* local type, bit packed periodic, etc */
   UBYTE fixed; /* reference static or moving position */
   UBYTE wavtype; /* sin or log type wave */
   UBYTE secoff; /* secondary offset */
   FLOAT secspace; /* secondary offset spacing */
};

struct attlist
{
   struct attlist *next;
   struct attmemb *first; /* first member of list */
   SHORT dpos;
   SHORT dsel;
   LONG count; /* low word: how many members in list up to 65000 */
               /* upper word:
                  low byte: shadow acceleration 0 to 255
                  upper byte: unused
               */
   UBYTE name[64]; /* the users name for this list */
   FLOAT cycles; /* how many times to repeat the list */
   UBYTE type; /* bit packed for periodic, etc. */
   UBYTE vi; /* visible */
   UBYTE bk; /* background */
   UBYTE nr; /* red */
   UBYTE ng; /* green */
   UBYTE nb; /* blue */
   UBYTE nv; /* reflectivity */
   UBYTE si; /* self illumination */
   UBYTE sv; /* specular reflectivity (hardness) */
   UBYTE hs; /* hardfactor (highlight size ) */
   UBYTE rr; /* red reflective */
   UBYTE rg; /* green reflective */
   UBYTE rb; /* blue reflective */
   UBYTE tr; /* transparency */
   UBYTE tt; /* transparency thick */
   UBYTE tl; /* transparency light */
   UBYTE ws; /* wave sensitivity */
   UBYTE di; /* diffusion */
   UBYTE ev; /* environment reflectivity */
   /* these are for speed, double 0.0 to 1.0 equivalents */
   /* can be figured once, then used when needed, eliminating multiplies */
   FLOAT dnr; /* red */
   FLOAT dng; /* green */
   FLOAT dnb; /* blue */
   FLOAT dnv; /* reflectivity */
   FLOAT dsi; /* self illumination */
   FLOAT dsv; /* specular reflectivity (hardness) */
   FLOAT dhs; /* hardfactor (highlight size ) */
              /********************* WARNING ***************************     */
              /* drr,drg,drb are no longer used because they were set to     */
              /* UBYTE instead of FLOAT. makeenvironment() and spanbuffer.c  */
              /* now calculate the values on the fly                         */
              /********************* WARNING ***************************     */
   UBYTE drr; /* red reflective */
   UBYTE drg; /* green reflective */
   UBYTE drb; /* blue reflective */
   FLOAT dtr; /* transparency */
   FLOAT dtt; /* transparency thick */
   FLOAT dtl; /* transparency light */
   FLOAT dws; /* wave sensitivity */
   FLOAT ddi; /* diffusion */
   FLOAT dev; /* environment reflectivity */
   /* these are linetypes, added for version 2.1 */
   UBYTE linetype; /* not bitpacked, incremented */
   FLOAT linedistance; /* for line types not normal */

   /*
    * Need to add index of refraction, raytrace reflectivity
    */

   /*
    * New in 5.0
    */
   UBYTE lastTab;    /* last ButtonTab visible for this list */
   UBYTE pad[3];
   WORD editorPen;   /* editor pen to use in drawing polygons with this attribute */
                     /* -1 or 0 (uninitialized) means use the default pen */
};

struct attmemb
{
   struct attmemb *next;
   /* the entry values */
   UBYTE fnr; /* red */
   UBYTE fng; /* green */
   UBYTE fnb; /* blue */
   UBYTE fnv; /* reflectivity */
   UBYTE fsi; /* self illumination */
   UBYTE fsv; /* specular reflectivity (hardness) */
   UBYTE fhs; /* hardfactor (highlight size ) */
   UBYTE frr; /* red reflective */
   UBYTE frg; /* green reflective */
   UBYTE frb; /* blue reflective */
   UBYTE ftr; /* transparency */
   UBYTE ftt; /* transparency thick */
   UBYTE ftl; /* transparency light */
   UBYTE fws; /* wave sensitivity */
   UBYTE fdi; /* diffusion */
   UBYTE fev; /* environment reflectivity */
   /* the exit values */
   UBYTE lnr; /* red */
   UBYTE lng; /* green */
   UBYTE lnb; /* blue */
   UBYTE lnv; /* reflectivity */
   UBYTE lsi; /* self illumination */
   UBYTE lsv; /* specular reflectivity (hardness) */
   UBYTE lhs; /* hardfactor (highlight size ) */
   UBYTE lrr; /* red reflective */
   UBYTE lrg; /* green reflective */
   UBYTE lrb; /* blue reflective */
   UBYTE ltr; /* transparency */
   UBYTE ltt; /* transparency thick */
   UBYTE ltl; /* transparency light */
   UBYTE lws; /* wave sensitivity */
   UBYTE ldi; /* diffusion */
   UBYTE lev; /* environment reflectivity */
   /* the constants */
   FLOAT init; /* % time begin */
   FLOAT end;  /* % time end */
   struct cspline *g; /* spline rate control */
   FLOAT cycles; /* local cycles, inside this member */
   UBYTE type; /* local type, bit packed periodic, etc */
   UBYTE vis; /* visible during this member? */
   UBYTE bk; /* background if front poly */
   UBYTE linetype; /* normal, outline, centers, points, INCREMENTED, not bitpacked */
   FLOAT flinedistance; /* entry width if not normal */
   FLOAT llinedistance; /* exit width */

   /*
    * Need to add index of refraction, raytrace reflectivity
    */
};

struct DeformInfo
{
   struct DeformInfo *next; /* one for each level of deform */
   FLOAT init;              /* % of time that this one begins */
   FLOAT end;               /* % of time that this one ends */
   struct cspline *m;       /* spline rate control */
};

/* the path has combination types, for example, each one has a
   global periodic
   member periodic
   angle periodic (3)
   movement periodic
   the path holds the variables for global type and movement type
   the member holds the variables for membertype and angle types
   when the member calculations are done,
   the pcntdone is calculated for the path, and is
   affected by the global type
   then this is used to determine the local time and the
   member types are used
   the final angles are stored in the pathinfo

   for movement, the globaltype is used to determine the local
   percentdone, and this is used to determine the movement
   time, based on the movement type

   instancing, which is global, is performed similarly
*/

struct PathInfo
{
   struct PolygonInfo *pathpoly;            /* poly for movement direction */
   struct PointInfo *guidepoint;         /* current location of guidepoint */
   struct PathInfo *guidepath;            /* may be following another path */
   struct DeformInfo *dft;            /* beginning of list of deform times */
   struct pathmemb *first;                  /* first rotation instructions */
   USHORT count;                                     /* number of pathmemb */
   /* these are the main globals to the path */
   FLOAT cycles;
   struct cspline *g;                          /* time alteration for path */
   LONG type;       /*  modified at time of member calculation, KEEP FLUID */
   /* these are translation, globals to the path! */
   FLOAT initm;                                          /* offset in time */
   FLOAT cyclesm;                /* number of times to repeat in animation */
   struct cspline *m;                        /* translation spline control */
   LONG movetype;   /* bit packed info on direction of rotate and movement */
   /* these are angles are set from pathmemb in effect */
   FLOAT aax,aay,aaz;                                  /* current rotation */
   SHORT deform;  /* if not 0, number of deform positions present in polys */
   FLOAT cyclesd;                                         /* deform cycles */
   FLOAT deformdone; /* this path's deform time */
   LONG deformlevel; /* and it's level */
   FLOAT sx,sy,sz;                                      /* current scaling */
   FLOAT chax,chay,chaz;                            /* current translation */
   /* these are mechanical wave displacement, set from pathmemb in effect */
   FLOAT wd,wf,wp;            /* current wave displacement,frequency,phase */
   FLOAT mar,mir;                            /* current wave max/min range */
   FLOAT wang;                                       /* current wave angle */
   FLOAT wnum;                        /* current wave number, type of wave */
   /* these are for instancing */
   LONG inum;                                           /* instance number */
   LONG itype;                               /* instance types, bit packed */
   struct cspline *ig;                  /* instance global spline adjuster */
   FLOAT ift,ilt;                                          /* time offsets */
   FLOAT ifpx,ifpy,ifpz,ilpx,ilpy,ilpz;                /* position offsets */
   FLOAT ifrx,ifry,ifrz,ilrx,ilry,ilrz;                /* rotation offsets */
   struct cspline *ict,*icpx,*icpy,*icpz,*icrx,*icry,*icrz;  /* spline adj */
   LONG ipl;                                 /* instance polys (per level) */
   struct PolygonInfo *ipf;                  /* first and poly in instance */
   FLOAT pathdone;             /* calculated and altered pcntdone for path */
   FLOAT itm,ipx,ipy,ipz,irx,iry,irz;       /* current values for instance */
   LONG ilevel;       /* paths created by instancing need to remember this */
   LONG *pathbuf;           /* temporary space for instances of this paths */
   /* these are required to track aligns */
   FLOAT obsegpct;
   struct PointInfo *obpt1,*obpt2,*obpt3;

   /* New For 5.0 */
   struct splineobject *pathspline;       /* Splines can now be paths too */
   char name[64];                         /* Paths can now be named too */
   LONG reserved[8];
};

struct pathmemb
{
   struct pathmemb *next;                  /* next rotation instructions */
   /* these are main */
   FLOAT init;                                /* time this member starts */
   FLOAT end;                                   /* time this member ends */
   struct cspline *g;                     /* global time adjusting spline */
   FLOAT cycles;                       /* number of times member repeats */
   /* these are rotation, x,y,z dependent */
   FLOAT initx,inity,initz;          /* start%, rotation offsets in time */
   FLOAT fx,fy,fz;                                   /* first angles */
   FLOAT lx,ly,lz;                                   /* last angles */
   FLOAT cyclesx,cyclesy,cyclesz;   /* number of times to repeat */
   struct cspline *rx,*ry,*rz;       /* rotation spline controls */
   /* this type holds main and x,y,z periodic flags */
   LONG type;
   /* these are scaling, x,y,z dependent */
   FLOAT sinitx,sinity,sinitz;      /* start%, scaling offsets in time */
   FLOAT fsx,fsy,fsz;                                   /* first percents */
   FLOAT lsx,lsy,lsz;                                   /* last percents */
   FLOAT scyclesx,scyclesy,scyclesz;   /* number of times to repeat */
   struct cspline *sx,*sy,*sz;       /* rotation spline controls */
   /* this type holds scaling x,y,z periodic flags */
   LONG stype;
   /* these are for mechanical wave displacement */
   FLOAT initw; /* start%, wave offset in time */
   FLOAT cyclesw; /* number of times to repeat */
   FLOAT fwd,lwd; /* displacement */
   FLOAT fwf,lwf; /* frequency, or distance crest to crest */
   FLOAT fwp,lwp; /* phase, how crests are positioned and moved */
   FLOAT fwmar,lwmar,fwmir,lwmir; /* ranges for circular waves */
   FLOAT fwang,lwang; /* rotation of wave effect */
   LONG wnum; /* type wave, linear, cylinder, sphere, etc */
              /* also holds axis reference */
   LONG wtype; /* bit packed periodic flags */
   struct cspline *wspl;   /* wave spline control */
};

struct FacePoint
{
   struct PointInfo *pnt;
   struct FacePoint *next;
};

struct space
{
   struct space *next;
   struct space *prev;
   struct PolygonInfo *firstpoly;
   struct PolygonInfo *lastpoly;
   struct procobject *firstprocobject;
   struct procobject *lastprocobject;
   LONG numberpoly;
   SHORT ax;
   SHORT ay;
   SHORT az;
   SHORT xtilt;
   SHORT ytilt;
   SHORT ztilt;
   LONG xchange;
   LONG ychange;
   LONG zchange;
   LONG dw;
   LONG di;
   SHORT axis;
   SHORT quickmove;
   SHORT isometric;
   SHORT canon;
   SHORT trackpoint;
   FLOAT atpoint[3];
   struct PolygonInfo *which; /* chosenpoly */
   struct procobject *chosenprocobject;
   struct PointInfo *nearpoint;
   struct lights *firstlight;
   struct cameraobject *cam; /* a space can only have one camera */
   struct gaslist *firstgaslist;
   struct wavlist *firstwavlist;
   /* next time add:
      QMpolys QMpnts gnumber atpaxislen
   */
};

struct lights
{
   struct PolygonInfo     *li;               /* pointer to the poly that is this light */
   struct lights          *next;             /* pointer to the next poly that is a light */
   /* lights use attlist for color, and the
       reflectivity setting of the attlist for strength
    */
   LONG                    range;            /* radius of influence */
   UBYTE                   type;             /* periodic & highlight &shadow flags */
   struct PolygonInfo     *lastshadowpoly;   /* for optimizing shadows */
   LONG                   *shadowbuf;        /* buffer for last scanline for shadows */
   FLOAT                   aconst,
                           adist,
                           adistsq;          /* attenuation factors */

   /* added these for 2.2, no change to file format */

   DOUBLE                  sqrange;          /* range squared for faster compare */
   DOUBLE                  irange;           /* range inverse for faster divide */

   /* Added in 5.0 */

   UBYTE                   pad1[3];          /* (bring us back to longword aligned) */

   UBYTE                   LightType;        /* Light type, see below */
   UBYTE                   SoftEdges;        /* Soft-edge shadow amount */
   UBYTE                   Temporary;        /* "Temporary" light for soft shadows */
   UBYTE                   LightFlags;       /* New flags for lights */

   FLOAT                   ConeAngleEntry;   /* Spotlight cone angle, in degrees */
   FLOAT                   ConeAngleExit;
   struct cspline         *ConeSpline;       /* Spline control for cone angle ?? */

   FLOAT                   EdgeFadeEntry;    /* Angle at which spotlight begins */
   FLOAT                   EdgeFadeExit;     /*    to fade out to give us a smooth edge */

   struct cameraobject    *TargetSystem;     /* Target system for a cone light.
                                                We use a cameraobject struct which
                                                points to a list of targets.  We
                                                use a cameraobject struct because
                                                we want to use existing functions
                                                for tracking targets, which
                                                presumeably expect cameraobject
                                                structures. */

   FLOAT                   Jitter;           /* Jitter for soft shadows (0.075) */

   LONG                    reserved[14];     /* for future expansion */
};

/* Light Types: */
#define LIGHT_POINT        (0)               /* Point (or spherical) source */
#define LIGHT_CONE         (1)               /* Cone source (eg. spotlight) */
#define LIGHT_DISTANT      (2)               /* Distant source (parallel rays) (FUTURE) */

/* Light flags: */
#define LIGHTF_NEGATIVE    (0x01)            /* So-called "negative" light */
#define LIGHTF_SOFTQMASK   (0x03)<<1
#define LIGHTF_SOFTQLOW    (0x00)<<1
#define LIGHTF_SOFTQMED    (0x01)<<1
#define LIGHTF_SOFTQHIGH   (0x02)<<1

#define LIGHTSOFTQ(L)         (((L)->LightFlags & LIGHTF_SOFTQMASK) >> 1)
#define SETLIGHTSOFTQ(L,a)    { (L)->LightFlags &= ~LIGHTF_SOFTQMASK; (L)->LightFlags |= ((a) << 1); }

struct dplines
{
   UBYTE *r, *g, *b;
};

struct dpimage
{
   LONG wi, hi;
   struct dplines *dprgb;
};


struct flareobject
{
   /* this is the head of a list */
   struct procobject *obj;  /* the procobject this belongs to */
   struct flarememb *first;
   struct BMList *bml;      /* the bmlist to be used */
   struct attlist *atl;     /* visible (and color to blend?) */
   struct PolygonInfo *po;  /* triangle? user's handle */
   struct PathInfo *path;   /* animation control */
   struct cspline *g;       /* change control */
   LONG count;              /* number of members */
   SHORT type;              /* periodic, etc */
   ULONG in;                /* bit packed information holder */
   FLOAT cycles;            /* times to repeat */
   /* from here, volatile, calculated, (some are file saved?) */
   FLOAT wpct,hpct;         /* apparent size of flare as % of render size */
   FLOAT rot;               /* current rotation of flare image */
   FLOAT bmlcol;            /* amount of color to get from bml (rest from atl) */
   FLOAT reldist;           /* relative distance for sizing & dropoff */
   FLOAT offx,offy;         /* offsets from center */
   /* these for future development */
   FLOAT dropoff;           /* amount of dropoff to apply, or min value? */
   FLOAT strnear;           /* strength range, closer than near, 1.0 */
   FLOAT strfar;            /* further than far, 0.0 */
   FLOAT ly,hy;             /* screen verticle limits for zbuffered flares */
   /* Added in 5.0 */
   ULONG artifactType;      /* type of lens artifacts (0 = none) */
   FLOAT artifactBright;    /* lens artifact brightness */
   ULONG reserved[4];
};

struct flarememb
{
   struct flarememb *next;
   struct cspline *m;       /* change control */
   FLOAT init;              /* % time begin */
   FLOAT end;               /* % time end */
   FLOAT cycles;            /* local cycles, inside this member */
   USHORT type;             /* local type, bit packed periodic, etc */
   USHORT in;               /* info holder */
   FLOAT fwpct,lwpct;
   FLOAT fhpct,lhpct;
   FLOAT frot,lrot;
   FLOAT fbmlcol,lbmlcol;
   FLOAT freldist,lreldist;
   FLOAT foffx,loffx;
   FLOAT foffy,loffy;
   /* these for future development */
   FLOAT fdropoff,ldropoff;           /* amount of dropoff to apply, or min value? */
   FLOAT fstrnear,lstrnear;           /* strength range, closer than near, 1.0 */
   FLOAT fstrfar,lstrfar;             /* further than far, 0.0 */
   /* Added in 5.0 */
   ULONG artifactType;                       /* type of lens artifacts (0 = none) */
   FLOAT fartifactBright, lartifactBright;   /* lens artifact brightness */
   ULONG reserved[4];
};

struct gaslist
{
   struct gaslist *next;   /* next gaseous object */
   struct gasmemb *first;  /* first member of list */
   struct PolygonInfo *p[6]; /* polygons that bound this gas */
   FLOAT sam;           /* number of samples to take */
   FLOAT str;           /* strength of gas */
   FLOAT noi;           /* strength of noise to use */
   FLOAT nsc;           /* scale of noise, typ. 0.0001, show x1000 */
   LONG att;             /* how to attenuate the gas, sphere, top-bot, etc */
   SHORT sides;          /* bits: top,bot,bak,frt,lft,rgt, color/dens */
   FLOAT scax,scay,scaz; /* scalers to equivocate sizes */
   FLOAT six,siy,siz;    /* sizes, x,y,z */
   FLOAT largest;        /* max size */
   FLOAT cex,cey,cez;    /* centers */
   FLOAT max,may,maz;    /* maximum values */
   FLOAT mix,miy,miz;    /* minimum values */
   FLOAT ra;             /* minimum radius of sphere (squared) */
   FLOAT fac;            /* density falloff power */
   SHORT ntn;            /* number of noise samples */
   FLOAT ndf;            /* noise definition power */
   FLOAT cycles; /* how many times to repeat the list */
   UBYTE type; /* bit packed for periodic, roll, etc. */
   FLOAT res;            /* (hirz-lorz)/div, size of steps in space */
   FLOAT lorz,hirz;      /* current frame TOTAL lo and hi rotated z */
   FLOAT avestr;         /* averaged strength per sample */
   FLOAT currentz;       /* the current distance after adding steps */
   FLOAT rollamt;        /* the current amount of roll */
   SHORT sub;            /* FREE was subdivisions, no longer used */
   SHORT count;          /* how many members */
   UBYTE r,g,b,d;        /* blending secondary color for noise */
   FLOAT isix,isiy,isiz; /* inverted sizes for speed */
   FLOAT cbal,dbal;      /* color/density balancers */
   FLOAT isam;           /* inverted samples */
   FLOAT strdsam;        /* strength divided by samples */
   FLOAT iglobalsize;    /* 1.0/(ga->hirz - ga->lorz) */
   FLOAT hglobalsize;    /* ga->lorz + ((ga->hirz - ga->lorz)*0.5) */
   FLOAT ofx,ofy,ofz;    /* noise translation, calculated */
   FLOAT rcx,rcy,rcz;    /* noise rotation centers, calculated */
   FLOAT rox,roy,roz;    /* noise rotation, additive from prev member */
   FLOAT srx,sry,srz,crx,cry,crz; /* noise calculated sines,cosines */
   UBYTE init;           /* used to announce participation */
   UBYTE rot;            /* noise announce rotation, 1,2,4 is x,y,z */
   /* these are to allow gas deforms (resizing only */
   FLOAT omix,omiy,omiz;
   FLOAT osix,osiy,osiz;
};

struct gasmemb
{
   struct gasmemb *next;
   FLOAT fsam;           /* number of samples to take */
   FLOAT fstr;           /* strength of gas */
   FLOAT fnoi;           /* strength of noise to use */
   FLOAT fnsc;           /* scale of noise to use */
   FLOAT fndf;           /* definition of noise */
   FLOAT ffac;           /* density falloff power */
   FLOAT fofx,fofy,fofz; /* noise positioning */
   FLOAT frcx,frcy,frcz; /* noise rotation positioning */
   FLOAT lsam;           /* number of samples to take */
   FLOAT lstr;           /* strength of gas */
   FLOAT lnoi;           /* strength of noise to use */
   FLOAT lnsc;           /* scale of noise to use */
   FLOAT lndf;           /* definition of noise */
   FLOAT lfac;           /* density falloff power */
   FLOAT lofx,lofy,lofz; /* noise positioning */
   FLOAT lrcx,lrcy,lrcz; /* noise rotation positioning */
   FLOAT rox,roy,roz;    /* noise rotation, additive from prev member */
   SHORT sides;
   UBYTE fr,fg,fb,ft;       /* blending secondary color for noise */
   UBYTE lr,lg,lb,lt;
   FLOAT init;           /* % time begin */
   FLOAT end;            /* % time end */
   struct cspline *mspline; /* spline rate control */
   FLOAT cycles;         /* local cycles, inside this member */
   UBYTE type;           /* local type, bit packed periodic, etc */
};

struct target
{
   struct target *next;    /* next in list */
   struct PolygonInfo *po; /* the target poly */
   FLOAT init,end;         /* % time begin, end */
   struct cspline *tspline; /* spline rate control (internal changes) */
   FLOAT trans;            /* percentage of time for transition to next */
   struct cspline *transspline; /* spline rate control (transition changes) */
   FLOAT ftilt;            /* tilt of camera */
   FLOAT fdw,fdi;          /* each target can have different lens */
   FLOAT ltilt;
   FLOAT ldw,ldi;          /* allows zoom during animation! */
   FLOAT x,y,z;            /* target position in space derived from poly */
   FLOAT cycles;           /* local cycles, inside this member */
   UBYTE type;             /* local type, bit packed periodic, etc */
   /* Added in 5.0 */
   UBYTE pad[3];
   struct lights *Light;   /* Spotlight source, if any */
};

struct cameraobject
{
   struct cameraobject *next; /* for future multiple cameras */
   struct PolygonInfo *po;    /* the camera poly */
   struct target *targ;       /* first target in list */
   SHORT count;               /* track of count of targets */
   FLOAT dw,di;               /* lens specifications */
   FLOAT tilt;                /* tilt of camera */
   FLOAT x,y,z;               /* camera's position in space */
   FLOAT tx,ty,tz;            /* "target" position in space */
   FLOAT rx,ry,rz;            /* rotation angles of camera to center target */
   struct cspline *g;         /* spline rate control */
   FLOAT cycles;              /* global cycles */
   UBYTE type;                /* global type */
   LONG nearplane,farplane;   /* clipping planes for this camera */
   /* Added in 5.0 */
   struct lights *Light;      /* Spotlight source, if any */
};

struct fpinfo
{
   FLOAT x; /* screen x */
   FLOAT y; /* screen y */
   DOUBLE rx; /* real space */
   DOUBLE ry;
   DOUBLE rz;
   FLOAT prx; /* modified perspective space */
   FLOAT pry;
};

typedef struct EDGE
{
   struct EDGE *next;
   SHORT len;
   FLOAT x;
   FLOAT x_add;
   struct PolygonInfo *poly;
}
edge;

struct trans
{
   /* the first one is just a dummy head to the list */
   struct trans *next; /* pointer to the next level */
   FLOAT *z;        /* pointer to the memory allocated for the z buffer */
   FLOAT *x;        /* pointer to the memory allocated for the x buffer */
   FLOAT *y;        /* pointer to the memory allocated for the y buffer */
   LONG *p;        /* pointer to the memory allocated for the poly buffer */
   LONG *c;        /* pointer to the memory allocated for the color buffer */
};

struct Pair
{
   struct PolygonInfo *po;
   FLOAT d;
};

/* this is the structure for buffering poly attributes pixel-pixel */
struct patbuf
{
   SHORT co[5]; /* r,g,b,tr,gen */
   FLOAT hs[2]; /* hrd, sil */
   FLOAT nor[3]; /* normal */
};

/* and this one for buffering lights */
struct litbuf
{
   SHORT co[7];      /* r,g,b,hr,hg,hb,shadow */
   FLOAT dm[2];      /* dist,mag */
   FLOAT ray[3];     /* normalized ray */
   FLOAT soft;       /* 5.0: softness of shadow */
};

/* the structure for our tools */
struct aladtool
{
   struct aladtool *next;
   struct aladtool *prev;
   UBYTE name[80];  /* the tool name as found */
   SHORT sync;     /* is the tool synchronous? */
};

/* a structure for screen polys to be overlayed on editor
   the poly is drawn for full number of points, or until one of
   the points has a negative x
*/
struct aladscreenpoly
{
   struct aladscreenpoly *next;
   USHORT pen; /* pen number for poly */
   USHORT count; /* number of point pairs */
   SHORT *pnts; /* point pairs */
};

struct fedge
{
   struct fedge *next; /* next edge */
   DOUBLE len;         /* number of scanlines */
   DOUBLE x;           /* screen x */
   DOUBLE sadx;        /* screen x increment */
   DOUBLE bx,by;       /* bitmap indices */
   DOUBLE badx,bady;   /* bitmap increments */
};

struct fparticle
{
   LONG x,y,z;            /* current position in space */
   LONG oldx,oldy,oldz;   /* fixed position in space */
   LONG dex,dey,dez;      /* fixed destination */
   FLOAT init;            /* particle's creation time */
   FLOAT end;             /* particle's expire time */
   FLOAT fsiz,lsiz;       /* cspline start end for size */
   FLOAT fstr,lstr;       /* cspline start end for strength */
   FLOAT fdra,ldra;       /* cspline start end for drag */
   FLOAT fimr,limr;       /* cspline start end for image rotation */
   FLOAT frx,fry,frz;     /* used as rotation center when not gmotion */
   FLOAT lrx,lry,lrz;     /* rotation values */
   USHORT seed;           /* each particle has a different seed */
   SHORT scrx,scry;       /* screen location of particle */
   USHORT pin;            /* bit packed info holder */
   FLOAT rage;            /* calculated relative age */
   FLOAT ly,hy;           /* screen verticle limits for zbuffered particles */
   /*********** these added for zbuf efficiency after 4.0 ***********/
   SHORT clipped;
   FLOAT rz;
   FLOAT fhx,flx,fhy,fly;
   FLOAT tnr;
   FLOAT tng;
   FLOAT tnb;
   struct fedge a1,a2,b1,b2;
   struct fedge *lft,*rgt;
};

struct fountainobject
{
   /* this is the head of a list, currently limited to one member */
   struct procobject *obj;     /* the procobject this belongs to */
   struct fountainmemb *first; /* first member in list */
   struct fparticle *list;  /* buffer for all particles in this fountain */
   struct BMList *bml;      /* the bmlist to be used */
   struct attlist *atl;     /* visible (and color to blend?) */
   struct PolygonInfo *po;  /* triangle? user's handle */
   struct PathInfo *path;   /* animation control */
   struct cspline *g;       /* change control */
   UBYTE activeTab;         /* New in 5.0: active button tab */
   UBYTE reserved;
   WORD count;              /* number of members, currently limited to one */
                            /* NOTE THAT count USED TO BE A LONG - TEK */
   SHORT type;              /* periodic, etc */
   ULONG in;                /* bit packed information holder */
   FLOAT cycles;            /* times to repeat */
   FLOAT initpercent;       /* time offset for age of fountain */
   /* from here, volatile, calculated for each frame from member */
   FLOAT wpct,hpct;         /* aspect ratio control of image */
   FLOAT aorot;             /* current image rotation limits */
   FLOAT borot;
   FLOAT adrot;
   FLOAT bdrot;
   FLOAT reldist;           /* relative distance for sizing */
   USHORT number,maxnum;    /* current number of particles, maximum needed */
   /* NOTE: never change maxnum, it is set in library at definition time
      never allocate or free list except with allocfountainlist()
   */
   USHORT rndseed;          /* so each fountain can be different */
   FLOAT adirx,adiry,adirz; /* max angles in initial direction */
   FLOAT bdirx,bdiry,bdirz; /* min angles in initial direction */
   FLOAT arx,ary,arz;       /* post placement rotations, part life */
   FLOAT brx,bry,brz;       /* post placement rotations, part life */
   FLOAT aorig;             /* max initial orig (distance from source) */
   FLOAT borig;             /* min initial orig (distance from source) */
   FLOAT adest;             /* max initial dest (distance from source) */
   FLOAT bdest;             /* min initial dest (distance from source) */
   FLOAT aosize;            /* max init orig size, multipliers for wpct,hpct */
   FLOAT bosize;            /* min init orig size, multipliers for wpct,hpct */
   FLOAT adsize;            /* max init dest size, multipliers for wpct,hpct */
   FLOAT bdsize;            /* min init dest size, multipliers for wpct,hpct */
   FLOAT aostr;            /* max init orig str, multipliers for wpct,hpct */
   FLOAT bostr;            /* min init orig str, multipliers for wpct,hpct */
   FLOAT adstr;            /* max init dest str, multipliers for wpct,hpct */
   FLOAT bdstr;            /* min init dest str, multipliers for wpct,hpct */
   FLOAT alife;             /* max particle life */
   FLOAT blife;             /* min particle life */
   FLOAT aodrag;            /* max init orig resistance to drift, force */
   FLOAT bodrag;            /* min init orib resistance to drift, force */
   FLOAT addrag;            /* max init dest resistance to drift, force */
   FLOAT bddrag;            /* min init dest resistance to drift, force */
   FLOAT indivd;            /* amount of individual direction, balance is group */
   FLOAT split;             /* amount of split, 0 to 1, balance is continous */
                            /* TEK - split is now "rotation dist factor" */
   FLOAT fntstr;            /* current strength */
   FLOAT drftx,drfty,drftz; /* "wind" */
   FLOAT lasttime;
   FLOAT curtime;
   ULONG seedincr;
   FLOAT caz,saz,cax,sax;   /* align trig storage */
   struct PathInfo *prrpath;   /* preroll animation control */
};

struct fountainmemb
{
   struct fountainmemb *next; /* even though not in use yet */
   struct cspline *m;       /* member change control */
   FLOAT init;              /* % time begin */
   FLOAT end;               /* % time end */
   FLOAT cycles;            /* local cycles, inside this member */
   USHORT type;             /* local type, bit packed periodic, etc */
   USHORT in;               /* info holder */
   USHORT rotorder;         /* rotation order and other info bits */
   FLOAT fwpct,lwpct;
   FLOAT fhpct,lhpct;
   FLOAT faorot,laorot;
   FLOAT fborot,lborot;
   FLOAT fadrot,ladrot;
   FLOAT fbdrot,lbdrot;
   FLOAT freldist,lreldist;
   USHORT fnumber,lnumber;
   FLOAT fadirx,fadiry,fadirz,ladirx,ladiry,ladirz;
   FLOAT fbdirx,fbdiry,fbdirz,lbdirx,lbdiry,lbdirz;
   FLOAT farx,fary,farz,larx,lary,larz;
   FLOAT fbrx,fbry,fbrz,lbrx,lbry,lbrz;
   FLOAT faorig,laorig;
   FLOAT fborig,lborig;
   FLOAT fadest,ladest;
   FLOAT fbdest,lbdest;
   FLOAT faosize,laosize;
   FLOAT fbosize,lbosize;
   FLOAT fadsize,ladsize;
   FLOAT fbdsize,lbdsize;
   FLOAT faostr,laostr;
   FLOAT fbostr,lbostr;
   FLOAT fadstr,ladstr;
   FLOAT fbdstr,lbdstr;
   FLOAT falife,lalife;
   FLOAT fblife,lblife;
   FLOAT faodrag,laodrag;
   FLOAT fbodrag,lbodrag;
   FLOAT faddrag,laddrag;
   FLOAT fbddrag,lbddrag;
   FLOAT findivd,lindivd;
   FLOAT fsplit,lsplit;
   FLOAT ffntstr,lfntstr; /* global strength for fountain */
   struct cspline *oimrotsp; /* orig image rotation angle */
   struct cspline *dimrotsp; /* dest image rotation angle */
   struct cspline *numsp; /* number particles */
   struct cspline *fntstrsp; /* global strength */
   struct cspline *lifsp; /* life */
   struct cspline *orisp; /* orig distance */
   struct cspline *dessp; /* dest distance */
   struct cspline *osizsp; /* orig size */
   struct cspline *dsizsp; /* dest size */
   struct cspline *ostrsp; /* orig strength */
   struct cspline *dstrsp; /* dest strength */
   struct cspline *odrasp; /* orig drag */
   struct cspline *ddrasp; /* dest drag */
   struct cspline *orx,*ory,*orz; /* orig rotations */
   struct cspline *drx,*dry,*drz; /* dest rotations */
   struct cspline *pldissp; /* individual distance */
   struct cspline *plsizsp; /* individual size */
   struct cspline *pldrasp; /* individual drag */
   struct cspline *plstrsp; /* individual strength */
   struct cspline *plrotsp; /* individual rotation */
   struct cspline *plagesp; /* individual aging */
   struct cspline *plimrsp; /* individual image rotation */
   struct cspline *prrnumsp; /* pre-roll number particles */
   /* these are "old age" csplines, particles older than 1.0 */
   struct cspline *oaplagesp; /* individual aging */
   struct cspline *oapldissp; /* individual distance */
   struct cspline *oaplrotsp; /* individual rotation */
   struct cspline *oapldrasp; /* individual drag */
   struct cspline *oaplsizsp; /* individual size */
   struct cspline *oaplstrsp; /* individual strength */
   struct cspline *oaplimrsp; /* individual image rotation */
};

/***************************
externobject structure is the hook for external handlers.

  save flags:
   as - always saved
   cs - conditionally saved (saved if in use, or flags set to use)
   ns - not saved
***************************/

struct externobject
{
   struct procobject *obj;         /* as: the procobject this belongs to */
   struct PolygonInfo *handle;     /* cs: may be more than one in list */
   struct PolygonInfo *renderpoly; /* cs: head of list of render polys */
   struct PathInfo *path;          /* as: path assign for ALL renderpolys */
   UBYTE handlerpath[120];         /* as: full path of handler */
   UBYTE handlername[40];          /* as: name of handler executable */
   UBYTE handlerid[40];            /* as: handler id, handler private */
   UBYTE userline[40];             /* as: user text line, handler private */
   ULONG alad_priv[4];             /* as: aladdin4d private */
   ULONG renderpolycount;          /* cs: maintained by aladdin */
   ULONG extcall;                  /* as: when external handler is called */
   ULONG rend;                     /* as: use of render polys */
   ULONG prev;                     /* as: use in preview */
   ULONG polysav;                  /* as: which poly(s) to save */
   ULONG exttexture;               /* as: allow texturing? */
   ULONG extattlist;               /* as: allow attlist assigns? */
   ULONG extshade;                 /* as: allow shading? */
   ULONG extcount;                 /* as: handler tracking, handler private */
   ULONG handlerversion;           /* as: handler version number */
   ULONG fluid_hand[6];            /* ns: handler private */
   ULONG fluid_arsize[6];          /* ns: aladdin maintained */
   ULONG *fluid_ar[6];             /* ns: handler private */
   ULONG sav_hand[6];              /* as: handler private */
   ULONG sav_arsize[6];            /* as: aladdin maintained */
   ULONG *sav_ar[6];               /* cs: handler private */
};


/**************************************************************************
 *
 * New structures in Aladdin 4D 5.0
 *
 * (Note that I have a different structure naming style than Greg.)
 *
 **************************************************************************/

/* For my own convenience: */

// same as type "vector"
typedef struct { FLOAT x, y, z; }   Vector;

// same as type "dvector"
typedef struct { DOUBLE x, y, z; }  DVector;

// same as type "lvector"
typedef struct { LONG x, y, z; }    LVector;

// same as type "uvector"
typedef struct { UBYTE x, y, z; }   UVector;


// Aladdin time values range from 0.0 - 1.0
typedef FLOAT  ATIME;

// "Real-World" time values are also floats
typedef FLOAT  RTIME;

// Aladdin coordinates are always stored as longwords
typedef LONG   AUNIT;

// "Real-World" coordinates are floats
typedef FLOAT  RUNIT;


/*
 * Someday I'd like to get every possible Aladdin object into the
 * same database list, for simplicity:
 *
 */
struct DBItem
{
   struct DBItem    *Next;          /* next database item */
   struct DBItem    *Prev;          /* previous database item */
   UBYTE             Type;          /* type of object */
   UBYTE             pad1[3];

   /* information about object follows */
};

#define ITEM_POLYGON    (0)
#define ITEM_LIGHT      (1)
#define ITEM_CAMERA     (2)
#define ITEM_GAS        (3)
#define ITEM_FLARE      (4)
#define ITEM_FOUNTAIN   (5)
#define ITEM_WAVE       (6)


/*
 * ObjectInfo:
 *
 * As of version 5.0, we are able to group polygons together into an
 * entity known only as an "Object".  This is a blatant and shameless attempt
 * at making Aladdin more understandable to Lightwave users.
 *
 * To accomplish this feat with a minimum of effort, we are stealing one of
 * the 5 grouping levels and calling it an "object grouping" level (no one
 * could possibly use 5 grouping levels in one drawing, right?).  This limits
 * us to 65535 objects per drawing.
 *
 * Objects can have names for easy selection via. a list requester or something.
 *
 * We also need to add the concept of hierchically linked objects.  That is,
 * the "Body" object contains the "Arms" and "Legs" objects, and so on.  In this
 * case, the "Body" object may not actually contain any polygons because it is
 * entirely made up of children polygons.
 *
 * We should keep inverse kinematics in mind.  So that in the above example,
 * if one were to grab and move the "Left Upper Arm" object, the "Left Fore Arm"
 * and "Left Hand" objects would move also.  This will require some rules for
 * translating movement and rotation of one child to other siblings.
 *
 * Note that to find all the polygons belonging to a particular ObjectInfo,
 * one needs to traverse the database looking for polygons where group[4]
 * matches the ObjectInfo ID field.  To find the polygons belonging to children
 * too, one needs to traverse the ObjectInfo->Children list.
 *
 */

/*
 * Current implementation of "Objects":
 *
 * An "Object" in a scene is indicated by a PolygonInfo struct with a
 * non-zero object pointer.  The object pointer points to an ObjectInfo
 * struct, which describes the object in detail.
 *
 */

/*
 * Last implementation 21.06.96:
 *
 * An object is now a procobject, very similar to an extern object actually.
 * procobject->special points to the ObjectInfo structure.
 *
 */

struct ObjectInfo
{
   struct ObjectInfo      *Next;       /* Next object */
   struct ObjectInfo      *Prev;       /* Previous object */

   struct ObjectInfo      *NextChild;  /* Next sibling (needed?) */
   struct ObjectInfo      *PrevChild;  /* Previous sibling (needed?) */

   struct ObjectInfo      *Parent;     /* Parent object.  If NULL, there is none. */
   struct ObjectInfo      *Children;   /* Points to first child or NULL if no children. */
                                       /* Theoretically, anything that affects a parent
                                          will also affect all its children. */

   ULONG                   ID;         /* Unique object ID value, used mainly
                                          when saving a scene to attach each
                                          polygon to a group.  Must be non-zero,
                                          because if a polygon's object ID is
                                          zero, it means it doesn't belong to
                                          an object. */

   UBYTE                   Name[64];   /* Human-readable object name,
                                          should be unique but is not
                                          required to be so. */

   struct procobject     *Tag;         /* Pointer back to the polygon tag in the
                                          database (our "handle"). */

   struct PolygonInfo     *FirstPoly,  /* Polygons that make up this object */
                          *LastPoly;

   /*
    * These fields are reserved for constraints and inverse kinematics.
    *
    */

   /* Rotation constraints, in degrees: */
   FLOAT                   MinRotateX, MaxRotateX;
   FLOAT                   MinRotateY, MaxRotateY;
   FLOAT                   MinRotateZ, MaxRotateZ;


   LONG                    reserved[16];

};

#define OBJECT_LEVEL       (4)         /* The 'object group' level number */


/*
 * NamedGroup:
 *
 * Introducing another concept:  A group of objects with a name.  This
 * allows us to easily select them later, without having to find them in
 * the scene and click on them.
 *
 */
struct NamedGroup
{
   struct NamedGroup      *Next;
   struct NamedGroup      *Prev;
   UBYTE                   Name[128];
   ULONG                   Group;            /* group number */
   ULONG                   ID;               /* group identifier */
};



/*
 * Shading:
 *
 * An extensible structure to hold shading attributes.  Used by the
 * new shading functions in alad.library.
 *
 */
typedef struct Shading
{
   UWORD    Flags;
   UWORD    Angle;
   UWORD    reserved[4];
}
Shading;

#define SHADEF_PHONG       (0x0001)
#define SHADEF_GVALUE      (0x0002)
#define SHADEF_GCOLOR      (0x0004)
#define SHADEF_ADJACENT    (0x8000)



/*
 * FillGlobals
 *
 * Structure that is passed between Aladdin and engine.library containing
 * a bunch of scanline buffer pointers.  The library allocates and maintains
 * the buffers, but Aladdin needs to have access to them.
 *
 */
typedef struct FillGlobals
{
   FLOAT    *fg_perb;      /* xper buffer */
   FLOAT    *fg_rayx;
   FLOAT    *fg_zbp;       /* z buffer */
   FLOAT    *fg_xbp;       /* x buffer */
   FLOAT    *fg_ybp;       /* y buffer */
   UBYTE    *fg_cbp;       /* tracker */
   LONG     *fg_line;      /* bucket */
   LONG     *fg_sbp;       /* show buf */
   LONG     *fg_sbp2;      /* remembered for convolve */
   LONG     *fg_sbp3;      /* remembered for convolve */

   ULONG    *fg_fbpc;      /* frame buf for color */
   ULONG    *fg_an1, *fg_an2, *fg_an3; /* antialiasing buffers */
   ULONG    *fg_whmfbpc, *fg_iwhmfbpc;
   LONG     *fg_whmsbp, *fg_iwhmsbp;

   struct Pair *fg_pptr;
   LONG      fg_polycount;

   UBYTE    *fg_edgepc;    /* NEW: edge buffer */

   UBYTE    *fg_mask;      /* NEW: mask to control where to render on scanline */

   ULONG    *fg_whmfbpc2;  /* NEW: support 3x3 antialiasing */
   LONG     *fg_whmsbp2;

   ULONG    fg_flags;      /* NEW: various flags (see below) */

   LONG     reserved[13];
}
FillGlobals;

#define FGF_NOSORTPOLYGONS (0x0001)    /* do not sort polygons before rendering */
