#ifndef RELEASE5
#define RELEASE5
#endif

#ifdef RELEASE5

#define ALADNAME        "alad.library"
#define ALADVERSION     (5)

#define APPTEKNAME      "apptek.library"
#define APPTEKVERSION   (1)

#define ENGINENAME      "engine.library"
#define ENGINEVERSION   (5)

// Application IDs:
#define AID_ALADDIN     (1010101)

// Pen numbers for Pens[] and DrPt[] arrays:
enum
{
   GROUND_PEN = 0,
   AXISX_PEN,
   AXISY_PEN,
   AXISZ_PEN,
   ATPX_PEN,
   ATPY_PEN,
   ATPZ_PEN,
   POLY_PEN,
   PATH_PEN,
   POLYSEL1_PEN,     // selected polygon
   POLYSEL2_PEN,     // chosen polygon
   PATHSEL1_PEN,
   PATHSEL2_PEN,
   POINT_PEN,
   CAMERA_PEN,
   LIGHT_PEN,
   POINTSEL_PEN,
   SPLINE_PEN,       // spline segment
   SPLINEC_PEN,      // spline control segment
   OBJECT_PEN,       // object pen
   OBJECTSEL_PEN,    // selected object pen
   LIGHTTARGET_PEN,  // line drawn between light and its target
   dummy_PEN
};

#endif

/* this isn't in float.h! 90 mil ought to be enough */
/* NOTE: it is in float.h in latest lattice, but now used in render
   modes extensively at this value, so left this in
*/
#define MINUSEVAL -90000000.0

/* very often have to divide by 255.0, the size of a UByte,
   so to avoid all the division... */
#define DSOUB 0.0039215
/* similiarly, for divide by 1000.0..... */
#define DTHOUSAND 0.001

/* clamping macros for speed */
#define cclamp(a,b) {if(a>b) a=b;}
#define fclamp(a,b) {if(a<b) a=b;}
#define bclamp(a,b,c) {if(a>c) a=c; if(a<b) a=b;}
/* often need to clamp 3 vars at once */
#define cclampthree(a,b,c,d) {if(a>d) a=d; if(b>d) b=d; if(c>d) c=d;}
#define fclampthree(a,b,c,d) {if(a<d) a=d; if(b<d) b=d; if(c<d) c=d;}
#define bclampthree(a,b,c,d,e) {if(a<d) a=d; if(b<d) b=d; if(c<d) c=d; if(a>e) a=e; if(b>e) b=e; if(c>e) c=e;}

#define GOTABORT -0x7fffffffL
/* careful, spacestatus is a short.... */
/* positive value or 0 is movespace instruction */
#define MAKENEWSPACE -1000
#define DELETESPACE -2000
#define MOVETOSPACE -4000
#define GOTSPACEABORT -3000
#define MOVESPACE 0x1000

#define USHT_MAX 65535

/* this alters the size of the minimum shnode allocation */
/* 6 is typical for all triangles object */
#define MINSHCNT 6

#define TOUPPER(c)  ( (c) >= 'a' && (c) <= 'z' ? (c) - 'a' + 'A' : (c) )

/* four-character IDentifier builder.*/
#define MakeID(a,b,c,d) ( (LONG)(a)<<24L | (LONG)(b)<<16L | (c)<<8 | (d) )

/* Standard group IDs. A chunk with one of these IDs contains a
  SubTypeID followed by zero or more chunks.*/
#define AD3D MakeID('A','D','3','D')
#define AD4D MakeID('A','D','4','D')
#define AD4P MakeID('A','D','4','P')
#define ADPR MakeID('A','D','P','R')
#define APRO MakeID('A','P','R','O')
#define ALAD MakeID('A','L','A','D')
#define ALAA MakeID('A','L','A','A')
#define ALAB MakeID('A','L','A','B')
/* this is the last one for drawings, version number now stored in file */
#define ALDN MakeID('A','L','D','N')
/* #define %!PS MakeID('%','!','P','S') can't do */
#define SANM MakeID('S','A','N','M')
#define NWSP MakeID('N','W','S','P')
#define MAGN MakeID('M','A','G','N')
#define VIEW MakeID('V','I','E','W')
#define POLY MakeID('P','O','L','Y')
#define DATA MakeID('D','A','T','A')
#define PALA MakeID('P','A','L','A')
#define LIGT MakeID('L','I','G','T')
#define ANID MakeID('A','N','I','D')
#define OBJ MakeID('O','B','J',' ')
#define BEZ4 MakeID('B','E','Z','4')
#define PDPF MakeID('P','D','P','F')
#define ANID MakeID('A','N','I','D')
#define FT3D MakeID('F','T','3','D')
#define LE3D MakeID('L','E','3','D')
#define FORM MakeID('F','O','R','M')
#define PROP MakeID('P','R','O','P')
#define LIST MakeID('L','I','S','T')
#define CAT MakeID('C','A','T',' ')
#define FILLER MakeID(' ',' ',' ',' ')
#define APMT MakeID('A','P','M','T')
#define ADMT MakeID('A','D','M','T')
#define AATL MakeID('A','A','T','L')
#define ABML MakeID('A','B','M','L')
/* this is the last one for txlists, version number now stored in file */
#define ATXV MakeID('A','T','X','V')
#define AATB MakeID('A','A','T','B')
#define AATC MakeID('A','A','T','C')
#define AATD MakeID('A','A','T','D')
/* this is the last one for attlists, version number now stored in file */
#define AATV MakeID('A','A','T','V')
#define ACSP MakeID('A','C','S','P')

/*************
these are now variables
#define YMIN 0
#define XMIN 0
**************/
#define VIEWTOP 12
#define VIEWSIDE 88

#define PRINTNEARPOINT printcoords(1)
#define OFFCOORDS printcoords(0)

#define GOTRANDOM 1234598
#ifdef RELEASE5
#define BCK 0
#define BLK 1
#define WHI 2
#define RED (redPen)
#else
#define WHI 1
#define RED 3
#define BLK 2
#define BCK 0
#endif

#define DRAWWHICH 1
#define DRAWSELECTED 2
#define DRAWALL 4
#define SAVEWHICH 8
#define SAVESELECTED 16
#define DRAWALLMASK 255
#define RESETSHIFT 8

#define IAMAPATH -1
#define IAMALIGHT -2
/* #define IAMAWAVE -3 are these used anymore? */

/*************************************************************
 *
 * Paths
 *
 *************************************************************/

/* the following are for paths in movetype and type variables */
/* see later for explaination of type<=>movetype shifts for anim routines */
#define CYCLEMASKX 0x01
#define CYCLEMASKY 0x02
#define CYCLEMASKZ 0x04
#define MOVEMASK 0x08
/* #define DIRECTMASK 0x10 no longer used */
#define CYCLEMOVEMASK 0x20
#define MOVELASTMASK 0x40
/* #define LOCALMOVEMASK 0x80 no longer used */
/* bit 7 */
#define ANGLEORDERMASK 0x700
/* bits 8,9 and 10, for ordermask, 3 bits, shift by 8 */
/* these are what it represents */
#define DOXYZ 0
#define DOXZY 1
#define DOZXY 2
#define DOYXZ 3
#define DOYZX 4
#define DOZYX 5
#define PLOCKMASK 0x800
/* 11th bit */
/* #define DEFORMON 0x1000 no longer used */
/* 12th bit */
#define DEFORMCYCLEMASK 0x2000
/* 13th bit */
/* the 14 bit is alignment flag */
#define PATHALIGNMASK (1<<14)
/* the 15,16,17 bits are for alignment angle locks: */
#define LOCKXMASK (1<<15)
#define LOCKYMASK (1<<16)
#define LOCKZMASK (1<<17)
/* the 18 bit is for reverse of angle movement */
/* although named "x", affects whichever angle is free at time */
#define REVXMASK (1<<18)
/* 19th bit: use last segment in align */
#define PATHALIGNLASTMASK (1<<19)
/* this is for overall periodicity, path and pathmemb */
#define CYCLEMASK (1<<20)
#define MAINCYCLEMASK (1<<21)
#define CONSTANTVELOCITY (1<<22)


/* for guidepaths to rotate
   default is BI (before instancing)
   if set, rotate AI (after instancing)
*/
#define AFTERINSTANCEMASK (1<<23)


/* the path->type is used for various flag setting,
   unsetting, frame to frame, no permanent flags!
   keep fluid
   bits in use: 0: inifinitewave
                1: translatedbyguide
                2-7: disp, alon
                8-10: order of rotation
               20: cyclemask
*/

/* this for translation by guidepath. only allowed once per frame */
/* bit 1 */
#define ISTRANSLATEDBYGUIDE(p) (p->type&2)
#define DOTRANSLATEDBYGUIDE(p) (p->type|=2)
#define UNTRANSLATEDBYGUIDE(p) (p->type&=~2)
/* this is for wave infinite flag, used in both path type variable
   and pathmemb wtype variable */
/* bit 0 */
#define INFINITEWAVE 1
/* these are also in path type and pathmemb wtype */
/* bits 2 to 7 */
#define DISPAXISX (1<<2)
#define DISPAXISY (1<<3)
#define DISPAXISZ (1<<4)
#define ALONAXISX (1<<5)
#define ALONAXISY (1<<6)
#define ALONAXISZ (1<<7)


/* held in path->itype variable for translation/rotation in instances */
#define ISITRA(path) (path->itype&1)
#define DOITRA(path) (path->itype|=1)
#define UNITRA(path) (path->itype&=~1)
#define ISIROT(path) (path->itype&2)
#define DOIROT(path) (path->itype|=2)
#define UNIROT(path) (path->itype&=~2)

#define FILESGADGBUFF Gadget2SIBuff
#define PATHGADGBUFF Gadget1SIBuff

#define PID180 0.017453292
#define PITIMES2 6.283185307
#define INVPITIMES2 0.159154943

/* the saveicon var can be used for flags, but is not saved to file */
/* so use it for switches that should not be changed by a file load */
/* like tooltypes, etc */
#define SAVEICONMASK (1)
#define RESOLVEROKMASK (1<<1)
#define AUTOQUICKMASK (1<<2)

/*************************************************************
 *
 * fillres, fillres2
 *
 *************************************************************/

/* in Draw4D, a var called fillspace was used, replaced by
   the bit packed var fillres2, February 16, 1992, for Draw4D-Pro 1.2
   these are defines for fillres2 var
*/
#define CONVBCKGMASK (1<<1)
#define CONVEDGEMASK (1<<2)

/* these are for aspect ratio types
   NOTE that under version 4.0 and above, if the user has operating
   system 2.0 or better, the aspect ratio is now
   interactively adjustable, so these flags are NOT USED

   videolockmask locks a typical video screen ratio, regardless
   of the horizontal/vertical lines used, great for multiple
   resolution boards like the resolver
   the scalelockx and scalelocky masks are meant for people doing
   printing from 24 bit files, allowing page layout choices of
   size in the bitmap and deciding whether to scale the image they
   see in the editor to be proportional with the new width, or the
   new height.
   no flag means a normal lock:
   the normal lock will image the polys at the same size they
   would be when using a regular screen, ie if they are 8 inches
   across on a 640x400, they will be 8 inches on any size screen.
   this mode takes into account hires and lace flags only in
   regular and deepfile modes, not in resolver modes
*/
#define VIDEOLOCKMASK (1<<3)
#define SCALELOCKXMASK (1<<4)
#define SCALELOCKYMASK (1<<5)
/* this is a 0 to 255 value for tint */
/* bits 8 to 15 */
#define TINTVALUEMASK 0x0000ff00
/* bits 16-31 are still open */
#define FOREGROUNDMASK (1<<16)
#define OVERLAYMASK (1<<17)
#define SHADOWMASK (1<<18)
#define LOWLIMITMASK (1<<19)
#define HIGHLIMITMASK (1<<20)
/* note that this is also defined in newiff/saveilbm.c */
#define HAMEIGHTMASK (1<<21)
/* allow half and double internal resolutions compared with image res */
#define HEIDOUBMASK (1<<22)
#define HEIHALFMASK (1<<23)
#define WIDDOUBMASK (1<<24)
#define WIDHALFMASK (1<<25)
/* if fieldrendering, allow reverse of field */
#define FIELDREVERSEMASK (1<<26)
/* These are new in 5.0: */
#define MOTIONBLURMASK (1<<27)
#define FOUNTAINMASK (1<<28)
#define FLAREMASK (1<<29)
#define AATRIPLEMASK (1<<30)
#define AAQUADMASK (1<<31)
#define AABESTMASK AATRIPLEMASK      /* if set in addition to HEIDOUB/WIDDOUBMASK,
                                        anti-aliases at three times image size */

/* these are defines for fillres var */
#define LACEMASK 1
#define HIRESMASK (1<<1)
#define OVERSCANMASK (1<<2)
/* this is also defined in newiff/saveilbm.c */
#define HAMMASK (1<<3)
#define SOFTENEDGEMASK (1<<4)
#define DITHERMASK (1<<5)
#define DARKMASK (1<<6)
#define SPACEMASK (1<<7)
#define FILLMASK (1<<8)
#define LIGHTMASK (1<<9)
#define FADEMASK (1<<10)
#define BACKGROUNDMASK (1<<11)
/* 1<<12 was autoclipmask */
#define OPALMASK (1<<12)
/* 1<<13 was tintmask */
#define FIELDRENDERMASK (1<<13)
#define MATCHPALETTEMASK (1<<14)
#define CONVOLVEMASK (1<<15)
#define SEVEREOSCANMASK (1<<16)
#define NUMBERPLANESMASK (7 << 17)
/*  use like this: (fillres&NUMBERPLANES)>>17,  gives 1 through 7 planes */
#define DCTVFILTERMASK (1<<20)
#define CUSTOMSCREENMASK (1<<21)
#define TEXTUREMASK (1<<22)
#define SHADEMASK (1<<23)
#define ROUNDMASK (1<<24)
#define TRANSPARENCYMASK (1<<25)
/* this is for old file compat, don't use except for file conversions */
#define DEEPBACKGROUNDMASK (1<<26)
#define FCMASK (1<<27)
#define GLOSSMASK (1<<28)
/* dualpass mask was #define DUALPASSMASK (1<<29), changed to retina
 watch old files! when loading, if don't have retina and bit set, unset it */
#define RETINAMASK (1<<29)
#define DCTVMASK (1<<30)
#define RESOLVERMASK (1<<31)

/* these are for use in code allowing global switch */
/* just UNSETUSINGFOREGROUND if want to render without foreground */
/* allows foreground to still point to its bmlist but not render */
#define USINGFOREGROUND (foreground() && (fres2&FOREGROUNDMASK))
#define USINGBACKGROUND (background() && (fres&BACKGROUNDMASK))
#define USINGOVERLAY (overlay() && (fres2&OVERLAYMASK))

/*************************************************************
 *
 * fillres3
 *
 *************************************************************/

/* I think fillres3 was ununsed in 4.x - we now need it */
#define GASMASK            (1 << 1)       /* enable gas objects */
#define COMPOSITEMASK      (1 << 2)       /* enable external zbuffer compositing */
#define NODISPLAYMASK      (1 << 3)       /* disable render screen output, save to disk only */
#define TOASTERMASK        (1 << 4)       /* enable toaster rendering */
#define AAHEITRIPLEMASK    (1 << 5)       /* triple vertical rendering */
#define AAHEIQUADMASK      (1 << 6)       /* quad vertical rendering */

#define DOINGGAS           (*fillres3() & GASMASK)
#define DOINGCOMPOSITE     (*fillres3() & COMPOSITEMASK)


/*************************************************************
 *
 * Polygons
 *
 *************************************************************/

/* UBYTE id, in order high to low */
/* meld,bmp,shade,texture,light,path,selected,show */
/* use for only regular polys showing and selected, excluding path,light */
#define REGPOLYSELECTED(a) ((a->id&15) == 3)
/* for regpoly without worry about selected */
#define REGPOLY(a) (!(a->id&12))
/* ISCAMERA(p) is (p->in & 32),  TARGET(p) is (p->in |= 64) */
#define NOTCAMTARG(a) (!(a->in&96))
/* for deterniming if poly is light or path */
#define ISLIGHTORPATH(a) (a->id&12)
/* for any poly selected and showing, remember, hidden are never selected */
/* so just use selected */
/* for a light or regular poly that is showing */
#define NOTAPATHANDSHOW(a) ((a->id&5) == 1)
#define SHOW(a) (a->id |= 1)
#define HIDE(a) (a->id &= ~1)
/* this for any poly showing */
#define ISSHOW(a) (a->id&1)
/* selecting a poly */
#define SELECT(a) (a->id |= 2)
/* selecting and insuring a poly is showing */
#define SELECTSHOW(a) (a->id |= 3)
/* unselecting a poly */
#define UNSELECT(a) (a->id &= ~2)
/* unselecting and hiding a poly */
#define UNSELECTHIDE(a) (a->id &=~3)
#define ISSELECTED(a) (a->id&2)
#define PATH(a) (a->id |= 4)
#define UNPATH(a) (a->id &= ~4)
#define ISPATH(a) (a->id&4)
#define LIGHT(a) (a->id |= 8)
#define UNLIGHT(a) (a->id &= ~8)
#define ISLIGHT(a) (a->id&8)
#define TEXTURE(a) (a->id |= 16)
#define UNTEXTURE(a) (a->id &= ~16)
#define USETXTUR(a) (a->id&16)
#define ISSHADED(a) (a->id&32)
#define SHADE(a) (a->id |= 32)
#define UNSHADE(a) (a->id &= ~32)
#define ISBMP(a) (a->id&64)
#define BMP(a) (a->id |= 64)
#define UNBMP(a) (a->id &= ~64)
#define ISMELD(a) (a->id&128)
#define MELD(a) (a->id |= 128)
#define UNMELD(a) (a->id &= ~128)
/* and this one for individual polygons that are included in a meld */
#define ISMELDPOLY(a) (a->pshow&64)
#define MELDPOLY(a) (a->pshow |= 64)
#define UNMELDPOLY(a) (a->pshow &= ~64)
#define RESETPSHOW(a) (a->pshow &= ~ 63)
/* 63 is binary 00111111 */
/* these are not used, instead 128 is used for optimization in makebuf.c
#define ISNORMALLOCK(a) (a->pshow & 128)
#define NORMALLOCK(a) (a->pshow |= 128)
#define UNNORMALLOCK(a) (a->pshow &= ~128)
*/
/* to get rid of flags for texture,shade,bmp, use 112, or 01110000 */
#define UNTEXTURESHADEBMP(a) (a->id &= ~112)

/* the in variable is similar to the id var, for information flags */
#define WAVE(a) (a->in |= 1)
#define UNWAVE(a) (a->in &= ~1)
#define ISWAVE(a) (a->in&1)
#define INVISIBLE(a) (a->in&2)
#define MAKEINVISIBLE(a) (a->in |= 2)
#define MAKEVISIBLE(a) (a->in &= ~2)
#define GAS(a) (a->in |= 4)
#define UNGAS(a) (a->in &= ~4)
#define ISGAS(a) (a->in&4)
/* for dominant normal vector, need 3 bits, for 0, 1 or 2 */
#define DOMINANT(a) ((a->in&24)>>3)
#define MAKEDOMINANT(p,a) (p->in |= (a<<3))
#define CLEARDOMINANT(p) (p->in &= ~24)
#define CAMERA(p) (p->in |= 32)
#define ISCAMERA(p) (p->in & 32)
#define UNCAMERA(p) (p->in &= ~32)
#define TARGET(p) (p->in |= 64)
#define ISTARGET(p) (p->in & 64)
#define UNTARGET(p) (p->in &= ~64)

/* to avoid polys that cannot be rendered:
   wave:   in    1
   camera: in   32
   target: in   64
   path:   id    4
   light:  id    8
*/
#define WONTRENDER(a) ((a->in&97)|(a->id&12))

/*************************************************************
 *
 * Lights
 *
 *************************************************************/

/* for lights, periodic and highlight flags are in type member */
#define ISLIGHTSHADOW(a) (a->type & 4)
#define ISLIGHTHIGHLIGHT(a) (a->type & 2)
#define UNSHADOWLIGHT(a) (a->type &= ~4)
#define UNHIGHLIGHTLIGHT(a) (a->type &= ~2)
#define LIGHTSHADOW(a) (a->type |= 4)
#define LIGHTHIGHLIGHT(a) (a->type |= 2)
#define ISUSELIGHT(a) (a->type & 8)
#define UNUSELIGHT(a) (a->type &= ~8)
#define DOUSELIGHT(a) (a->type |= 8)
/* to optimize, checking range of light to be small */
#define ISLOWRANGELIGHT(a) (a->type & 16)
#define UNLOWRANGELIGHT(a) (a->type &= ~16)
#define DOLOWRANGELIGHT(a) (a->type |= 16)

/* extracting color/value from polys, in c, and oc */
/* 8 bits each, value, red, green, blue */
/* 0x0f is 00001111 */

/*
#define LVAL(a) (a->c>>24)
#define SVAL(a) (a->c>>28)
*/

#define LRED(a) ((a->c&0x00ff0000)>>16)
#define SRED(a) ((a->c&0x00f00000)>>20)
#define LGRN(a) ((a->c&0x0000ff00)>>8)
#define SGRN(a) ((a->c&0x0000f000)>>12)
#define LBLU(a) (a->c&0x000000ff)
#define SBLU(a) ((a->c&0x000000f0)>>4)

#define TRAN(a) (a->t & 0x000000ff)
#define HARD(a) ((a->t&0x0000ff00)>>8)

#define OVAL(a) (a->atl->nv)
#define ORED(a) (a->atl->nr)
#define OGRN(a) (a->atl->ng)
#define OBLU(a) (a->atl->nb)
#define OHRD(a) (a->atl->sv)
#define OTRN(a) (a->atl->tr)

/* these are for gouraud shading and using the color present in an
  assigned bitmap, and adjacent polys. They are held in poly->bmp->flip */
#define USESHADING 1
#define USEBMCOLOR 2
#define USETXRANTIALIASING 4
#define USECOLORSHADING 8
#define BUTTPOLY 16
#define HASMORETHANTHREE 32
#define USEPHONGSHADING 64
/* often need to ask:
     if(points < 5) {
      if((bmrpoly->flip&USESHADING)||(bmrpoly->flip&USECOLORSHADING)) {
       if(!(bmrpoly->flip&HASMORETHANTHREE)) {
 and can reduce it by reason, if USE...SHAD..
 then points has to be less than 5, so eliminate that
 now from above defines, want to make sure that flip
 has bits set corresponding to 1 and 8, but not 32,
 ie 00001001, so.....
*/
#define USEANYSHADING(a) (a&9)&&(!(a&32))
/* after files converted, going to change to the new way, which
   sets bit #5 in poly->id if the poly uses shading, (of course, this
   would also mean it has less than 5 points), and if it does not
   share a common point with more than 3 other polygons
*/


/* this variable controls the number of textures that can be loaded */
/* watch out, room in selected var for this many, could be changed,
   but have to recompile all references */
/* #define MAXTEXTURES 64 */

#define Z_MAX 0x7fffffffL
#define Z_MIN -0x7fffffffL

#define ZERO 0
#define BACKGROUND 0

// TEK:
// Boy would I love to remove these!
// They cause conflicts with <intuition/imageclass.h> which
// is included by <apptek.h>.
#define X 0
#define Y 1
#define Z 2

#define MAX_INTENSITY 255

#define RMASK 0x0F00
#define GMASK 0x00F0
#define BMASK 0x000F
/* will I run into trouble on this DVMASK due to negatives?? */
#define DVMASK 0xff000000
#define DRMASK 0x00ff0000
#define DGMASK 0x0000ff00
#define DBMASK 0x000000ff

#define GETNEWTRSTRUCT (struct trans *)AllocMem(sizeof(struct trans),MEMF_PUBLIC|MEMF_CLEAR)
#define FREETRSTRUCT(a) FreeMem(a,sizeof(struct trans))
#define GETNEWBUF (long *)AllocMem((sizeof(long)*xsize),MEMF_PUBLIC|MEMF_CLEAR)
#define GETNEWFBUF (FLOAT *)AllocMem((sizeof(FLOAT)*xsize),MEMF_PUBLIC|MEMF_CLEAR)
#define FREETRBUF(a)   FreeMem(a,sizeof(LONG)*xsize)
#define FREETRFBUF(a)   FreeMem(a,sizeof(FLOAT)*xsize)

#define unless(a) if(!(a))

#define MYSTANDARDSCREEN 0
#define MYCUSTOMSCREEN 1
#define MYDCTVSCREEN 2
#define MYRESOLVERSCREEN 4
#define MYFCSCREEN 8
#define MYOPALSCREEN 16
#define MYRETINASCREEN 32

/*
#define DATAPASSID 0x0000ffff
#define DAPOLD 1<<0
#define DAPNOMEM 1<<1
#define DAPFILEERROR 1<<2
#define DAPLETEMKNOW 1<<3
#define DAPLOCALVARREAD 1<<4
#define DAPLOCALVARSAVE 1<<5
*/

/*************************************************************
 *
 * struct BMLmemb
 *
 *************************************************************/

/* I changed these to numbers, but no change in code size or speed
   compiler/optimizer must take care of this??

  if add to this list check bmmapsup3.c!!!
*/
#define BMDOGENLOCK(a)  (a->info |=  1)
#define BMISGENLOCK(a)  (a->info &   1)
#define BMUNGENLOCK(a)  (a->info &= ~1)
#define BMDODECAL(a)    (a->info |=  (1<<1))
#define BMISDECAL(a)    (a->info &   (1<<1))
#define BMUNDECAL(a)    (a->info &= ~(1<<1))
#define BMDOBUMP(a)     (a->info |=  (1<<2))
#define BMISBUMP(a)     (a->info &   (1<<2))
#define BMUNBUMP(a)     (a->info &= ~(1<<2))
#define BMDOOPAC(a)     (a->info |=  (1<<3))
#define BMISOPAC(a)     (a->info &   (1<<3))
#define BMUNOPAC(a)     (a->info &= ~(1<<3))
#define BMDOXACTIVE(a)  (a->info |=  (1<<4))
#define BMISXACTIVE(a)  (a->info &   (1<<4))
#define BMUNXACTIVE(a)  (a->info &= ~(1<<4))
#define BMDOYACTIVE(a)  (a->info |=  (1<<5))
#define BMISYACTIVE(a)  (a->info &   (1<<5))
#define BMUNYACTIVE(a)  (a->info &= ~(1<<5))
#define BMDOZACTIVE(a)  (a->info |=  (1<<6))
#define BMISZACTIVE(a)  (a->info &   (1<<6))
#define BMUNZACTIVE(a)  (a->info &= ~(1<<6))
#define BMDOSHINGLES(a) (a->info |=  (1<<7))
#define BMISSHINGLES(a) (a->info &   (1<<7))
#define BMUNSHINGLES(a) (a->info &= ~(1<<7))
#define BMDOPROJECT(a)  (a->info |=  (1<<8))
#define BMISPROJECT(a)  (a->info &   (1<<8))
#define BMUNPROJECT(a)  (a->info &= ~(1<<8))
#define BMDOWRAPCYL(a)  (a->info |=  (1<<9))
#define BMISWRAPCYL(a)  (a->info &   (1<<9))
#define BMUNWRAPCYL(a)  (a->info &= ~(1<<9))
#define BMDOWRAPSPH(a)  (a->info |=  (1<<10))
#define BMISWRAPSPH(a)  (a->info &   (1<<10))
#define BMUNWRAPSPH(a)  (a->info &= ~(1<<10))
#define BMDOFREEANG(a)  (a->info |=  (1<<11))
#define BMISFREEANG(a)  (a->info &   (1<<11))
#define BMUNFREEANG(a)  (a->info &= ~(1<<11))
#define BMDOENVIRON(a)  (a->info |=  (1<<12))
#define BMISENVIRON(a)  (a->info &   (1<<12))
#define BMUNENVIRON(a)  (a->info &= ~(1<<12))
#define BMDOFLIPX(a)    (a->info |=  (1<<13))
#define BMISFLIPX(a)    (a->info &   (1<<13))
#define BMUNFLIPX(a)    (a->info &= ~(1<<13))
#define BMDOFLIPY(a)    (a->info |=  (1<<14))
#define BMISFLIPY(a)    (a->info &   (1<<14))
#define BMUNFLIPY(a)    (a->info &= ~(1<<14))
#define BMDONORMAL(a)   (a->info |=  (1<<15))
#define BMISNORMAL(a)   (a->info &   (1<<15))
#define BMUNNORMAL(a)   (a->info &= ~(1<<15))
#define BMDOBELLBL(a)   (a->info |=  (1<<16))
#define BMISBELLBL(a)   (a->info &   (1<<16))
#define BMUNBELLBL(a)   (a->info &= ~(1<<16))
#define BMDOPROCEDURE(a) (a->info |=  (1<<17))
#define BMISPROCEDURE(a) (a->info &   (1<<17))
#define BMUNPROCEDURE(a) (a->info &= ~(1<<17))
#define BMDOANTIAL(a)    (a->info |=  (1<<18))
#define BMISANTIAL(a)    (a->info &   (1<<18))
#define BMUNANTIAL(a)    (a->info &= ~(1<<18))
#define BMDOFILTER(a)    (a->info |=  (1<<19))
#define BMISFILTER(a)    (a->info &   (1<<19))
#define BMUNFILTER(a)    (a->info &= ~(1<<19))
#define BMDOTUCK(a)    (a->info |=  (1<<20))
#define BMISTUCK(a)    (a->info &   (1<<20))
#define BMUNTUCK(a)    (a->info &= ~(1<<20))
#define BMDOSPECULAR(a)  (a->info |=  (1<<21))
#define BMISSPECULAR(a)  (a->info &   (1<<21))
#define BMUNSPECULAR(a)  (a->info &= ~(1<<21))
#define BMDOILLUM(a)  (a->info |=  (1<<22))
#define BMISILLUM(a)  (a->info &   (1<<22))
#define BMUNILLUM(a)  (a->info &= ~(1<<22))
/* the combination procedural/bitmap indexing */
/* note that the procedure is treated as a procedural in code
   and special cased for tiles flag if bmr is of concern
*/
#define BMDOTILES(a) (a->info |=  (1<<23))
#define BMISTILES(a) (a->info &   (1<<23))
#define BMUNTILES(a) (a->info &= ~(1<<23))
#define BMDONEGATIVE(a) (a->info |= (1<<24))
#define BMISNEGATIVE(a) (a->info &   (1<<24))
#define BMUNNEGATIVE(a) (a->info &= ~(1<<24))
#define BMDOTRANSMOD(a) (a->info |= (1<<25))
#define BMISTRANSMOD(a) (a->info &   (1<<25))
#define BMUNTRANSMOD(a) (a->info &= ~(1<<25))
/* added October 17, 1994, point spherical projections */
#define BMDOWRAPSPHPNT(a)  (a->info |=  (1<<26))
#define BMISWRAPSPHPNT(a)  (a->info &   (1<<26))
#define BMUNWRAPSPHPNT(a)  (a->info &= ~(1<<26))

/* the upper 24 bits of the numcol var in the bitmapmembers are used for
   various purposes, the lower 8 are used for number of colors in the
   procedural texture.......
   the upper bits are set in setinten.c and unset after each render
   so that old versions of the program may read the file
*/
#define NUMCOLMASK 255

/* often need to ask if genlock | decal so... */
#define BMISGENLOCKORDECAL(a) (a->info & 3)

/* if a poly has a bmlist pointer, it uses a texture
   unless it is a procedural */
/* BE CAREFUL! this has changed with the addition of the
   bitmap tiles type which is a combination of
   procedural and bitmap indexing
   change this and recompile all references
*/
#define USESBITMAP(a) ((a->bmr)&&(!(BMISPROCEDURE(a))))

/*************************************************************
 *
 * Gases
 *
 *************************************************************/

/* these are defines for gases, held in ga->att member, 32 bits */
/* available only one at a time */
/* for these, side first is heavy, ie T2B is top to bottom,
   full at top, graduating to nothing at the bottom
   F2B is front to back, L2R is left to right */
#define ISSPHERE(a) (a->att & 1)
#define ISSOLID(a)  (a->att & (1<<1))
#define IST2B(a)  (a->att & (1<<2))
#define ISB2T(a)  (a->att & (1<<3))
#define ISL2R(a)  (a->att & (1<<4))
#define ISR2L(a)  (a->att & (1<<5))
#define ISB2F(a)  (a->att & (1<<6))
#define ISF2B(a)  (a->att & (1<<7))
#define DOSPHERE(a) (a->att |= 1)
#define DOSOLID(a)  (a->att |= (1<<1))
#define DOT2B(a)  (a->att |= (1<<2))
#define DOB2T(a)  (a->att |= (1<<3))
#define DOL2R(a)  (a->att |= (1<<4))
#define DOR2L(a)  (a->att |= (1<<5))
#define DOB2F(a)  (a->att |= (1<<6))
#define DOF2B(a)  (a->att |= (1<<7))
#define UNSPHERE(a) (a->att &= ~1)
#define UNSOLID(a)  (a->att &= ~(1<<1))
#define UNT2B(a)  (a->att &= ~(1<<2))
#define UNB2T(a)  (a->att &= ~(1<<3))
#define UNL2R(a)  (a->att &= ~(1<<4))
#define UNR2L(a)  (a->att &= ~(1<<5))
#define UNB2F(a)  (a->att &= ~(1<<6))
#define UNF2B(a)  (a->att &= ~(1<<7))
/* more will be coming, like spikes, wisps, etc, when time to do */

/* these are in the type member */
#define ISGASPERIODIC(a) (a->type & 1)
#define ISGASROLL(a)     (a->type & (1<<1))
#define DOGASPERIODIC(a) (a->type |= 1)
#define DOGASROLL(a)     (a->type |= (1<<1))
#define UNGASPERIODIC(a) (a->type &= ~1)
#define UNGASROLL(a)     (a->type &= ~(1<<1))

/* these are in the sides member, a SHORT */
#define TOPCOL (1)
#define BOTCOL (1<<1)
#define LFTCOL (1<<2)
#define RGTCOL (1<<3)
#define FRTCOL (1<<4)
#define BAKCOL (1<<5)
#define TOPDEN (1<<6)
#define BOTDEN (1<<7)
#define LFTDEN (1<<8)
#define RGTDEN (1<<9)
#define FRTDEN (1<<10)
#define BAKDEN (1<<11)
#define DEFAULTGASSETUP (1<<12)
#define DEFAULTGASSCALE (1<<13)
#define GASHASDEFORMS (1<<14)
#define CAMERAINSIDEGAS (1<<15)

/*************************************************************
 *
 * Attributes
 *
 *************************************************************/

/* in attlists, the line type var, not bitpacked, just incremented */
#define LINENORMAL 0
#define LINEOUTLINE 1
#define LINECENTERS 2
#define LINEPOINTS 3
#define LINEPOINTCENTERS 4

/* these are:
red,green,blue,transparency,genlock,hardness,self illumination,
highlight red,green,blue
shadow
distance
vector magnitude
*/

#define RD 0
#define RE 0
#define GR 1
#define BL 2
#define TR 3
#define GN 4
#define HD 0
#define SI 1
#define HR 3
#define HG 4
#define HB 5
#define SD 6
#define DD 0
#define MA 1

typedef struct Vector_Struct VECTOR;
typedef LONG ID;        /* my ID is four printable ASCII chars but
                         * stored as a LONG for efficient copy & compare.*/
typedef float vector[3];
typedef double dvector[3];
typedef LONG lvector[3];
typedef UBYTE uvector[3];

/* these are procobject defines, used in switch statements */
#define PROB_ISSPLINE      1
#define PROB_ISFLARE       2
#define PROB_ISFOUNTAIN    3
#define PROB_ISEXTERN      4
#define PROB_ISOBJECT      5     /* new for 5.0 */


/* these are defines used in individual point id */
/* NOTE that the upper bit is a fluid bit for tracking purposes
for outside tools, don't use for permanent purpose
*/
/* used in multiplepoint modes */
#define DOPNTPERMIT(a) (a->id |= 1)
#define UNPNTPERMIT(a) (a->id &= ~1)
#define ISPNTPERMIT(a) (a->id & 1)
#define DOCALCULATEPNT(a) (a->id |= (1<<1))
#define UNCALCULATEPNT(a) (a->id &= ~(1<<1))
#define ISCALCULATEPNT(a) (a->id & (1<<1))

/*
these notes are for bit pack placement for path and path members
they are set in pathdef tool, and examined in animation routines
the bits set in the pathmemb vars MAY NOT BE the same bit set in the
fluid path vars

the bitpacked vars in struct PathInfo:

 LONG type;       * modified at time of member calculation, KEEP FLUID *
 LONG movetype;   * translation GLOBALS *
 LONG itype;      * instance types GLOBALS *

the bitpacked vars in struct pathmemb:

 LONG type;  * rotation *
 LONG stype; * scaling x,y,z periodic flags *
 LONG wnum;  * type wave, linear, cylinder, sphere, and axis reference *
 LONG wtype; * bit packed periodic flags *

 * the following are for paths in movetype and type variables *
 * bits are started at 0 *
 * for instance, bit 2 is accessed by (1<<2) *
 * giving a total of 32 (0 through 31) bits for a long *
 * shown is the pathmemb var to the path var if fluid *
 * or NULL in pathmemb var if global to path *
 * if to NOTHING, bit not used in path, only in pathmemb *
bit 0 CYCLEMASKX              type and stype to NOTHING
bit 1 CYCLEMASKY              type and stype to NOTHING
bit 2 CYCLEMASKZ              type and stype to NOTHING
bit 3 MOVEMASK                NULL to movetype
bit 4 DIRECTMASK              NO LONGER USED
bit 5 CYCLEMOVEMASK           NULL to movetype
bit 6 MOVELASTMASK            NULL to movetype
bit 7 LOCALMOVEMASK           NO LONGER USED
bit 8,9,10 ANGLEORDERMASK     type to type
bit 11 PLOCKMASK              NULL to movetype
bit 12 DEFORMON               NO LONGER USED
bit 13 DEFORMCYCLEMASK        NULL to movetype
bit 14 PATHALIGNMASK          NULL to movetype
bit 15 LOCKXMASK              NULL to movetype
bit 16 LOCKYMASK              NULL to movetype
bit 17 LOCKZMASK              NULL to movetype
bit 18 REVXMASK               NULL to movetype
bit 19 PATHALIGNLASTMASK      NULL to movetype
bit 20 CYCLEMASK              type to type
bit 21 MAINCYCLEMASK          NULL to movetype
bit 22 CONSTANTVELOCITY       NULL to movetype
bit 23 AFTERINSTANCEMASK      NULL to movetype



 * the path->type is used for various flag setting,
   unsetting, frame to frame, no permanent flags!
   keep fluid
   bits in use: 0: inifinitewave
                1: translatedbyguide
                2-7: disp, alon
                8-10: angleorder for rotation
                20: cyclemask
 *

 * this is for wave infinite flag, used in both path type variable
   and pathmemb wtype variable *
 * bit 0 *
 INFINITEWAVE 1
 * this for translation by guidepath. only allowed once per frame *
 * bit 1 *
 ISTRANSLATEDBYGUIDE(p) (p->type&2)
 DOTRANSLATEDBYGUIDE(p) (p->type|=2)
 UNTRANSLATEDBYGUIDE(p) (p->type&=~2)
 * these are also in path type and pathmemb wtype *
 * bits 2 to 7 *
 DISPAXISX (1<<2)
 DISPAXISY (1<<3)
 DISPAXISZ (1<<4)
 ALONAXISX (1<<5)
 ALONAXISY (1<<6)
 ALONAXISZ (1<<7)


 * held in path->itype variable for translation rotation in instances *
 ISITRA(path) (path->itype&1)
 DOITRA(path) (path->itype|=1)
 UNITRA(path) (path->itype&=~1)
 ISIROT(path) (path->itype&2)
 DOIROT(path) (path->itype|=2)
 UNIROT(path) (path->itype&=~2)

*/

/*************************************************************
 *
 * Fountains
 *
 *************************************************************/

/* these are for fountains */
/* note the 1,2,4,8 are in use for flare images, up to 1<<3 */
/* check below, looks like up to 1<<5
and the new one added is at 1<<21 */
#define FTXRINDEPENDENTMASK (1<<6)
#define FOUNTAINPREROLLMASK (1<<7)
#define ROTATEDISTMASK (1<<8)
#define PLACERELATIVEMASK (1<<9)
#define GMOTIONMASK (1<<10)
#define AGERELATIVEMASK (1<<11)
#define FOUNTAINALIGNMASK (1<<12)
#define PATTERNMASK (1<<13)
#define FATLINDEPENDENTMASK (1<<14)
#define FNTIMAGEALIGNMASK (1<<15)
/* the fnt member uses a USHORT for its in member
   the fnt itself uses a ULONG
   these are only in the fnt
*/
#define EVENDIRPLACEMASK (1<<16)
#define FATLLOCKMASK (1<<17)
#define FATLRANDMASK (1<<18)
#define FTXRLOCKMASK (1<<19)
#define FTXRRANDMASK (1<<20)

/* this is in particle pin member */
#define JUSTCREATEDMASK (1)
#define PARTICLEOLDAGEMASK (1<<1)

/* these are for flares AND fountains in the ->in member */
#define FLAREOBSCURMASK (1)
#define FLARESEDGESMASK (1<<1)
#define FLAREOBSTRANSMASK (1<<2)
#define FLARERELSIZEMASK (1<<3)
#define FLAREZBUFFERMASK (1<<4)
/* this is in the flare->in member and the particle->pin member
   used to determine if they are initialized if zbuffered
*/
#define FLAREZBUFINITMASK (1<<5)
/* this is in the ->in member of flares and fountains */
#define FLAREOPAQUEMASK (1<<21)

/*************************************************************
 *
 * Extern objects
 *
 *************************************************************/

/* these are defines used by externobjects */
#define EXT_DOSAVRENDPOLYS(a) (a->polysav |= 1)
#define EXT_UNSAVRENDPOLYS(a) (a->polysav &= ~1)
#define EXT_ISSAVRENDPOLYS(a) (a->polysav & 1)

#define EXT_DORESPOND(a) (a->extcall |= 1)
#define EXT_UNRESPOND(a) (a->extcall &= ~1)
#define EXT_ISRESPOND(a) (a->extcall & 1)
#define EXT_DORENDERPREVCALL(a) (a->extcall |= (1<<1))
#define EXT_UNRENDERPREVCALL(a) (a->extcall &= ~(1<<1))
#define EXT_ISRENDERPREVCALL(a) (a->extcall & (1<<1)
#define EXT_DOPREVIEWPREVCALL(a) (a->extcall |= (1<<2))
#define EXT_UNPREVIEWPREVCALL(a) (a->extcall &= ~(1<<2))
#define EXT_ISPREVIEWPREVCALL(a) (a->extcall & (1<<2)
#define EXT_DORENDERFRAMECALL(a) (a->extcall |= (1<<3))
#define EXT_UNRENDERFRAMECALL(a) (a->extcall &= ~(1<<3))
#define EXT_ISRENDERFRAMECALL(a) (a->extcall & (1<<3)
#define EXT_DOPREVIEWFRAMECALL(a) (a->extcall |= (1<<4))
#define EXT_UNPREVIEWFRAMECALL(a) (a->extcall &= ~(1<<4))
#define EXT_ISPREVIEWFRAMECALL(a) (a->extcall & (1<<4)
#define EXT_DORENDERPOSTCALL(a) (a->extcall |= (1<<5))
#define EXT_UNRENDERPOSTCALL(a) (a->extcall &= ~(1<<5))
#define EXT_ISRENDERPOSTCALL(a) (a->extcall & (1<<5)
#define EXT_DOPREVIEWPOSTCALL(a) (a->extcall |= (1<<6))
#define EXT_UNPREVIEWPOSTCALL(a) (a->extcall &= ~(1<<6))
#define EXT_ISPREVIEWPOSTCALL(a) (a->extcall & (1<<6)
#define EXT_DOSAVECALL(a) (a->extcall |= (1<<7))
#define EXT_UNSAVECALL(a) (a->extcall &= ~(1<<7))
#define EXT_ISSAVECALL(a) (a->extcall & (1<<7)
#define EXT_DOLOADCALL(a) (a->extcall |= (1<<8))
#define EXT_UNLOADCALL(a) (a->extcall &= ~(1<<8))
#define EXT_ISLOADCALL(a) (a->extcall & (1<<8)
#define EXT_DOEDITCHANGESCALL(a) (a->extcall |= (1<<9))
#define EXT_UNEDITCHANGESCALL(a) (a->extcall &= ~(1<<9))
#define EXT_ISEDITCHANGESCALL(a) (a->extcall & (1<<9)

/* these are used for added displays in addeddisplays() array in library */
#define HAVEFIRECRACKER 0
#define HAVEOPAL 1
#define HAVERETINA 2
#define HAVERESOLVER 3



#define TOREALWORLD(f,a)        { (f) = (FLOAT)(a); toRealWorld(&(f)); }
