#include <aladdin/tools.h>


int CXBRK(void) { return(0); }	/* Disable Lattice CTRL/C handling */
void chkabort __ARGS((void)) { return; }  /* really */
void Chk_Abort __ARGS((void)) { return; } /* really */

static void getdefaults(int);
void mirrorlines(void);

struct Library *AladBase;
struct IntuitionBase *IntuitionBase;
struct SignalSemaphore *polysema;

long low[3],high[3],center[3];

int main(int,char **);
int getmirrordef(void);
static void sethighlow(void);

int main(argc,argv)
int argc;
char **argv;
{
 int t;

 IntuitionBase = (struct IntuitionBase *)OpenLibrary("intuition.library",33);
 if(IntuitionBase == NULL) return(-1);
 AladBase = OpenLibrary("Aladdin4D:support/alad.library",0);
 if(AladBase == NULL) {
  CloseLibrary((struct Library *)IntuitionBase);
  return(-1);
 }
 Forbid();
 polysema = FindSemaphore("Aladdin4DSemaphore");
 Permit();
 if(!polysema) {
  CloseLibrary((struct Library *)IntuitionBase);
  CloseLibrary(AladBase);
  return(-1);
 }
 getdefaults(0);
 t = readHSLdevice();
 if(t == 1) { /* LMB */
  mirrorlines();
 } else if(t == 2) { /* RMB */
  if(getmirrordef()) mirrorlines();
  getdefaults(1);
 }
 CloseLibrary((struct Library *)IntuitionBase);
 CloseLibrary(AladBase);
 return(0);
}

long mirrorx = 1,mirrory,mirrorz,from,deforms;
long *atpoint;

static void getdefaults(int sav)
{
 /* establish a defaults file in ram:
    if program run before, get them
    if first time, file won't exist, so return
 */
 LONG file;
 char *nam = toolDefaultsFile("{ALAD}_mir.def");
 double version;

 if(sav) {
  file=Open(nam,MODE_NEWFILE);
  if(file==0) { return; }
  version = 3.0;
  Write(file,(BYTE *)&version,sizeof(version));
  Write(file,(BYTE *)&mirrorx,sizeof(mirrorx));
  Write(file,(BYTE *)&mirrory,sizeof(mirrory));
  Write(file,(BYTE *)&mirrorz,sizeof(mirrorz));
  Write(file,(BYTE *)&from,sizeof(from));
  Write(file,(BYTE *)&deforms,sizeof(deforms));
 } else {
  file=Open(nam,MODE_OLDFILE);
  if(file==0) { return; }
  Read(file,(BYTE *)&version,sizeof(version));
  if(version == 3.0) {
   Read(file,(BYTE *)&mirrorx,sizeof(mirrorx));
   Read(file,(BYTE *)&mirrory,sizeof(mirrory));
   Read(file,(BYTE *)&mirrorz,sizeof(mirrorz));
   Read(file,(BYTE *)&from,sizeof(from));
   Read(file,(BYTE *)&deforms,sizeof(deforms));
  }
 }
 Close(file);
}

void mirrorlines()
{
 struct PolygonInfo *top,*po;
 struct PointInfo *pnt,*p;
 struct PolyBMpoint *pt;
 struct PathInfo *path;
 SHORT i,multoff;
 struct defpnt *dpt;
 struct procobject *ob;
 struct splineobject *spo;
 struct flareobject *fla;
 struct fountainobject *fnt;

 if(!from) { sethighlow(); atpoint = center; }
  else {		   atpoint = getatpoint(); }
 if(!deformactive()) {
  if(deforms) {
   top = firstpoly();
   while(top) {
    if(ISSELECTED(top)) {
     path = top->path;
     if(path && path->deform) {
      deforms = askem("Mirror Deforms? (no undo)");
      top = NULL;
     } else {
      top = top->next;
     }
    } else {
     top = top->next;
    }
   }
  }
 }
 if(multiplepoint()) multoff = 0;
 else		     multoff = 1;
 top = firstpoly();
 while(top) {
  if(ISSELECTED(top)) {
   pnt = top->firstpoint;
   while(pnt) {
    if(multoff || (ISPNTPERMIT(pnt))) {
     if(mirrorx) { pnt->x = atpoint[0] + (atpoint[0] - pnt->x); }
     if(mirrory) { pnt->y = atpoint[1] + (atpoint[1] - pnt->y); }
     if(mirrorz) { pnt->z = atpoint[2] + (atpoint[2] - pnt->z); }
    }
    pnt = pnt->next;
   }
   if((ISBMP(top)) && (top->points > 4)) {
    pt = top->bmp.pnt;
    for(i=0;i<4;i++) {
     if(mirrorx) pt->x[i] = atpoint[0] + (atpoint[0] - pt->x[i]);
     if(mirrory) pt->y[i] = atpoint[1] + (atpoint[1] - pt->y[i]);
     if(mirrorz) pt->z[i] = atpoint[2] + (atpoint[2] - pt->z[i]);
    }
   }
   path = top->path;
   if(!deformactive()) {
    if(deforms && path && path->deform) {
     p = top->firstpoint;
     while(p) {
      if(multoff || (ISPNTPERMIT(p))) {
       dpt = p->dpt;
       while(dpt) {
	if(mirrorx) dpt->x = atpoint[0] + (atpoint[0] - dpt->x);
	if(mirrory) dpt->y = atpoint[1] + (atpoint[1] - dpt->y);
	if(mirrorz) dpt->z = atpoint[2] + (atpoint[2] - dpt->z);
	dpt = dpt->next;
       }
      }
      p = p->next;
     }
    }
   }
   if(ISMELD(top)) { /* only need to move the bounding polys */
    for(po = top->special; po; po = po->next) {
     if((po->points > 4)&&(ISBMP(po))) {
      pt = po->bmp.pnt;
      for(i=0;i<4;i++) {
       if(mirrorx) pt->x[i] = atpoint[0] + (atpoint[0] - pt->x[i]);
       if(mirrory) pt->y[i] = atpoint[1] + (atpoint[1] - pt->y[i]);
       if(mirrorz) pt->z[i] = atpoint[2] + (atpoint[2] - pt->z[i]);
      }
     }
    }
   }
  }
  top = top->next;
 }
 for(ob = firstprocobject(); ob; ob = ob->next) {
  if(ISSELECTED(ob)) {
   if(ob->in == PROB_ISSPLINE) { /* spline object */
    spo = (struct splineobject *)ob->special;
    for(pnt = spo->firstpoint; pnt; pnt = pnt->next) {
     if(multoff || (ISPNTPERMIT(pnt))) {
      if(mirrorx) { pnt->x = atpoint[0] + (atpoint[0] - pnt->x); }
      if(mirrory) { pnt->y = atpoint[1] + (atpoint[1] - pnt->y); }
      if(mirrorz) { pnt->z = atpoint[2] + (atpoint[2] - pnt->z); }
     }
    }
    for(pnt = spo->controlpnt; pnt; pnt = pnt->next) {
     if(multoff || (ISPNTPERMIT(pnt))) {
      if(mirrorx) { pnt->x = atpoint[0] + (atpoint[0] - pnt->x); }
      if(mirrory) { pnt->y = atpoint[1] + (atpoint[1] - pnt->y); }
      if(mirrorz) { pnt->z = atpoint[2] + (atpoint[2] - pnt->z); }
     }
    }
   } else {
    if(ob->in == PROB_ISFLARE) {
     fla = (struct flareobject *)ob->special;
     top = fla->po;
    } else if(ob->in == PROB_ISFOUNTAIN) {
     fnt = (struct fountainobject *)ob->special;
     top = fnt->po;
    } else {
     top = NULL;
    }
    if(top) {
     for(pnt = top->firstpoint; pnt; pnt = pnt->next) {
      if(multoff || (ISPNTPERMIT(pnt))) {
       if(mirrorx) { pnt->x = atpoint[0] + (atpoint[0] - pnt->x); }
       if(mirrory) { pnt->y = atpoint[1] + (atpoint[1] - pnt->y); }
       if(mirrorz) { pnt->z = atpoint[2] + (atpoint[2] - pnt->z); }
      }
     }
    }
   }
  }
 }
}

static void sethighlow()
{
 struct PolygonInfo *top;
 struct PointInfo *pnt;
 struct procobject *ob;
 struct splineobject *spo;
 struct flareobject *fla;
 struct fountainobject *fnt;

 /* the calling function should deselect paths or lights, etc.
    if they are not to participate. */
 low[0] = low[1] = low[2] = 1000000000;
 high[0] = high[1] = high[2] = -1000000000;
 ObtainSemaphore(polysema);
 for(top = firstpoly(); top; top = top->next) {
  if(ISSELECTED(top)) {
   for(pnt = top->firstpoint; pnt; pnt = pnt->next) {
    if(pnt->x < low[0]) low[0] = pnt->x;
    if(pnt->x > high[0]) high[0] = pnt->x;
    if(pnt->y < low[1]) low[1] = pnt->y;
    if(pnt->y > high[1]) high[1] = pnt->y;
    if(pnt->z < low[2]) low[2] = pnt->z;
    if(pnt->z > high[2]) high[2] = pnt->z;
   }
  }
 }
 for(ob = firstprocobject();ob;ob=ob->next) {
  if(ISSELECTED(ob)) {
   if(ob->in == PROB_ISSPLINE) { /* spline object */
    spo = (struct splineobject *)ob->special;
    for(pnt = spo->firstpoint; pnt; pnt = pnt->next) {
     if(pnt->x < low[0]) low[0] = pnt->x;
     if(pnt->x > high[0]) high[0] = pnt->x;
     if(pnt->y < low[1]) low[1] = pnt->y;
     if(pnt->y > high[1]) high[1] = pnt->y;
     if(pnt->z < low[2]) low[2] = pnt->z;
     if(pnt->z > high[2]) high[2] = pnt->z;
    }
    for(pnt = spo->controlpnt; pnt; pnt = pnt->next) {
     if(pnt->x < low[0]) low[0] = pnt->x;
     if(pnt->x > high[0]) high[0] = pnt->x;
     if(pnt->y < low[1]) low[1] = pnt->y;
     if(pnt->y > high[1]) high[1] = pnt->y;
     if(pnt->z < low[2]) low[2] = pnt->z;
     if(pnt->z > high[2]) high[2] = pnt->z;
    }
   } else {
    if(ob->in == PROB_ISFLARE) {
     fla = (struct flareobject *)ob->special;
     top = fla->po;
    } else if(ob->in == PROB_ISFOUNTAIN) {
     fnt = (struct fountainobject *)ob->special;
     top = fnt->po;
    } else {
     top = NULL;
    }
    if(top) {
     for(pnt = top->firstpoint; pnt; pnt = pnt->next) {
      if(pnt->x < low[0]) low[0] = pnt->x;
      if(pnt->x > high[0]) high[0] = pnt->x;
      if(pnt->y < low[1]) low[1] = pnt->y;
      if(pnt->y > high[1]) high[1] = pnt->y;
      if(pnt->z < low[2]) low[2] = pnt->z;
      if(pnt->z > high[2]) high[2] = pnt->z;
     }
    }
   }
  }
 }
 ReleaseSemaphore(polysema);
 /* these are the center point of all selected polys */
 center[0] = (high[0]+low[0])>>1;
 center[1] = (high[1]+low[1])>>1;
 center[2] = (high[2]+low[2])>>1;
}
