#include <aladdin/tools.h>


extern struct Library *AladBase;
extern struct IntuitionBase *IntuitionBase;

extern long mirrorx,mirrory,mirrorz;
extern long from,deforms;


struct Library *ApptekBase;

enum
{
   GID_dummy = 0,

   GID_MIRRORX,
   GID_MIRRORY,
   GID_MIRRORZ,
   GID_FROM,
   GID_DEFORMS,

   GID_ABOUT,
   GID_PERFORM,
   GID_SAVE,
   GID_CANCEL
};

static
LONG GuiTags[] =
{
   APG_VERTICAL_GROUP,
      APG_EqualWidth, TRUE,
      TAG_DONE,

      APG_VERTICAL_GROUP,
	 APG_EqualWidth, TRUE,
	 APG_Frame, FRAME_BUTTON,
	 APG_RightJustify, TRUE,
	 TAG_DONE,

	 CHECKBOX_KIND,
	    APG_ID, GID_MIRRORX,
	    APG_Label, (LONG)"Mirror X Axis:",
	    APG_ValuePtr, (LONG)&mirrorx,
	    APG_OnSuccessStore, (LONG)&mirrorx,
	    GTCB_Checked, 0,
	    TAG_DONE,

	 CHECKBOX_KIND,
	    APG_ID, GID_MIRRORY,
	    APG_Label, (LONG)"Mirror Y Axis:",
	    APG_ValuePtr, (LONG)&mirrory,
	    APG_OnSuccessStore, (LONG)&mirrory,
	    GTCB_Checked, 0,
	    TAG_DONE,

	 CHECKBOX_KIND,
	    APG_ID, GID_MIRRORZ,
	    APG_Label, (LONG)"Mirror Z Axis:",
	    APG_ValuePtr, (LONG)&mirrorz,
	    APG_OnSuccessStore, (LONG)&mirrorz,
	    GTCB_Checked, 0,
	    TAG_DONE,

	 CHECKBOX_KIND,
	    APG_ID, GID_DEFORMS,
	    APG_Label, (LONG)"Mirror Deforms:",
	    APG_ValuePtr, (LONG)&deforms,
	    APG_OnSuccessStore, (LONG)&deforms,
	    GTCB_Checked, 0,
	    TAG_DONE,

	 CYCLE_KIND,
	    APG_ID, GID_FROM,
	    APG_Label, (LONG)"Mirror Around:",
	    APG_CycleLabels, (LONG)"Center\tATP",
	    APG_ValuePtr, (LONG)&from,
	    APG_OnSuccessStore, (LONG)&from,
	    GTCY_Active, 0,
	    TAG_DONE,


	 BUTTON_KIND,
	    APG_ID, GID_ABOUT,
	    APG_Label, (LONG)"_Help...",	     // MSG_About,
	    APG_ToolTip, (LONG)"Open help window",   // MSG_About_Tip,
	    APG_HelpChoice, TRUE,
	    TAG_DONE,

	 APG_END_GROUP,
	    TAG_DONE,

      APG_HORIZONTAL_GROUP,
	 APG_EqualWidth, TRUE,
	 APG_EqualSpaced, TRUE,
	 TAG_DONE,

	 BUTTON_KIND,
	    APG_ID, GID_PERFORM,
	    APG_Label, (LONG)"_Mirror", 	// MSG_Perform,
	    APG_ToolTip, (LONG)"Mirror polygons",
	    APG_CloseCode, GID_PERFORM,
	    APG_DefaultChoice, TRUE,
	    TAG_DONE,

	 BUTTON_KIND,
	    APG_ID, GID_SAVE,
	    APG_Label, (LONG)"_Save",	       // MSG_Save,
	    APG_ToolTip, (LONG)"Save settings only",
	    APG_CloseCode, GID_SAVE,
	    TAG_DONE,

	 BUTTON_KIND,
	    APG_ID, GID_CANCEL,
	    APG_Label, (LONG)"_Cancel",        // MSG_Cancel,
	    APG_ToolTip, (LONG)"Cancel and exit",
	    APG_CloseCode, GID_CANCEL,
	    APG_CancelChoice, TRUE,
	    TAG_DONE,

	 APG_END_GROUP,
	    TAG_DONE,

      APG_END_GROUP,
	 TAG_DONE,

   APG_DONE
};



int getmirrordef (void)
{
   int perform = 0;

   {
      LONG retcode;

      if (ApptekBase = OpenLibrary(APPTEKNAME, APPTEKVERSION))
      {
	 retcode = APT_NewWindow(GetAppHandle(), GuiTags,
			   APW_ID, WID_MIRROR,
			   APW_Modal, TRUE,
			   APW_PrivateIDCMP, TRUE,
			   APC_HelpFile, "Mirror.guide",
			   APC_LocaleHook, NULL,      // disable localization for now
			   WA_CustomScreen, getactivescreen(),
			   WA_Title, "Mirror Settings",
			   WA_Activate, TRUE,
			   TAG_DONE);

	 switch(retcode)
	 {
	    case GID_PERFORM :
	       perform = 1;
	       break;
	    case GID_SAVE :
	       perform = 0;
	       break;
	    case GID_CANCEL :
	       perform = 0;
	       break;
	 }

	 CloseLibrary(ApptekBase);
      }
   }

 return(perform);
}

