
********************************************
*** ROTATE SHIP                            *
********************************************
Rotate_Ship
	move.l	#Ship,a0
	bsr	Get_Stick_Readings
	tst.w	xdirec
	beq.s	no_movement
	bmi.s	rotate_left	
	addq.w	#5,angle(a0)
	cmp.w	#360,angle(a0)
	blt.s	no_movement
	sub.w	#360,angle(a0)
	bra.s	no_movement
rotate_left
	subq.w	#5,angle(a0)	
	bge.s	no_movement
	add.w	#359,angle(a0)
no_movement
	move.w	number_of_points(a0),d0	
	move.w	angle(a0),d1
	move.l	point_list(a0),a1
	move.w	screen_x(a0),d6
	move.w	screen_y(a0),d7
	move.l	temp_list(a0),a0
	bsr	Rotate
	rts

*********************************************
***    PROCESS   VELOCITY                 ***
*********************************************
Process_Velocity
	tst.w	fire
	beq.s	no_thrust
	move.l	#sinradtable,a4
	move.l	#cosradtable,a5
	move.l	#ship,a3
	move.w	angle(a3),d0
	move.w	x_vel(a3),d1
	move.w	y_vel(a3),d2
	sub.w	(a4,d0*2),d1
	add.w	(a5,d0*2),d2
	ext.l	d1
	ext.l	d2
	
	divs	#1024,d1
	divs	#1024,d2
	add.w	d1,screen_x(a3)
	add.w	d2,screen_y(a3)
	swap	d1
	swap	d2
	move.w	d1,x_vel(A3)
	move.w	d2,y_vel(a3) 
no_thrust
	rts	


********************************************
** DRAW SHIP                            ****
********************************************
Draw_Ship
	move.l	#ship,a2
	move.l	temp_list(a2),a1
	move.w	number_of_cons(a2),d5
	move.l	connection_list(a2),a2	
draw_loop	
	move.w	(a2)+,d6	;connection1
	move.w	(a2)+,d7	;connection2
	move.w	(a1,d6*4),d0
	move.w	2(a1,d6*4),d1
	move.w	(a1,d7*4),d2
	move.w	2(a1,d7*4),d3
	move.l	plane1,a0
	move.l	d5,-(sp)
	bsr	Draw_Slice_Line	
	move.l	(sp)+,d5
	dbra	d5,draw_loop
	rts

********************************************
***       ROTATE ALGORITHM               ***
********************************************
ROTATE
*send list in a1
*send temp list in a0
*d1 = angle
*d6,d7 = screen pos
	
	
	move.l	#sinradtable,a4
	move.l	#cosradtable,a5
	move.w	(a5,d1*2),d2	;cos 
	move.w  (a4,d1*2),d1	;sin
	move.w	d6,-(sp)

rotate_loop
	move.w	(a1)+,d3	;x
	move.w	(a1)+,d4	;y
	move.w	d3,d5		;save
	move.w	d4,d6	
	muls	d2,d3		;cos*x
	muls	d1,d4		;sin*y
	sub.l	d4,d3		;cosx-cosy = d3
	asr.l	#8,d3		;shift down
	asr.l	#2,d3
	add.w	(sp),d3
	move.w	d3,(a0)+	;store x
	
	muls	d1,d5		;sin*x
	muls	d2,d6		;cos*y
	add.l	d5,d6
	asr.l	#8,d6
	asr.l	#2,d6
	add.w	d7,d6
	move.w	d6,(a0)+	;store y	
	dbra	d0,rotate_loop	
	addq.l	#2,sp
	rts


Ship_points_list
	dc.w	0,75/8
	dc.w	50/8,-50/8
	dc.w	0,-25/8
	dc.w	-50/8,-50/8
No_Ship_Points EQU (*-ship_points_list)/4	

Ship_Connection_List
	dc.w	0,1,1,2,2,3,3,0
No_Ship_Connections EQU (*-Ship_Connection_List)/4	

Ship_Temp_List
	ds.w	No_Ship_Points*2
	
	
Ship
	dc.w	No_Ship_Points-1
	dc.w	No_Ship_Connections-1
	dc.w	0
	dc.w	0,0
	dc.w	160,125
	dc.l	Ship_Points_List
	dc.l	Ship_Temp_List
	dc.l	Ship_Connection_List	
	
	rsreset	
number_of_points rs.w	1
number_of_cons	 rs.w	1
angle		 rs.w	1
x_vel		 rs.w	1
y_vel		 rs.w	1
screen_x	 rs.w	1
screen_y	 rs.w	1
point_list	 rs.l	1
temp_list	 rs.l	1
connection_list  rs.l	1
	
	
sinradtable
 DC.W 17,35,53,71,89,107,124,142,160,177
 DC.W 195,212,230,247,265,282,299,316,333,350
 DC.W 366,383,400,416,432,448,464,480,496,511
 DC.W 527,542,557,572,587,601,616,630,644,658
 DC.W 671,685,698,711,724,736,748,760,772,784
 DC.W 795,806,817,828,838,848,858,868,877,886
 DC.W 895,904,912,920,928,935,942,949,955,962
 DC.W 968,973,979,984,989,993,997,1001,1005,1008
 DC.W 1011,1014,1016,1018,1020,1021,1022,1023,1023,1024
 DC.W 1023,1023,1022,1021,1020,1018,1016,1014,1011,1008
 DC.W 1005,1001,997,993,989,984,979,973,968,962
 DC.W 955,949,942,935,928,920,912,904,895,886
 DC.W 877,868,858,848,838,828,817,806,795,784
 DC.W 772,760,748,736,724,711,698,685,671,658
 DC.W 644,630,616,601,587,572,557,542,527,512
 DC.W 496,480,464,448,432,416,400,383,366,350
 DC.W 333,316,299,282,265,247,230,212,195,177
 DC.W 160,142,124,107,89,71,53,35,17,0
 DC.W -18,-36,-54,-72,-90,-108,-125,-143,-161,-178
 DC.W -196,-213,-231,-248,-266,-283,-300,-317,-334,-351
 DC.W -367,-384,-401,-417,-433,-449,-465,-481,-497,-512
 DC.W -528,-543,-558,-573,-588,-602,-617,-631,-645,-659
 DC.W -672,-686,-699,-712,-725,-737,-749,-761,-773,-785
 DC.W -796,-807,-818,-829,-839,-849,-859,-869,-878,-887
 DC.W -896,-905,-913,-921,-929,-936,-943,-950,-956,-963
 DC.W -969,-974,-980,-985,-990,-994,-998,-1002,-1006,-1009
 DC.W -1012,-1015,-1017,-1019,-1021,-1022,-1023,-1024,-1024,-1025
 DC.W -1024,-1024,-1023,-1022,-1021,-1019,-1017,-1015,-1012,-1009
 DC.W -1006,-1002,-998,-994,-990,-985,-980,-974,-969,-963
 DC.W -956,-950,-943,-936,-929,-921,-913,-905,-896,-887
 DC.W -878,-869,-859,-849,-839,-829,-818,-807,-796,-785
 DC.W -773,-761,-749,-737,-725,-712,-699,-686,-672,-659
 DC.W -645,-631,-617,-602,-588,-573,-558,-543,-528,-513
 DC.W -497,-481,-465,-449,-433,-417,-401,-384,-367,-351
 DC.W -334,-317,-300,-283,-266,-248,-231,-213,-196,-178
 DC.W -161,-143,-125,-108,-90,-72,-54,-36,-18,0
cosradtable
 DC.W 1023,1023,1022,1021,1020,1018,1016,1014,1011,1008
 DC.W 1005,1001,997,993,989,984,979,973,968,962
 DC.W 955,949,942,935,928,920,912,904,895,886
 DC.W 877,868,858,848,838,828,817,806,795,784
 DC.W 772,760,748,736,724,711,698,685,671,658
 DC.W 644,630,616,601,587,572,557,542,527,511
 DC.W 496,480,464,448,432,416,400,383,366,350
 DC.W 333,316,299,282,265,247,230,212,195,177
 DC.W 160,142,124,107,89,71,53,35,17,0
 DC.W -18,-36,-54,-72,-90,-108,-125,-143,-161,-178
 DC.W -196,-213,-231,-248,-266,-283,-300,-317,-334,-351
 DC.W -367,-384,-401,-417,-433,-449,-465,-481,-497,-513
 DC.W -528,-543,-558,-573,-588,-602,-617,-631,-645,-659
 DC.W -672,-686,-699,-712,-725,-737,-749,-761,-773,-785
 DC.W -796,-807,-818,-829,-839,-849,-859,-869,-878,-887
 DC.W -896,-905,-913,-921,-929,-936,-943,-950,-956,-963
 DC.W -969,-974,-980,-985,-990,-994,-998,-1002,-1006,-1009
 DC.W -1012,-1015,-1017,-1019,-1021,-1022,-1023,-1024,-1024,-1025
 DC.W -1024,-1024,-1023,-1022,-1021,-1019,-1017,-1015,-1012,-1009
 DC.W -1006,-1002,-998,-994,-990,-985,-980,-974,-969,-963
 DC.W -956,-950,-943,-936,-929,-921,-913,-905,-896,-887
 DC.W -878,-869,-859,-849,-839,-829,-818,-807,-796,-785
 DC.W -773,-761,-749,-737,-725,-712,-699,-686,-672,-659
 DC.W -645,-631,-617,-602,-588,-573,-558,-543,-528,-512
 DC.W -497,-481,-465,-449,-433,-417,-401,-384,-367,-351
 DC.W -334,-317,-300,-283,-266,-248,-231,-213,-196,-178
 DC.W -161,-143,-125,-108,-90,-72,-54,-36,-18,0
 DC.W 17,35,53,71,89,107,124,142,160,177
 DC.W 195,212,230,247,265,282,299,316,333,350
 DC.W 366,383,400,416,432,448,464,480,496,511
 DC.W 527,542,557,572,587,601,616,630,644,658
 DC.W 671,685,698,711,724,736,748,760,772,784
 DC.W 795,806,817,828,838,848,858,868,877,886
 DC.W 895,904,912,920,928,935,942,949,955,962
 DC.W 968,973,979,984,989,993,997,1001,1005,1008
 DC.W 1011,1014,1016,1018,1020,1021,1022,1023,1023,1024
ENDSINRAD
