LoopDelay	=	6
ScrlDelay	=	2
IlBob		=	63
IlCaves		=	60
IlMirrors	=	40
StartLives	=	1
AddIlNab	=	6
BoxX		=	24
BoxY		=	24
BoxBPR		=	4
CaveX		=	18
CaveY		=	33
CaveSize	=	CaveX*CaveY
CSize		=	754
ScrBoxX		=	14
ScrBoxY		=	11
ScrX		=	ScrBoxX*BoxX
ScrY		=	ScrBoxY*BoxY
ScrBPR		=	ScrX/8
ScrDPH		=	4
ScrMOD		=	[ScrDPH-1]*ScrBPR
ScrDDF		=	ScrX/2-8
ScrSize		=	ScrBPR*ScrY*ScrDPH
ScrNL		=	ScrBPR*ScrDPH
ScrNB		=	ScrNL*BoxY
BoxSize		=	BoxBPR*BoxY*ScrDPH
STACKSIZE	=	1024

Start:
	moveq	#0,d7
	bra.s	Start2
	dc.l	Start2
Start2:
	moveq	#0,d0			;POZA
	lea	CopperList,a0		;POZA

	move.l	a0,CLPtr
	adda.l	#Line-CopperList,a0
	move.l	a0,LinePtr
	adda.l	#Bobs-Line,a0
	move.l	a0,BobsPtr
	adda.l	#Screen0-Bobs,a0
	move.l	a0,Screen0Ptr
	adda.l	#Screen1-Screen0,a0
	move.l	a0,Screen1Ptr
	adda.l	#Samples-Screen1,a0
	move.l	a0,SamplesPtr
	move.b	d0,CaveNum

	move.b	d7,SysStat
	bne.s	Begin
	bsr.L	StartSystem
	lea	Begin,a6
	move.l	a6,$80
	trap	#0
	bsr.L	StopSystem
Strt0:	rts
Begin:	move.l	a7,MemStack
	lea	Stack+STACKSIZE,a7
	lea	CUSTOM,a6
	bsr.s	Program
Halt:	move.l	MemStack,a7
	move.b	CaveNum,d0
	move.b	FineRobbo,d1
	tst.b	SysStat
	bne.s	Strt0
	rte

;*******************************************************************

Program:
	bsr.L	Randomize
	bsr.L	ResetGame
NCave:	bsr.L	ResetCave
	lea	Palette0,a0
	move.l	CLPtr,a1
	lea	CoLiDLCol-CopperList(a1),a1
	bsr.L	Fade16
	bsr.L	Paste
	bsr.L	ScreenSwap
	bsr.L	Paste
	move.l	ActPalette,a0
	move.l	CLPtr,a1
	bsr.L	Fade16
	bsr.L	ClrKeyBuf
Loop:
	bsr.L	ScreenSwap
	bsr.L	CyfryLoop
	bsr.L	Move
	bsr.L	Player
	bsr.L	Range
	bsr.L	Anim
	bsr.L	Paste
	cmp.b	#15,KillRobbo
	bne.s	Loop1
	bsr.L	ToBoom
Loop1:	cmp.b	#30,KillRobbo
	beq.s	Loop2
	cmp.b	#15,FineRobbo
	beq.s	Loop3
	bra.s	Loop
Loop2:
	lea	PaletteZero,a0
	move.l	CLPtr,a1
	bsr.s	Fade16
	tst.w	BCD2
	bne.L	Loop4
	lea	PaletteZero,a0
	move.l	CLPtr,a1
	lea	CoLiDLCol-CopperList(a1),a1
	bsr.L	Fade16
	rts
Loop4:
	bsr.L	DecLives
	bra.L	NCave
Loop3:
	lea	PaletteZero,a0
	move.l	CLPtr,a1
	bsr.s	Fade16
	bsr.L	IncCave
	cmp.b	#IlCaves,CaveNum
	bcs.L	NCave
	lea	PaletteZero,a0
	move.l	CLPtr,a1
	lea	CoLiDLCol-CopperList(a1),a1
	bsr.L	Fade16
	rts

;*******************************************************************

Fade16:
	move.w	#16,d7
Fd1:	bsr.s	WaitVBL
	movem.l	a0/a1,-(sp)
	bsr.s	Fade
	movem.l	(sp)+,a0/a1
	dbf	d7,Fd1
	rts

;*******************************************************************

WaitVBL:
	sf	ByloVBL
WaVBL:	tst.b	ByloVBL
	beq.s	WaVBL
	rts

;*******************************************************************

;a0-palette a1-copperlist
Fade:
	move.w	#15,d0
Fa1:
	move.w	2(a1),d1
	move.w	(a0)+,d2
	move.w	d1,d3
	move.w	d2,d4
	and.w	#$f00,d3
	and.w	#$f00,d4
	cmp.w	d3,d4
	beq.s	Fa2a
	bcs.s	Fa3a
	add.w	#$100,d1
	bra.s	Fa2a
Fa3a:	sub.w	#$100,d1
Fa2a:
	move.w	d1,d3
	move.w	d2,d4
	and.w	#$0f0,d3
	and.w	#$0f0,d4
	cmp.w	d3,d4
	beq.s	Fa2b
	bcs.s	Fa3b
	add.w	#$010,d1
	bra.s	Fa2b
Fa3b:	sub.w	#$010,d1
Fa2b:
	move.w	d1,d3
	move.w	d2,d4
	and.w	#$00f,d3
	and.w	#$00f,d4
	cmp.w	d3,d4
	beq.s	Fa2c
	bcs.s	Fa3c
	add.w	#$001,d1
	bra.s	Fa2c
Fa3c:	sub.w	#$001,d1
Fa2c:
	move.w	d1,2(a1)
	lea	4(a1),a1
	dbf	d0,Fa1
	rts

;*******************************************************************

ToBoom:
	lea	Cave,a0
	move.w	#CaveSize-1,d0
ToBo1:
	tst.b	(a0)+
	beq.s	ToBo2
	cmp.b	#2,-1(a0)
	beq.s	ToBo2
	cmp.b	#3,-1(a0)
	beq.s	ToBo2
	move.b	#64,-1(a0)
ToBo2:	dbf	d0,ToBo1
	rts

;*******************************************************************

Random:
	move.b	TBLO,d6
	eor.b	d6,Last
	move.b	Last,d6
	rts

;*******************************************************************

Randomize:
	clr.b	d0
	move.b	#$7f,ICR
	move.b	d0,CRB
	move.b	d0,TBHI
	move.b	#255,TBLO
	move.b	#%00010000,CRB
	move.b	#%00000001,CRB
	rts

;*******************************************************************

IncCave:
	add.b	#1,CaveNum
IC:	add.b	#1,BCD1+1
	cmp.b	#10,BCD1+1
	bne.s	InCa1
	clr.b	BCD1+1
	add.b	#1,BCD1
InCa1:	rts

;*******************************************************************

IncLives:
	add.b	#1,BCD2+1
	cmp.b	#10,BCD2+1
	bne.s	InLi1
	clr.b	BCD2+1
	add.b	#1,BCD2
InLi1:	move.b	#2,Set2
	rts

;*******************************************************************

DecLives:
	sub.b	#1,BCD2+1
	bpl.s	DeLi1
	move.b	#9,BCD2+1
	sub.b	#1,BCD2
DeLi1:	move.b	#2,Set2
	rts

;*******************************************************************

IncSruba:
	add.b	#1,BCD3+1
	cmp.b	#10,BCD3+1
	bne.s	InSr1
	clr.b	BCD3+1
	add.b	#1,BCD3
InSr1:	rts

;*******************************************************************

DecSruba:
	tst.w	BCD3
	beq.s	DeSr1
	sub.b	#1,BCD3+1
	bpl.s	DeSr2
	move.b	#9,BCD3+1
	sub.b	#1,BCD3
DeSr2:	move.b	#2,Set3
DeSr1:	rts

;*******************************************************************

AddStrzal:
	move.b	BCD4+1,d7
	add.b	#6,d7
	cmp.b	#10,d7
	bcs.s	AdSt1
	sub.b	#10,d7
	add.b	#1,BCD4
AdSt1:	move.b	d7,BCD4+1
	move.b	#2,Set4
	rts

;*******************************************************************

DecStrzal:
	sub.b	#1,BCD4+1
	bpl.s	DeSt1
	move.b	#9,BCD4+1
	sub.b	#1,BCD4
DeSt1:	move.b	#2,Set4
	rts

;*******************************************************************

DecKlucz:
	sub.b	#1,BCD5+1
	bpl.s	DeKl1
	move.b	#9,BCD5+1
	sub.b	#1,BCD5+1
DeKl1:	move.b	#2,Set5
	rts

;*******************************************************************

IncKlucz:
	add.b	#1,BCD5+1
	cmp.b	#10,BCD5+1
	bne.s	InKl1
	clr.b	BCD5+1
	add.b	#1,BCD5
InKl1:	move.b	#2,Set5
	rts

;*******************************************************************

SetBat:
	st	BCD6
	st	Set6
	rts

;*******************************************************************

CyfryLoop:
	tst.b	Set1
	bne.s	Draw1
	tst.b	Set2
	bne.s	Draw2
	tst.b	Set3
	bne.L	Draw3
	tst.b	Set4
	bne.L	Draw4
	tst.b	Set5
	bne.L	Draw5
	tst.b	Set6
	bne.L	Draw6
	rts

Draw1:	cmp.b	#2,Set1
	bne.s	Dr11
	move.b	BCD1+1,d0
	move.l	BCD1Ptr,a1
	lea	1(a1),a1
	bra.s	Dr10
Dr11:	move.b	BCD1,d0
	move.l	BCD1Ptr,a1
Dr10:	sub.b	#1,Set1
	bra.L	Cyfra

Draw2:	cmp.b	#2,Set2
	bne.s	Dr21
	move.b	BCD2+1,d0
	move.l	BCD2Ptr,a1
	lea	1(a1),a1
	bra.s	Dr20
Dr21:	move.b	BCD2,d0
	move.l	BCD2Ptr,a1
Dr20:	sub.b	#1,Set2
	bra.L	Cyfra

Draw3:	cmp.b	#2,Set3
	bne.s	Dr31
	move.b	BCD3+1,d0
	move.l	BCD3Ptr,a1
	lea	1(a1),a1
	bra.s	Dr30
Dr31:	move.b	BCD3,d0
	move.l	BCD3Ptr,a1
Dr30:	sub.b	#1,Set3
	bra.L	Cyfra

Draw4:	cmp.b	#2,Set4
	bne.s	Dr41
	move.b	BCD4+1,d0
	move.l	BCD4Ptr,a1
	lea	1(a1),a1
	bra.s	Dr40
Dr41:	move.b	BCD4,d0
	move.l	BCD4Ptr,a1
Dr40:	sub.b	#1,Set4
	bra.L	Cyfra

Draw5:	cmp.b	#2,Set5
	bne.s	Dr51
	move.b	BCD5+1,d0
	move.l	BCD5Ptr,a1
	lea	1(a1),a1
	bra.s	Dr50
Dr51:	move.b	BCD5,d0
	move.l	BCD5Ptr,a1
Dr50:	sub.b	#1,Set5
	bra.L	Cyfra

Draw6:
	tst.b	BCD6
	bne.s	Draw60
	moveq	#10,d0
	move.l	BCD6Ptr,a1
	sf	Set6
	bra.L	Cyfra
Draw60:
	moveq	#11,d0
	move.l	BCD6Ptr,a1
	sf	Set6
	bra.L	Cyfra

;*******************************************************************

ResetCyfry:
	move.w	#0,BCD4
	move.w	#0,BCD5
	sf	BCD6
	move.b	#2,Set1
	move.b	#2,Set2
	move.b	#2,Set3
	move.b	#2,Set4
	move.b	#2,Set5
	st	Set6
	bsr.L	Draw1
	bsr.L	Draw1
	bsr.L	Draw2
	bsr.L	Draw2
	bsr.L	Draw3
	bsr.L	Draw3
	bsr.L	Draw4
	bsr.L	Draw4
	bsr.L	Draw5
	bsr.L	Draw5
	bsr.L	Draw6
	rts

;*******************************************************************

Cyfra:
	and.w	#$f,d0
	lea	CyfryTab,a0
	lsl.w	#2,d0
	move.l	0(a0,d0.w),a0
	move.b	(a0)+,00*144(a1)
	move.b	(a0)+,01*144(a1)
	move.b	(a0)+,02*144(a1)
	move.b	(a0)+,03*144(a1)
	move.b	(a0)+,04*144(a1)
	move.b	(a0)+,05*144(a1)
	move.b	(a0)+,06*144(a1)
	move.b	(a0)+,07*144(a1)
	move.b	(a0)+,08*144(a1)
	move.b	(a0)+,09*144(a1)
	move.b	(a0)+,10*144(a1)
	move.b	(a0)+,11*144(a1)
	move.b	(a0)+,12*144(a1)
	move.b	(a0)+,13*144(a1)
	move.b	(a0)+,14*144(a1)
	move.b	(a0)+,15*144(a1)
	move.b	(a0)+,16*144(a1)
	rts

;*******************************************************************

Anim:
	eor.b	#$ff,AnimCnt
	add.b	#1,NietopCnt
	cmp.b	#4,NietopCnt
	bcs.s	AnIm1
	clr.b	NietopCnt
AnIm1:	lea	BoxToBob,a0
	move.b	#2,1(a0)
	tst.b	BylRuch
	beq.s	AnIm2
	tst.b	Kierunek
	bne.s	AnIm3
	tst.b	AnimCnt
	bne.s	AnIm4
	move.b	#7,1(a0)
	bra.s	AnIm2
AnIm4:	move.b	#8,1(a0)
	bra.s	AnIm2
AnIm3:	tst.b	AnimCnt
	bne.s	AnIm5
	move.b	#5,1(a0)
	bra.s	AnIm2
AnIm5:	move.b	#6,1(a0)
AnIm2:
	move.b	#14,128(a0)
	tst.b	CaveOpen
	beq.s	AnIm10
	move.b	#15,128(a0)
	tst.b	AnimCnt
	beq.s	AnIm10
	move.b	#16,128(a0)
AnIm10:
	tst.b	AnimCnt
	bne.s	AnIm11
	move.l	#$2c2c2c2c,16(a0)
	move.l	#$2d2d2d2d,20(a0)
	move.l	#$1c1e1c1e,28(a0)
	move.l	#$181a181a,32(a0)
	move.w	#$181a,80(a0)
	bra.s	AnIm12
AnIm11:
	move.l	#$2d2d2d2d,16(a0)
	move.l	#$2c2c2c2c,20(a0)
	move.l	#$1d1f1d1f,28(a0)
	move.l	#$191b191b,32(a0)
	move.w	#$191b,80(a0)
AnIm12:
	cmp.b	#0,NietopCnt
	beq.s	AnIm20
	cmp.b	#1,NietopCnt
	beq.s	AnIm21
	cmp.b	#2,NietopCnt
	beq.s	AnIm22
	move.l	#$2f2f2f2f,24(a0)
	bra.s	AnIm30
AnIm20:
	move.l	#$2e2e2e2e,24(a0)
	bra.s	AnIm30
AnIm21:
	move.l	#$2f2f2f2f,24(a0)
	bra.s	AnIm30
AnIm22:
	move.l	#$30303030,24(a0)
AnIm30:
	rts

;*******************************************************************

Move:
	lea	Cave+CaveSize,a0
	lea	Cave0+CaveSize,a1
	lea	Cave1+CaveSize,a2
	lea	MoveBox,a3
	lea	M,a4
	eor.b	#$ff,CaveSwap
	beq.s	Mo1
	exg	a1,a2
Mo1:	move.w	#CaveSize-1,d7
Mo2:	clr.b	-(a2)
	tst.b	-(a1)
	bne.s	Mo3
	clr.w	d1
	move.b	-(a0),d1
	tst.b	0(a3,d1.w)
	beq.s	Mo4
	move.w	d1,d0
	lsl.w	#2,d1
	movea.l	a4,a5
	adda.l	0(a5,d1.w),a5
	jsr	(a5)
	st	(a1)
Mo4:	dbf	d7,Mo2
	bra.s	Mo5
Mo3:	lea	-1(a0),a0
	dbf	d7,Mo2
Mo5:	move.w	#CaveSize-1,d7
Mo6:	tst.b	(a1)
	bne.s	Mo7
	clr.w	d1
	move.b	(a0),d1
	tst.b	0(a3,d1.w)
	bne.s	Mo7
	move.w	d1,d0
	lsl.w	#2,d1
	movea.l	a4,a5
	adda.l	0(a5,d1.w),a5
	jsr	(a5)
	st	(a1)
Mo7:	lea	1(a0),a0
	lea	1(a1),a1
	dbf	d7,Mo6
RetBox:	rts

Box_16:
	tst.b	1(a0)
	beq.s	Box_16_1
	tst.b	-CaveX(a0)
	beq.s	Box_16_2
	move.b	#19,(a0)
	rts
Box_16_1:
	clr.b	(a0)
	move.b	#17,1(a0)
	st	1(a1)
	rts
Box_16_2:
	clr.b	(a0)
	move.b	#16,-CaveX(a0)
	st	-CaveX(a1)
	rts

Box_17:
	tst.b	CaveX(a0)
	beq.s	Box_17_1
	tst.b	1(a0)
	beq.s	Box_17_2
	move.b	#16,(a0)
	rts
Box_17_1:
	clr.b	(a0)
	move.b	#18,CaveX(a0)
	st	CaveX(a1)
	rts
Box_17_2:
	clr.b	(a0)
	move.b	#17,1(a0)
	st	1(a1)
	rts

Box_18:
	tst.b	-1(a0)
	beq.s	Box_18_1
	tst.b	CaveX(a0)
	beq.s	Box_18_2
	move.b	#17,(a0)
	rts
Box_18_1:
	clr.b	(a0)
	move.b	#19,-1(a0)
	st	-1(a1)
	rts
Box_18_2:
	clr.b	(a0)
	move.b	#18,CaveX(a0)
	st	CaveX(a1)
	rts

Box_19:
	tst.b	-CaveX(a0)
	beq.s	Box_19_1
	tst.b	-1(a0)
	beq.s	Box_19_2
	move.b	#18,(a0)
	rts
Box_19_1:
	clr.b	(a0)
	move.b	#16,-CaveX(a0)
	st	-CaveX(a1)
	rts
Box_19_2:
	clr.b	(a0)
	move.b	#19,-1(a0)
	st	-1(a1)
	rts

Box_20:
	tst.b	-1(a0)
	beq.s	Box_20_1
	tst.b	-CaveX(a0)
	beq.s	Box_20_2
	move.b	#23,(a0)
	rts
Box_20_1:
	clr.b	(a0)
	move.b	#21,-1(a0)
	st	-1(a1)
	rts
Box_20_2:
	clr.b	(a0)
	move.b	#20,-CaveX(a0)
	st	-CaveX(a1)
	rts

Box_21:
	tst.b	CaveX(a0)
	beq.s	Box_21_1
	tst.b	-1(a0)
	beq.s	Box_21_2
	move.b	#20,(a0)
	rts
Box_21_1:
	clr.b	(a0)
	move.b	#22,CaveX(a0)
	st	CaveX(a1)
	rts
Box_21_2:
	clr.b	(a0)
	move.b	#21,-1(a0)
	st	-1(a1)
	rts

Box_22:
	tst.b	1(a0)
	beq.s	Box_22_1
	tst.b	CaveX(a0)
	beq.s	Box_22_2
	move.b	#21,(a0)
	rts
Box_22_1:
	clr.b	(a0)
	move.b	#23,1(a0)
	st	1(a1)
	rts
Box_22_2:
	clr.b	(a0)
	move.b	#22,CaveX(a0)
	st	CaveX(a1)
	rts

Box_23:
	tst.b	-CaveX(a0)
	beq.s	Box_23_1
	tst.b	1(a0)
	beq.s	Box_23_2
	move.b	#22,(a0)
	rts
Box_23_1:
	clr.b	(a0)
	move.b	#20,-CaveX(a0)
	st	-CaveX(a1)
	rts
Box_23_2:
	clr.b	(a0)
	move.b	#23,1(a0)
	st	1(a1)
	rts

Box_24:
	tst.b	-CaveX(a0)
	bne.s	Box_24_1
	clr.b	(a0)
	move.b	#24,-CaveX(a0)
	st	-CaveX(a1)
	rts
Box_24_1:
	move.b	#25,(a0)
	rts

Box_25:
	tst.b	CaveX(a0)
	bne.s	Box_25_1
	clr.b	(a0)
	move.b	#25,CaveX(a0)
	st	CaveX(a1)
	rts
Box_25_1:
	move.b	#24,(a0)
	rts

Box_26:
	tst.b	1(a0)
	bne.s	Box_26_1
	clr.b	(a0)
	move.b	#26,1(a0)
	st	1(a1)
	rts
Box_26_1:
	move.b	#27,(a0)
	rts

Box_27:
	tst.b	-1(a0)
	bne.s	Box_27_1
	clr.b	(a0)
	move.b	#27,-1(a0)
	st	-1(a1)
	rts
Box_27_1:
	move.b	#26,(a0)
	rts

Box_57:
	move.b	#58,(a0)
	rts

Box_58:
	move.b	#59,(a0)
	rts

Box_59:
	move.b	#60,(a0)
	rts

Box_60:
	move.b	#61,(a0)
	rts

Box_61:
	move.b	#62,(a0)
	rts

Box_62:
	move.b	#63,(a0)
	rts

Box_63:
	move.b	#0,(a0)
	rts

Box_64:
	move.b	#65,(a0)
	rts

Box_65:
	move.b	#66,(a0)
	rts

Box_66:
	move.b	#67,(a0)
	rts

Box_67:
	move.b	#68,(a0)
	rts

Box_68:
	move.b	#69,(a0)
	rts

Box_69:
	move.b	#70,(a0)
	rts

Box_70:
	move.b	#71,(a0)
	rts

Box_71:
	move.b	#72,(a0)
	rts

Box_72:
	move.b	#73,(a0)
	rts

Box_73:
	move.b	#0,(a0)
	rts

Box_74:
	tst.b	-CaveX(a0)
	bne.s	Box_74_1
	clr.b	(a0)
	move.b	#74,-CaveX(a0)
	st	-CaveX(a1)
	rts
Box_74_1:
	move.b	#4,(a0)
	lea	-CaveX(a0),a5
	bsr.L	Shot
	tst.b	d6
	beq.L	RetBox
	st	-CaveX(a1)
	rts

Box_75:
	tst.b	CaveX(a0)
	bne.s	Box_75_1
	clr.b	(a0)
	move.b	#75,CaveX(a0)
	st	CaveX(a1)
	rts
Box_75_1:
	move.b	#4,(a0)
	lea	CaveX(a0),a5
	bsr.L	Shot
	tst.b	d6
	beq.L	RetBox
	st	CaveX(a1)
	rts

Box_76:
	tst.b	1(a0)
	bne.s	Box_76_1
	clr.b	(a0)
	move.b	#76,1(a0)
	st	1(a1)
	rts
Box_76_1:
	move.b	#4,(a0)
	lea	1(a0),a5
	bsr.L	Shot
	tst.b	d6
	beq.L	RetBox
	st	1(a1)
	rts

Box_77:
	tst.b	-1(a0)
	bne.s	Box_77_1
	clr.b	(a0)
	move.b	#77,-1(a0)
	st	-1(a1)
	rts
Box_77_1:
	move.b	#4,(a0)
	lea	-1(a0),a5
	bsr.L	Shot
	tst.b	d6
	beq.L	RetBox
	st	-1(a1)
	rts

Box_40:
	bsr.L	Random
	cmp.b	#10,d6
	bhi.L	RetBox
	move.b	#41,(a0)
	tst.b	-CaveX(a0)
	beq.s	Box_40_1
	lea	-CaveX(a0),a5
	bsr.L	Shot
	tst.b	d6
	beq.L	RetBox
	st	-CaveX(a1)
	rts
Box_40_1:
	move.b	#28,-CaveX(a0)
	st	-CaveX(a1)
	rts

Box_41:
	bsr.L	Random
	cmp.b	#10,d6
	bhi.L	RetBox
	move.b	#42,(a0)
	tst.b	1(a0)
	beq.s	Box_41_1
	lea	1(a0),a5
	bsr.L	Shot
	tst.b	d6
	beq.L	RetBox
	st	1(a1)
	rts
Box_41_1:
	move.b	#29,1(a0)
	st	1(a1)
	rts

Box_42:
	bsr.L	Random
	cmp.b	#10,d6
	bhi.L	RetBox
	move.b	#43,(a0)
	tst.b	CaveX(a0)
	beq.s	Box_42_1
	lea	CaveX(a0),a5
	bsr.L	Shot
	tst.b	d6
	beq.L	RetBox
	st	CaveX(a1)
	rts
Box_42_1:
	move.b	#30,CaveX(a0)
	st	CaveX(a1)
	rts

Box_43:
	bsr.L	Random
	cmp.b	#10,d6
	bhi.L	RetBox
	move.b	#40,(a0)
	tst.b	-1(a0)
	beq.s	Box_43_1
	lea	-1(a0),a5
	bsr.L	Shot
	tst.b	d6
	beq.L	RetBox
	st	-1(a1)
	rts
Box_43_1:
	move.b	#31,-1(a0)
	st	-1(a1)
	rts

Box_44:
	bsr.L	Random
	cmp.b	#10,d6
	bhi.L	RetBox
	move.b	#45,(a0)
	tst.b	-CaveX(a0)
	beq.s	Box_44_1
	lea	-CaveX(a0),a5
	bsr.L	Shot
	tst.b	d6
	beq.L	RetBox
	st	-CaveX(a1)
	rts
Box_44_1:
	move.b	#28,-CaveX(a0)
	st	-CaveX(a1)
	rts

Box_45:
	bsr.L	Random
	cmp.b	#10,d6
	bhi.L	RetBox
	move.b	#46,(a0)
	tst.b	-1(a0)
	beq.s	Box_45_1
	lea	-1(a0),a5
	bsr.L	Shot
	tst.b	d6
	beq.L	RetBox
	st	-1(a1)
	rts
Box_45_1:
	move.b	#31,-1(a0)
	st	-1(a1)
	rts

Box_46:
	bsr.L	Random
	cmp.b	#10,d6
	bhi.L	RetBox
	move.b	#47,(a0)
	tst.b	CaveX(a0)
	beq.s	Box_46_1
	lea	CaveX(a0),a5
	bsr.L	Shot
	tst.b	d6
	beq.L	RetBox
	st	CaveX(a1)
	rts
Box_46_1:
	move.b	#30,CaveX(a0)
	st	CaveX(a1)
	rts

Box_47:
	bsr.L	Random
	cmp.b	#10,d6
	bhi.L	RetBox
	move.b	#44,(a0)
	tst.b	1(a0)
	beq.s	Box_47_1
	lea	1(a0),a5
	bsr.L	Shot
	tst.b	d6
	beq.L	RetBox
	st	1(a1)
	rts
Box_47_1:
	move.b	#29,1(a0)
	st	1(a1)
	rts

Box_28:
	clr.b	(a0)
	tst.b	-CaveX(a0)
	beq.s	Box_28_1
	lea	-CaveX(a0),a5
	bsr.L	Shot
	tst.b	d6
	bne.s	Box_28_2
	move.b	#64,(a0)
	rts
Box_28_2:
	st	-CaveX(a1)
	rts
Box_28_1:
	move.b	#28,-CaveX(a0)
	st	-CaveX(a1)
	rts

Box_29:
	clr.b	(a0)
	tst.b	1(a0)
	beq.s	Box_29_1
	lea	1(a0),a5
	bsr.L	Shot
	tst.b	d6
	bne.s	Box_29_2
	move.b	#64,(a0)
	rts
Box_29_2:
	st	1(a1)
	rts
Box_29_1:
	move.b	#29,1(a0)
	st	1(a1)
	rts

Box_30:
	clr.b	(a0)
	tst.b	CaveX(a0)
	beq.s	Box_30_1
	lea	CaveX(a0),a5
	bsr.L	Shot
	tst.b	d6
	bne.s	Box_30_2
	move.b	#64,(a0)
	rts
Box_30_2:
	st	CaveX(a1)
	rts
Box_30_1:
	move.b	#30,CaveX(a0)
	st	CaveX(a1)
	rts

Box_31:
	clr.b	(a0)
	tst.b	-1(a0)
	beq.s	Box_31_1
	lea	-1(a0),a5
	bsr.L	Shot
	tst.b	d6
	bne.s	Box_31_2
	move.b	#64,(a0)
	rts
Box_31_2:
	st	-1(a1)
	rts
Box_31_1:
	move.b	#31,-1(a0)
	st	-1(a1)
	rts

Box_32:
	tst.b	-CaveX(a0)
	beq.s	Box_32_1
	cmp.b	#84,-CaveX(a0)
	beq.s	Box_32_2
	cmp.b	#80,-CaveX(a0)
	beq.s	Box_32_3
	move.b	#34,(a0)
	lea	-CaveX(a0),a5
	bsr.L	Shot
	beq.L	RetBox
	st	-CaveX(a1)
	rts
Box_32_1:
	move.b	#80,(a0)
	move.b	#32,-CaveX(a0)
	st	-CaveX(a1)
	rts
Box_32_2:
	clr.b	(a0)
	rts
Box_32_3:
	clr.b	(a0)
	move.b	#32,-CaveX(a0)
	st	-CaveX(a1)
	rts

Box_34:
	tst.b	CaveX(a0)
	beq.s	Box_34_1
	cmp.b	#82,CaveX(a0)
	beq.s	Box_34_2
	cmp.b	#80,CaveX(a0)
	beq.s	Box_34_3
	move.b	#32,(a0)
	lea	CaveX(a0),a5
	bsr.L	Shot
	beq.L	RetBox
	st	CaveX(a1)
	rts
Box_34_1:
	move.b	#80,(a0)
	move.b	#34,CaveX(a0)
	st	CaveX(a1)
	rts
Box_34_2:
	clr.b	(a0)
	rts
Box_34_3:
	clr.b	(a0)
	move.b	#34,CaveX(a0)
	st	CaveX(a1)
	rts

Box_33:
	tst.b	1(a0)
	beq.s	Box_33_1
	cmp.b	#85,1(a0)
	beq.s	Box_33_2
	cmp.b	#81,1(a0)
	beq.s	Box_33_3
	move.b	#35,(a0)
	lea	1(a0),a5
	bsr.L	Shot
	beq.L	RetBox
	st	1(a1)
	rts
Box_33_1:
	move.b	#81,(a0)
	move.b	#33,1(a0)
	st	1(a1)
	rts
Box_33_2:
	clr.b	(a0)
	rts
Box_33_3:
	clr.b	(a0)
	move.b	#33,1(a0)
	st	1(a1)
	rts

Box_35:
	tst.b	-1(a0)
	beq.s	Box_35_1
	cmp.b	#83,-1(a0)
	beq.s	Box_35_2
	cmp.b	#81,-1(a0)
	beq.s	Box_35_3
	move.b	#33,(a0)
	lea	-1(a0),a5
	bsr.L	Shot
	beq.L	RetBox
	st	-1(a1)
	rts
Box_35_1:
	move.b	#81,(a0)
	move.b	#35,-1(a0)
	st	-1(a1)
	rts
Box_35_2:
	clr.b	(a0)
	rts
Box_35_3:
	clr.b	(a0)
	move.b	#35,-1(a0)
	st	-1(a1)
	rts

Box_82:
	bsr.L	Random
	cmp.b	#10,d6
	bhi.L	RetBox
	tst.b	-CaveX(a0)
	beq.s	Box_82_1
	lea	-CaveX(a0),a5
	bsr.L	Shot
	tst.b	d6
	beq.L	RetBox
	st	-CaveX(a1)
	rts
Box_82_1:
	move.b	#32,-CaveX(a0)
	st	-CaveX(a1)
	rts

Box_84:
	bsr.L	Random
	cmp.b	#10,d6
	bhi.L	RetBox
	tst.b	CaveX(a0)
	beq.s	Box_84_1
	lea	CaveX(a0),a5
	bsr.L	Shot
	tst.b	d6
	beq.L	RetBox
	st	CaveX(a1)
	rts
Box_84_1:
	move.b	#34,CaveX(a0)
	st	CaveX(a1)
	rts

Box_83:
	bsr.L	Random
	cmp.b	#10,d6
	bhi.L	RetBox
	tst.b	1(a0)
	beq.s	Box_83_1
	lea	1(a0),a5
	bsr.L	Shot
	tst.b	d6
	beq.L	RetBox
	st	1(a1)
	rts
Box_83_1:
	move.b	#33,1(a0)
	st	1(a1)
	rts

Box_85:
	bsr.L	Random
	cmp.b	#10,d6
	bhi.L	RetBox
	tst.b	-1(a0)
	beq.s	Box_85_1
	lea	-1(a0),a5
	bsr.L	Shot
	tst.b	d6
	beq.L	RetBox
	st	-1(a1)
	rts
Box_85_1:
	move.b	#35,-1(a0)
	st	-1(a1)
	rts

Box_134:
	bsr.L	Random
	cmp.b	#10,d6
	bhi.L	RetBox
	tst.b	-CaveX(a0)
	beq.s	Box_134_1
	lea	-CaveX(a0),a5
	bsr.L	Shot
	beq.L	RetBox
	st	-CaveX(a1)
	rts
Box_134_1:
	move.b	#28,-CaveX(a0)
	st	-CaveX(a1)
	rts

Box_136:
	bsr.L	Random
	cmp.b	#10,d6
	bhi.L	RetBox
	tst.b	CaveX(a0)
	beq.s	Box_136_1
	lea	CaveX(a0),a5
	bsr.L	Shot
	beq.L	RetBox
	st	CaveX(a1)
	rts
Box_136_1:
	move.b	#30,CaveX(a0)
	st	CaveX(a1)
	rts

Box_135:
	bsr.L	Random
	cmp.b	#10,d6
	bhi.L	RetBox
	tst.b	1(a0)
	beq.s	Box_135_1
	lea	1(a0),a5
	bsr.L	Shot
	beq.L	RetBox
	st	1(a1)
	rts
Box_135_1:
	move.b	#29,1(a0)
	st	1(a1)
	rts

Box_137:
	bsr.L	Random
	cmp.b	#10,d6
	bhi.L	RetBox
	tst.b	-1(a0)
	beq.s	Box_137_1
	lea	-1(a0),a5
	bsr.L	Shot
	beq.L	RetBox
	st	-1(a1)
	rts
Box_137_1:
	move.b	#31,-1(a0)
	st	-1(a1)
	rts

Box_86:
	move.b	#65,(a0)
	lea	-CaveX-1(a0),a5
	bsr.L	SShot
	tst.b	d6
	beq.s	Box_86_1
	st	-CaveX-1(a1)
Box_86_1:
	lea	-CaveX(a0),a5
	bsr.L	SShot
	tst.b	d6
	beq.s	Box_86_2
	st	-CaveX(a1)
Box_86_2:
	lea	-CaveX+1(a0),a5
	bsr.L	SShot
	tst.b	d6
	beq.s	Box_86_3
	st	-CaveX+1(a1)
Box_86_3:
	lea	-1(a0),a5
	bsr.L	SShot
	tst.b	d6
	beq.s	Box_86_4
	st	-1(a1)
Box_86_4:
	lea	1(a0),a5
	bsr.L	SShot
	tst.b	d6
	beq.s	Box_86_5
	st	1(a1)
Box_86_5:
	lea	CaveX-1(a0),a5
	bsr.L	SShot
	tst.b	d6
	beq.s	Box_86_6
	st	CaveX-1(a1)
Box_86_6:
	lea	CaveX(a0),a5
	bsr.L	SShot
	tst.b	d6
	beq.s	Box_86_7
	st	CaveX(a1)
Box_86_7:
	lea	CaveX+1(a0),a5
	bsr.L	SShot
	tst.b	d6
	beq.s	Box_86_8
	st	CaveX+1(a1)
Box_86_8:
	rts

Box_36:
	move.b	#58,(a0)
	tst.b	-CaveX(a0)
	beq.s	Box_36_1
	cmp.b	#52,-CaveX(a0)
	beq.s	Box_36_1
	lea	-CaveX(a0),a5
	bsr.L	Shot
	tst.b	d6
	beq.L	RetBox
	st	-CaveX(a1)
	rts
Box_36_1:
	move.b	#36,-CaveX(a0)
	st	-CaveX(a1)
	rts

Box_37:
	move.b	#58,(a0)
	tst.b	1(a0)
	beq.s	Box_37_1
	cmp.b	#52,1(a0)
	beq.s	Box_37_1
	lea	1(a0),a5
	bsr.L	Shot
	tst.b	d6
	beq.L	RetBox
	st	1(a1)
	rts
Box_37_1:
	move.b	#37,1(a0)
	st	1(a1)
	rts

Box_38:
	move.b	#58,(a0)
	tst.b	CaveX(a0)
	beq.s	Box_38_1
	cmp.b	#52,CaveX(a0)
	beq.s	Box_38_1
	lea	CaveX(a0),a5
	bsr.L	Shot
	tst.b	d6
	beq.L	RetBox
	st	CaveX(a1)
	rts
Box_38_1:
	move.b	#38,CaveX(a0)
	st	CaveX(a1)
	rts

Box_39:
	move.b	#58,(a0)
	tst.b	-1(a0)
	beq.s	Box_39_1
	cmp.b	#52,-1(a0)
	beq.s	Box_39_1
	lea	-1(a0),a5
	bsr.L	Shot
	tst.b	d6
	beq.L	RetBox
	st	-1(a1)
	rts
Box_39_1:
	move.b	#39,-1(a0)
	st	-1(a1)
	rts

Box_48:
	bsr.L	Random
	cmp.b	#10,d6
	bhi.L	RetBox
	tst.b	-CaveX(a0)
	beq.s	Box_48_1
	cmp.b	#52,-CaveX(a0)
	beq.s	Box_48_1
	lea	-CaveX(a0),a5
	bsr.L	Shot
	tst.b	d6
	beq.L	RetBox
	st	-CaveX(a1)
	rts
Box_48_1:
	move.b	#36,-CaveX(a0)
	st	-CaveX(a1)
	rts

Box_49:
	bsr.L	Random
	cmp.b	#10,d6
	bhi.L	RetBox
	tst.b	1(a0)
	beq.s	Box_49_1
	cmp.b	#52,1(a0)
	beq.s	Box_49_1
	lea	1(a0),a5
	bsr.L	Shot
	tst.b	d6
	beq.L	RetBox
	st	1(a1)
	rts
Box_49_1:
	move.b	#37,1(a0)
	st	1(a1)
	rts

Box_50:
	bsr.L	Random
	cmp.b	#10,d6
	bhi.L	RetBox
	tst.b	CaveX(a0)
	beq.s	Box_50_1
	cmp.b	#52,CaveX(a0)
	beq.s	Box_50_1
	lea	CaveX(a0),a5
	bsr.L	Shot
	tst.b	d6
	beq.L	RetBox
	st	CaveX(a1)
	rts
Box_50_1:
	move.b	#38,CaveX(a0)
	st	CaveX(a1)
	rts

Box_51:
	bsr.L	Random
	cmp.b	#10,d6
	bhi.L	RetBox
	tst.b	-1(a0)
	beq.s	Box_51_1
	cmp.b	#52,-1(a0)
	beq.s	Box_51_1
	lea	-1(a0),a5
	bsr.L	Shot
	tst.b	d6
	beq.L	RetBox
	st	-1(a1)
	rts
Box_51_1:
	move.b	#39,-1(a0)
	st	-1(a1)
	rts

Box_53:
	move.b	#54,(a0)
	rts

Box_54:
	move.b	#55,(a0)
	rts

Box_55:
	move.b	#56,(a0)
	rts

Box_56:
	move.b	NiespCnt,d6
	cmp.b	#21,d6
	bcs.s	Box_56_1
	cmp.b	#42,d6
	bcs.s	Box_56_2
	cmp.b	#63,d6
	bcs.s	Box_56_3
	cmp.b	#84,d6
	bcs.s	Box_56_4
	cmp.b	#105,d6
	bcs.s	Box_56_5
	cmp.b	#126,d6
	bcs.s	Box_56_6
	cmp.b	#147,d6
	bcs.s	Box_56_7
	cmp.b	#168,d6
	bcs.s	Box_56_8
	cmp.b	#189,d6
	bcs.s	Box_56_9
	cmp.b	#210,d6
	bcs.s	Box_56_10
	cmp.b	#231,d6
	bcs.s	Box_56_11
	move.b	#133,(a0)
	rts

Box_56_1:
	move.b	#13,(a0)
	rts

Box_56_2:
	move.b	#16,(a0)
	rts

Box_56_3:
	move.b	#20,(a0)
	rts

Box_56_4:
	move.b	#24,(a0)
	rts

Box_56_5:
	move.b	#25,(a0)
	rts

Box_56_6:
	move.b	#26,(a0)
	rts

Box_56_7:
	move.b	#27,(a0)
	rts

Box_56_8:
	move.b	#40,(a0)
	rts

Box_56_9:
	move.b	#44,(a0)
	rts

Box_56_10:
	move.b	#61,(a0)
	rts

Box_56_11:
	move.b	#131,(a0)
	rts

SShotB:
	st	d6
	move.b	#64,(a5)
	rts

SShot:
	sf	d6
	cmp.b	#6,(a5)
	beq.s	SShotB
	cmp.b	#128,(a5)
	beq.s	SShotB
Shot:
	sf	d6
	cmp.b	#52,(a5)
	beq.s	Shot1
	cmp.b	#1,(a5)
	beq.s	ShotRobbo
	cmp.b	#11,(a5)
	bls.s	Shot0
	cmp.b	#27,(a5)
	bls.s	Shot1
	cmp.b	#51,(a5)
	bls.s	Shot0
	cmp.b	#131,(a5)
	bls.s	Shot0
	cmp.b	#132,(a5)
	beq.s	ShotBomb
	cmp.b	#133,(a5)
	beq.s	ShotNiesp
	bra.s	Shot0
Shot1:	st	d6
	move.b	#64,(a5)
Shot0:	rts

ShotRobbo:
	move.b	#1,KillRobbo
	move.b	#64,(a5)
	st	d6
	rts

ShotBomb:
	move.b	#86,(a5)
	st	d6
	rts

ShotNiesp:
	move.b	#53,(a5)
	st	d6
	rts

;*******************************************************************

Player:
	sf	BylRuch

	tst.b	FineRobbo
	beq.s	PlAy97
	add.b	#1,FineRobbo
	rts
PlAy97:
	tst.w	BCD3
	bne.s	PlAy98
	tst.b	BCD6
	beq.s	PlAy98
	st	CaveOpen
PlAy98:
	tst.b	KillRobbo
	beq.s	PlAy99
	add.b	#1,KillRobbo
	rts

PlAy99:	bsr.L	JoyStick

	btst	#3,KEYICR
	beq.L	Key0
	move.b	KEYSDR,d0
	bset	#6,KEYCRA
	bclr	#6,KEYCRA

	cmp.b	#$75,d0
	bne.s	Key1
	move.b	#1,KillRobbo
	lea	Cave,a0
	movea.l	a0,a3
	add.l	PlayOfs,a0
	move.b	#64,(a0)
	rts
Key1:
	cmp.b	#$67,d0
	bne.s	Key2
	st	KeyUp
	bra.L	Key0
Key2:
	cmp.b	#$65,d0
	bne.s	Key3
	st	KeyDown
	bra.L	Key0
Key3:
	cmp.b	#$63,d0
	bne.s	Key4
	st	KeyRight
	bra.L	Key0
Key4:
	cmp.b	#$61,d0
	bne.s	Key5
	st	KeyLeft
	bra.s	Key0
Key5:
	cmp.b	#$66,d0
	bne.s	Key6
	sf	KeyUp
	bra.s	Key0
Key6:
	cmp.b	#$64,d0
	bne.s	Key7
	sf	KeyDown
	bra.s	Key0
Key7:
	cmp.b	#$62,d0
	bne.s	Key8
	sf	KeyRight
	bra.s	Key0
Key8:
	cmp.b	#$60,d0
	bne.s	Key9
	sf	KeyLeft
	bra.s	Key0
Key9:
	cmp.b	#$37,d0
	bne.s	Key10
	st	KeyFire
	bra.s	Key0
Key10:
	cmp.b	#$36,d0
	bne.s	Key11
	sf	KeyFire
	bra.s	Key0
Key11:
	cmp.b	#$35,d0
	bne.s	Key12
	st	KeyFire
	bra.s	Key0
Key12:
	cmp.b	#$34,d0
	bne.s	Key13
	sf	KeyFire
	bra.s	Key0
Key13:
	nop
Key0:
	tst.l	JoyUp
	bne.s	Key00
	tst.b	JoyFire
	bne.s	Key00
	move.l	KeyUp,JoyUp
	move.b	KeyFire,JoyFire
Key00:
	move.w	PlayY,d0
	lsl.w	#2,d0
	lea	Cave,a0
	lea	BoxLine,a1
	add.l	0(a1,d0.w),a0
	sf	d1
	sf	d2
	move.w	#CaveX-1,d0
PlAy10:	cmp.b	#0,(a0)
	beq.s	PlAy11
	cmp.b	#1,(a0)
	beq.s	PlAy12
	cmp.b	#78,(a0)
	beq.s	PlAy13
	cmp.b	#79,(a0)
	beq.s	PlAy14
	sf	d1
	sf	d2
PlAy11:	lea	1(a0),a0
	dbf	d0,PlAy10
	bra.s	PlAy00
PlAy12:
	tst.b	d1
	bne.s	PlAy15
	sf	d1
	st	d2
	bra.s	PlAy11
PlAy15:
	sf	JoyFire
	sf	JoyUp
	sf	JoyDown
	st	JoyLeft
	sf	JoyRight
	bra.s	PlAy00
PlAy13:
	st	d1
	sf	d2
	bra.s	PlAy11
PlAy14:
	tst.b	d2
	bne.s	PlAy16
	sf	d1
	sf	d2
	bra.s	PlAy11
PlAY16:
	sf	JoyFire
	sf	JoyUp
	sf	JoyDown
	sf	JoyLeft
	st	JoyRight
PlAy00:
	move.w	PlayX,d0
	move.w	PlayY,d1
	lea	Cave,a0
	movea.l	a0,a3
	add.l	PlayOfs,a0

	cmp.b	#16,-1(a0)
	bcs.s	Kill1
	cmp.b	#27,-1(a0)
	bhi.s	Kill1
Kill2:
	move.b	#1,KillRobbo
	move.b	#64,(a0)
	rts
Kill1:
	cmp.b	#16,1(a0)
	bcs.s	Kill3
	cmp.b	#27,1(a0)
	bls.s	Kill2
Kill3:
	cmp.b	#16,-CaveX(a0)
	bcs.s	Kill4
	cmp.b	#27,-CaveX(a0)
	bls.s	Kill2
Kill4:
	cmp.b	#16,CaveX(a0)
	bcs.s	Kill5
	cmp.b	#27,CaveX(a0)
	bls.s	Kill2
Kill5:
	cmp.b	#78,-1(a0)
	beq.s	Kill2
	cmp.b	#79,1(a0)
	beq.s	Kill2

	tst.b	JoyRight
	beq.s	PlAy2
	addq	#1,d0
	lea	1(a0),a1
	lea	2(a0),a2
	move.b	#76,d2
	move.b	#29,d4
	st	Kierunek
	bra.L	MovePlayer
PlAy2:
	tst.b	JoyLeft
	beq.s	PlAy3
	subq	#1,d0
	lea	-1(a0),a1
	lea	-2(a0),a2
	move.b	#77,d2
	move.b	#31,d4
	sf	Kierunek
	bra.s	MovePlayer
PlAy3:
	tst.b	JoyDown
	beq.s	PlAy4
	addq	#1,d1
	lea	CaveX(a0),a1
	lea	CaveX*2(a0),a2
	move.b	#75,d2
	move.b	#30,d4
	bra.s	MovePlayer
PlAy4:
	tst.b	JoyUp
	beq.s	PlAy5
	subq	#1,d1
	lea	-CaveX(a0),a1
	lea	-CaveX*2(a0),a2
	move.b	#74,d2
	move.b	#28,d4
	bra.s	MovePlayer
PlAy5:
	move.b	#1,(a0)
	rts

PlFire:
	tst.b	(a1)
	beq.s	PlFi1
	tst.w	BCD4
	beq.s	PlAy5
	movea.l	a1,a5
	bsr.L	Shot
	tst.b	d6
	beq.s	PlAy5
	bsr.L	DecStrzal
	bra.s	PlAy5
PlFi1:
	tst.w	BCD4
	beq.s	PlAy5
	bsr.L	DecStrzal
	move.b	d4,(a1)
	bra.s	PlAy5

MovePlayer:
	tst.b	JoyFire
	bne.s	PlFire
	tst.b	(a1)
	bne.L	CheckPush
MoPl0:	clr.b	(a0)
	move.b	#1,(a1)
	move.w	d0,PlayX
	move.w	d1,PlayY
	suba.l	a3,a1
	move.l	a1,PlayOfs
	st	BylRuch
	rts

MKrata:
	tst.b	(a2)
	bne.s	PlAy5
	move.b	d2,d3
	bra.L	PuSh0

MLustro:
	cmp.b	#29,d4
	beq.s	MLRight
	cmp.b	#31,d4
	beq.s	MLLeft
	cmp.b	#30,d4
	beq.L	MLDown

MLUp:
	bsr.L	FindMir
	move.w	8(a2),d0
	move.w	10(a2),d1
	move.l	12(a2),a1
	bsr.L	CheckU
	bsr.L	CheckD
	bsr.L	CheckR
	bsr.L	CheckL
	move.w	(a2),d0
	move.w	2(a2),d1
	move.l	4(a2),a1
	bsr.L	CheckU
	bsr.L	CheckR
	bsr.L	CheckL
	bra.L	MLStop

MLRight:
	bsr.L	FindMir
	move.w	8(a2),d0
	move.w	10(a2),d1
	move.l	12(a2),a1
	bsr.L	CheckR
	bsr.L	CheckL
	bsr.L	CheckU
	bsr.L	CheckD
	move.w	(a2),d0
	move.w	2(a2),d1
	move.l	4(a2),a1
	bsr.L	CheckR
	bsr.L	CheckU
	bsr.L	CheckD
	bra.L	MLStop

MLLeft:
	bsr.L	FindMir
	move.w	8(a2),d0
	move.w	10(a2),d1
	move.l	12(a2),a1
	bsr.L	CheckL
	bsr.L	CheckR
	bsr.s	CheckU
	bsr.L	CheckD
	move.w	(a2),d0
	move.w	2(a2),d1
	move.l	4(a2),a1
	bsr.L	CheckL
	bsr.s	CheckU
	bsr.L	CheckD
	bra.s	MLStop

MLDown:
	bsr.L	FindMir
	move.w	8(a2),d0
	move.w	10(a2),d1
	move.l	12(a2),a1
	bsr.s	CheckD
	bsr.s	CheckU
	bsr.L	CheckR
	bsr.L	CheckL
	move.w	(a2),d0
	move.w	2(a2),d1
	move.l	4(a2),a1
	bsr.s	CheckD
	bsr.L	CheckR
	bsr.L	CheckL
	bra.s	MLStop

FindMir:
	lea	Mirrors,a2
	move.w	#IlMirrors-1,d4
FiMi1:	cmp.w	(a2),d0
	bne.s	FiMi2
	cmp.w	2(a2),d1
	bne.s	FiMi2
	rts
FiMi2:	lea	16(a2),a2
	dbf	d4,FiMi1
	rts

MLStop:
	move.b	#1,(a0)
	rts

CheckU:
	tst.b	-CaveX(a1)
	bne.s	Check0
	move.b	#60,(a0)
	lea	-CaveX(a1),a1
	move.b	#1,(a1)
	suba.l	a3,a1
	move.l	a1,PlayOfs
	subq.w	#1,d1
	move.w	d0,PlayX
	move.w	d1,PlayY
	move.l	(sp)+,d0
Check0:	rts

CheckD:
	tst.b	CaveX(a1)
	bne.s	Check0
	move.b	#60,(a0)
	lea	CaveX(a1),a1
	move.b	#1,(a1)
	suba.l	a3,a1
	move.l	a1,PlayOfs
	addq.w	#1,d1
	move.w	d0,PlayX
	move.w	d1,PlayY
	move.l	(sp)+,d0
	rts

CheckL:
	tst.b	-1(a1)
	bne.s	Check0
	move.b	#60,(a0)
	lea	-1(a1),a1
	move.b	#1,(a1)
	suba.l	a3,a1
	move.l	a1,PlayOfs
	subq.w	#1,d0
	move.w	d0,PlayX
	move.w	d1,PlayY
	move.l	(sp)+,d0
	rts

CheckR:
	tst.b	1(a1)
	bne.s	Check0
	move.b	#60,(a0)
	lea	1(a1),a1
	move.b	#1,(a1)
	suba.l	a3,a1
	move.l	a1,PlayOfs
	addq.w	#1,d0
	move.w	d0,PlayX
	move.w	d1,PlayY
	move.l	(sp)+,d0
	rts

MDrzwi:
	tst.w	BCD5
	beq.L	PlAy5
	bsr.L	DecKlucz
	bra.L	MoPl0

MSruba:
	bsr.L	DecSruba
	bra.L	MoPl0

MKlucz:
	bsr.L	IncKlucz
	bra.L	MoPl0

MBat:
	bsr.L	SetBat
	bra.L	MoPl0

MNab:
	bsr.L	AddStrzal
	bra.L	MoPl0

MZycie:
	bsr.L	IncLives
	bra.L	MoPl0

MKaps:
	tst.b	CaveOpen
	beq.s	Push
	move.b	#1,FineRobbo
	clr.b	(a0)
	rts

CheckPush:
	move.b	(a1),d3
	cmp.b	#4,d3
	beq.L	MKrata
	cmp.b	#5,d3
	beq.L	MLustro
	cmp.b	#6,d3
	beq.s	MDrzwi
	cmp.b	#9,d3
	beq.s	MSruba
	cmp.b	#10,d3
	beq.s	MKLucz
	cmp.b	#11,d3
	beq.s	MBat
	cmp.b	#12,d3
	beq.s	MNab
	cmp.b	#13,d3
	beq.s	MZycie
	cmp.b	#128,d3
	beq.s	MKaps
ChPu0:	tst.b	d3
	bmi.s	Push
	bra.L	PlAy5

Push:
	tst.b	(a2)
	bne.L	PlAy5
PuSh0:	clr.b	(a0)
	move.b	d3,(a2)
	move.b	#1,(a1)
	move.w	d0,PlayX
	move.w	d1,PlayY
	suba.l	a3,a1
	move.l	a1,PlayOfs
	st	BylRuch
	rts

;*******************************************************************

ClrKeyBuf:
	bsr.L	WaitVBL
	bsr.L	WaitVBL
	btst	#3,KEYICR
	beq.L	CKB0
	move.b	KEYSDR,d0
	bset	#6,KEYCRA
	bclr	#6,KEYCRA
	bra.s	ClrKeyBuf
CKB0:	rts

;*******************************************************************

Range:
	cmp.b	#ScrlDelay,ScrlCnt
	bcs.L	RaNe2
	sf	ScrlCnt
	move.w	YCave,d0
	addq.w	#4,d0
	sub.w	PlayY,d0
	bmi.s	ScrlDown
	cmp.b	#1,d0
	bcc.s	ScrlUp
RaNe1:	move.w	XCave,d0
	addq.w	#6,d0
	sub.w	PlayX,d0
	bmi.s	ScrlRight
	cmp.b	#2,d0
	bcc.s	ScrlLeft
RaNe2:	rts

ScrlDown:
	cmp.w	#24,YCave
	beq.s	RaNe1
	add.w	#1,YCave
	add.w	#ScrNB,CaveScrlY
	bra.s	RaNe1

ScrlUp:
	tst.w	YCave
	beq.s	RaNe1
	sub.w	#1,YCave
	sub.w	#ScrNB,CaveScrlY
	bra.s	RaNe1

ScrlRight
	cmp.w	#6,XCave
	beq.s	RaNe2
	add.w	#1,XCave
	add.w	#24,CaveScrlX
	bra.s	RaNe2

ScrlLeft:
	tst.w	XCave
	beq.s	RaNe2
	sub.w	#1,XCave
	sub.w	#24,CaveScrlX
	bra.s	RaNe2

;*******************************************************************

ScreenSwap:
	move.l	Screen0Ptr,d0
	tst.b	ScrNum
	beq.s	ScSw1
	move.l	Screen1Ptr,d0
ScSw1:	move.l	d0,ActScreen
ScSw2:	st	CopyScroll
ScSw3:	tst.b	CopyScroll
	bne.s	ScSw3
	tst.b	LoopCnt
	bmi.s	ScSw0
	cmp.b	#LoopDelay,LoopCnt
	bcs.s	ScSw2
ScSw0:	eor.b	#$ff,ScrNum
	sf	LoopCnt
	add.b	#1,ScrlCnt
	rts

;*******************************************************************

Paste:
	lea	Cave-1-CaveX,a0
	move.w	YCave,d0
	lsl.w	#2,d0
	lea	BoxLine,a1
	add.l	0(a1,d0.w),a0
	add.w	XCave,a0
	move.l	Screen0Ptr,a1
	tst.b	ScrNum
	beq.s	PaSt2
	move.l	Screen1Ptr,a1
PaSt2:	lea	BoxToBob,a2
	lea	BoxOfs,a3
	btst	#6,DMACONR(a6)
PaSt5:	btst	#6,DMACONR(a6)
	bne.s	PaSt5
	clr.w	d3
	move.w	#$dfc,BLTCON0(a6)
	move.w	#ScrBpr-BoxBpr,BLTAMOD(a6)
	move.w	#ScrBpr-BoxBpr,BLTDMOD(a6)
	move.w	d3,BLTBMOD(a6)
	move.w	#ScrBoxY-1,d1
PaSt3:	move.w	#ScrBoxX-1,d2
PaSt4:	clr.w	d0
	move.b	(a0)+,d0
	move.b	0(a2,d0.w),d0
	lsl.w	#2,d0
	btst	#6,DMACONR(a6)
PaSt6:	btst	#6,DMACONR(a6)
	bne.s	PaSt6
	move.l	a1,BLTAPT(a6)
	move.l	a1,BLTDPT(a6)
	move.l	0(a3,d0.w),BLTBPT(a6)
	eor.b	#$ff,d3
	beq.s	PaSt7
	move.l	#$ff,BLTAFWM(a6)
	move.w	#0,BLTCON1(a6)
	move.w	#64*BoxY*ScrDph+2,BLTSIZE(a6)
	lea	2(a1),a1
	dbf	d2,PaSt4
	lea	ScrNB-ScrBpr(a1),a1
	lea	CaveX-ScrBoxX(a0),a0
	dbf	d1,PaSt3
	bra.L	WaitBlt
PaSt7:	move.l	#$ff000000,BLTAFWM(a6)
	move.w	#$8000,BLTCON1(a6)
	move.w	#64*BoxY*ScrDph+2,BLTSIZE(a6)
	lea	4(a1),a1
	dbf	d2,PaSt4
	lea	ScrNB-ScrBpr(a1),a1
	lea	CaveX-ScrBoxX(a0),a0
	dbf	d1,PaSt3
	bra.L	WaitBlt

;*******************************************************************

OnDMA:
	move.l	CLPtr,COP1PTR(a6)
	move.w	#SETCLR+DMAEN+BPLEN+BLTEN+BLTPR+COPEN,DMACON(a6)
	rts

;*******************************************************************

CopyCave:
	st	d6
	move.b	CaveNum,d7
	cmp.b	OldCave,d7
	bne.s	CoCa0
	sf	d6
CoCa0:	move.b	d7,OldCave
	lea	Cave,a0
	lea	Cave0,a1
	lea	Cave1,a2
	move.l	CavePtr,a3
	move.w	#CaveSize-1,d0
CoCa1:	move.b	(a3)+,(a0)+
	tst.b	d6
	bne.s	CoCa00
	cmp.b	#13,-1(a0)
	bne.s	CoCa00
	clr.b	-1(a0)
CoCa00:	clr.b	(a1)+
	clr.b	(a2)+
	dbf	d0,CoCa1
	move.l	ActBTB,a0
	lea	BobsData,a1
	move.l	BobsPtr,a2
	move.w	#IlBob-1,d0
CoCa2:	clr.l	d1
	move.b	(a0)+,d1
	mulu.w	#BoxSize,d1
	movea.l	a1,a3
	adda.l	d1,a3
	move.w	#BoxSize-1,d1
CoCa3:	move.b	(a3)+,(a2)+
	dbf	d1,CoCa3
	dbf	d0,CoCa2
	clr.w	d0
	clr.w	d1
	clr.l	d2
	move.l	CavePtr,a0
CoCa4:	cmp.b	#1,(a0)+
	beq.s	CoCa5
	addq.l	#1,d2
	addq.l	#1,d0
	cmp.b	#CaveX,d0
	bcs.s	CoCa4
	clr.w	d0
	addq.l	#1,d1
	bra.s	CoCa4
CoCa5:	move.w	d0,PlayX
	move.w	d1,PlayY
	move.l	d2,PlayOfs
	clr.w	BCD3
	move.l	CavePtr,a0
	move.w	#CaveSize-1,d0
CoCa6:	cmp.b	#9,(a0)+
	bne.s	CoCa7
	bsr.L	IncSruba
CoCa7:	dbf	d0,CoCa6
	lea	Cave,a2
	lea	Mirrors,a0
	move.l	CavePtr,a1
	lea	CaveSize(a1),a1
	move.w	#IlMirrors-1,d0
CoCa8:
	clr.l	d1
	clr.l	d2
	clr.l	d3
	clr.l	d4
	move.b	(a1)+,d1
	move.b	(a1)+,d2
	move.b	(a1)+,d3
	move.b	(a1)+,d4
	move.w	d1,(a0)
	move.w	d2,2(a0)
	move.w	d3,8(a0)
	move.w	d4,10(a0)
	mulu.w	#CaveX,d2
	mulu.w	#CaveX,d4
	add.l	d1,d2
	add.l	d3,d4
	add.l	a2,d2
	add.l	a2,d4
	move.l	d2,4(a0)
	move.l	d4,12(a0)
	lea	16(a0),a0
	dbf	d0,CoCa8
	rts

;*******************************************************************

SetPalette:
	rts

	move.l	CLPtr,a0
	lea	Palette0,a1
	move.w	#15,d0
SePa1:	move.w	(a1)+,2(a0)
	lea	4(a0),a0
	dbf	d0,SePa1
	move.l	CLPtr,a0
	lea	CoLiDLCol-CopperList(a0),a0
	lea	Palette0,a1
	move.w	#15,d0
SePa2:	move.w	(a1)+,2(a0)
	lea	4(a0),a0
	dbf	d0,SePa2
	rts

;*******************************************************************

ResetCave:
	bsr.L	StopVBL
	lea	CavesRem,a0
	clr.l	d0
	move.b	CaveNum,d0
	lsl.l	#1,d0
	clr.l	d1
	clr.l	d2
	move.b	0(a0,d0.w),d1
	move.b	1(a0,d0.w),d2
	lsl.l	#2,d1
	lsl.l	#2,d2
	lea	RemTabBTB,a0
	adda.l	0(a0,d1.w),a0
	move.l	a0,ActBTB
	lea	RemTabPAL,a0
	adda.l	0(a0,d2.w),a0
	move.l	a0,ActPalette
	clr.w	XCave
	clr.w	YCave
	clr.b	ScrNum
	clr.b	CopyScroll
	clr.w	CaveScrlX
	clr.w	CaveScrlY
	clr.w	CmpScrlX
	clr.w	CmpScrlY
	clr.w	ScrollX
	clr.w	ScrollY
	clr.b	LoopCnt
	clr.b	ScrlCnt
	clr.b	CaveSwap
	clr.b	CaveOpen
	clr.b	KillRobbo
	clr.b	Last
	clr.b	FineRobbo
	clr.b	Kierunek
	clr.b	BylRuch
	clr.b	AnimCnt
	clr.b	NietopCnt
	clr.l	KeyUp
	clr.b	KeyFire
	clr.l	JoyUp
	clr.b	JoyFire
	moveq	#0,d0
	move.b	CaveNum,d0
	mulu.w	#CSize,d0
	lea	Caves,a0
	adda.l	d0,a0
	move.l	a0,CavePtr
	bsr.L	SetPalette
	bsr.L	CopyCave
	bsr.L	ResetCyfry
	bsr.L	StartVBL
	bsr.L	Anim
	rts

;*******************************************************************

SetVar:
	move.l	CLPtr,a0
	lea	CoLiDL-CopperList(a0),a0
	move.l	LinePtr,d0
	move.w	#3,d1
SeVa1:	move.w	d0,6(a0)
	swap	d0
	move.w	d0,2(a0)
	swap	d0
	add.l	#36,d0
	lea	8(a0),a0
	dbf	d1,SeVa1
	lea	BoxLine,a0
	move.w	#CaveY-1,d0
	clr.l	d1
SeVa2:	move.l	d1,(a0)+
	add.l	#CaveX,d1
	dbf	d0,SeVa2
	lea	BoxOfs,a0
	move.l	BobsPtr,d0
	move.w	#IlBob-1,d1
SeVa3:	move.l	d0,(a0)+
	add.l	#BoxSize,d0
	dbf	d1,SeVa3
	lea	Cyfry,a0
	lea	CyfryTab,a1
	move.w	#11,d0
SeVa4:	move.l	a0,(a1)+
	lea	17(a0),a0
	dbf	d0,SeVa4
	move.l	LinePtr,a0
	lea	5(a0),a0
	lea	20*36(a0),a0
	move.l	a0,BCD1Ptr
	lea	6(a0),a0
	move.l	a0,BCD2Ptr
	lea	6(a0),a0
	move.l	a0,BCD3Ptr
	lea	6(a0),a0
	move.l	a0,BCD4Ptr
	lea	5(a0),a0
	move.l	a0,BCD5Ptr
	lea	5(a0),a0
	move.l	a0,BCD6Ptr
	move.b	#0,BCD1
	move.b	#1,BCD1+1
	move.b	#0,BCD2
	move.b	#StartLives,BCD2+1
	move.b	#0,BCD3
	move.b	#0,BCD3+1
	move.b	#0,BCD4
	move.b	#0,BCD4+1
	move.b	#0,BCD5
	move.b	#0,BCD5+1
	sf	BCD6
	st	OldCave
	clr.l	d0
SeVr1:
	cmp.b	CaveNum,d0
	beq.s	SeVr2
	bsr.L	IC
	addq.b	#1,d0
	bra.s	SeVr1
SeVr2:
	rts

;*******************************************************************

ResetGame:
	bsr.L	SetVar
	bsr.L	SetVBL
	bsr.L	OnDMA
	rts

;*******************************************************************

Joystick:
	btst	#7,$bfe001
	seq	JoyFire
	move.w	JOY1DAT(a6),d0
	btst	#1,d0
	sne	JoyRight
	btst	#9,d0
	sne	JoyLeft
	sf	JoyUp
	sf	JoyDown
	btst	#0,d0
	bne.s	JoYs1
	btst	#1,d0
	beq.s	JoYs2
	st	JoyDown
	bra.s	JoYs2
JoYs1:	btst	#1,d0
	bne.s	JoYs2
	st	JoyDown
JoYs2:	btst	#8,d0
	bne.s	JoYs3
	btst	#9,d0
	beq.s	JoYs4
	st	JoyUp
	bra.s	JoYs4
JoYs3:	btst	#9,d0
	bne.s	JoYs4
	st	JoyUp
JoYs4:	rts

;*******************************************************************

ProcVBL:
	st	ByloVBL
	add.b	#20,NiespCnt
	tst.b	LoopCnt
	bmi.s	VBL0
	add.b	#1,LoopCnt
VBL0:	tst.b	CopyScroll
	beq.s	VBL1
	move.w	CaveScrlX,CmpScrlX
	move.w	CaveScrlY,CmpScrlY
	sf	CopyScroll
VBL1:	clr.l	d0
	move.w	ScrollY,d0
	sub.w	CmpScrlY,d0
	beq.s	VBL5
	bmi.s	VBL4
	sub.w	#ScrNL*2,ScrollY
	sub.w	#ScrNL*2,d0
	bra.s	VBL5
VBL4:	add.w	#ScrNL*2,ScrollY
	add.w	#ScrNL*2,d0
VBL5:	move.l	ActScreen,a0
	ext.l	d0
	add.l	a0,d0
	move.l	CLPtr,a0
	lea	CoLiScrl-CopperList+2(a0),a0
	clr.l	d1
	move.w	ScrollX,d1
	sub.w	CmpScrlX,d1
	beq.s	VBL6
	bmi.s	VBL7
	sub.w	#2,ScrollX
	subq.w	#1,d1
	move.w	d1,d2
	and.w	#%1111,d2
	moveq	#15,d3
	sub.b	d2,d3
	move.b	d3,d2
	lsl.b	#4,d2
	or.b	d2,d3
	move.w	d3,(a0)
	lsr.w	#4,d1
	lsl.w	#1,d1
	add.l	d1,d0
	addq	#2,d0
	bra.s	VBL8
VBL7:	add.w	#2,ScrollX
	neg.w	d1
	move.w	d1,d2
	and.w	#%1111,d2
	move.w	d2,d3
	lsl.b	#4,d3
	or.b	d3,d2
	move.w	d2,(a0)
	lsr.w	#4,d1
	lsl.w	#1,d1
	ext.l	d1
	sub.l	d1,d0
	bra.s	VBL8
VBL6:	clr.w	(a0)
VBL8:	add.l	#ScrNB,d0
	move.l	CLPtr,a1
	lea	CoLiScr-CopperList(a1),a1
	move.l	d0,d1
	move.l	d0,d2
	move.l	d0,d3
	add.l	#ScrBPR*1,d1
	add.l	#ScrBPR*2,d2
	add.l	#ScrBPR*3,d3
	move.w	d0,8*0+6(a1)
	swap	d0
	move.w	d0,8*0+2(a1)
	move.w	d1,8*1+6(a1)
	swap	d1
	move.w	d1,8*1+2(a1)
	move.w	d2,8*2+6(a1)
	swap	d2
	move.w	d2,8*2+2(a1)
	move.w	d3,8*3+6(a1)
	swap	d3
	move.w	d3,8*3+2(a1)
	rts

;*******************************************************************

VBL:
	move.w	d0,-(sp)
	move.w	INTREQR+CUSTOM,d0
	btst	#5,d0
	beq.s	QuitV
	tst.b	WykonujVBL
	beq.s	QuitV
	movem.l	d0-d7/a0-a6,-(sp)
	lea	CUSTOM,a6
	bsr.L	ProcVBL
	movem.l	(sp)+,d0-d7/a0-a6
QuitV:	and.w	#$7fff,d0
	move.w	d0,INTREQ+CUSTOM
	move.w	(sp)+,d0
	rte

;*******************************************************************

StartVBL:
	st	WykonujVBL
	rts

;*******************************************************************

StopVBL:
	sf	WykonujVBL
	rts

;*******************************************************************

SetVBL:
	sf	WykonujVBL
	lea	VBL,a0
	move.l	a0,$6c
	move.w	#SETCLR+%100000+$4000,INTENA(a6)
	rts

;*******************************************************************

LMK:
	btst	#6,$bfe001
	bne.s	LMK
	rts

;*******************************************************************

WaitBlt:
	btst	#6,$dff002
WaBl1:	btst	#6,$dff002
	bne.s	WaBl1
	rts

;*******************************************************************

StartSystem:
	movem.l	d0-d7/a0-a6,-(sp)
	lea	GfxLibName,a1
	move.l	ExecBase,a6
	jsr	OldOpenLibrary(a6)
	move.l	d0,GfxLibBase
	exg	d0,a6
	jsr	OwnBlitter(a6)
	bsr.s	WaitBlt
	move.l	ExecBase,a6
	jsr	Forbid(a6)
	move.w	$dff002,MemDma
	move.w	$dff01c,MemInt
	or.w	#$8000,MemDma
	or.w	#$8000,MemInt
	move.w	#$7fff,$dff09a
	move.w	#$7fff,$dff096
	lea	MemVectors,a0
	lea	0,a1
	lea	Reset,a2
	moveq	#63,d0
StSy1:	move.l	(a1),(a0)+
	move.l	a2,(a1)+
	dbf	d0,StSy1
	movem.l	(sp)+,d0-d7/a0-a6
	rts

;*******************************************************************

StopSystem:
	movem.l	d0-d7/a0-a6,-(sp)
	move.w	#$7fff,$dff09a
	move.w	#$7fff,$dff096
	lea	MemVectors,a0
	lea	0,a1
	moveq	#63,d0
StSs1:	move.l	(a0)+,(a1)+
	dbf	d0,StSs1
	move.l	GfxLibBase,a6
	move.l	$26(a6),$dff080
	move.w	MemDma,$dff096
	move.w	MemInt,$dff09a
	move.l	ExecBase,a6
	jsr	Permit(a6)
	move.l	GfxLibBase,a6
	jsr	DisownBlitter(a6)
	exg	a6,a1
	move.l	ExecBase,a6
	jsr	CloseLibrary(a6)
	movem.l	(sp)+,d0-d7/a0-a6
	rts

;*******************************************************************

Reset:
	move.w	#$7fff,$dff09a
	move.w	#$7fff,$dff096
	lea	ResetP,a0
	move.l	a0,$80
	trap	#0
ResetP:	clr.l	ExecBase
	lea	2,a0
	reset
	jmp	(a0)

;*******************************************************************
;			CONSTANS
;*******************************************************************

ExecBase	=	4
OldOpenLibrary	=	-408
CloseLibrary	=	-414
OwnBlitter	=	-456
DisownBlitter	=	-462
Forbid		=	-132
Permit		=	-138
CUSTOM		=	$dff000
BLTDDAT		=	$000
DMACONR		=	$002
VPOSR		=	$004
VHPOSR		=	$006
DSKDATR		=	$008
JOY0DAT		=	$00A
JOY1DAT		=	$00C
CLXDAT		=	$00E
ADKCONR		=	$010
POT0DAT		=	$012
POT1DAT		=	$014
POTGOR		=	$016
SERDATR		=	$018
DSKBYTR		=	$01A
INTENAR		=	$01C
INTREQR		=	$01E
DSKPTH		=	$020
DSKPTL		=	$022
DSKLEN		=	$024
DSKDAT		=	$026
REFPTR		=	$028
VPOSW		=	$02A
VHPOSW		=	$02C
COPCON		=	$02E
SERDAT		=	$030
SERPER		=	$032
POTGO		=	$034
JOYTEST		=	$036
STRQU		=	$038
STRVBL		=	$03A
STRHOR		=	$03C
STRLONG		=	$03E
BLTCON0		=	$040
BLTCON1		=	$042
BLTAFWM		=	$044
BLTALWM		=	$046
BLTCPT		=	$048
BLTBPT		=	$04C
BLTAPT		=	$050
BLTDPT		=	$054
BLTSIZE		=	$058
BLTCMOD		=	$060
BLTBMOD		=	$062
BLTAMOD		=	$064
BLTDMOD		=	$066
BLTCDAT		=	$070
BLTBDAT		=	$072
BLTADAT		=	$074
DSKSYNC		=	$07E
COP1PTR		=	$080
COP2PTR		=	$084
COP1LCH		=	$080
COP1LCL		=	$082
COP2LCH		=	$084
COP2LCL		=	$086
COPJMP1		=	$088
COPJMP2		=	$08A
COPINS		=	$08C
DIWSTRT		=	$08E
DIWSTOP		=	$090
DDFSTRT		=	$092
DDFSTOP		=	$094
DMACON		=	$096
CLXCON		=	$098
INTENA		=	$09A
INTREQ		=	$09C
ADKCON		=	$09E
AUDIO0		=	$0A0
AUDIO1		=	$0B0
AUDIO2		=	$0C0
AUDIO3		=	$0D0
BPL1PTH		=	$0E0
BPL1PTL		=	$0E2
BPL2PTH		=	$0E4
BPL2PTL		=	$0E6
BPL3PTH		=	$0E8
BPL3PTL		=	$0EA
BPL4PTH		=	$0EC
BPL4PTL		=	$0EE
BPL5PTH		=	$0F0
BPL5PTL		=	$0F2
BPL6PTH		=	$0F4
BPL6PTL		=	$0F6
BPLCON0		=	$100
BPLCON1		=	$102
BPLCON2		=	$104
BPL1MOD		=	$108
BPL2MOD		=	$10A
SPRPTR		=	$120
SPRPOS		=	$140
COLORS		=	$180
SETCLR		=	$8000
DSKEN		=	$10
SPREN		=	$20
BLTEN		=	$40
COPEN		=	$80
BPLEN		=	$100
DMAEN		=	$200
BLTPR		=	$400
ERSY		=	$2
LACE		=	$4
LPEN		=	$8
GAUD		=	$100
COLOR		=	$200
DBLPF		=	$400
HOMOD		=	$800
BPU0		=	$1000
BPU1		=	$2000
BPU2		=	$4000
HIRES		=	$8000
COPWAIT		=	$fffe
ENDCOPLST	=	$ffff
ENDHALF		=	$ffdf
KEYTALO		=	$bfe401
KEYTAHI		=	$bfe501
KEYCRA		=	$bfee01
KEYSDR		=	$bfec01
KEYICR		=	$bfed01
TBLO		=	$bfd600
TBHI		=	$bfd700
CRB		=	$bfdf00
ICR		=	$bfdd00
SPR0POS		=	$140
SPR0CTL		=	$142
SPR0DATA	=	$144
SPR0DATB	=	$146
SPR1POS		=	$148
SPR1CTL		=	$14a
SPR1DATA	=	$14c
SPR1DATB	=	$14e
SPR2POS		=	$150
SPR2CTL		=	$152
SPR2DATA	=	$154
SPR2DATB	=	$156
SPR3POS		=	$158
SPR3CTL		=	$15a
SPR3DATA	=	$15c
SPR3DATB	=	$15e
SPR4POS		=	$160
SPR4CTL		=	$162
SPR4DATA	=	$164
SPR4DATB	=	$166
SPR5POS		=	$168
SPR5CTL		=	$16a
SPR5DATA	=	$16c
SPR5DATB	=	$16e
SPR6POS		=	$170
SPR6CTL		=	$172
SPR6DATA	=	$174
SPR6DATB	=	$176
SPR7POS		=	$178
SPR7CTL		=	$17a
SPR7DATA	=	$17c
SPR7DATB	=	$17e

;*******************************************************************
;			FAST DATA
;*******************************************************************

	;--- System. ---

SysStat:	dc.b	0
GfxLibName:	dc.b	'graphics.library',0
	EVEN

	;--- Caves. ---

	incdir	'dh1:sources/asm/robbo/bin/gamebin/'

Caves:		incbin	'RobboCaves.BIN'

	;--- Cyfry. ---

Cyfry:		incbin	'RobboCyfry.BIN'

	;--- Bobs. ---

BoxToBob:
	dc.b	00,02,01,09,11,20,21,00,00,13
	dc.b	17,18,42,43,00,00,44,44,44,44
	dc.b	44,44,44,44,46,46,46,46,28,30
	dc.b	28,30,24,26,24,26,49,49,49,49
	dc.b	32,33,34,35,32,35,34,33,36,37
	dc.b	38,39,40,49,50,51,52,49,50,51
	dc.b	52,51,50,49,53,54,55,56,57,58
	dc.b	59,60,61,62,11,11,11,11,22,23
	dc.b	24,26,36,37,38,39,53,00,00,00
	dc.b	00,00,00,00,00,00,00,00,00,00
	dc.b	00,00,00,00,00,00,00,00,00,00
	dc.b	00,00,00,00,00,00,00,00,00,00
	dc.b	00,00,00,00,00,00,00,00

	dc.b	14,00
	dc.b	00,10,12,19,36,37,38,39,00,00

BoxToBox0:	dc.b	97,98,0,1,2,3,4,5,6,20,28,33,38,39,123
		dc.b	44,46,49,52,55,58,61,65,66,73,77,81
		dc.b	85,89,93,124,128,99,102,105,108,111,114
		dc.b	117,120,132,136,137,140,143,144,145,146,147
		dc.b	154,155,156,157,158,159,160,161
		dc.b	162,163,164,165,166,167,0

BoxToBox1:	dc.b	97,98,0,1,2,3,4,5,6,7,27,31,35,39,123
		dc.b	43,46,49,52,55,58,61,65,66,73,77,81
		dc.b	85,89,93,124,128,99,102,105,108,111,114
		dc.b	117,120,132,136,137,140,143,144,145,146,147
		dc.b	154,155,156,157,158,159,160,161
		dc.b	162,163,164,165,166,167,0

BoxToBox2:	dc.b	97,98,0,1,2,3,4,5,6,7,27,31,35,39,123
		dc.b	43,46,49,52,55,58,61,65,66,73,77,81
		dc.b	85,89,93,124,128,99,102,105,108,111,114
		dc.b	117,120,132,136,137,140,143,144,145,146,147
		dc.b	154,155,156,157,158,159,160,161
		dc.b	162,163,164,165,166,167,0

BoxToBox3:	dc.b	97,98,0,1,2,3,4,5,6,7,27,31,35,39,123
		dc.b	43,46,49,52,55,58,61,65,66,73,77,81
		dc.b	85,89,93,124,128,99,102,105,108,111,114
		dc.b	117,120,132,136,137,140,143,144,145,146,147
		dc.b	154,155,156,157,158,159,160,161
		dc.b	162,163,164,165,166,167,0

BoxToBox4:	dc.b	97,98,0,1,2,3,4,5,6,7,27,31,35,39,123
		dc.b	43,46,49,52,55,58,61,65,66,73,77,81
		dc.b	85,89,93,124,128,99,102,105,108,111,114
		dc.b	117,120,132,136,137,140,143,144,145,146,147
		dc.b	154,155,156,157,158,159,160,161
		dc.b	162,163,164,165,166,167,0

BoxToBox5:	dc.b	97,98,0,1,2,3,4,5,6,7,27,31,35,39,123
		dc.b	43,46,49,52,55,58,61,65,66,73,77,81
		dc.b	85,89,93,124,128,99,102,105,108,111,114
		dc.b	117,120,132,136,137,140,143,144,145,146,147
		dc.b	154,155,156,157,158,159,160,161
		dc.b	162,163,164,165,166,167,0

BoxToBox6:	dc.b	97,98,0,1,2,3,4,5,6,7,27,31,35,39,123
		dc.b	43,46,49,52,55,58,61,65,66,73,77,81
		dc.b	85,89,93,124,128,99,102,105,108,111,114
		dc.b	117,120,132,136,137,140,143,144,145,146,147
		dc.b	154,155,156,157,158,159,160,161
		dc.b	162,163,164,165,166,167,0

BoxToBox7:	dc.b	97,98,0,1,2,3,4,5,6,7,27,31,35,39,123
		dc.b	43,46,49,52,55,58,61,65,66,73,77,81
		dc.b	85,89,93,124,128,99,102,105,108,111,114
		dc.b	117,120,132,136,137,140,143,144,145,146,147
		dc.b	154,155,156,157,158,159,160,161
		dc.b	162,163,164,165,166,167,0

PaletteZero:	blk.w	16,0

Palette0:	incbin	'Palette 0.BIN'
Palette1:	incbin	'Palette 1.BIN'
Palette2:	incbin	'Palette 2.BIN'
Palette3:	incbin	'Palette 3.BIN'
Palette4:	incbin	'Palette 4.BIN'
Palette5:	incbin	'Palette 5.BIN'
Palette6:	incbin	'Palette 6.BIN'
Palette7:	incbin	'Palette 7.BIN'

RemTabBTB:
	dc.l	BoxToBox0-RemTabBTB
	dc.l	BoxToBox1-RemTabBTB
	dc.l	BoxToBox2-RemTabBTB
	dc.l	BoxToBox3-RemTabBTB
	dc.l	BoxToBox4-RemTabBTB
	dc.l	BoxToBox5-RemTabBTB
	dc.l	BoxToBox6-RemTabBTB
	dc.l	BoxToBox7-RemTabBTB

RemTabPAL:
	dc.l	Palette0-RemTabPAL
	dc.l	Palette1-RemTabPAL
	dc.l	Palette2-RemTabPAL
	dc.l	Palette3-RemTabPAL
	dc.l	Palette4-RemTabPAL
	dc.l	Palette5-RemTabPAL
	dc.l	Palette6-RemTabPAL
	dc.l	Palette7-RemTabPAL

CavesRem:
	dc.b	0,0
	dc.b	0,0
	dc.b	0,0

MoveBox:
	dc.b	1,1,1,1,1,1,1,1,1,1
	dc.b	1,1,1,1,1,1,0,1,1,0
	dc.b	0,0,1,1,0,1,1,0,0,1
	dc.b	1,0,0,1,1,0,0,1,1,0
	dc.b	0,1,1,0,0,0,1,1,0,1
	dc.b	1,0,1,1,1,1,1,1,1,1
	dc.b	1,1,1,1,1,1,1,1,1,1
	dc.b	1,1,1,1,1,1,1,1,1,1
	dc.b	1,1,0,1,1,0,1,1,1,1
	dc.b	1,1,1,1,1,1,1,1,1,1
	dc.b	1,1,1,1,1,1,1,1,1,1
	dc.b	1,1,1,1,1,1,1,1,1,1
	dc.b	1,1,1,1,1,1,1,1

	dc.b	1,1
	dc.b	1,1,1,1,0,1,1,0,1,1
	dc.b	1,1,1,1,1,1,1,1,1,1
	dc.b	1,1,1,1,1,1,1,1,1,1
	dc.b	1,1,1,1,1,1,1,1

M:
	dc.l	RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M
	dc.l	RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M,Box_16-M,Box_17-M,Box_18-M,Box_19-M
	dc.l	Box_20-M,Box_21-M,Box_22-M,Box_23-M,Box_24-M,Box_25-M,Box_26-M,Box_27-M,Box_28-M,Box_29-M
	dc.l	Box_30-M,Box_31-M,Box_32-M,Box_33-M,Box_34-M,Box_35-M,Box_36-M,Box_37-M,Box_38-M,Box_39-M
	dc.l	Box_40-M,Box_41-M,Box_42-M,Box_43-M,Box_44-M,Box_45-M,Box_46-M,Box_47-M,Box_48-M,Box_49-M
	dc.l	Box_50-M,Box_51-M,RetBox-M,Box_53-M,Box_54-M,Box_55-M,Box_56-M,Box_57-M,Box_58-M,Box_59-M
	dc.l	Box_60-M,Box_61-M,Box_62-M,Box_63-M,Box_64-M,Box_65-M,Box_66-M,Box_67-M,Box_68-M,Box_69-M
	dc.l	Box_70-M,Box_71-M,Box_72-M,Box_73-M,Box_74-M,Box_75-M,Box_76-M,Box_77-M,RetBox-M,RetBox-M
	dc.l	RetBox-M,RetBox-M,Box_82-M,Box_83-M,Box_84-M,Box_85-M,Box_86-M,RetBox-M,RetBox-M,RetBox-M
	dc.l	RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M
	dc.l	RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M
	dc.l	RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M
	dc.l	RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M,RetBox-M

	dc.l	RetBox-M,RetBox-M
	dc.l	RetBox-M,RetBox-M,RetBox-M,RetBox-M,Box_134-M,Box_135-M,Box_136-M,Box_137-M,RetBox-M,RetBox-M

;*******************************************************************
;			POINTERS
;*******************************************************************

Screen0Ptr:	dc.l	0
Screen1Ptr:	dc.l	0
LinePtr:	dc.l	0
BobsPtr:	dc.l	0
CLPtr:		dc.l	0
SamplesPtr:	dc.l	0

;*******************************************************************
;			FAST WORK
;*******************************************************************

	;--- System. ---

GfxLibBase:	dc.l	0
MemStack:	dc.l	0
MemDma:		dc.w	0
MemInt:		dc.w	0
MemVectors:	blk.l	64
Stack:		blk.b	STACKSIZE
	EVEN

	;--- VBL. ---

ActScreen:	dc.l	0
WykonujVBL:	dc.b	0
	EVEN

	;--- Joystick. ---

JoyUp:		dc.b	0
JoyDown:	dc.b	0
JoyRight:	dc.b	0
JoyLeft:	dc.b	0
JoyFire:	dc.b	0
	EVEN
KeyUp:		dc.b	0
KeyDown:	dc.b	0
KeyRight:	dc.b	0
KeyLeft:	dc.b	0
KeyFire:	dc.b	0
	EVEN

	;--- Cave. ---

		blk.b	CaveX*2,0
Cave:		blk.b	CaveSize
		blk.b	CaveX*2,0
Cave0:		blk.b	CaveSize
Cave1:		blk.b	CaveSize

	;--- Box. ---

BoxOfs:		blk.l	IlBob
BoxLine:	blk.l	CaveY
BobsData:	incbin	'Robbo.BOX'

	;--- Game. ---

ActPalette:	dc.l	0
ActBTB:		dc.l	0
CavePtr:	dc.l	0
CaveScrlX:	dc.w	0
CaveScrlY:	dc.w	0
CmpScrlX:	dc.w	0
CmpScrlY:	dc.w	0
ScrollX:	dc.w	0
ScrollY:	dc.w	0
XCave:		dc.w	0
YCave:		dc.w	0
CopyScroll:	dc.b	0
ScrNum:		dc.b	0
CaveNum:	dc.b	0
LoopCnt:	dc.b	0
ScrlCnt:	dc.b	0
CaveSwap:	dc.b	0
CaveOpen:	dc.b	0
Last:		dc.b	0
KillRobbo:	dc.b	0
FineRobbo:	dc.b	0
NiespCnt:	dc.b	0
Kierunek:	dc.b	0
BylRuch:	dc.b	0
AnimCnt:	dc.b	0
NietopCnt:	dc.b	0
ByloVBL:	dc.b	0
OldCave:	dc.b	0
	EVEN

	;--- Player. ---

PlayX:		dc.w	0
PlayY:		dc.w	0
PlayOfs:	dc.l	0

	;--- Cyfry. ---

CyfryTab:	blk.l	12,0
BCD1Ptr:	dc.l	0
BCD2Ptr:	dc.l	0
BCD3Ptr:	dc.l	0
BCD4Ptr:	dc.l	0
BCD5Ptr:	dc.l	0
BCD6Ptr:	dc.l	0
BCD1:		dc.b	0,0
BCD2:		dc.b	0,0
BCD3:		dc.b	0,0
BCD4:		dc.b	0,0
BCD5:		dc.b	0,0
BCD6:		dc.b	0,0
Set1:		dc.b	0
Set2:		dc.b	0
Set3:		dc.b	0
Set4:		dc.b	0
Set5:		dc.b	0
Set6:		dc.b	0
	EVEN

	;--- Mirrors. ---

Mirrors:	blk.b	IlMirrors*16
	
;*******************************************************************
;			CHIP DATA
;*******************************************************************

CopperList:
		dc.w	$180,0,$182,0,$184,0,$186,0
		dc.w	$188,0,$18a,0,$18c,0,$18e,0
		dc.w	$190,0,$192,0,$194,0,$196,0
		dc.w	$198,0,$19a,0,$19c,0,$19e,0
		dc.w	SPR0CTL,0,SPR1CTL,0,SPR2CTL,0,SPR3CTL,0
		dc.w	SPR4CTL,0,SPR5CTL,0,SPR6CTL,0,SPR7CTL,0
		dc.w	BPLCON0,COLOR,BPLCON2,0
		dc.w	BPL1MOD,ScrMod,BPL2MOD,ScrMod
		dc.w	DDFSTRT,7*8,DDFSTOP,7*8+ScrDDF
		dc.w	DIWSTRT,$0099,DIWSTOP,$7fb9
		dc.w	$2803,COPWAIT
CoLiScr:	dc.w	$e0,0,$e2,0,$e4,0,$e6,0
		dc.w	$e8,0,$ea,0,$ec,0,$ee,0
CoLiScrl:	dc.w	BPLCON1,0
		dc.w	$3203,COPWAIT,BPLCON0,BPU2+COLOR
		dc.w	ENDHALF,COPWAIT
		dc.w	$0a03,COPWAIT,BPLCON0,COLOR
CoLiDL:		dc.w	$e0,0,$e2,0,$e4,0,$e6,0
		dc.w	$e8,0,$ea,0,$ec,0,$ee,0
CoLiDLCol:	dc.w	$180,0,$182,0,$184,0,$186,0
		dc.w	$188,0,$18a,0,$18c,0,$18e,0
		dc.w	$190,0,$192,0,$194,0,$196,0
		dc.w	$198,0,$19a,0,$19c,0,$19e,0
		dc.w	BPLCON1,$88
		dc.w	BPL1MOD,36*3,BPL2MOD,36*3
		dc.w	DDFSTRT,8*8,DDFSTOP,8*8+136

		dc.w	$190,$000,$194,$011
		dc.w	$0c03,COPWAIT,BPLCON0,BPU2+COLOR
		dc.w	$0d03,COPWAIT,$194,$122
		dc.w	$0e03,COPWAIT,$194,$233
		dc.w	$0f03,COPWAIT,$194,$344

		dc.w	$1003,COPWAIT,$182,$8
		dc.w	$1103,COPWAIT,$182,$7,$192,$60
		dc.w	$1203,COPWAIT,$182,$6,$192,$70
		dc.w	$1303,COPWAIT,$182,$5,$192,$80
		dc.w	$1403,COPWAIT,$182,$4,$192,$90
		dc.w	$1503,COPWAIT,$182,$3,$192,$b0
		dc.w	$1603,COPWAIT,$182,$2,$192,$c0
		dc.w	$1703,COPWAIT,$182,$1,$192,$d0
		dc.w	$1803,COPWAIT,$182,$0,$192,$e0
		dc.w	$1903,COPWAIT,$192,$f0
		dc.w	$1a03,COPWAIT,$192,$e0
		dc.w	$1b03,COPWAIT,$192,$d0
		dc.w	$1c03,COPWAIT,$192,$c0
		dc.w	$1d03,COPWAIT,$192,$b0
		dc.w	$1e03,COPWAIT,$192,$a0
		dc.w	$1f03,COPWAIT,$192,$90
		dc.w	$2003,COPWAIT,$192,$80
		dc.w	$2103,COPWAIT,$182,$1,$192,$70
		dc.w	$2203,COPWAIT,$182,$2
		dc.w	$2303,COPWAIT,$182,$3
		dc.w	$2403,COPWAIT,$182,$4
		dc.w	$2503,COPWAIT,$182,$5
		dc.w	$2603,COPWAIT,$182,$6
		dc.w	$2703,COPWAIT,$182,$7
		dc.w	$2803,COPWAIT,$182,$8
		dc.w	$2c03,COPWAIT,$194,$233
		dc.w	$2d03,COPWAIT,$194,$122
		dc.w	$2e03,COPWAIT,$194,$011
		dc.w	$2f03,COPWAIT,BPLCON0,COLOR
		dc.w	ENDCOPLST,COPWAIT

Line:		incbin	'RobboLine.BIN'

;*******************************************************************
;			CHIP WORK
;*******************************************************************

Bobs:		blk.b	BoxSize*IlBob
Screen0:	blk.b	ScrSize
Screen1:	blk.b	ScrSize

Samples:

Stop:

FAST		=	CopperList-Start
CHIP		=	Stop-CopperList
MEM		=	Stop-Start
