;
;          MEGABALL       by Ed Mackey
;           v4.0            PO Box 475
;                            Wayne, PA 19087

;  Here is the source code, assembled with Assempro by Abacus.

REGISTERED = 1

CDROM      = 1
CD32       = 0

VERSION = 4     ;Version byte in save file header.

TheExplodingKind = 72   ;Was 36

       Include 'includes:IncludeMe'
       Include 'includes:intuition.offsets'
       Include 'includes:graphics.offsets'
       Include 'includes:diskfont.offsets'
       Include 'includes:icon.offsets'
       Include 'includes:dos.offsets'
       Include 'includes:iff.offsets'
       Include 'includes:exec/types.i'
       Include 'includes:exec/lists.i'
       Include 'includes:devices/audio.i'
       Include 'includes:MemVars'
       Include 'includes:libraries/reqbase.i'

; Some v39 gfx calls:

_LVOLoadRGB32          = -$372
_LVOAllocBitMap        = -$396
_LVOFreeBitMap         = -$39C
_LVOAllocSpriteDataA   = -$3FC
_LVOGetExtSpriteA      = -$3A2
_LVOFreeSpriteData     = -$408

; datatypes.library calls:

_LVONewDTObjectA       = -$30
_LVODisposeDTObject    = -$36
_LVOGetDTAttrsA        = -$42
_LVODoDTMethodA        = -$5A

; asl.library calls:

_LVOAllocAslRequest    = -$30
_LVOFreeAslRequest     = -$36
_LVOAslRequest         = -$3C

; intuition.library calls:

_LVOLockPubScreen      = -$1FE
_LVOUnLockPubScreen    = -$204

; lowlevel.library calls:

_LVOReadJoyPort        = -$1E    ;port # (usually 1) in d0.l

       ILABEL 'Includes:Amiga.L'

MegaBallAGA:
       bra.s   NoDebug
YesDebug:
       move    #1,Debug
NoDebug:
; a0 = args, d0 = arg len.
       move.l  a0,SaveArgs
       move.l  d0,ArgLen

       INIT_AMIGA

       move.l  #'STCK',-(sp)
       move.l  #'MBAL',-(sp)
       bsr     run
       addq.l  #8,sp
       move.l  ExecBase,a6

       EXIT_AMIGA

MOUSESPEED = 480       ;Smaller is faster

Whole_Thing = 50 * 20 * 21    ;21k

NewTim:
       move.l  gfxbase,a6
       jsr     _LVOWaitTOF(a6)
       move.l  ExecBase,a6
       rts
NewTimM:
       move.l  d2,-(sp)
       move.l  d0,d2
NTM:   bsr     NewTim
       dbra    d2,NTM
       move.l  (sp)+,d2
       rts

;; Old time code used to look like this:
;       lea     devio,a1
;       move.l  ExecBase,a6
;       jsr     _LVOWaitIO(a6)
;       lea     devio,a1
;       move.w  #$9,Tm_Cmd
;       clr.l   secs
;       move.l  #16667,msecs
;       move.l  #readreply,port
;       move.w  #40,Tm_Length
;       clr.w   io
;       move.l  ExecBase,a6
;       jsr     _LVOSendIO(a6)

run:
  IFEQ CDROM,1
       bsr     freeanim1    ;all regs preserved
  ENDIF
       tst.l   PR_CLI(a4)   ;a4 was inited to our task ptr by INIT_AMIGA
       beq     YesWB
       cmp.l   #1,ArgLen
       bhi     Arg
       move.l  PR_CLI(a4),a0
       add.l   a0,a0
       add.l   a0,a0
       move.l  16(a0),d0
       lsl.l   #2,d0
       move.l  d0,SaveArgs
Arg:   moveq   #0,d0
YesWB: move.l  d0,WBMsg     ;d0 has WBMsg (unless from CLI), again I_A
       clr     Mus_play
       clr     Mus_Pause
       clr     NoVoice0
       clr     SJump
       clr     DoSJump
       clr     JoyFire
       clr.l   MyTOC
       move    #1,FadeMus
       move    #$f,VolMult
       move.l  ExecBase,a6
;       move.l  #Whole_Thing,d0
;       moveq.l #0,d1
;       jsr     _LVOAllocMem(a6)  ;Some old code I got rid of
;       tst.l   d0
;       beq     MemKicked
       move.l  #MyMem,d0   ;Now in BSS segment!
       move.l  d0,MemPtr
       sub.l   a1,a1
       jsr     _LVOFindTask(a6)
       move.l  d0,readreply+$10 ;pr_WindowPtr computed from this later.
       move.l  d0,CDreply+$10
       move.b  #4,readreply+$8
       move.b  #4,CDreply+$8
       lea     MyTask,a2
       move.l  #7,d2
PMT:   move.l  d0,(a2)
       move.b  #4,-8(a2)
       add.l   #64,a2
       dbra    d2,PMT
       move.l  d0,a1
; move.l SaveArgs,$58(a1)  ;Task -> UserData, to be viewed from ARTM.
       moveq   #4,d0
       jsr     _LVOSetTaskPri(a6) ;Runs smoother at pri +4
       move    d0,OldPri
       lea     readreply+20,a1
       NEWLIST a1
       lea     CDreply+20,a1
       NEWLIST a1
       moveq   #-1,d0
       jsr     _LVOAllocSignal(a6)
       cmp.b   #-1,d0
       beq     CDsigKicked
       move.b  d0,CDreply+$f
;       lea     readreply,a1
;       jsr     _LVOAddPort(a6)
       lea     devio,a1
       moveq.l #1,d0    ;timer.
       moveq.l #0,d1
       move.l  #readreply,port
       move.w  #32,Tm_Length
       clr.w   io
;       lea     timename,a0
;       jsr     _LVOOpenDevice(a6) ;get timer.device
;       tst.l   d0
;       bne     TimeKicked
       move.l  #$00200000,numcolors    ;number = 32, initial = 0
       bsr     openint      ;open intuition.library
       beq     IntKicked    ;uh-oh.  Where's intuition?!?!
       bsr     opendos
       beq     DosKicked    ;dos.library
       bsr     openlow
       move.w  ExpBrickPeriod,ExpBrickPeriodSave
       move.l  #-1,OldDir
       tst     Debug
       beq     NoDB
       move.l  #DebugProgName,SaveArgs
       move.l  #DebugCurDirName,d1
       moveq   #-2,d2    ;ACCESS_READ
       move.l  dosbase,a6
       jsr     _LVOLock(a6)
       move.l  d0,d1
       bne     DB1
       clr     Debug
NoDB:  move.l  WBMsg,a0
       cmp.l   #0,a0
       beq     NoWB
       clr.l   SaveArgs
       move.l  36(a0),a0    ;sm_ArgList
       cmp.l   #0,a0
       beq     NoWB
       move.l  (a0),d1
       move.l  4(a0),SaveArgs
       move.l  dosbase,a6
DB1:   jsr     _LVOCurrentDir(a6)
       move.l  d0,OldDir
NoWB:  bsr     opengfx      ;graphics.library
       beq     GfxKicked
       move.l  intbase,a6
       lea     rSecs,a0      ;init random numbers
       lea     rMicros,a1    ;BEFORE icon.library's RandomizeTuneList!!
       jsr     _LVOCurrentTime(a6)
       bsr     openicon      ;icon.library and MegaBall.info (optional!)
       move.l  MemPtr,a2
       bsr     CopyBoards    ;Decrunch and check for corrupt boards.
       tst     d0
       beq     BoardsKickedM
       move.l  ExecBase,a6
       lea     MsgSig,a2    ;4 signals needed for 4 voices.
       move.l  #3,d2
ASP:   move.l  #-1,d0     ;Another Signal Please!
       jsr     _LVOAllocSignal(a6)
       move.b  d0,(a2)
       add.l   #64,a2
       cmp.b   #-1,d0
       beq     SigKicked
       dbra    d2,ASP
       lea     Message,a1
       move.l  #1,d0
       moveq.l #0,d1
       move.l  #combops,AData
       move.l  #1,Aud_Length
       clr.w   AllocKey
       clr.l   Unit
       move.w  #ADCMD_ALLOCATE,Aud_Cmd
       lea     audname,a0
  IFEQ CDROM,1
       bsr     freeanim2    ;all regs preserved
  ENDIF
       jsr     _LVOOpenDevice(a6) ;open audio.device
       tst.l   d0
       bne     AudioKickedM
       clr     Self_Sound
       move    #-1,d0       ;init audio.device
       bsr     playme       ;with opening sound effect
  IFEQ CDROM,1
       move.l  ExecBase,a6
       lea     LoaderName,a1
       jsr     _LVOFindPort(a6)
       tst.l   d0
       beq     NoLoader2
       eor.w   #$80,SType
  ENDIF
NoLoader2:
       bsr     LoadScores
       bsr     _InitPlayer     ;Setup OctaMED player.
       tst     d0
       bne     OMedKickedM
       clr.l   Font
       lea     TopazTextAttr,a0
       move.l  gfxbase,a6
       jsr     _LVOOpenFont(a6)
       move.l  d0,TopazFont     ;fonts are optional
       clr     LdStat1
       bsr     opendiskfont
       beq     DiskFontKicked
       move    #1,LdStat1
       move.l  fontbase,a6      ;look for font
       lea     TextAttr,a0
       jsr     _LVOOpenDiskFont(a6)
       move.l  d0,Font
       tst.l   d0
       beq     dfk1
       move.l  #TextAttr,ScreenTextAttr
dfk1:  bsr     closediskfont
DiskFontKicked:
       clr.l   DataTypesBase
       clr.l   iffbase
       bsr     opendatatypes  ;get datatypes.library if v39.
       beq     DTkickedM
       bsr     openiff        ;get iff.library if NOT v39.
       beq     Screen3Kicked
       tst     UseOS20
       beq     NoSAdj
       lea     screendef,a0
       move.l  gfxbase,a1
       moveq.l #0,d0
       move    218(a1),d0    ;NormalDisplayColumns
       cmp     #640,d0
       blt     PlC1b
       lsr     #1,d0
PlC1b: sub     #320,d0
       blt     NoSAdj
       lsr     #1,d0
       move    d0,(a0)
NoSAdj:lea     GfxNameNonAGAList,a2  ;Non-AGA gfx list.
       tst     v39
       beq     TryToLoadGfx    ;Was OldGfx
       lea     GfxNameList,a2
TryToLoadGfx:                  ;MegaBall Graphics Loader
       move.l  (a2)+,d1
       tst.l   d1
       beq     GfxKickedM      ;Out of MegaBall.Gfx.#? files
       move.l  #MODE_OLD,d2
       move.l  dosbase,a6
       jsr     _LVOOpen(a6)
       move.l  d0,d7
       beq     TryToLoadGfx
       move.l  d0,d1
       move.l  #FakeRast,d2

HDRSIZ = 84

       moveq.l #HDRSIZ,d3
       jsr     _LVORead(a6)    ;Peek at this file
       cmp.l   #HDRSIZ,d0
       beq     ttlg1
ttlgX: move.l  d7,d1
       move.l  dosbase,a6
       jsr     _LVOClose(a6)
       bra     TryToLoadGfx
ttlg1: lea     FakeRast,a0
       cmp.l   #'MBG4',(a0)+      ;First longword = 'MBG4'
       bne     ttlgX
       move.w  (a0)+,d0           ;Next word = End of TheExplodingKind.
       sub     #36,d0
       add     d0,d0
       add     #TheExplodingKind+1,d0
       move    d0,EndExploder
       move.w  (a0)+,Depth        ;Next word = Depth.
       move.w  (a0)+,FitchSubCol  ;Next word = color to inverse-blink
       move.w  (a0)+,FitchCol     ;Next word = color to blink
       moveq   #17,d0
       lea     Converter,a1       ; Next 72 bytes are Converter bytes.
h2c:   move.l  (a0)+,(a1)+
       dbra    d0,h2c
       bsr     openscreen         ;Can we handle this Depth?
       beq     ttlgX
       move.l  d0,screenhd        ;OK!  We got one, let's GO!
       bsr     allocbitmap
       beq     bitmap3kickedM
       move.l  d0,bit3map
       bsr     allocbitmap        ;Allocate bitmaps for it
       beq     bitmap2kickedM
       move.l  d0,bit2map
       lea     FakeRast,a1
       move.l  a1,Rast3
       move.l  gfxbase,a6
       jsr     _LVOInitRastPort(a6)
       move.l  Rast3,a1
       move.l  bit3map,4(a1)

       move.l  d7,d1
       moveq   #0,d2
       moveq   #1,d3           ;OFFSET_END
       move.l  dosbase,a6
       jsr     _LVOSeek(a6)    ;seek to eof...
       cmp.l   #-1,d0
       beq     ReadKickedM     ;File read kicked, close d7!
       move.l  d7,d1
       moveq   #HDRSIZ,d2
       moveq   #-1,d3          ;OFFSET_BEGINNING
       jsr     _LVOSeek(a6)    ;seek back.  *poof* get length of file!
       sub.l   #HDRSIZ,d0
       move.l  d0,d6
       cmp.l   #40,d6
       ble     ReadKickedM
       move.l  ExecBase,a6
       moveq   #0,d1
       jsr     _LVOAllocMem(a6)   ;Get mem for file
       move.l  d0,d5
       beq     ReadKickedM
       move.l  dosbase,a6
       move.l  d7,d1           ;d7 has filehandle
       move.l  d5,d2           ;d5 has memory
       move.l  d6,d3           ;d6 has length
       jsr     _LVORead(a6)
       cmp.l   d0,d6
       bne     ReadKickedMM    ;File read kicked, free d5/d6 and close d7!
       bsr     CloseD7

       tst     v39
       beq     OldGfx
       move.l  #MBgfxTempName,d1
       move.l  #MODE_NEW,d2
       jsr     _LVOOpen(a6)
       move.l  d0,d7
       beq     RamKickedM      ;FreeD5D6.
       move.l  d0,d1
       move.l  d5,a0
       move.l  d5,d2           ;First IFF
       move.l  4(a0),d3
       addq.l  #8,d3           ;Length of First IFF.
       jsr     _LVOWrite(a6)
       move.l  d0,d4
       move.l  d7,d1
       jsr     _LVOClose(a6)
       cmp.l   d3,d4
       bne     RamKickedM
       move.l  bit2map,a5
       bsr     GetDTgfx
       bsr     DisposeD7

       move.l  dosbase,a6
       move.l  #MBgfxTempName,d1
       move.l  #MODE_NEW,d2
       jsr     _LVOOpen(a6)
       move.l  d0,d7
       beq     RamKickedM      ;FreeD5D6.
       move.l  d0,d1
       move.l  d5,a0
       move.l  4(a0),d3        ;Length of First IFF...
       addq.l  #8,d3
       add.l   d3,a0           ;Skip past First IFF.
       move.l  a0,d2           ;Find Second IFF.
       move.l  4(a0),d3
       addq.l  #8,d3           ;Length of Second IFF.
       jsr     _LVOWrite(a6)
       move.l  d0,d4
       move.l  d7,d1
       jsr     _LVOClose(a6)
       cmp.l   d3,d4
       bne     RamKickedM
       move.l  bit3map,a5
       bsr     GetDTgfx
       bra     DTgfxOK

;  inputs: a5 = bitmap
; returns: d7 = DTobj
GetDTgfx:
       moveq   #0,d7
       move.l  DataTypesBase,a6
       move.l  #MBgfxTempName,d0
       lea     DTtags,a0
       jsr     _LVONewDTObjectA(a6)
       move.l  d0,d7
       beq     DTObjKickedM    ;Object kicked, pop.l, dispose d7!
       move.l  d7,a0
       suba.l  a1,a1
       suba.l  a2,a2
       lea     gpl,a3          ;Layout the object on our process.
       jsr     _LVODoDTMethodA(a6)
       tst.l   d0
       beq     DTObjKickedM    ;no mem?
;       move.l  d7,a0
;       suba.l  a1,a1
;       suba.l  a2,a2
;       lea     dtf,a3          ;Request a FrameInfo.
;       jsr     _LVODoDTMethodA(a6)
;       tst.l   d0
;       beq     DTObjKickedM
       move.l  d7,a0
       lea     DTGAtags,a2
       jsr     _LVOGetDTAttrsA(a6)
       cmp.l   #3,d0           ;number of attributes gotten.
       bne     DTObjKickedM
       tst.l   newbm
       beq     DTBitmapKickedM
       tst.l   CRegs
       beq     DTColsKickedM
       movem.l d5-d7,-(sp)
       move.l  gfxbase,a6
       move.l  newbm,a0
       moveq   #0,d0
       moveq   #0,d1
       move.l  a5,a1   ;Dest bitmap was passed in as a5.
       moveq   #0,d2
       moveq   #0,d3
       move.l  #320,d4
       move.l  #200,d5
       move    #$c0,d6
       move    #$ff,d7
       suba.l  a2,a2
       jsr     _LVOBltBitMap(a6)  ;Copy the gfx page
       movem.l (sp)+,d5-d7
       rts

DTgfxOK:
       bsr     FreeD5D6
       moveq   #0,d1
       move    Depth,d1
       moveq   #1,d0
       lsl.l   d1,d0
       clr.l   numcolors       ;clear # colors and initial color.
       move.w  d0,numcolors    ;write # colors.
       subq.l  #1,d0
       lea     ctable32,a0
       move.l  CRegs,a1
       lea     ctable,a2
       move.l  #28,d3
ColorMake:
       move.l  (a1)+,d2        ;R
       move.l  d2,(a0)+
       lsr.l   d3,d2
       move.l  d2,d1           ;d1 builds 4-bit color
       move.l  (a1)+,d2        ;G
       move.l  d2,(a0)+
       lsr.l   d3,d2
       lsl     #4,d1
       or      d2,d1
       move.l  (a1)+,d2        ;B
       move.l  d2,(a0)+
       lsr.l   d3,d2
       lsl     #4,d1
       or      d2,d1
       move    d1,(a2)+
       dbra    d0,ColorMake
       clr.l   (a0)+           ;Put end-of-colors mark.

       bsr     DisposeD7
       bsr     DeleteTemp
       bra     GfxOK

OldGfx:
       move.l  d5,a1
       move.l  bit2map,a0
       bsr     pic2plane      ;Sets ErrPtr if there's a problem.
       beq     PicKickedM
       move.l  d5,a1
       addq.l  #4,a1          ;FORM
       move.l  (a1)+,d0       ;length
       add.l   d0,a1
       move.l  bit3map,a0
       bsr     pic2plane
       beq     PicKickedM
       bsr     FreeD5D6

GfxOK: bsr     closeiff
       bsr     closedatatypes
       move.l  screenhd,a0
       add.l   #84,a0          ;Get RastPort
       move.l  4(a0),bit1map   ;Get bitmap from RastPort
       bsr     windopen        ;make my window.
       beq     WindKicked
       clr.w   PaddleX
       move.l  windowhd,a0
       move.l  50(a0),a0
       move.l  a0,Rast
       move.l  screenhd,a0
       moveq.l #0,d0
       jsr     _LVOShowTitle(a6)  ;hide title bar
       move.l  readreply+$10,a0
       move.l  184(a0),OldWindowPtr
       move.l  windowhd,184(a0)   ;install new DOS requestors!

       lea     BonusDescribe,a0   ;Fix Bonustext Colors.
       lea     Converter,a1
       moveq   #0,d0
fixBC: move.b  (a0),d0            ;Read in "brick" number.
       move.b  (a1,d0),(a0)       ;Run through converter.
       move.l  16(a0),a0          ;IntuiText -> NextText
       cmp.l   #0,a0
       bne     fixBC

 IFEQ REGISTERED,1
       clr.l   aslbase
       clr.l   AslFR
       clr.l   reqbase
       lea     AslAllocTags,a0
       move.l  windowhd,4(a0)
       bsr     openasl
       tst.l   AslFR
       bne     GotAsl
       bsr     openreq
 ENDIF
GotAsl:move.l  Rast,a1
       move.l  #1,d0
       move.l  gfxbase,a6
       jsr     _LVOSetAPen(a6)
       tst.l   Font
       beq     OopsNoFont
       move.l  Font,a0           ;install font, if it was there
       move.l  Rast,a1
       jsr     _LVOSetFont(a6)
       move.l  Font,a0           ;and on other screen
       move.l  Rast3,a1
       jsr     _LVOSetFont(a6)
       move    #2,LdStat1
OopsNoFont:
       lea     MyCD,a1
       moveq   #11,d0
wipe1: clr.l   (a1)+
       dbra    d0,wipe1
  IFEQ CDROM,1
       move.l  ExecBase,a6
       lea     cdname,a0
       lea     MyCD,a1
       move.l  #CDreply,$e(a1)
       move.w  #48,$12(a1)  ;length
       moveq   #0,d0
       moveq   #0,d1
       jsr     _LVOOpenDevice(a6)  ;Open cd.device
  ENDIF
       move.l  intbase,a6
       move.l  windowhd,a0
       lea     blkptr,a1
       moveq.l #1,d0
       moveq.l #16,d1
       moveq.l #0,d2
       moveq.l #0,d3
       jsr     _LVOSetPointer(a6)  ;Get rid of that mouse pointer!
       move.l  windowhd,a0
       jsr     _LVOViewPortAddress(a6)  ;Why did I do this?
       move.l  d0,ViewPort
       bsr     ColorOff        ;Start black, then call FadeIn later.
       tst     v39
       beq     nv391

       lea     BallBitmap,a2
       lea     AllocSPTags,a1
       jsr     _LVOAllocSpriteDataA(a6)
       move.l  d0,BallSP
       tst.l   d0
       beq     AllocSPdataKickedM
       lea     Las1Bitmap,a2
       lea     AllocSPTags,a1
       jsr     _LVOAllocSpriteDataA(a6)
       move.l  d0,Las1SP
       tst.l   d0
       beq     AllocSPdataKickedM
       lea     Las2Bitmap,a2
       lea     AllocSPTags,a1
       jsr     _LVOAllocSpriteDataA(a6)
       move.l  d0,Las2SP
       tst.l   d0
       beq     AllocSPdataKickedM

       move.l  BallSP,a2
       lea     BallSTags,a1
       jsr     _LVOGetExtSpriteA(a6)
       cmp.w   #-1,d0
       bne     spOK39
       move.l  BallSP,a2
       suba.l  a1,a1
       jsr     _LVOGetExtSpriteA(a6)
       cmp.w   #-1,d0
       beq     SpriteKickedM
spOK39:move.l  Las1SP,a2
       suba.l  a1,a1
       jsr     _LVOGetExtSpriteA(a6)
       cmp.w   #-1,d0
       beq     Las1KickedM
       move.l  Las2SP,a2
       suba.l  a1,a1
       jsr     _LVOGetExtSpriteA(a6)
       cmp.w   #-1,d0
       beq     Las2KickedM
       bra     spDone

nv391: move.l  #4,d0
       lea     ballsprite,a0
       jsr     _LVOGetSprite(a6)  ;Let's get some sprites!
       cmp.w   #-1,d0
       bne     spOK
       move.l  #-1,d0
       lea     ballsprite,a0
       jsr     _LVOGetSprite(a6)
       cmp.w   #-1,d0
       beq     SpriteKickedM
spOK:  move.l  #-1,d0
       lea     Las1Sprite,a0
       jsr     _LVOGetSprite(a6)
       cmp.w   #-1,d0
       beq     Las1KickedM
       move.l  #-1,d0
       lea     Las2Sprite,a0
       jsr     _LVOGetSprite(a6)
       cmp.w   #-1,d0
       beq     Las2KickedM
spDone:move.l  ExecBase,a6
       moveq.l #5,d0
       lea     VBInterrupt,a1
       jsr     _LVOAddIntServer(a6)
;       lea     devio,a1    ;first timer message.
;       move.w  #$9,Tm_Cmd
;       clr.l   secs
;       move.l  #16000,msecs
;       move.l  #readreply,port
;       move.w  #40,Tm_Length
;       clr.w   io
;       move.l  ExecBase,a6
;       jsr     _LVOSendIO(a6)
       bsr     clrscr
       clr     WhichMus

       move.l  bit3map,a0
       move.l  bit1map,a1
       move.l  #183,d0
       move.l  #149,d1
       moveq   #0,d2
       moveq   #0,d3
       move.l  #120,d4
       move.l  #43,d5
       move.l  #$c0,d6
       move.l  #$ff,d7
       move.l  gfxbase,a6
       jsr     _LVOBltBitMap(a6)  ;get IAM logo on there

       move.l  Rast,a1
       moveq   #1,d0
       jsr     _LVOSetAPen(a6)
       move.l  Rast,a1
       move.l  #120,d0
       move.l  #10,d1
       jsr     _LVOMove(a6)
       move.l  #end_IAM1 - IAM1,d0
       lea     IAM1,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
       move.l  Rast,a1
       move.l  #120,d0
       move.l  #20,d1
       jsr     _LVOMove(a6)
       move.l  #end_IAM2 - IAM2,d0
       lea     IAM2,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
       move.l  Rast,a1
       move.l  #120,d0
       move.l  #30,d1
       jsr     _LVOMove(a6)
       move.l  #end_IAM3 - IAM3,d0
       lea     IAM3,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
       move.l  Rast,a1
       move.l  #120,d0
       move.l  #40,d1
       jsr     _LVOMove(a6)
       move.l  #end_IAM4 - IAM4,d0
       lea     IAM4,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
       move.l  Rast,a1
       moveq   #0,d0
       move.b  Converter+3,d0     ;Magenta
       jsr     _LVOSetAPen(a6)
       move.l  Rast,a1
       moveq   #0,d0
       move.l  #55,d1
       jsr     _LVOMove(a6)
       move.l  #end_IAM5 - IAM5,d0
       lea     IAM5,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
       move.l  Rast,a1
       moveq   #0,d0
       move.l  #65,d1
       jsr     _LVOMove(a6)
       move.l  #end_IAM6 - IAM6,d0
       lea     IAM6,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
       move.l  Rast,a1
       moveq   #0,d0
       move.l  #75,d1
       jsr     _LVOMove(a6)
       move.l  #end_IAM7 - IAM7,d0
       lea     IAM7,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)

       move.l  Rast,a1
       moveq   #0,d0
       move.b  Converter+1,d0     ;Blue
       jsr     _LVOSetAPen(a6)
       move.l  Rast,a1
       moveq.l #0,d0
       move.l  #95,d1
       jsr     _LVOMove(a6)
       move.l  #end_MBbanner1 - MBbanner1,d0
       lea     MBbanner1,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
       move.l  Rast,a1
       moveq.l #0,d0
       move.l  #105,d1
       jsr     _LVOMove(a6)
       move.l  #end_MBbanner2 - MBbanner2,d0
       lea     MBbanner2,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
       move.l  Rast,a1
       moveq.l #0,d0
       move.l  #115,d1
       jsr     _LVOMove(a6)
       move.l  #end_MBbanner3 - MBbanner3,d0
       lea     MBbanner3,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)

       move.l  Rast,a1
       moveq.l #0,d0
       move.l  #130,d1
       move.l  gfxbase,a6
       jsr     _LVOMove(a6)
       tst     LdStat1
       bne     LdOp1
       move.l  Rast,a1
       moveq   #0,d0
       move.b  Converter+20,d0     ;Red
       jsr     _LVOSetAPen(a6)
       move.l  #end_NoDF - NoDF,d0
       lea     NoDF,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
       bra     LdOp3
LdOp1: cmp     #1,LdStat1
       bne     LdOp2
       move.l  Rast,a1
       moveq   #0,d0
       move.b  Converter+20,d0    ;Red
       jsr     _LVOSetAPen(a6)
       move.l  #end_NoMF - NoMF,d0
       lea     NoMF,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
       bra     LdOp3
LdOp2: move.l  Rast,a1
       moveq.l #1,d0
       jsr     _LVOSetAPen(a6)
       move.l  #end_FdMF - FdMF,d0
       lea     FdMF,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
LdOp3: move.l  Rast,a1
       moveq.l #0,d0
       move.l  #140,d1
       move.l  gfxbase,a6
       jsr     _LVOMove(a6)
       move.l  Rast,a1
       moveq.l #1,d0
       jsr     _LVOSetAPen(a6)
       move.l  #end_LdMus - LdMus,d0
       lea     LdMus,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
       bsr     FadeIn
       clr     GameRecover
       clr     GameRecover2
       clr     GPlayRec
       jsr     LoadMusic   ;Pre-load the music for speed!
       move.l  Rast,a1
       moveq.l #0,d0
       move.l  #150,d1
       move.l  gfxbase,a6
       jsr     _LVOMove(a6)
       move    LdStat1,d0
       move.b  d0,PutLdHere
       cmp     #'x',d0
       beq     NoMemM
       cmp     #'5',d0   ;Max # of songs.
       beq     AlLded
       cmp     #'0',d0
       bne     SmLded
       move.l  Rast,a1
       moveq   #0,d0
       move.b  Converter+20,d0   ;Red
       jsr     _LVOSetAPen(a6)
       move.l  #end_NoMus - NoMus,d0
       lea     NoMus,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
       bra     MCont
NoMemM:move.l  Rast,a1
       moveq   #0,d0
       move.b  Converter+20,d0   ;Red
       jsr     _LVOSetAPen(a6)
       move.l  #end_NoMusMem - NoMusMem,d0
       lea     NoMusMem,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
       bra     MCont
SmLded:move.l  Rast,a1
       moveq.l #1,d0
       jsr     _LVOSetAPen(a6)
       move.l  #end_SmMus - SmMus,d0
       lea     SmMus,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
       bra     MCont
AlLded:move.l  Rast,a1
       moveq.l #1,d0
       jsr     _LVOSetAPen(a6)
       move.l  #end_AlMus - AlMus,d0
       lea     AlMus,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
MCont: move.l  Rast,a1
       moveq.l #0,d0
       move.l  #170,d1
       move.l  gfxbase,a6
       jsr     _LVOMove(a6)
;       move.l  mts_bage,mt_pdata
       move    #1,FadeMus
;       bsr     mt_init
       move    #1,Self_Sound
       moveq   #13,d0    ;Wait for quiet...
       bsr     playme
  IFEQ CDROM,1
       move.l  ExecBase,a6
       lea     LoaderName,a1
       jsr     _LVOFindPort(a6)
       tst.l   d0
       beq     NoLoader
       move.l  d0,a2
       move.l  16(a2),a1  ;mp_SigTask
       moveq   #1,d0
       moveq   #0,d1
       move.b  15(a2),d1  ;mp_SigBit
       lsl.l   d1,d0
       movem.l d0/a1/a6,-(sp)
       bsr     ColorOff
       bsr     clrscr
       move.l  IntBase,a6
       move.l  screenhd,a0
       jsr     _LVOScreenToFront(a6)
       movem.l (sp)+,d0/a1/a6
       jsr     _LVOSignal(a6)
       bra     TitScr
  ENDIF
NoLoader:
       bsr     PlayLifeTune
       move.l  gfxbase,a6
       move.l  Rast,a1
       moveq   #0,d0
       move.b  Converter+5,d0    ;Yellow
       jsr     _LVOSetAPen(a6)
       move.l  #end_PTC - PTC,d0
       lea     PTC,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
       bsr     DumpMsgs
       moveq.l #0,d7
       bsr     tloop           ;Wait for mouse button
       bsr     FadeOut
       jsr     mt_end
TitScr:clr     d7
NewGame:                       ;Main title screen
       move    d7,-(sp)
       bsr     clrscr
       move.l  Rast,a1
       moveq.l #0,d0
       move.l  #29,d1
       move.l  gfxbase,a6
       jsr     _LVOMove(a6)
       move.l  Rast,a1
       moveq   #0,d0
       move.b  Converter+24,d0  ;Blinkenlichten
       jsr     _LVOSetAPen(a6)
       move.l  #end_title2 - title2,d0
       lea     title2,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
       move.l  #8,d2
       move.l  #2,d3
       move.l  bit3map,a0
       move.l  bit1map,a1
       move.l  #6,d0
       move.l  #104,d1
       move.l  #146,d4
       move.l  #60,d5
       move.l  #$c0,d6
       move.l  #$ff,d7
       move.l  gfxbase,a6
       jsr     _LVOBltBitMap(a6)  ;get that logo on there
       move.l  Rast,a1
       move.l  #40,d0
       move.l  #67,d1           ;put up a bunch of titles
       jsr     _LVOMove(a6)
       move.l  Rast,a1
       moveq   #0,d0
       move.b  Converter+5,d0   ;Yellow
       jsr     _LVOSetAPen(a6)
       move.l  #end_instr - instr,d0
       lea     instr,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
       move.l  Rast,a1
       move.l  #40,d0
       move.l  #77,d1
       jsr     _LVOMove(a6)
       move.l  #end_instr2 - instr2,d0
       lea     instr2,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)

  IFEQ CD32,1

       move.l  Rast,a1
       move.l  #96,d0
       move.l  #67,d1           ;the colors, the colors....
       jsr     _LVOMove(a6)
       move.l  Rast,a1
       moveq   #0,d0
       move.b  Converter+18,d0  ;Bright Red
       jsr     _LVOSetAPen(a6)
       moveq   #6,d0
       lea     instr+7,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
       move.l  Rast,a1
       move.l  #48,d0
       move.l  #77,d1
       jsr     _LVOMove(a6)
       move.l  Rast,a1
       moveq   #0,d0
       move.b  Converter+1,d0   ;Blue
       jsr     _LVOSetAPen(a6)
       moveq   #4,d0
       lea     instr2+1,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)

  ENDIF

       move.l  Rast,a1
       move.l  #144,d0
       move.l  #42,d1
       jsr     _LVOMove(a6)
       move.l  Rast,a1
       moveq   #0,d0
       move.b  Converter+8,d0    ;Grey
       jsr     _LVOSetAPen(a6)
       move.l  #end_ALTL - ALTL,d0
       lea     ALTL,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
       move.l  Rast,a1
       move.l  #80,d0
       move.l  #56,d1
       jsr     _LVOMove(a6)
       move.l  Rast,a1
       moveq   #0,d0
       move.b  Converter+24,d0   ;Blinkenlichten
       jsr     _LVOSetAPen(a6)
       move.l  #end_Al - Al,d0
       lea     Al,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
       move.l  Rast,a1
       moveq.l #1,d0
       jsr     _LVOSetAPen(a6)
       clr     dx
       move.w  #94,dy
       move.l  #BonusCoords+4,a5
NextBonus:
       moveq.l #0,d0
       moveq.l #0,d1
       moveq.l #0,d2
       moveq.l #0,d3
       move.w  dx,d2
       move.w  dy,d3
       move.l  bit3map,a0
       move.l  bit1map,a1
       move.w  (a5)+,d0
       move.w  (a5)+,d1
       move.l  #16,d4
       move.l  #14,d5
       move.l  #$c0,d6
       move.l  #$ff,d7
       jsr     _LVOBltBitMap(a6)  ;show the bonuses
       tst.w   dx
       bne     Ych
       move.w  #160,dx
       bra     Zch
Ych:   clr.w   dx
       add.w   #15,dy
Zch:   cmp.l   #end_BonusCoords,a5
       bne     NextBonus
       move.l  intbase,a6
       move.l  Rast,a0
       lea     BonusDescribe,a1
       move.l  #20,d0
       move.l  #97,d1
       jsr     _LVOPrintIText(a6) ;show the names of the bonuses
       bsr     FadeIn
       clr     You_Cheated
       clr     You_Cheated2       ;clear some flags
;       move.l  mts_main,mt_pdata
       move    #1,FadeMus
       tst     Mus_Play
       bne     TSni    ;Title Screen No Init...NI!!
;       bsr     mt_init
       move.l  Name_Title,d1
       move.l  mts_title,d5
       jsr     OMed_LoadPlayD1D5
TSni:  bsr     DumpMsgs
       move    (sp)+,d7
       cmp.b   #'2',d7
       beq     Auto2
       cmp.b   #'c',d7
       beq     AutoC
       cmp.b   #'C',d7
       beq     AutoC
       moveq.l #0,d7
       clr     Fcol
       move    #1,Fdir
       move    #8,dx
       lea     ScrollText,a4
       move.l  gfxbase,a6
       move.l  Rast3,a1
       moveq   #0,d0
       move.b  Converter+24,d0   ;Blinkenlichten
       jsr     _LVOSetAPen(a6)
       lea     Params1,a2
       lea     Params2,a3
       tst.l   Font
       beq.s   TryTopaz
       move.l  Font,a0
       move.l  Rast3,a1
       jsr     _LVOSetFont(a6)
       bra.s   TryMsgAgain
TryTopaz:
       tst.l   TopazFont
       beq.s   TryMsgAgain
       move.l  TopazFont,a0
       move.l  Rast3,a1
       jsr     _LVOSetFont(a6)
TryMsgAgain:
       jsr     mt_music
       bsr     ColorFitch
       move.l  readreply+$10,a1
       move.l  ExecBase,a6
       moveq   #22,d0
       jsr     _LVOSetTaskPri(a6) ;Runs smoother at pri +22...YEAH!!!!
       bsr     NewTim
       move.l  gfxbase,a6
       move.l  Rast,a0
       move.l  a0,a1
       movem.l (a2),d0-d5
       jsr     _LVOScrollRaster(a6)  ;wonderful scrolling doohickie
       move.l  readreply+$10,a1
       move.l  ExecBase,a6
       moveq   #4,d0
       jsr     _LVOSetTaskPri(a6) ;Runs smoother at pri +4
       move.l  gfxbase,a6
       addq.w  #1,dx
       cmp     #9,dx
       blt     NoNL
       move.b  (a4),d0
       tst.b   d0
       bne     NoNL2
       lea     ScrollText,a4
       bra     NoNL2
TryCA: addq.l  #1,a4     ;Color change, try again.
       move.b  (a4),d0
NoNL2: cmp.b   #1,d0
       bne     NoNL3
       move.l  Rast3,a1
       moveq   #0,d0
       move.b  Converter+24,d0     ;1 = Blinkenlichten
       jsr     _LVOSetAPen(a6)
       bra     TryCA
NoNL3: cmp.b   #2,d0
       bne     NoNL4
       move.l  Rast3,a1
       moveq   #0,d0
       move.b  Converter+3,d0      ;2 = Pink (Ed's text)
       jsr     _LVOSetAPen(a6)
       bra     TryCA
NoNL4: cmp.b   #3,d0
       bne     NoNL4d
       move.l  Rast3,a1
       moveq   #0,d0
       move.b  Converter+5,d0      ;3 = Yellow (Al's text)
       jsr     _LVOSetAPen(a6)
       bra     TryCA
NoNL4d:cmp.b   #7,d0
       bne     NoNL5
       move.l  Rast3,a1
       moveq   #0,d0
       move.b  Converter+4,d0     ;7 = Purple (Dale's text)
       jsr     _LVOSetAPen(a6)
       bra     TryCA
NoNL5: cmp.b   #4,d0
       bne     NoNL6
       move.l  Rast3,a1
       moveq   #0,d0
       move.b  Converter+20,d0     ;4 = Red
       jsr     _LVOSetAPen(a6)
       bra     TryCA
NoNL6: cmp.b   #5,d0               ;5 = Topaz font
       bne     NoNL7
       tst.l   TopazFont
       beq     TryCA
       move.l  TopazFont,a0
       move.l  Rast3,a1
       jsr     _LVOSetFont(a6)
       bra     TryCA
NoNL7: cmp.b   #6,d0               ;6 = MegaBall font
       bne     NoNL8
       tst.l   Font
       beq     TryCA
       move.l  Font,a0
       move.l  Rast3,a1
       jsr     _LVOSetFont(a6)
       bra     TryCA
NoNL8: move.l  Rast3,a1
       move.l  #77,d0
       move.l  #192,d1
       jsr     _LVOMove(a6)
       move.l  #1,d0
       move.l  a4,a0
       addq.l  #1,a4
       move.l  Rast3,a1
       jsr     _LVOText(a6)
       move    #1,dx
NoNL:  move.l  bit3map,a0
       move.l  bit1map,a1
       move.l  d7,-(sp)
       movem.l (a3),d0-d7   ;Word add id OK here
       add     dx,d0        ;because >320 not allowed anyway.
       move    #$ff,d7
       jsr     _LVOBltBitMap(a6)  ;Move letter slice onto screen
       move.l  (sp)+,d7
GetMsgAgain:
       bsr     MyReadJoyTitle
       tst     d0
       beq     gma1
       moveq   #2,d7
       cmp     #1,d0
       bne     gma3
       clr     PlayerUp
       clr     GPlayRec
       clr     GameRecover
       clr     GameRecover2
gma3:  cmp     #2,d0
       bne     gma2
       move    #2,PlayerUp
       move    #2,GPlayRec
       clr     GameRecover
       clr     GameRecover2
gma2:  cmp     #3,d0
       bne     gma1
       move    GPlayRec,PlayerUp
gma1:  move.l  windowhd,a0
       move.l  86(a0),a0
       move.l  ExecBase,a6
       jsr     _LVOGetMsg(a6)    ;read in the message.
       tst.l   d0
       beq     PlayGame
       move.l  d0,a5
       move.l  20(a5),d6
       cmp.l   #$200000,d6   ;User press a key?    (TITLE SCREEN)
       bne     NotKey
       move.b  25(a5),d0
       cmp.b   #'c',d0       ;Was it, continue game?
       beq     CC
       cmp.b   #'C',d0       ;same.
       beq     CC
       cmp.b   #$a3,d0       ;Was it, Load Boards?
       beq     INBoards
       cmp.b   #'l',d0
       beq     INBoards
       cmp.b   #'L',d0
       beq     INBoards
       cmp.b   #'Q',d0       ;Was it, 'Q'?
       bne     NotQu
       move    #-1,d7
       bra     Rep2
Params1:
       dc.l    1,0,2,82,311,92   ;Excuse me while I insert this.
Params2:
       dc.l    76,186,310,83,1,9,$c0,$ff
CC:    moveq   #2,d7
       move    GPlayRec,PlayerUp
       bra     Rep2
NotQu: cmp.b   #'1',d0       ;Was it, '1' for 1-Player game?
       bne     Not1k
       moveq   #2,d7
       clr     PlayerUp
       clr     GPlayRec
       clr     GameRecover
       clr     GameRecover2
Not1k: cmp.b   #'2',d0       ;Was it, '2' for 2-Player game?
       bne     NotKey
       moveq   #2,d7
       move    #2,PlayerUp
       move    #2,GPlayRec
       clr     GameRecover
       clr     GameRecover2
       bra     Rep2
NotKey:
       cmp.l   #$8,d6
       bne     Rep2
       addq    #1,d7
       clr     PlayerUp
       clr     GPlayRec
       clr     GameRecover
       clr     GameRecover2
Rep2:  move.l  a5,a1
       move.l  ExecBase,a6
       jsr     _LVOReplyMsg(a6)
       bra     GetMsgAgain
Auto2:
       move    #2,GPlayRec
       clr     GameRecover
       clr     GameRecover2
AutoC: moveq   #2,d7
       move    GPlayRec,PlayerUp
PlayGame:
       cmp     #-1,d7
       beq     ende
       cmp     #2,d7
       blt     TryMsgAgain
       bsr     FadeOut        ;OK!  Let's play this thing
       jsr     mt_end
       clr     You_Looped
       clr     You_Looped2
       clr.l   LifePts
       clr.l   LifePts2
       move    #1,NeedSetup
       move    #1,NeedSetup2
       move.w  GameRecover,CurrentBoard
       move.w  GameRecover2,CurrentBoard2
       clr.l   P2Offset
       move.w  #3,LivesLeft    ;have some lives, why don't you
       move.w  #3,LivesLeft2
       tst     PlayerUp
       bne     NP2U4
       move    #-1,LivesLeft2  ;(unless you're not playing, P2!)
NP2U4: clr.l   Score
       clr.l   Score2
       move.w  #140,PaddleX
       subq.w  #4,CurrentBoard
       subq.w  #4,CurrentBoard2
DrawBoard:
       clr     cylx        ;draw a nice board
       clr     cyly
       clr     cyln
       bsr     clrscr
       tst     PlayerUp
       ble     OnePGame
       moveq.l #0,d1
       move    PlayerUp,d1
       cmp     #-1,LivesLeft2
       beq     OPL                ;switch players?
       move    CurrentBoard,d0
       move    CurrentBoard2,CurrentBoard
       move    d0,CurrentBoard2
       move    NeedSetup,d0
       move    NeedSetup2,NeedSetup
       move    d0,NeedSetup2
       move    GameRecover,d0
       move    GameRecover2,GameRecover
       move    d0,GameRecover2
       move    You_Cheated,d0
       move    You_Cheated2,You_Cheated
       move    d0,You_Cheated2
       move.l  LifePts,d0
       move.l  LifePts2,LifePts
       move.l  d0,LifePts2
       move    You_Looped,d0
       move    You_Looped2,You_Looped
       move    d0,You_Looped2
       move    LivesLeft,d0
       move    LivesLeft2,LivesLeft
       move    d0,LivesLeft2
       move.l  Score,d0
       move.l  Score2,Score
       move.l  d0,Score2
       move.l  #Pl2Boards,d0
       sub.l   #Board1,d0
       move.l  d0,P2Offset
       cmp     #2,PlayerUp
       bne     P2U1
       clr.l   P2Offset
P2U1:  move.l  #3,d1
       sub     PlayerUp,d1
       move    d1,PlayerUp
OPL:   mulu    #29,d1
       sub     #28,d1
       move.l  #220,d0      ; D1: #1 = Player 1, #30 = Player 2
       move.l  #116,d2
       move.l  #86,d3
       move.l  bit3map,a0
       move.l  bit1map,a1
       move.l  #88,d4
       move.l  #28,d5
       move.l  #$c0,d6
       move.l  #$ff,d7
       jsr     _LVOBltBitMap(a6)  ;Tell user: Player 1 or 2??
       bsr     DumpMsgs
       bsr     FadeIn
       clr     d7
       bsr     tloop             ;Wait for mouse button
       bsr     FadeOut
       move.l  gfxbase,a6
       moveq.l #0,d0
       move.l  Rast,a1
       jsr     _LVOSetRast(a6)
OnePGame:
       moveq   #13,d0
       bsr     playme    ;Wait for self-destruct sound to finish.
       bsr     ColorOn
       bsr     CheckLifePts  ;See if she got a 20k life.
       tst     d1
       bne     nnt   ;No Next Tune if she did!
       bsr     NextTune
nnt:   bsr     ColorOff
       clr     FadeMus
       move    You_Looped,Got_Catch   ;Got_Catch: temp "blank.BDS" check!
HeyThatBoardIsTotallyBlank:
       lea     ExplodingBits,a5
       moveq   #13,d0
kEB:   clr.l   (a5)+
       dbra    d0,kEB
       and     #$7fff,PlayerUp
       addq.w  #4,CurrentBoard
       lea     Board1,a5
       move.l  MemPtr,a0
       moveq.l #0,d0
       move.w  CurrentBoard,d0
       mulu    #105,d0
       add.l   d0,a0
       cmp.w   #50*4,CurrentBoard
       blt     DBok
 IFEQ REGISTERED,0
       bsr     ShowTiredText
 ENDIF
       move.l  MemPtr,a0
       addq    #1,You_Looped    ;If player loops all the way around,
       clr.w   CurrentBoard     ;start handing out the funny <?>s!
DBok:  add.l   P2Offset,a5
       move.l  a5,CurBrdPtr
       tst     NeedSetup
       beq     DB2ok
       move.l  a5,a1
       move.l  #420,d0
       move.l  ExecBase,a6
       jsr     _LVOCopyMem(a6)   ;Setup this board
       clr     NeedSetup
; move.l a5,a1        ;Debug code for brick numbers
; add.l  #20,a1
; move.l #TheExplodingKind-1,d0
;huhhuh:
; move.b d0,(a1)+
; dbra   d0,huhhuh
DB2ok: move.l  a5,d0
       add.l   #420,d0
       move.l  d0,End_Board
       move    CurrentBoard,DeathRecover
       subq    #4,DeathRecover
       moveq.l #0,d0
       moveq.l #0,d1
       moveq.l #0,d2
       moveq.l #0,d3
       moveq.l #0,d5
       moveq.l #0,d6      ;d6 tells if we drew stuff
       clr.w   BlocksLeft
       move.l  gfxbase,a6
       move.w  #10,dx
       move.w  #8,dy
       lea     ExplodingBits,a4
       move    #$80,d7
NextBlock:
       moveq.l #0,d4
       move.b  (a5)+,d4
       cmp.b   #TheExplodingKind,d4
       blo     BC3
       or.b    d7,(a4)    ;Set explode bit!
BC3:   lsr     #1,d7
       bne     BC4
       addq.l  #1,a4
       move    #$80,d7
BC4:   tst.b   d4
       beq     NoBlk
       cmp.b   #41,d4 ;red gold
       bne     TrigD1
       or      #$02,d6
       bra     BC2
TrigD1:cmp.b   #47,d4 ;green gold
       bne     TrigD2
       or      #$04,d6
       bra     BC2
TrigD2:cmp.b   #43,d4 ;blue gold
       bne     TrigD3
       or      #$08,d6
       bra     BC2
TrigD3:cmp.b   #42,d4 ;red trigger
       bne     TrigD4
       or      #$20,d6
TrigD4:cmp.b   #44,d4 ;green trigger
       bne     TrigD5
       or      #$40,d6
TrigD5:cmp.b   #45,d4 ;blue trigger
       bne     TrigD6
       or      #$80,d6
TrigD6:cmp.b   #6,d4
       blo     BC1
       addq.w  #1,BlocksLeft
BC1:   cmp.b   #5,d4
       bhs     BC2
       addq.w  #1,BlocksLeft
BC2:   lsl     #2,d4
       lea     BlockCoords,a0
       move.w  0(a0,d4),d0
       move.w  2(a0,d4),d1
       move.w  dx,d2
       move.w  dy,d3
       move.l  bit2map,a0
       move.l  bit1map,a1
       move.w  #15,d4
       move.w  #7,d5
       move    d7,a3
       move    d6,-(sp)
       move.l  #$c0,d6    ;looks like we drew stuff!
       move.l  #$ff,d7
       jsr     _LVOBltBitMap(a6)  ;get them blocks on there
       move    (sp)+,d6
       or      #$1,d6
       move    a3,d7
NoBlk: move.w  dx,d2
       add.w   #15,d2
       cmp.w   #310,d2
       blt     NBdxOK
       move.w  #10,d2
       addq.w  #7,dy
NBdxOK:move.w  d2,dx
       cmp.l   End_Board,a5
       bne     NextBlock
       tst     BlocksLeft      ;Is this a blank board?
       bne     TrigCK
       move    You_Looped,d0   ;Yes.  Are we looping out of control?
       sub     Got_Catch,d0
       cmp     #2,d0
       bge     LoopieDeath     ;Yep, so die!
       move    #1,NeedSetup
       tst     d6              ;Did we draw stuff?
       beq     HeyThatBoardIsTotallyBlank
       bsr     clrscr
       bra     HeyThatBoardIsTotallyBlank   ;Blank, so skip it!!
TrigCK:move    d6,d5
       move    d6,d4
       and     #$22,d6
       and     #$44,d5
       and     #$88,d4
       move    #41,d3    ;red gold
       cmp     #$02,d6
       beq     NoTrig
       move    #47,d3    ;green gold
       cmp     #$04,d5
       beq     NoTrig
       move    #43,d3    ;blue gold
       cmp     #$08,d4
       bne     Bord
NoTrig:move.l  CurBrdPtr,a5    ;No trigger?? Delete all (d3) golds from board.
       moveq   #0,d4
NT_2:  move.b  (a5)+,d4
       cmp.b   d4,d3
       bne     NT_1
       clr.b   -1(a5)
NT_1:  cmp.l   End_Board,a5
       bne     NT_2
       clr     BlocksLeft
       bsr     clrscr
       subq.w  #4,CurrentBoard  ;Sub this and don't set NeedSetup.
       bra     HeyThatBoardIsTotallyBlank  ;Then we can try again!
Bord:  clr     Fcol      ;Draw the borders
       move    #1,Fdir
       move.l  #194,d3
       move.l  #7,d4
       move.l  #6,d5
       move.l  #$c0,d6
MoreBd:
       move.l  #3,d2
       move.l  bit2map,a0
       move.l  bit1map,a1
       move.l  #247,d0
       move.l  #3,d1
       sub     PlayerUp,d1
       lsl     #3,d1
       add     #4,d1
       move    #$ff,d7  ;OS bug, DUH!
       jsr     _LVOBltBitMap(a6)  ;left border
       move.l  #310,d2
       move.l  bit2map,a0
       move.l  bit1map,a1
       move.l  #280,d0
       move.l  #3,d1
       sub     PlayerUp,d1
       lsl     #3,d1
       add     #4,d1
       move    #$ff,d7  ;OS bug, DUH!
       jsr     _LVOBltBitMap(a6)  ;right border
       subq    #6,d3
       tst     d3
       bge     MoreBd
WarpIn:
       clr     FadeMus
       move    #3,d0
       bsr     playme
       bsr     showlives      ;make a cool sound and fade in the
       bsr     FadeIn         ;cool board.
       move    #1,FadeMus
       lea     WarpInList,a5
       clr     Got_Catch
       clr     Got_Down
       clr     Got_Laser
       clr     Got_Brick
       clr     Got_Grav
       clr     Got_Expand
       clr     Loopie
       move.w  #41,Paddle_Size
       move.w  #140,PaddleX
       move.w  #((MOUSESPEED*160)/320),PaddleXbig    ;Start pos for paddle
       clr.l   PaddleXmod
       move.w  #19,Stuck
       move.w  #1,dx
       move.w  #-1,dy
       move.w  #4,spx
       move.w  #5,spy
       move.w  #1,cx
       move.w  #1,cy
       clr.w   SCount
       move.l  #7,BallSpeed
       bsr     DumpMsgs
       move.l  #3,a2
WarpInCont:
;       moveq.l #3,d0
       bsr     NewTim    ;Warp-in speed (was NewTimM).
       move.l  #187,d3
       moveq.l #0,d2
       move.w  PaddleX,d2
       move.l  bit2map,a0
       move.l  bit1map,a1
       move.l  #17,d0
       move.l  #34,d1
       move.l  #44,d4
       move.l  #12,d5
       move.l  #$c0,d6
       move.l  #$ff,d7
       move.l  gfxbase,a6
       jsr     _LVOBltBitMap(a6)  ;erase your tracks
;       move.l  Rast,a0
;       move.l  screenhd,a4
;       move.w  $12(a4),d2
;       mulu    #259,d2
;       divu    #319,d2
;       add     #10,d2
       moveq   #0,d2
       move    PaddleXbig,d2
       move.l  ExecBase,a6
wi3:   move.l  windowhd,a0
       move.l  86(a0),a0
       jsr     _LVOGetMsg(a6)
       tst.l   d0
       beq     wi4
       move.l  d0,a1
       move.l  20(a1),d1
       and.l   #$10,d1      ;MOUSEMOVE
       tst.l   d1
       beq     wi4b
       add.w   32(a1),d2   ;MouseX
wi4b:  jsr     _LVOReplyMsg(a6)
       bra     wi3
wi4:   tst     d2
       bge     w3bok
       moveq   #0,d2
w3bok: cmp     #MOUSESPEED,d2
       ble     w4bok
       move    #MOUSESPEED,d2
w4bok: move    d2,PaddleXbig
       mulu    #259,d2
       divu    #MOUSESPEED,d2
       add     #8,d2
       cmp.w   #10,d2
       bge     w3ok
       move.l  #10,d2
w3ok:  cmp.w   #263,d2
       ble     w4ok
       move.l  #263,d2
w4ok:  move.w  d2,PaddleX
       move.l  #187,d3
       move.l  bit2map,a0
       move.l  bit1map,a1
       moveq.l #0,d0
       moveq.l #0,d1
       move.w  (a5),d0
       move.w  2(a5),d1
       move.l  #44,d4
       move.l  #12,d5
       move.l  #$c0,d6
       move.l  #$ff,d7
       move.l  gfxbase,a6
       jsr     _LVOBltBitMap(a6) ;do the "cool" warp-in thingie
       subq.l  #1,a2
       cmp.l   #0,a2
       bge     WarpInCont
       move.l  #3,a2
       addq.l  #4,a5
       cmp.l   #end_list,a5
       bne     WarpInCont
       add     #2,PaddleX  ;fix width difference for warpin/mainpaddle
       bsr     DumpMsgs
       bra     fixpaddle  ;prepare paddle.  Branches to "loop".
loop:
       cmp     #-5,Lasy1
       ble     NoML1
       moveq.l #0,d0
       moveq.l #0,d1
       move    Lasx1,d0
       move    Lasy1,d1
       subq    #7,d1
       move.l  d0,d2
       move.l  d1,d3
       addq    #1,d2
       bsr     FB2
       beq     NoHL1
       move.w  #-5,d1
       move.w  #-40,d0
NoHL1: move.l  ViewPort,a0
       move.l  Las1SP,a1
       move.l  gfxbase,a6
       jsr     MoveLas1Sprite   ;move those lasers
NoML1  cmp     #-5,Lasy2
       ble     NoML2
       moveq.l #0,d0
       moveq.l #0,d1
       move    Lasx2,d0
       move    Lasy2,d1
       subq    #7,d1
       move.l  d0,d2
       move.l  d1,d3
       addq    #1,d2
       bsr     FB2
       beq     NoHL2
       move.w  #-5,d1
       move.w  #-40,d0
NoHL2: move.l  ViewPort,a0
       move.l  Las2SP,a1
       move.l  gfxbase,a6
       jsr     MoveLas2Sprite  ;both of them
NoML2: tst.b   cyln
       beq     NoC
       cmp.w   #184,cyly
       bge     KilCyl
       addq.w  #1,cyly
       bsr     DrawCyl          ;Bonuses are also called
       cmp.w   #176,cyly        ;"cylenders" because that's
       blt     NoC              ;what they looked like
       move.w  cylx,d0          ;in Arkanoid.
       move.w  PaddleX,d1
       add.w   #15,d0
       cmp.w   d0,d1
       bgt     NoC
       sub.w   #15,d0
       sub.w   Paddle_Size,d0
       cmp.w   d0,d1
       blt     NoC
       moveq.l #0,d3
       move.b  cyln,d3    ;BINGO!!!  Caught a cylender!
       add.l   #10,Score
       movem.l d0-a6,-(sp)
       bsr     ShowScore  ;show your new & improved score
;       cmp.b   #12,cyln
;       beq     NoCS1     ;The music cyl didn't make a sound effect.
       move    #6,d0
       bsr     playme
NoCS1: movem.l (sp)+,d0-a6
       lsl     #2,d3
       lea     CodeTable,a3  ;find out what the cyl does
       move.l  (a3,d3),a2
       jmp     (a2)
CodeTable:
       dc.l    Cyl_Null,Cyl_Slow,Cyl_Kill,Cyl_Break,Cyl_Life,Cyl_Laser
       dc.l    Cyl_Expand,Cyl_Grav,Cyl_Brick,Cyl_Catch,Cyl_RemInde
       dc.l    Cyl_Down,Cyl_Dynamite,Cyl_Pill,Cyl_Magnet
Cyl_Slow:
       clr     Got_Grav
       sub.l   #4,BallSpeed
       cmp.l   #5,BallSpeed
       bgt     KilCyl
       move.l  #5,BallSpeed
       bra     KilCyl
Cyl_Kill:
       bra     YourDead    ;Simple enough!
Cyl_Break:
       add.l   #40,Score
       bsr     EraseCyl
       bra     NewBoardBonus
Cyl_Life:
       addq.w  #1,LivesLeft
       bsr     ShowLives
       clr     Got_Catch
       clr     Got_Down
       clr     Got_Brick
       clr     Got_Laser
       cmp     #-1,Stuck
       beq     NStk2
       move    d0,-(sp)
       move    #8,d0
       bsr     playme
       move    (sp)+,d0
       move.w  #-1,Stuck
NStk2: clr     Got_Grav
       bra     KilCyl
Cyl_Laser:
       move    #1,Got_Laser
       bra     KilCyl
Cyl_Expand:
       cmp.w   #2,Got_Expand
       bge     KilCyl
       addq.w  #1,Got_Expand
       move.w  Paddle_Size,d0
       lsl     #1,d0
       cmp     #40,d0
       bne     NFE
       move    #41,d0
NFE:   move.w  d0,Paddle_Size
       cmp     #-1,Stuck
       beq     KilCyl
       move    d0,-(sp)
       move    #8,d0
       bsr     playme
       move    (sp)+,d0
       move.w  #-1,Stuck
       bra     KilCyl
Cyl_Grav:
       move    #1,Got_Grav
       bra     KilCyl
Cyl_Brick:
       move    #1,Got_Brick
       bra     KilCyl
Cyl_Catch:
       move    #1,Got_Catch
       bra     KilCyl
Cyl_RemInde:
       bsr     HideBobs
       move    #10,ddx   ;this one is actually a bit complicated!
       move    #8,ddy
       move.l  CurBrdPtr,a3
CRI2:  moveq.l #0,d3
       move.b  (a3),d3
       cmp.b   #5,d3
       blo     CRInxt
       cmp.b   #41,d3  ;red gold
       beq     CRI3d
       cmp.b   #47,d3  ;green gold
       beq     CRI3d
       cmp.b   #43,d3  ;blue gold
       beq     CRI3d
       cmp.b   #12,d3  ;aga blocks
       bhs     CRInxt
       cmp.b   #5,d3
       bne     CRI3
CRI3d: clr.b   d3
       bra     CRI4
CRI3:  cmp.b   #7,d3
       beq     CRI3b
       cmp.b   #11,d3
       beq     CRI3c
       move.b  #10,d3
       bra     CRI4
CRI3c: move.b  #2,d3
       bra     CRI4
CRI3b: move.b  #3,d3
CRI4:  move.b  d3,(a3)
       lsl     #2,d3
       lea     BlockCoords,a0
       move.w  0(a0,d3),d0
       move.w  2(a0,d3),d1
       move.w  ddx,d2
       move.w  ddy,d3
       move.l  bit2map,a0
       move.l  bit1map,a1
       move.w  #15,d4
       move.w  #7,d5
       move.l  #$c0,d6
       move.l  #$ff,d7
       move.l  gfxbase,a6
       jsr     _LVOBltBitMap(a6)  ;fix those inde blocks
CRInxt:add.w   #15,ddx
       addq.l  #1,a3
       cmp.w   #310,ddx
       blt     CRI5
       move    #10,ddx
       addq.w  #7,ddy
CRI5:  cmp.w   #155,ddy
       blt     CRI2
       bra     KilCyl
Cyl_Down:
       move    #1,Got_Catch
       move    #1,Got_Down
       bra     KilCyl
Cyl_Dynamite:
       bsr     HideBobs
       move    #10,ddx
       move    #15,ddy
       move.l  CurBrdPtr,a3
       lea     QSandBuf,a2
       move.l  #104,d0
CD1:   move.l  (a3)+,(a2)+
       dbra    d0,CD1
       move.l  CurBrdPtr,a3
       add.l   #20,a3
       lea     QSandBuf+20,a2
CD2:   moveq.l #0,d3
       move.b  (a3),d3
       cmp.b   #24,d3
       beq     CDnxt
       cmp     #TheExplodingKind,d3
       bhs     CDnxt
       cmp     #8,ddy
       beq.s   CD7
       cmp.b   #24,-20(a2)   ;Check above
       beq.s   CD4a
CD7:   cmp     #148,ddy
       bge.s   CD8
       cmp.b   #24,20(a2)    ;Check below
       beq.s   CD4a
CD8:   cmp     #10,ddx
       beq.s   CD9
       cmp.b   #24,-1(a2)    ;Check left
       beq.s   CD4a
CD9:   cmp     #295,ddx
       bge.s   CD9c
       cmp.b   #24,1(a2)     ;Check right
       bne.s   CD9c
CD4a:  moveq   #24,d4
       bra.s   CD4
CD9c:  cmp     #8,ddy
       beq.s   CD7b
       cmp.b   #36,-20(a2)   ;Check above
       beq.s   CD4b
CD7b:  cmp     #148,ddy
       bge.s   CD8b
       cmp.b   #36,20(a2)    ;Check below
       beq.s   CD4b
CD8b:  cmp     #10,ddx
       beq.s   CD9b
       cmp.b   #36,-1(a2)    ;Check left
       beq.s   CD4b
CD9b:  cmp     #295,ddx
       bge     CDnxt
       cmp.b   #36,1(a2)     ;Check right
       bne     CDnxt
CD4b:  moveq   #36,d4
CD4:   addq.w  #1,BlocksLeft ;Probably made a new block, right?
       tst     d3
       beq     CD10
       cmp     #5,d3
       beq     CD10
       cmp     #41,d3  ;red gold
       beq     CD10
       cmp     #47,d3  ;green gold
       beq     CD10
       cmp     #43,d3  ;blue gold
       beq     CD10
       subq.w  #1,BlocksLeft ;Oops, no we didn't!
CD10:  move.b  d4,(a3)
       lsl     #2,d4
       lea     BlockCoords,a0
       move.w  0(a0,d4),d0
       move.w  2(a0,d4),d1
       move.w  ddx,d2
       move.w  ddy,d3
       move.l  bit2map,a0
       move.l  bit1map,a1
       move.w  #15,d4
       move.w  #7,d5
       move.l  #$c0,d6
       move.l  #$ff,d7
       move.l  gfxbase,a6
       jsr     _LVOBltBitMap(a6)  ;Add Dynamite blocks.
CDnxt: add.w   #15,ddx
       addq.l  #1,a3
       addq.l  #1,a2
       cmp.w   #310,ddx
       blt     CD5
       move    #10,ddx
       addq.w  #7,ddy
CD5:   cmp.w   #155,ddy
       blt     CD2
       bra     KilCyl
Cyl_Pill:
       cmp.w   #-1,Got_Expand
       beq     KilCyl
       subq.w  #1,Got_Expand
       move.w  Paddle_Size,d0
       lsr     #1,d0
       move    #1,BigFP
       move.w  d0,Paddle_Size
       cmp     #-1,Stuck
       beq     KilCyl
       move    d0,-(sp)
       move    #8,d0
       bsr     playme
       move    (sp)+,d0
       move.w  #-1,Stuck
       bra     KilCyl
Cyl_Magnet:
       move    #-1,Got_Grav
Cyl_Null:
KilCyl:bsr     EraseCyl  ;erase the cyl you just caught
       clr     cyly
       clr     cylx
       clr     cyln
       bra     fixpaddle  ;and patch you up
NoC:   cmp.w   #-1,Stuck
       bne     NoAcelBall
       move.l  BallSpeed,d7  ;This section is the ball-not-stuck section.
       addq.w  #1,SCount
       cmp.w   #400,SCount      ;Ball Accelleration.
       blt     NoSped
       clr.w   SCount
       addq.l  #1,BallSpeed
NoSped:moveq.l #0,d6
BalLop:bsr     MoveBall
       tst     d6
       bne     YourDead     ;oops...  you dropped it!
       dbra    d7,BalLop
       bsr     UpDateBall
       cmp.w   #-1,Stuck
       bne     fixpaddle    ;only done if ball _just_ got stuck.
NoAcelBall:
       bsr     BlowEmUpRealGood     ;The Exploding Kind.
       bsr     GrowSlime            ;The Growing Kind.
       bsr     ShowBobs
       tst.w   BlocksLeft
       ble     NewBoard
       bsr     ColorFitch
       bsr     mt_music
       bsr     CD_CheckTune
       bsr     NewTim  ;wonderful timing doohickie
       moveq.l #0,d7
       bsr     MyReadJoy
       move.b  JoyFire,d0
       add.b   JoyFire+1,d0
       btst    #0,d0
       beq.s   NoFire
       bsr     LetGo
NoFire:tst     PaddleXmod
       beq.s   loop2
       bset    #2,d7
loop2:
       move.l  windowhd,a0
       move.l  86(a0),a0
       jsr     _LVOGetMsg(a6)    ;read in the message.
       tst.l   d0
       bne     ReadMsg
       tst     d7
       beq     loop
       btst    #1,d7
       bne     AbortGame
       btst    #3,d7
       bne     Pause
       btst    #4,d7
       bne     SelfDest   ;Thank you for pressing
       btst    #2,d7      ;the Self-Destruct Button!
       bne     fixpaddle
       bra     loop
ende:
       bsr     FadeOut    ;Fun Finish For Fade Fans! (FFFFF)
       bsr     mt_end
;       lea     devio,a1
       move.l  ExecBase,a6         ;we're leaving the whole prog here
;       jsr     _LVOWaitIO(a6)
       moveq.l #5,d0
       lea     VBInterrupt,a1
       jsr     _LVORemIntServer(a6)
       moveq.l #0,d0
       move.l  Las2SP,a0
       move.w  10(a0),d0
       move.l  gfxbase,a6
       jsr     _LVOFreeSprite(a6)  ;return all allocated resources
Las2Kicked:
       move.l  Las1SP,a0
       move.w  10(a0),d0
       move.l  gfxbase,a6
       jsr     _LVOFreeSprite(a6)  ;in the opposite order
Las1Kicked:
       move.l  BallSP,a0
       move.w  10(a0),d0
       move.l  gfxbase,a6
       jsr     _LVOFreeSprite(a6)  ;that they were allocated in.
AllocSPDataKicked:
       tst     v39
       beq     SpriteKicked
       move.l  gfxbase,a6
       move.l  Las2SP,a2
       jsr     _LVOFreeSpriteData(a6)
       move.l  Las1SP,a2
       jsr     _LVOFreeSpriteData(a6)
       move.l  BallSP,a2
       jsr     _LVOFreeSpriteData(a6)
SpriteKicked:
 IFEQ CDROM,1
       move.l  ExecBase,a6
       lea     MyCD,a1
       tst.l   $14(a1)
       beq     CDkicked
       jsr     _LVOCloseDevice(a6)  ;close cd.device
 ENDIF
CDkicked:
 IFEQ REGISTERED,1
       bsr     closeasl
       bsr     closereq
 ENDIF
       move.l  readreply+$10,a0
       move.l  OldWindowPtr,184(a0)   ;replace old DOS requestors!
       bsr     windclose
WindKicked:                   ;A few things converge here
       move.l  bit2map,a0
       bsr     freebitmap
bitmap2kicked:
       move.l  bit3map,a0
       bsr     freebitmap
bitmap3kicked:
       move.l  screenhd,a0
       bsr     closescreen
Screen3Kicked:                ;A few things converge here
       bsr     closeiff
       bsr     closedatatypes   ;These two check for NULL bases.
       move.l  gfxbase,a6
       tst.l   Font
       beq     FontK1
       move.l  Font,a1
       jsr     _LVOCloseFont(a6)
FontK1:tst.l   TopazFont
       beq     FontKicked
       move.l  TopazFont,a1
       jsr     _LVOCloseFont(a6)
FontKicked:
       bsr     _RemPlayer
OMedKicked:
       move.l  ExecBase,a6
       move.l  #3,d2
Ab:    move    d2,d0
       mulu    #68,d0
       lea     othermessages,a2
       add.l   d0,a2
       move.l  a2,a1
       jsr     _LVOAbortIO(a6)   ;get rid of our audio.device
       move.l  a2,a1
       jsr     _LVOWaitIO(a6)
       dbra    d2,Ab
       move.l  #15,Unit
       lea     Message,a1
       jsr     _LVOCloseDevice(a6)
AudioKicked:
       move    #-1,d2
SigKicked:
       cmp     #3,d2
       beq     SigsFree
       addq    #1,d2
       moveq.l #3,d0
       sub     d2,d0       ;free up these signals
       lsl     #6,d0
       lea     MsgSig,a0
       add.l   d0,a0
       moveq.l #0,d0
       move.b  (a0),d0
       move.l  ExecBase,a6
       jsr     _LVOFreeSignal(a6)
       bra     SigKicked
SigsFree:                  ;BoardsKickedM joins us here.
       bsr     closeicon   ;Ignores a NULL base.
       bsr     closegfx
GfxKicked:
       tst.l   ErrPtr
       beq     NoErr
       move.l  intbase,a6
       suba.l  a5,a5   ;a5 = pubscreen handle
       tst     UseOS20
       beq     NAjEr   ;No Adjust Error window.
       suba.l  a0,a0
       jsr     _LVOLockPubScreen(a6)
       move.l  d0,a5
       tst.l   d0
       beq     NAjEr
       lea     Errwinddef,a0
       move.l  a5,$1e(a0)      ;NewWindow -> Screen
       move.w  #2,$2e(a0)      ;#PUBLICSCREEN, NewWindow -> Type
       moveq   #0,d0
       move.b  $23(a5),d0      ;Screen -> WBorTop
       move.l  $28(a5),a1      ;Screen -> Font
       add     4(a1),d0        ;TextAttr -> ta_YSize
       addq    #1,d0
       move.w  d0,6(a0)        ;NewWindow -> Height
NAjEr: bsr     ErrWindOpen     ;tell user if error occoured
       beq     NoEW
       move.l  windowhd,a0
       move.l  86(a0),a0
       move.l  ExecBase,a6
       jsr     _LVOWaitPort(a6)    ;wait for message.
NextMsg:
       move.l  windowhd,a0
       move.l  86(a0),a0
       jsr     _LVOGetMsg(a6)    ;read in the message.
       tst.l   d0
       beq     NMMsgs
       move.l  d0,a1
       jsr     _LVOReplyMsg(a6)
       bra     NextMsg
NMMsgs:
       bsr     WindClose
NoEW:  cmp.l   #0,a5
       beq     NoErr
       suba.l  a0,a0
       move.l  a5,a1
       move.l  intbase,a6
       jsr     _LVOUnlockPubScreen(a6)
NoErr: 
       cmp.l   #-1,OldDir
       beq     NoChB
       move.l  dosbase,a6
       move.l  OldDir,d1
       jsr     _LVOCurrentDir(a6)
       tst     Debug
       beq     NoChB
       move.l  d0,d1
       jsr     _LVOUnLock(a6)
NoChB:
       bsr     closelow
       bsr     closedos
DosKicked:
       bsr     closeint
IntKicked:
       move.l  ExecBase,a6
       move    OldPri,d0
       move.l  readreply+$10,a1
       jsr     _LVOSetTaskPri(a6)
;       lea     devio,a1
;       jsr     _LVOCloseDevice(a6)  ;close timer.device
;       lea     readreply,a1
;       jsr     _LVORemPort(a6)
TimeKicked:
       move.l  ExecBase,a6
       moveq   #0,d0
       move.b  CDreply+$f,d0
       jsr     _LVOFreeSignal(a6)
CDsigKicked:
       bsr     UnLoadMusic
MemKicked:
       rts   ;that's all folks!  We're outta here!
AllocSPDataKickedM:
       move.l  #no_allocsprite,ErrPtr
       bra     AllocSPDataKicked
SpriteKickedM:
       move.l  #no_sprites,ErrPtr
       bra     SpriteKicked
Las1KickedM:
       move.l  #no_sprites,ErrPtr   ;some little patches
       bra     Las1Kicked
Las2KickedM:
       move.l  #no_sprites,ErrPtr   ;for telling the user about errors
       bra     Las2Kicked
AudioKickedM:
       move.l  #no_audio,ErrPtr
       bra     AudioKicked
OMedKickedM:
       move.l  #no_omed,ErrPtr
       bra     OMedKicked
BoardsKickedM:
       move.l  #no_boards,ErrPtr
       bra     SigsFree
DTkickedM:
       move.l  #no_datatypes,ErrPtr
       bra     Screen3Kicked
DeleteTemp:
       move.l  dosbase,a6
       move.l  #MBgfxTempName,d1
       jsr     _LVODeleteFile(a6)
       rts
CloseD7:
       move.l  dosbase,a6
       move.l  d7,d1
       jsr     _LVOClose(a6)
       rts
FreeD5D6:
       move.l  ExecBase,a6
       move.l  d5,a1
       move.l  d6,d0
       jsr     _LVOFreeMem(a6)
       rts
bitmap2kickedM:
       bsr     CloseD7
       move.l  #no_bitmap,ErrPtr
       bra     bitmap2kicked
bitmap3kickedM:
       bsr     CloseD7
       move.l  #no_bitmap,ErrPtr
       bra     bitmap3kicked
ReadKickedMM:
       bsr     FreeD5D6
ReadKickedM:
       bsr     CloseD7
       move.l  #no_gfx,ErrPtr
       bra     WindKicked
DisposeD7:
       move.l  DataTypesBase,a6
       move.l  d7,a0
       jsr     _LVODisposeDTObject(a6)
       rts
RamKickedM:
       bsr     FreeD5D6
       bsr     DeleteTemp
       move.l  #no_ram,ErrPtr
       bra     WindKicked
PicKickedM:
       bsr     FreeD5D6
       bra     WindKicked
DTObjKickedM:
       bsr     DisposeD7
       bsr     FreeD5D6
       bsr     DeleteTemp
       addq.l  #4,sp
       move.l  #no_gfx,ErrPtr
       bra     WindKicked
DTColsKickedM:
       bsr     DisposeD7
       bsr     FreeD5D6
       bsr     DeleteTemp
       addq.l  #4,sp
       move.l  #no_cols,ErrPtr
       bra     WindKicked
DTBitmapKickedM:
       bsr     DisposeD7
       bsr     FreeD5D6
       bsr     DeleteTemp
       addq.l  #4,sp
       move.l  #no_DTbm,ErrPtr
       bra     WindKicked
GfxKickedM:
       move.l  #no_gfx,ErrPtr
       bra     Screen3Kicked

PlayLifeTune:
       movem.l d5/a5-a6,-(sp)   ;same regs as NextTune!
       move.l  Name_Life,d0
       move.l  mts_life,d5
       bra     nt3     ;Part of NextTune (below).
NextTune:
       tst     Mus_Play
       bne     _rts
  IFEQ CDROM,1
       bsr     CD_PlayTune
       tst     Mus_Play
       bne     _rts
  ENDIF
       bsr     mt_end
       tst     Music
       beq     _rts
       tst.l   MyToolTypes
       beq     _rts
       movem.l d5/a5-a6,-(sp)   ;same regs as PlayLifeTune.
       move.l  iconbase,a6
       moveq   #0,d5
       tst.l   TuneList
       bne     ntTL1
ntLoop:add     #1,WhichMus
       moveq   #0,d0
       move    WhichMus,d0
       lea     TexBuf,a5
       bsr     PrtNum
       clr.b   (a5)+
       lea     Tool_TuneX+4,a0
       lea     TexBuf,a1
nt1:   cmp.b   #'0',(a1)+
       beq     nt1
       subq.l  #1,a1
nt2:   move.b  (a1)+,(a0)+
       bne     nt2
       move.l  MyToolTypes,a0
       lea     Tool_TuneX,a1
       jsr     _LVOFindToolType(a6)
       tst.l   d0
       bne.s   nt3
       cmp     #1,WhichMus
       beq     nt0
       clr     WhichMus
       bra     ntLoop
nt3:   bsr     mt_end   ;PlayLifeTune joins us here.
       move.l  d0,a0
       tst.b   (a0)
       beq.s   nt0
       tst.b   1(a0)
       beq.s   nt4
       cmp.b   #'|',2(a0)   ;Form: TUNE1=3E|my.tune
       bne.s   nt4
       addq.l  #3,d0
       cmp.b   #'3',(a0)  ;First dig: 3|4 (# of voices)
       bne.s   nt5
       move    #1,NoVoice0
nt5:   cmp.b   #'e',1(a0)
       beq.s   nt5b
       cmp.b   #'E',1(a0) ;Second dig: E = End with sjump 1, F = Fade out.
       bne.s   nt4
nt5b:  move    #1,DoSJump
nt4:   move.l  d0,d1
       jsr     OMed_LoadPlayD1D5
nt0:   movem.l (sp)+,d5/a5-a6
       rts
ntTL1: move.l  TuneList,a0
       moveq   #0,d0
       move    WhichMus,d0
       mulu    #6,d0
       move.l  2(a0,d0),d0
       addq.w  #1,WhichMus
       move    WhichMus,d1
       cmp     NumTunes,d1
       blo     nt3
       clr     WhichMus
       bsr     RandomizeTuneList
       bra     nt3

NewBoard:
       add.l   #100,Score     ;a little patch for a new board
NewBoardBonus:
       cmp     #2,Mus_Play
       bne     men08
       tst     DoSJump
       beq     men08
       moveq   #13,d0    ;Shut off v0.
       bsr     playme
       clr     NoVoice0
       move.l  #$dff0a0,Voice0HW
       move    #1,SJump
men08: move    #1,NeedSetup
       move.l  #183,d3
       moveq.l #0,d2
       moveq.l #0,d4
       move.w  PaddleX,d2
       move.w  #310,d1
       sub.w   Paddle_Size,d1
       cmp.w   d1,d2
       ble     wYup
       move.w  d1,d2
wYup:  move.l  bit2map,a0
       move.l  bit1map,a1
       move.l  #17,d0
       move.l  #34,d1
       move.w  Paddle_Size,d4
       move.l  #15,d5
       move.l  #$c0,d6
       move.l  #$ff,d7
       move.l  gfxbase,a6
       jsr     _LVOBltBitMap(a6)  ;erase old paddle
       move    sx,d0
       move    sy,d1
       move.l  ViewPort,a0
       move.l  ballsp,a1
       jsr     MoveBallSprite
       lea     end_list,a5
       move    Paddle_Size,d4
       sub     #45,d4    ;width of winwarp
       asr.w   #1,d4
       add     PaddleX,d4      ;fix paddle placement for size change
       cmp.w   #10,d4
       bge     ww3ob
       move.l  #10,d4
ww3ob: cmp.w   #265,d4
       ble     ww4ob
       move.l  #263,d4
ww4ob: move.w  d4,PaddleX
       move.w  #41,Paddle_Size
       move.l  #-10,a2
       move.l  #187,d3
       move.l  #3,a2
       bra     wwSkipErase
WinWarpCont:
       moveq.l #3,d2           ;Win-Warp speed.
WWC1:  bsr     mt_music
       bsr     NewTim
;       dbra    d2,WWC1
       moveq.l #0,d2
       move.w  PaddleX,d2
       move.l  bit2map,a0
       move.l  bit1map,a1
       move.l  #17,d0
       move.l  #34,d1
       move.l  #44,d4
       move.l  #12,d5
       move.l  #$c0,d6
       move.l  #$ff,d7
       move.l  gfxbase,a6
       jsr     _LVOBltBitMap(a6)  ;erase your tracks
wwSkipErase:
;;       add     #1,a2    ;
;;       move.l  a2,d3    ;
;;       tst     d3       ; <=-  This is some STRANGE CODE
;;       bge     NoNeP    ;      that made the paddle bounce in
;;       neg     d3       ;      a very weird way.  I chucked it.
;;NoNep: mulu    d3,d3    ;
;;       add     #106,d3  ;
;       move.l  Rast,a0
;       move.l  screenhd,a4
;       move.w  $12(a4),d2
;       mulu    #259,d2
;       divu    #319,d2
;       add     #10,d2
       move    PaddleX,d2
       move.l  ExecBase,a6
wwi3:  move.l  windowhd,a0
       move.l  86(a0),a0
       jsr     _LVOGetMsg(a6)
       tst.l   d0
       beq     wwi4
       move.l  d0,a1
       move.l  20(a1),d1
       and.l   #$10,d1      ;MOUSEMOVE
       tst.l   d1
       beq     wwi4b
       add.w   32(a1),d2   ;MouseX
wwi4b: jsr     _LVOReplyMsg(a6)
       bra     wwi3
wwi4:  cmp.w   #10,d2
       bge     ww3ok
       move.l  #10,d2
ww3ok: cmp.w   #265,d2
       ble     ww4ok
       move.l  #263,d2
ww4ok: move.w  d2,PaddleX
       move.l  bit2map,a0
       move.l  bit1map,a1
       moveq.l #0,d0
       moveq.l #0,d1
       move.w  -2(a5),d1
       move.w  -4(a5),d0
       move.l  #44,d4
       move.l  #12,d5
       move.l  #$c0,d6
       move.l  #$ff,d7
       move.l  gfxbase,a6
       jsr     _LVOBltBitMap(a6) ;do the "cool" win-warp thingie
       subq.l  #1,a2
       cmp.l   #0,a2
       bge     WinWarpCont
       move.l  #3,a2
       subq.l  #4,a5
       cmp.l   #WarpInlist,a5
       bne     WinWarpCont
       cmp     #2,Mus_Play
       bne     man05
       tst     DoSJump
       beq     man05
       clr     FadeMus
       bsr     FadeOut
man07: tst     SJump
       beq     man06
       move.l  windowhd,a0
       move.l  86(a0),a0
       move.l  ExecBase,a6
       jsr     _LVOGetMsg(a6)    ;Test for ESC during SJump1.
       tst.l   d0
       beq     man07b
       move.l  d0,a1
       move.l  20(a1),d1
       cmp.l   #$200000,d1 ;Key
       bne     man07c
       move.b  25(a1),d0
       cmp.b   #27,d0      ;ESC
       bne     man07c
       clr     SJump       ;Wait aborted by user.
man07c:jsr     _LVOReplyMsg(a6)
man07b:move.l  gfxbase,a6
       jsr     _LVOWaitTOF(a6)
       bra     man07
man05: bsr     FadeOut
man06: or      #$8000,PlayerUp
       cmp     #8,Mus_Play
       beq     DrawBoard
       bsr     mt_end
       bra     DrawBoard
clrscr:                     ;Clear the screen!
       clr     ScoreShowing
       clr     Fcol
       move    #1,Fdir
       moveq.l #0,d0           ;Affects d0,d1,a0,a1,a6 only.
       moveq.l #0,d1
       move.w  #-40,d0
       move.w  #-4,d1
       move.l  gfxbase,a6
       move.l  ViewPort,a0
       move.l  ballsp,a1
       jsr     MoveBallSprite  ;Yank ball off screen
       moveq.l #0,d0
       moveq.l #0,d1
       move.w  #-40,d0
       move.w  #-5,d1
       move.l  gfxbase,a6
       move.l  ViewPort,a0
       move.l  Las1SP,a1
       jsr     MoveLas1Sprite  ;Yank laser off screen
       moveq.l #0,d0
       moveq.l #0,d1
       move.w  #-40,d0
       move.w  #-5,d1
       move.l  ViewPort,a0
       move.l  Las2SP,a1
       jsr     MoveLas2Sprite  ;Yank other laser off screen
       moveq.l #0,d0
       move.l  Rast,a1
       jsr     _LVOSetRast(a6)     ;Clear bitmap
       rts
EOGmessage:                  ;End-Of-Game messages for user
       bsr     clrscr
       cmp     #2,PlayerUp
       bne     NoFix2
       move    You_Cheated,d0
       move    You_Cheated2,You_Cheated
       move    d0,You_Cheated2
       move.l  Score,d0
       move.l  Score2,Score
       move.l  d0,Score2
NoFix2:cmp     #1,PlayerUp
       bne     NoFixP
       move    CurrentBoard,d0
       move    CurrentBoard2,CurrentBoard
       move    d0,CurrentBoard2
       move    GameRecover,d0
       move    GameRecover2,GameRecover
       move    d0,GameRecover2
NoFixP:lea     end_ScoreList,a5
       tst     You_Cheated
       beq     NCH1
       clr.l   Score
NCH1:  tst     You_Cheated2
       beq     NCH2
       clr.l   Score2
NCH2:  moveq.l #0,d0
       clr     Mark1
       clr     Mark2
       move.l  -(a5),d0
       move.l  Score,d6
       moveq.l #0,d7
       cmp.l   d6,d0
       blt     HighScoreSong
       move.l  Score2,d6
       move    #1,d7
       cmp.l   d6,d0
       blt     HighScoreSong
       move.l  #6,d0
       move.l  #169,d1
       move.l  #95,d2
       move.l  #20,d3
       move.l  bit2map,a0
       move.l  bit1map,a1
       move.l  #129,d4
       move.l  #28,d5
       move.l  #$c0,d6
       move.l  #$ff,d7
       move.l  gfxbase,a6
       jsr     _LVOBltBitMap(a6)  ;"Final Scores" message.
       move.l  #220,d0
       move.l  #1,d1
       move    #71,d2
       move    #72,d3
       move.l  bit3map,a0
       move.l  bit1map,a1
       move    #88,d4
       move    #57,d5
       move    #$ff,d7  ;OS bug, DUH!
       jsr     _LVOBltBitMap(a6)  ;PLAYER 1 & 2
       move    #28,d5
       move.l  Score,d0
       lea     TexBuf,a5
       bsr     PrtNum
       move.l  Rast,a1
       move.l  a5,d3
       sub.l   #TexBuf,d3
       move.l  #187,d0
       move.l  #89,d1
       jsr     _LVOMove(a6)
       move.l  d3,d0
       lea     TexBuf,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
       tst     PlayerUp
       beq     NoS2
       move.l  Score2,d0
       lea     TexBuf,a5
       bsr     PrtNum
       move.l  Rast,a1
       move.l  a5,d3
       sub.l   #TexBuf,d3
       move.l  #187,d0
       move.l  #118,d1
       jsr     _LVOMove(a6)
       move.l  d3,d0
       lea     TexBuf,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
NoS2:  tst     You_Cheated
       beq     NoP1C
       move.l  #220,d0
       move.l  #59,d1
       move    #161,d2
       move    #72,d3
       move.l  bit3map,a0
       move.l  bit1map,a1
       move    #$ff,d7  ;OS bug, DUH!
       jsr     _LVOBltBitMap(a6)  ;Tell Player 1: CHEATER!!
NoP1C: tst     You_Cheated2
       beq     NoP2C
       move.l  #220,d0
       move.l  #59,d1
       move    #161,d2
       move    #101,d3
       move.l  bit3map,a0
       move.l  bit1map,a1
       move    #$ff,d7  ;OS bug, DUH!
       jsr     _LVOBltBitMap(a6)  ;Tell Player 2: CHEATER!!
NoP2C: bsr     DumpMsgs
;       move.l  mts_dead,mt_pdata
;       bsr     mt_init
       bsr     FadeIn
       clr     FadeMus
       moveq   #0,d7
       bsr     tloop    ;Wait for mouse button / key
       cmp.b   #'2',d7
       beq     NewGameFade
       cmp.b   #'c',d7
       beq     NewGameFade
       cmp.b   #'C',d7
       beq     NewGameFade
       bsr     FadeOut
HiScr: bsr     clrscr
       move.l  #136,d0
       move.l  #169,d1
       move.l  #95,d2
       move.l  #4,d3     ;was 10
       move.l  bit2map,a0
       move.l  bit1map,a1
       move.l  #129,d4
       move.l  #28,d5
       move.l  #$c0,d6
       move.l  #$ff,d7
       move.l  gfxbase,a6
       jsr     _LVOBltBitMap(a6)  ;"High Scores" message.
       tst     Mark2
       beq     NFM
       move    Mark1,d0
       cmp     Mark2,d0
       blt     NFM
       addq    #1,Mark1
       cmp     #15,Mark1
       ble     NFM
       clr     Mark1
NFM:   tst     Mark1
       beq     NHi1
       move.l  #87,d0
       move.l  #176,d1
       move    #227,d2
       move    Mark1,d3
       mulu    #10,d3
       add     #26,d3    ;was 38
       move.l  bit3map,a0
       move.l  bit1map,a1
       move    #50,d4
       move    #11,d5
       move    #$ff,d7  ;OS bug, DUH!
       jsr     _LVOBltBitMap(a6)  ;Highlight Player 1's score
NHi1:  tst     Mark2
       beq     NHi2
       move.l  #87,d0
       move.l  #188,d1
       move    #227,d2
       move    Mark2,d3
       mulu    #10,d3
       add     #26,d3    ;was 38
       move.l  bit3map,a0
       move.l  bit1map,a1
       move    #50,d4
       move    #11,d5
       move    #$ff,d7  ;OS bug, DUH!
       jsr     _LVOBltBitMap(a6)  ;Highlight Player 2's score
NHi2:  move.l  Rast,a1
       moveq.l #0,d0
       jsr     _LVOSetDrMd(a6)
       move.l  Rast,a1
  IFEQ CD32,0
       move.l  #60,d0
  ELSE
       move.l  #48,d0
  ENDIF
       move.l  #198,d1
       jsr     _LVOMove(a6)
       move.l  Rast,a1
       moveq   #0,d0
       move.b  Converter+8,d0    ;Grey
       jsr     _LVOSetAPen(a6)
       move.l  #end_C2cont - C2cont,d0
       lea     C2cont,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
       move.l  Rast,a1
       move.l  #1,d0
       jsr     _LVOSetAPen(a6)
       lea     ScoreList,a4
       move.l  #14,d6
       move.l  #44,d7    ;was 56
NexNam:lea     texbuf,a5
       move.l  #19,d3
NexLet:move.b  (a4)+,(a5)+
       dbra    d3,NexLet
       move.w  #'  ',(a5)+
       move.b  #' ',(a5)+
       move.l  (a4)+,d0
       bsr     PrtNum
       move.l  a5,d3
       sub.l   #TexBuf,d3
       move.l  Rast,a1
       move.l  #44,d0
       move.l  d7,d1
       add.l   #10,d7
       jsr     _LVOMove(a6)
       move.l  d3,d0
       lea     TexBuf,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
       dbra    d6,NexNam
       move.l  Rast,a1
       move.l  #1,d0
       jsr     _LVOSetDrMd(a6)
       bsr     DumpMsgs
       bsr     FadeIn
       clr     d7
       bsr     tloop             ;Wait for mouse button / key
NewGameFade:
       move    d7,-(sp)
       move    #1,FadeMus
       bsr     FadeOut
       move    (sp)+,d7
       bsr     mt_end
       bra     NewGame
HighScoreSong:
;       move.l  mts_high,mt_pdata
;       bsr     mt_init    ;Regs are now preserved in this call.
HighScore:   ;d6 = Score, d7 = Player (0=1, 1=2), a5 = pointer
       lea     Mark1,a0
       tst     d7
       beq     HS1a
       lea     Mark2,a0
HS1a:  move    #15,(a0)
       sub.l   #20,a5
       lea     end_ScoreList,a4
HS1:   move.l  -(a5),d0
       cmp.l   d6,d0
       bge     HS3
       subq    #1,(a0)
       move.l  d0,-(a4)
       move.l  #9,d5
HS2:   move    -(a5),-(a4)
       dbra    d5,HS2
       bra     HS1
HS3:   move.l  d6,-(a4)
       addq.l  #4,a5
       move.l  d7,-(sp)
       move.l  a5,-(sp)
       mulu    #29,d7
       addq    #1,d7
       move.l  d7,d1
       move.l  #220,d0
       move.l  #116,d2
       move.l  #20,d3
       move.l  bit3map,a0
       move.l  bit1map,a1
       move.l  #88,d4
       move.l  #28,d5
       move.l  #$c0,d6
       move.l  #$ff,d7
       move.l  gfxbase,a6
       jsr     _LVOBltBitMap(a6)   ;Player 1 or 2, enter your name!
       move    #20,LenStr
       move.l  Rast,a1
       moveq.l #0,d0
       move.l  #65,d1
       jsr     _LVOMove(a6)
       move.l  #end_ScrMsg-ScrMsg,d0
       lea     ScrMsg,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
GetLB: clr     CPos
       sub     #1,LenStr
       moveq.l #0,d0
       move.l  #75,d1
       move.l  Rast,a1
       jsr     _LVOMove(a6)
       move    #'>_',TexBuf
       move.l  Rast,a1
       move.l  #2,d0
       lea     TexBuf,a0
       jsr     _LVOText(a6)
       bsr     FadeIn
       clr     FadeMus
       bsr     DumpMsgs
       move.l  (sp)+,a5
GetL:  clr     d7          ;Enter your name!
       bsr     tloop       ;You're on the list!
       cmp.b   #8,d7
       bne     NotD
       tst     Cpos
       beq     NotD
       subq    #1,Cpos
       move.l  Rast,a1
       move.l  #75,d1
       move    Cpos,d0
       mulu    #8,d0
       addq    #8,d0
       move.l  gfxbase,a6
       jsr     _LVOMove(a6)
       lea     texbuf,a0
       move.l  #2,d0
       move.l  Rast,a1
       move    #'_ ',(a0)
       jsr     _LVOText(a6)
       subq.l  #1,a5
       bra     GetL
NotD:  cmp.b   #13,d7
       beq     DoneName
       cmp.b   #10,d7
       beq     DoneName
       cmp.b   #12,d7     ;Ctrl-L
       bne     NoFC1          ;(No Funny Character #1)
       move    #$99,d7    ;becomes heart symbol
       bra.s   HS4
NoFC1: cmp.b   #6,d7      ;Ctrl-F
       bne     NoFC2
       move    #$9a,d7    ;becomes frown face.
       bra.s   HS4
NoFC2: cmp.b   #18,d7     ;Ctrl-R
       bne     NoFC3
       move    #$9b,d7    ;becomes rolling eyes.
       bra.s   HS4
NoFC3: cmp.b   #2,d7      ;Ctrl-B
       bne     NoFC4
       move    #$98,d7    ;becomes "ball" symbol.
       bra.s   HS4
NoFC4: cmp     #32,d7
       blt     GetL
       cmp     #127,d7
       ble     HS4        ;Used to be blt!
       cmp     #160,d7
       blt     GetL
HS4:   move    LenStr,d0
       cmp     Cpos,d0    ;Not enough room
       blt     GetL
       move.l  gfxbase,a6
       move.l  Rast,a1
       move.l  #75,d1
       move    Cpos,d0
       mulu    #8,d0
       addq    #8,d0
       jsr     _LVOMove(a6)
       move.l  #2,d0
       lea     texbuf,a0
       move.l  Rast,a1
       move.b  #'_',1(a0)
       move.b  d7,(a5)+
       move.b  d7,(a0)
       jsr     _LVOText(a6)
       addq    #1,Cpos
       bra     GetL
DoneName:
 IFEQ REGISTERED,1
       cmp     #20,LenStr
       bgt     INBdsCnt
 ENDIF
       cmp     #20,Cpos
       bge     Dok
       addq    #1,Cpos
       move.b  #32,(a5)+
       bra     DoneName
Dok:   bsr     FadeOut
       bsr     SaveScores
       bsr     ColorOff
       bsr     clrscr
       move.l  (sp)+,d7
       tst     d7
       bne     HiScr
       lea     end_ScoreList,a5
       move.l  -(a5),d0
       move.l  Score2,d6
       move    #1,d7
       cmp.l   d6,d0
       blt     HighScore  ;Enter your name
       bra     HiScr      ;Show HighScore list
DumpMsgs:
       clr.l   PaddleXmod
       clr     JoyFire
       clr     CTcnt
       move.l  windowhd,a0
       move.l  86(a0),a0
       move.l  ExecBase,a6
       jsr     _LVOGetMsg(a6)    ;check for leftover messages.
       tst.l   d0
       beq     _rts           ;No more leftovers, look for real ones.
       move.l  d0,a1
       jsr     _LVOReplyMsg(a6)
       bra     DumpMsgs
Pause:
       move    #1,FadeMus
       tst.l   mts_pause
       bne     ps1
       tst.l   Name_Pause
       beq     nps1      ;No Pause Song?
       move.l  Name_Pause,a0
       tst.b   (a0)
       beq     nps1
ps1:   moveq   #5,d2
       bsr     rnd
       tst     d0
       bne     nps1
       move.l  Name_Pause,d1
       move.l  mts_pause,d5
       bsr     OMed_LoadPlayD1D5
       clr     FadeMus
nps1:  moveq   #0,d6
       move    PauBak,d6
       cmp     #8,d6
       beq.s   noPT1
       move.l  windowhd,a0
       move.l  intbase,a6
       jsr     _LVOClearPointer(a6)  ;mouse pointer appears!
       bra.s   noPT2
noPT1: moveq   #0,d6
noPT2: move.l  d6,-(sp)     ;d6= back or not?
       bsr     FadeOutGrey
       bsr     DumpMsgs
       moveq   #0,d7
       tst.l   (sp)
       beq     ploop
       move.l  intbase,a6
       move.l  screenhd,a0
       jsr     _LVOScreenToBack(a6)
       bra     plpi
ploop:
;       move.l  windowhd,a0
;       move.l  86(a0),a0
;       move.l  ExecBase,a6
;       jsr     _LVOWaitPort(a6)    ;wait for message.
       moveq   #6,d2
       bsr     NewTimM    ;Puts ExecBase in a6.
ploop2:
       bsr     MyReadJoyLoop
       move.l  windowhd,a0
       move.l  86(a0),a0
       move.l  ExecBase,a6
       jsr     _LVOGetMsg(a6)    ;read in the message.
       tst.l   d0
       bne     pReadMsg
       tst     d7
       beq     plpi      ;sorta like Plki?  OH NO!!
       tst.l   (sp)
       beq     plpi      ;It really doesn't stand for anything.
       move.l  intbase,a6
       move.l  screenhd,a0
       jsr     _LVOScreenToFront(a6)
plpi:  tst     UseBallBob
       bne.s   plpi2
       moveq.l #0,d0           ;Affects d0,d1,a0,a1,a6 only.
       moveq.l #0,d1
       move.w  sx,d0
       move.w  sy,d1
       move.l  gfxbase,a6
       move.l  ViewPort,a0
       move.l  ballsp,a1
       jsr     MoveBallSprite  ;Update ball in pause
plpi2: tst     UseLasBobs
       bne.s   plpi3
       moveq.l #0,d0
       moveq.l #0,d1
       move.w  Lasx1,d0
       move.w  Lasy1,d1
       move.l  gfxbase,a6
       move.l  ViewPort,a0
       move.l  Las1SP,a1
       jsr     MoveLas1Sprite  ;Update laser in pause
       moveq.l #0,d0
       moveq.l #0,d1
       move.w  Lasx2,d0
       move.w  Lasy2,d1
       move.l  ViewPort,a0
       move.l  Las2SP,a1
       jsr     MoveLas2Sprite  ;Update other laser in pause
plpi3: tst     d7
       beq     ploop
       bsr     FadeInGrey
       move.l  windowhd,a0
       lea     blkptr,a1
       moveq.l #1,d0
       moveq.l #16,d1
       moveq.l #0,d2
       moveq.l #0,d3
       move.l  intbase,a6
       jsr     _LVOSetPointer(a6)  ;get rid of mouse pointer, again
       addq.l  #4,sp      ;Get that d6 off the stack
       tst     FadeMus
       bne.s   nps2
       bsr     mt_end
       bsr     NextTune
       move    #1,FadeMus
nps2:  bsr     DumpMsgs
       bra     FixPaddle
pReadMsg:
       move.l  d0,a5
       move.l  20(a5),d6
       move.l  d6,d0
       and.l   #$200008,d0    ;User press a key?  (PAUSE MODE)
       tst.l   d0
       beq     pReply
       moveq   #1,d7
pReply:move.l  a5,a1
       jsr     _LVOReplyMsg(a6)
       bra     ploop2
tloop:                       ;Please clear d7 on entry.
       bsr     mt_music
       bsr     NewTim
       bsr     ColorFitch
       bsr     MyReadJoyLoop
tloop2:
       move.l  windowhd,a0
       move.l  86(a0),a0
       move.l  ExecBase,a6
       jsr     _LVOGetMsg(a6)    ;read in the message.
       tst.l   d0
       bne     tReadMsg
       tst     d7
       beq     tloop
       rts
tReadMsg:
       move.l  d0,a1
       move.l  20(a1),d0
       and.l   #$8,d0         ;User press a MB?  (PLAYER 1/2 SCREEN)
       tst.l   d0             ;   Scores screen, TiredText, etc.
       beq     tKey
       moveq   #1,d7
       bra     tReply
tKey:  move.l  20(a1),d0
       and.l   #$200000,d0    ;or a key?
       tst.l   d0
       beq     tReply
       move.b  25(a1),d7
tReply:jsr     _LVOReplyMsg(a6)
       bra     tloop2
ReadMsg:
       move.l  d0,a5
       move.l  20(a5),d6
       and.l   #$10,d6      ;MOUSEMOVE
       tst.l   d6
       beq     NOpxm
       move    PaddleXmod,d6
       add.w   32(a5),d6
       move    d6,PaddleXmod
NOpxm: move.l  20(a5),d6
       move.l  d6,d0
       and.l   #$200000,d0    ;User press a key?  (DURING GAME)
       tst.l   d0
       beq     NotClose
       move.b  25(a5),d0
       cmp.b   #'Q',d0        ;Was it, 'Q'?
       bne     NotQ
       bset    #1,d7
       bra     Reply
NotQ:  cmp.b   #'S',d0        ;Was it, 'S'?
       bne     NotS
       bsr     ToggleBallBob
       bra     Reply
NotS:  cmp.b   #'L',d0        ;Was it, 'L'?
       bne     NotL
       bsr     ToggleLasBobs
       bra     Reply
NotL:  cmp.b   #$A9,d0        ;Was it the cheat key?   ;->
       bne     NotC1                     ;(shhh!)
       clr.l   Score
       move    #1,You_Cheated
       move    PaddleX,cylx
       add     #12,cylx
       move    #175,cyly
       move.b  #3,cyln
       bra     Reply
NotC1: cmp.b   #$B6,d0        ;Was it the OTHER cheat key??
       bne     NotC2                       ; 8->    (!!)
       clr.l   Score
       move    #1,You_Cheated
       move    #1,Got_Laser
       move    #1,Got_Brick
       move    #1,Got_Catch
       clr     Got_Down
       clr     Got_Grav
       clr     You_Looped
       move    PaddleX,cylx
       add     #12,cylx
       move    #175,cyly
       move.b  #10,cyln
       bra     Reply
NotC2: cmp.b   #$b0,d0        ;Was it the NEW THIRD cheat key??
       bne     NotC2b                      ; 8-)) !!!!
       clr.l   Score
       move    #1,You_Cheated
       bra     WarpAnywhere
NotC2b:cmp.b   #$A5,d0        ;Was it the new FOURTH cheat key??
       bne     NotC2d
       tst     You_Cheated
       beq     NotC2d
       cmp     #16,LivesLeft
       bge     NotC2d
       clr     LifePts
       move.l  #20000,Score
       movem.l a5/d7,-(sp)
       bsr     ShowScore
       movem.l (sp)+,a5/d7
       bra     Reply
NotC2d:cmp.b   #'?',d0        ;Was it QuestionMark?
       bne     NotC2c         ;(Formerly Alt-M).
       movem.l a5/d7,-(sp)
       tst     ScoreShowing
       beq     C2c
       move.l  Rast,a1
       move.l  #20,d0
       move.l  #6,d1
       move.l  gfxbase,a6
       jsr     _LVOMove(a6)
       move.l  #36,d0   ;len
       lea     MusName,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)  ;Show music name
       clr     ScoreShowing
       bra.s   C2c2
C2c:   bsr     ShowScore
C2c2:  movem.l (sp)+,a5/d7
       bra     Reply
NotC2c:cmp.b   #27,d0         ;Was it ESC?
       bne     NotC3
       bset    #3,d7
       clr     PauBak
       bra     Reply
NotC3: cmp.b   #$7f,d0        ;Was it DEL?
       bne     NotC4
       bset    #4,d7
       bra     Reply
NotC4: or.b    #'a'-'A',d0    ;Was it 'b' or 'B'?    (back)
       cmp.b   #'b',d0
       bne     NotC5
       move    #1,PauBak
       bset    #3,d7
       bra     Reply
NotC5: cmp.b   #'p',d0        ;Was it 'p' or 'P'?
       bne     NotC7
       clr     PauBak
       bset    #3,d7
       bra     Reply
NotC7: cmp.b   #'m',d0
       bne     NotClose
       tst     Mus_Play
       beq     C8a
       bsr     mt_end
       clr     Music
       bra     Reply
C8a:   move    #1,Music
       bsr     NextTune
       bra     Reply
NotClose:
       move.l  d6,d0
       and.l   #$80000,d0
       tst.l   d0
       beq     NotInAct
       bset    #3,d7
       clr     PauBak
NotInAct:
       move.l  d6,d0
       and.l   #$100010,d0
       tst.l   d0
       beq     NotFix
       bset    #2,d7
NotFix:
       move.l  d6,d0
       and.l   #$8,d0
       tst.l   d0
       beq     Reply
       bsr     LetGo
       bra     Reply

LetGo:
       clr     Loopie
       cmp.w   #-1,Stuck
       beq     NotStk
       move    d0,-(sp)
       move    #8,d0
       bsr     playme      ;release the ball from paddle
       move    (sp)+,d0
       move.w  #-1,Stuck
NotStk:bset    #2,d7
       tst     Got_Laser
       beq     _rts
       movem.l d0-a6,-(sp)
       clr     d7
       tst     Lasy1
       bge     NoL1
       moveq.l #0,d0
       move    #7,d7
       move.w  PaddleX,d0
       subq.w  #1,d0
       move.l  #181,d1
       move.l  gfxbase,a6
       move.l  ViewPort,a0
       move.l  Las1SP,a1
       jsr     MoveLas1Sprite  ;shoot that laser!
NoL1:  tst     Lasy2
       bge     NoL2
       moveq.l #0,d0
       move    #7,d7
       move.w  PaddleX,d0
       add.w   Paddle_Size,d0
       subq.w  #4,d0
       move.l  #181,d1
       move.l  gfxbase,a6
       move.l  ViewPort,a0
       move.l  Las2SP,a1
       jsr     MoveLas2Sprite  ;shoot that other laser!
NoL2:  tst     d7
       beq     NoL12
       tst     Got_Brick
       bne     Hefty      ;Sound effect for laser depends on
       move    #10,d7     ;Brickthrough or not
Hefty: move    d7,d0          ;Hefty Hefty Hefty! Wimpy Wimpy Wimpy!!
       bsr     playme
NoL12: movem.l (sp)+,d0-a6
       rts

IsD1Gold:
       cmp.b   #5,d1
       beq.s   id1gr
       cmp.b   #41,d1  ;red gold
       beq.s   id1gr
       cmp.b   #47,d1  ;green gold
       beq.s   id1gr
       cmp.b   #43,d1  ;blue gold
id1gr: rts

beurgDone:
       cmp.l   Score,d0
       beq     _rts       ;No score change - no action.
       move    #17,d0
       add.w   #10,ExpBrickPeriod
       cmp     #856,ExpBrickPeriod
       ble     bgDn1
       move    #856,ExpBrickPeriod
bgDn1: add.w   #1,ExpBrickVoice
       and.w   #3,ExpBrickVoice
       bsr     playme

; bsr ShowScore   ;uncomment this to debug explosions/slime.
; moveq #0,d7
; bsr tloop
; rts

       bra     ShowScore  ;and don't come back!

b7d:   divu    #20,d3
       move.l  d3,d2
       swap    d2
       move    d2,a5      ;a5 is a return value showing block x-coord.
       bra     b7c

; Do the anim of the exploding bricks.
; Don't save any registers.
BlowEmUpRealGood:
       move.l  Score,-(sp)
       lea     BlockCoords,a4      ;a4 = block coords
       move.l  gfxbase,a6          ;a5 is used by beurg7 as ddx return.
       move    #$c0,d6
       move    #$ff,d7
       move.l  CurBrdPtr,a3        ;a3 = pointer to board
       lea     ExplodingBits,a2    ;a2 = pointer to bitmap of Exploding blocks
       moveq   #31,d4
       moveq   #0,d3     ;d3 = block #
beurg1:move.l  (a2)+,d2  ;d2 = bitmap of Exploding blocks
       bne.s   beurg2
       add     #32,d3
beurg5:cmp     #420,d3
       blt.s   beurg1
       move.l  (sp)+,d0  ;leave with original score in d0 for beurgDone.
       bra     beurgDone
beurg2:btst    #31,d2    ;on entry, d4 = #31.  Used as bit counter.
       bne.s   beurg4
beurg3:addq    #1,d3
       add.l   d2,d2     ;Faster than lsl.l #1,d2??
       dbra    d4,beurg2
       moveq   #31,d4
       bra.s   beurg5
beurg4:                        ;a3 = CurBrdPtr
       moveq   #0,d0           ;d3 = offset into board
       move.b  (a3,d3),d0      ;d0 = brick
       cmp.b   #TheExplodingKind,d0
       beq     beurg8          ;poof the ones around this one.
       cmp.b   #TheExplodingKind+19,d0
       beq     blue8           ;poof the ones around this one.
       cmp.b   #TheExplodingKind+38,d0
       beq     gold8           ;poof the ones around this one.
       cmp.b   #TheExplodingKind+57,d0
       beq     slime8          ;poof the ones around this one.
       cmp.b   #TheExplodingKind+17,d0   ;from earlier this pass...
       bne.s   b4c
       moveq   #TheExplodingKind,d0
b4c:   cmp.b   #TheExplodingKind+18,d0
       bne.s   b4d
       moveq   #TheExplodingKind-1,d0
b4d:   cmp.b   #TheExplodingKind+36,d0   ;from earlier this pass...
       bne.s   b4e
       moveq   #TheExplodingKind+19,d0
b4e:   cmp.b   #TheExplodingKind+37,d0
       bne.s   b4f
       moveq   #TheExplodingKind+18,d0
b4f:   cmp.b   #TheExplodingKind+55,d0   ;from earlier this pass...
       bne.s   b4g
       moveq   #TheExplodingKind+38,d0
b4g:   cmp.b   #TheExplodingKind+56,d0
       bne.s   b4h
       moveq   #TheExplodingKind+37,d0
b4h:   cmp.b   #TheExplodingKind+74,d0   ;from earlier this pass...
       bne.s   b4a
       move    #TheExplodingKind+57,d0
b4a:   cmp.b   #TheExplodingKind+75,d0
       bne.s   b4b
       move    #TheExplodingKind+56,d0
b4b:   addq    #1,d0           ;Increase the explosion
       cmp.b   #TheExplodingKind+55,d0
       beq.s   bEnd3
       cmp.b   #TheExplodingKind+74,d0
       beq.s   bEnd4
       cmp.b   #TheExplodingKind+36,d0
       bne.s   bEnd1
       moveq   #1,d0           ;This brick is toast (looped to 1).
       bra.s   bEnd2
bEnd4: move    SlimeMorph,d0   ;This slime has slimed.
       beq.s   bEnd3
       bra.s   bEnd2
bEnd1: cmp     EndExploder,d0
       bne.s   beurg6
bEnd3: moveq   #0,d0           ;This brick is toast (looped to 0).
       sub.w   #1,BlocksLeft
bEnd2: lea     ExplodingBits,a0
       move.l  d3,d5
       lsr     #3,d5
       add.l   d5,a0
       move    #$80,d1         ;Compute exploding bit.
       move.l  d3,d5
       and     #7,d5
       lsr     d5,d1
       not     d1
       and.b   d1,(a0)         ;Erase its exploding bit.
beurg6:bsr.s   beurg7
       bra     beurg3
beurg7:move.b  d0,(a3,d3)   ;Subroutine to put d0 on screen in location d3.
       movem.l d2-d4,-(sp)
       and.l   #$ff,d0
       move.l  d0,d2
       sub     #TheExplodingKind,d2
       ble.s   b7b
       divu    #19,d2
       swap    d2
       tst     d2
       beq.s   b7b
       cmp     #17,d2
       bge     b7d
       btst    #0,d2
       beq     b7d

b7b:   lsl     #2,d0
       move.l  (a4,d0),d0      ;Get source x/y
       move.l  d0,d1
       swap    d0

       divu    #20,d3          ;compute ddx and ddy
       move.l  d3,d2
       swap    d2
       move    d2,a5           ;a5 is a return value showing block x-coord.
;       mulu    #15,d2    ;To multiply d2 by 15,
       move    d2,d4
       lsl     #4,d2      ;shift left 4 (*16)
       sub     d4,d2      ;and subtract the original value.
       add     #10,d2
;       mulu    #7,d3     ;To multiply d3 by 7,
       move    d3,d4
       lsl     #3,d3      ;shift left 3 (*8)
       sub     d4,d3      ;and subtract the original value.
       addq    #8,d3
       move.l  bit2map,a0
       move.l  bit1map,a1
       moveq   #15,d4
       moveq   #7,d5
       bsr     HideBobsHere
       move    #$ff,d7  ;OS bug, DUH!
       jsr     _LVOBltBitMap(a6)  ;Make that brick EXPLODE!!
b7c:   movem.l (sp)+,d2-d4
       rts
beurg8:moveq   #TheExplodingKind+2,d0
       bsr     beurg7          ;This is a bomb brick,
       move.w  d3,-(sp)        ;the ones around it are getting toasty!
       move.w  a5,-(sp)        ;*Push* brick's X position.
       sub     #20,d3
       bsr.s   beurgA          ;beurgA makes brick into normal exploder.
       add     #40,d3
       moveq   #11,d5          ;d5 holds would-be bit# of d2 (for beurgB).
       bsr     beurgB          ;beurgB is "future exploding brick".
       tst.w   (sp)    ;left side?
       beq.s   beurg9
       sub     #41,d3
       bsr.s   beurgA
       add     #20,d3
       bsr.s   beurgA
       add     #20,d3
       moveq   #12,d5
       bsr     beurgB
       addq    #1,d3
beurg9:cmp.w   #19,(sp)+  ;right side?    *pop*
       beq.s   beurgC
       sub     #39,d3
       bsr.s   beurgA
       add     #20,d3
       moveq   #30,d5
       bsr.s   beurgB
       add     #20,d3
       moveq   #10,d5
       bsr.s   beurgB
beurgC:move    (sp)+,d3
       bra     beurg3
beurgA:moveq   #0,d1
       move.b  (a3,d3),d1      ;Past block.  What is it?
       beq.s   b_rts
       cmp.b   #TheExplodingKind,d1
       bhs.s   b_rts
       lea     PastTransform,a0
       moveq   #0,d0
       move.b  (a0,d1),d0
       bne.s   bA2
       moveq   #TheExplodingKind+1,d0
bA2:   bsr     IsD1Gold        ;It explodes.
       bne.s   bA1
       add.w   #1,BlocksLeft   ;Gold adds one to BlocksLeft.
bA1:   lea     ExplodingBits,a0
       move.l  d3,d5
       lsr     #3,d5
       add.l   d5,a0
       move    #$80,d1         ;Compute exploding bit.
       move.l  d3,d5
       and     #7,d5
       lsr     d5,d1
       or.b    d1,(a0)         ;Set its exploding bit.
       add.l   #4,Score
       bra     beurg7          ;Go there and don't come back!
b_rts: rts
beurgB:moveq   #0,d1
       move.b  (a3,d3),d1      ;Future block.  What is it?
       beq.s   b_rts
       cmp.b   #TheExplodingKind,d1
       bhs.s   b_rts
       bset    d5,d2           ;d5 was passed into beurgB.
       lea     FutureTransform,a0
       moveq   #0,d0
       move.b  (a0,d1),d0
       bne.s   bA2
       moveq   #TheExplodingKind+17,d0
       bra.s   bA2

blue8: moveq   #TheExplodingKind+21,d0
       bsr     beurg7          ;This is a blue bomb brick,
       move.w  d3,-(sp)        ;the ones around it are getting toasty!
       move.w  a5,-(sp)        ;*Push* brick's X position.
       sub     #20,d3
       bsr.s   blueA           ;blueA makes brick into normal exploder.
       add     #40,d3
       moveq   #11,d5          ;d5 holds would-be bit# of d2 (for blueB).
       bsr     blueB           ;blueB is "future exploding brick".
       tst.w   (sp)    ;left side?
       beq.s   blue9
       sub     #41,d3
       bsr.s   blueA
       add     #20,d3
       bsr.s   blueA
       add     #20,d3
       moveq   #12,d5
       bsr     blueB
       addq    #1,d3
blue9: cmp.w   #19,(sp)+  ;right side?    *pop*
       beq.s   blueC
       sub     #39,d3
       bsr.s   blueA
       add     #20,d3
       moveq   #30,d5
       bsr.s   blueB
       add     #20,d3
       moveq   #10,d5
       bsr.s   blueB
blueC: move    (sp)+,d3
       bra     beurg3
blueA: cmp     #20,d3
       blt.s   bl_rts
       cmp     #420,d3
       bge.s   bl_rts
       moveq   #0,d1
       move.b  (a3,d3),d1      ;Past block.  What is it?
       cmp.b   #TheExplodingKind,d1
       bhs.s   bl_rts
       lea     PastTransform,a0
       moveq   #0,d0
       move.b  (a0,d1),d0
       bne.s   blA3
       moveq   #TheExplodingKind+20,d0
blA3:  tst.b   d1
       bne.s   blA4
       add.w   #1,BlocksLeft   ;Zero adds one to BlocksLeft.
blA4:  bsr     IsD1Gold        ;It explodes.
       bne.s   blA1
       add.w   #1,BlocksLeft   ;Gold adds one to BlocksLeft.
blA1:  lea     ExplodingBits,a0
       move.l  d3,d5
       lsr     #3,d5
       add.l   d5,a0
       move    #$80,d1         ;Compute exploding bit.
       move.l  d3,d5
       and     #7,d5
       lsr     d5,d1
       or.b    d1,(a0)         ;Set its exploding bit.
       add.l   #4,Score
       bra     beurg7          ;Go there and don't come back!
bl_rts:rts
blueB: cmp     #20,d3
       blt.s   bl_rts
       cmp     #420,d3
       bge.s   bl_rts
       moveq   #0,d1
       move.b  (a3,d3),d1      ;Future block.  What is it?
       cmp.b   #TheExplodingKind,d1
       bhs.s   bl_rts
       bset    d5,d2           ;d5 was passed into blueB.
       lea     FutureTransform,a0
       moveq   #0,d0
       move.b  (a0,d1),d0
       bne.s   blA3
       moveq   #TheExplodingKind+36,d0
       bra.s   blA3

gold8: moveq   #TheExplodingKind+40,d0
       bsr     beurg7          ;This is a gold bomb brick,
       move.w  d3,-(sp)        ;the ones around it are getting toasty!
       move.w  a5,-(sp)        ;*Push* brick's X position.
       sub     #20,d3
       bsr.s   goldA           ;goldA makes brick into normal exploder.
       add     #40,d3
       moveq   #11,d5          ;d5 holds would-be bit# of d2 (for goldB).
       bsr     goldB           ;goldB is "future exploding brick".
       tst.w   (sp)    ;left side?
       beq.s   gold9
       sub     #41,d3
       bsr.s   goldA
       add     #20,d3
       bsr.s   goldA
       add     #20,d3
       moveq   #12,d5
       bsr     goldB
       addq    #1,d3
gold9: cmp.w   #19,(sp)+  ;right side?    *pop*
       beq.s   goldC
       sub     #39,d3
       bsr.s   goldA
       add     #20,d3
       moveq   #30,d5
       bsr.s   goldB
       add     #20,d3
       moveq   #10,d5
       bsr.s   goldB
goldC: move    (sp)+,d3
       bra     beurg3
goldA: moveq   #0,d1
       move.b  (a3,d3),d1      ;Past block.  What is it?
       cmp.b   #TheExplodingKind,d1
       bhs.s   bg_rts
       cmp.b   #5,d1    ;gold destroyer only gets true gold.
       bne.s   bgA2
       moveq   #46,d1   ;gold destroyer
       add.w   #1,BlocksLeft
bgA2:  lea     PastTransform,a0
       moveq   #0,d0
       move.b  (a0,d1),d0
       beq.s   bg_rts
bgA1:  lea     ExplodingBits,a0
       move.l  d3,d5
       lsr     #3,d5
       add.l   d5,a0
       move    #$80,d1         ;Compute exploding bit.
       move.l  d3,d5
       and     #7,d5
       lsr     d5,d1
       or.b    d1,(a0)         ;Set its exploding bit.
       add.l   #4,Score
       bra     beurg7          ;Go there and don't come back!
bg_rts:rts
goldB: moveq   #0,d1
       move.b  (a3,d3),d1      ;Future block.  What is it?
       cmp.b   #TheExplodingKind,d1
       bhs.s   bg_rts
       cmp.b   #5,d1    ;gold destroyer only gets true gold
       bne.s   bgB2
       moveq   #46,d1   ;gold destroyer
       add.w   #1,BlocksLeft
bgB2:  lea     FutureTransform,a0
       moveq   #0,d0
       move.b  (a0,d1),d0
       beq.s   bg_rts
       bset    d5,d2           ;d5 was passed into goldB.
       bra.s   bgA1

slime8:move    #TheExplodingKind+59,d0
       bsr     beurg7          ;This is a slime brick,
       move.w  d3,-(sp)        ;the ones around it are getting slimey!
       move.w  a5,-(sp)        ;*Push* brick's X position.
       sub     #20,d3
       bsr.s   slimeA          ;slimeA makes brick into normal exploder.
       add     #40,d3
       moveq   #11,d5          ;d5 holds would-be bit# of d2 (for slimeB).
       bsr     slimeB          ;slimeB is "future slimeing brick".
       tst.w   (sp)    ;left side?
       beq.s   slime9
       sub     #41,d3
       bsr.s   slimeA
       add     #20,d3
       bsr.s   slimeA
       add     #20,d3
       moveq   #12,d5
       bsr     slimeB
       addq    #1,d3
slime9:cmp.w   #19,(sp)+  ;right side?    *pop*
       beq.s   slimeC
       sub     #39,d3
       bsr.s   slimeA
       add     #20,d3
       moveq   #30,d5
       bsr.s   slimeB
       add     #20,d3
       moveq   #10,d5
       bsr.s   slimeB
slimeC:move    (sp)+,d3
       bra     beurg3
slimeA:move.b  (a3,d3),d1      ;Past block.  What is it?
       cmp.b   #37,d1
       blt.s   bs_rts
       cmp.b   #40,d1          ;slime only slimes slime.
       bgt.s   bs_rts
       move    #TheExplodingKind+57,d0
bsA1:  lea     ExplodingBits,a0
       move.l  d3,d5
       lsr     #3,d5
       add.l   d5,a0
       move    #$80,d1         ;Compute exploding bit.
       move.l  d3,d5
       and     #7,d5
       lsr     d5,d1
       or.b    d1,(a0)         ;Set its exploding bit.
       add.l   #4,Score
       bra     beurg7          ;Go there and don't come back!
bs_rts:rts
slimeB:move.b  (a3,d3),d1      ;Future block.  What is it?
       cmp.b   #37,d1
       blt.s   bs_rts
       cmp.b   #40,d1          ;slime only slimes slime.
       bgt.s   bs_rts
       move    #TheExplodingKind+75,d0
       bset    d5,d2           ;d5 was passed into slimeB.
       bra.s   bsA1

; Test for Green Slime
PeekSlime:
       cmp.b   #37,d5
       blt.s   ps_no
       cmp.b   #40,d5
       bgt.s   ps_no
       moveq   #0,d4   ;Equal slime
       rts
ps_no: moveq   #1,d4   ;Not equal slime
       rts

; This subroutine grows some green slime!!
GrowSlime:
       move.l  #399,d2
       bsr     rnd
       add     #20,d0
       and.l   #$ffff,d0
       move.l  d0,d1
       divu    #20,d1
       swap    d1
       move.l  CurBrdPtr,a2
       add.l   d0,a2
       moveq   #0,d5
       move.b  (a2),d5
       bsr     PeekSlime
       beq.s   GS2b
       move.b  -20(a2),d5    ;Check above
       bsr     PeekSlime
       beq.s   GS2
       move.b  20(a2),d5     ;Check below
       bsr     PeekSlime
       beq.s   GS2
       tst     d1
       beq.s   GS3
       move.b  -1(a2),d5     ;Check left
       bsr     PeekSlime
       beq.s   GS2
GS3:   cmp     #19,d1
       beq.s   GS1
       move.b  1(a2),d5      ;Check right
       bsr     PeekSlime
       beq.s   GS2
GS1:   rts
GS2b:  sub.w   #1,BlocksLeft  ;morph current slime brick
       clr.b   (a2)
GS2:   moveq   #0,d2          ;make new slime brick
       move.b  (a2),d2
       bne     GS4
       move.l  d1,d5
       move.l  d2,d4
       moveq   #3,d2
       bsr     rnd      ;Pick any of the slime bricks.
       add     #37,d0
       move.l  d4,d2
       move.l  d5,d1
       add.w   #1,BlocksLeft
GS5:   move.b  d0,(a2)
       moveq   #15,d2
       moveq   #7,d3
       mulu    d1,d2
       swap    d1
       mulu    d1,d3
       add     #10,d2
       add     #8,d3
       lsl     #2,d0
       lea     BlockCoords,a0
       move.w  2(a0,d0.w),d1
       move.w  0(a0,d0.w),d0
       move.l  bit2map,a0
       move.l  bit1map,a1
       move.w  #15,d4
       move.w  #7,d5
       bsr     HideBobs
       move.l  #$c0,d6
       move.l  #$ff,d7
       move.l  gfxbase,a6
       jsr     _LVOBltBitMap(a6)  ;He slimed me!!
       bra     GS1
GS4:   cmp.b   #5,d2     ;Trying to move onto occoupied brick
       beq     GS1       ;...maybe set off slime chain reaction?
       cmp.b   #11,d2
       beq     GS1
       cmp.b   #41,d2  ;red gold
       beq     GS1
       cmp.b   #47,d2  ;green gold
       beq     GS1
       cmp.b   #43,d2  ;blue gold
       beq     GS1
       cmp.b   #TheExplodingKind,d2
       bhs     GS1
       move    d2,SlimeMorph    ;Thar she blows!!
       move.l  d0,-(sp)   ;Push offset
       lea     ExplodingBits,a3
       move    #$80,d3
       and     #7,d0
       lsr     d0,d3
       move.l  (sp)+,d0   ;Pop offset
       lsr     #3,d0
       or.b    d3,(a3,d0) ;Write to the ExplodingBits
       move.w  ExpBrickPeriodSave,ExpBrickPeriod
       add.w   #1,ExpBrickVoice
       and.w   #3,ExpBrickVoice
       moveq   #17,d0
       bsr     playme
       move    #TheExplodingKind+57,d0
       bra     GS5

MoveBall:
       cmp.w   #-1,Stuck
       bne     ok5
       moveq.l #0,d0
       moveq.l #0,d1
       move.w  sx,d0
       move.w  sy,d1
       move.w  cx,d2
       subq.w  #1,d2
       move.w  d2,cx
       tst.w   d2
       bne     ok2
       add.w   dx,d0
       move.w  spx,cx
       cmp     #-1,Got_Grav
       bne     NoMag
       movem.l d0-d1,-(sp)   ;silly magnetism math
       move.w  #15,d0
       muls    #14,d1        ;(needs a lot of work, probably)
       divs    #200,d1
       sub     d1,d0         ;(follows no laws of physics!)
       move    d0,cx
       movem.l (sp)+,d0-d1
NoMag: moveq.l #0,d4
       bsr     CheckBlock  ;did I hit something?  Duh...
       bne     Nok3
       cmp.w   #10,d0
       bgt     ok1
       move.w  #1,dx
       move    d0,-(sp)
       move    #9,d0
       bsr     playme
       move    (sp)+,d0
ok1:   cmp.w   #305,d0
       blt     ok2
       move    d0,-(sp)
       move    #9,d0
       bsr     playme
       move    (sp)+,d0
       move.w  #-1,dx
       bra     ok2
Nok3:  move.w  sx,d0
       neg.w   dx
ok2:   move.w  cy,d2
       subq.w  #1,d2
       move.w  d2,cy
       tst.w   d2
       bne     ok4
       add.w   dy,d1
       cmp     #1,Got_Grav
       bne     NoGrv
       movem.l d0-d1,-(sp)   ;silly gravity math
       move.w  #15,d0
       muls    #14,d1        ;(needs a lot of work, probably)
       divs    #200,d1
       sub     d1,d0         ;(follows no laws of physics!)
       move    d0,cy
       movem.l (sp)+,d0-d1
       bra     Grv
NoGrv: move.w  spy,cy
Grv:   moveq.l #0,d4
       addq    #1,d4
       bsr     CheckBlock
       bne     Nok4
       tst.w   d1
       bgt     ok3
       move    d0,-(sp)
       move    #9,d0
       bsr     playme
       move    (sp)+,d0
       move.w  #1,dy
       bra     ok3
Nok4:  move.w  sy,d1
       neg.w   dy
ok3:   cmp.w   #186,d1
       bge     chkx
ok3b:  cmp.w   #206,d1  ;Death height bumped from 196 to 206.
       blt     ok4
;       move.w  #-1,dy  ;Why turn around?  You're dead already.
       move.l  #1,d6
ok4:   move.w  d0,sx
       move.w  d1,sy
ok5:   rts
UpDateBall:
       moveq.l #0,d0
       moveq.l #0,d1
       move.w  sx,d0
       move.w  sy,d1
       move.l  gfxbase,a6
       move.l  ViewPort,a0
       move.l  ballsp,a1
       jsr     MoveBallSprite  ;show ball's new position
       rts
Reply:
       move.l  a5,a1
       move.l  ExecBase,a6
       jsr     _LVOReplyMsg(a6)
       bra     Loop2
chkx:
       cmp.w   #198,d1     ;underneath-paddle height
       bge     ok3b
       cmp.w   PaddleX,d0
       blt     ok3b
       moveq.l #0,d2
       move.w  PaddleX,d2
       add.w   Paddle_Size,d2
       subq.w  #1,d2
       cmp.w   d2,d0
       bgt     ok3b
       move.w  dy,d2
       tst     d2
       ble     ok3b    ;Paddle: Don't bounce ball down!
       neg.w   dy
       move.w  d0,d2
       clr     Loopie
       sub.w   PaddleX,d2
       tst     Got_Catch
       beq     NoCat
       move.l  d0,-(sp)
       clr     d0
       bsr     playme
       move.l  (sp)+,d0
       move.w  d2,Stuck       ;Catch feature.  Play the catch sound!
       tst     Got_Down
       beq     NoCatb
       movem.l d0-a6,-(sp)    ;SAVE REGS
       move    dx,-(sp)
       move    dy,-(sp)       ;This is the Quicksand code.
       moveq.l #0,d0
       moveq.l #19,d1
       move.l  End_Board,a0
       move.l  a0,a1
       move.l  a2,-(sp)
       lea     end_QSandBuf,a2
dAddUp:move.b  -(a0),-(a2)
       dbra    d1,dAddUp
;dAddUp:add.b   -(a0),d0
;       dbra    d1,dAddUp
;       tst     d0
;       bne     NoCatc
       move.l  #399,d1
dDown: subq.l  #1,a1
       move.b  -(a0),-(a2)
       tst.b   (a0)        ;If Source = empty, don't flop.
       beq     dDw2
       cmp.b   #TheExplodingKind,(a0)  ;If Source is exploding, don't flop.
       bhs     dDw2
       cmp.b   #5,(a1)     ;If Dest = gold, DO flop!
       beq     dDw3
       tst.b   (a1)        ;If Dest = empty, DO flop!
       beq     dDw3
       cmp.b   #41,(a1)    ;If Dest = red gold, DO flop!
       beq     dDw3
       cmp.b   #47,(a1)    ;If Dest = green gold, DO flop!
       beq     dDw3
       cmp.b   #43,(a1)    ;If Dest = blue gold, DO flop!
       beq     dDw3
       cmp.b   #11,(a1)    ;If Dest != empty|gold|1-hit inde, don't flop.
       bne     dDw2
       move.b  #2,(a1)     ;Dest: 1-hit inde ==> normal green block.
       bra     dDw2        ;no flopping of course.
dDw3:  move.b  (a0),(a1)
       clr.b   (a0)
       moveq   #1,d0
dDw2:  dbra    d1,dDown
       tst     d0
       beq     NoCaa2
       move.l  CurBrdPtr,a5
       add.l   #20,a5
       moveq.l #0,d0
       moveq.l #0,d1
       moveq.l #0,d2
       moveq.l #0,d3
       moveq.l #0,d5
       move.l  gfxbase,a6
       move.w  #10,dx
       move.w  #15,dy
       lea     QSandBuf+20,a2
dNextBlock:
       moveq.l #0,d4
       move.b  (a5)+,d4
;       move.b  19(a5),d0
;       or.b    d4,d0
;       tst     d0
       cmp.b   (a2)+,d4
       beq     SkipIt
       lsl     #2,d4
       lea     BlockCoords,a0
       move.w  0(a0,d4),d0
       move.w  2(a0,d4),d1
       move.w  dx,d2
       move.w  dy,d3
       move.l  bit2map,a0
       move.l  bit1map,a1
       move.w  #15,d4
       move.w  #7,d5
       move.l  #$c0,d6
       move.l  #$ff,d7
       jsr     _LVOBltBitMap(a6)  ;get them blocks on there
SkipIt:move.w  dx,d2
       add.w   #15,d2
       cmp.w   #310,d2
       blt     dBdxOK
       move.w  #10,d2
       addq.w  #7,dy
dBdxOK:move.w  d2,dx
       cmp.l   End_Board,a5
       bne     dNextBlock
NoCaa2:move.l  (sp)+,a2
NoCatc:move    (sp)+,dy
       move    (sp)+,dx
       movem.l (sp)+,d0-a6    ;RESTORE REGS
       bra     NoCatb
NoCat: move.l  d0,-(sp)
       move    #8,d0
       bsr     playme         ;Play the "Bonk" sound if you
       move.l  (sp)+,d0       ;can't catch the ball.
NoCatb:moveq.l #0,d3
       move.w  Paddle_size,d3
       lsr.l   #1,d3
       sub.w   d3,d2
       tst     d2
       bge     NoExt
       swap    d2
       move    #$ffff,d2
       swap    d2
NoExt: cmp     #1,Got_Expand
       bne     NoE3
       divs    #2,d2
NoE3:  cmp     #2,Got_Expand
       bne     NoE4
       divs    #4,d2
NoE4:  move.w  #1,dx
       tst.w   d2
       bge     NoAbs
       neg.w   d2
       neg.w   dx
NoAbs: and.l   #$ffff,d2
       moveq.l #0,d3
       mulu    #3,d2
       divu    #5,d2
       move.w  #12,d3
       sub.w   d2,d3
       cmp.w   #3,d2
       bge     Notd20
       move.w  #3,d2
Notd20:move.w  d2,spy
       cmp.w   #2,d3
       bge     Notd30
       move.w  #2,d3
Notd30:move.w  d3,spx
       bra     ok4

; Trigger special gold bricks.  d3 == brick num
Trigger_gold:
       bsr     HideBobs
       movem.l d0-a6,-(sp)
       move.l  d3,a4
       moveq.l #10,d6
       moveq.l #8,d7
       move.l  CurBrdPtr,a3
TSG2:  moveq.l #0,d3
       move.b  (a3),d3
       move    a4,d0
       cmp.b   d0,d3
       bne     TSGnxt
       moveq   #0,d3
       move.b  d3,(a3)
       lsl     #2,d3
       lea     BlockCoords,a0
       move.w  0(a0,d3),d0
       move.w  2(a0,d3),d1
       move.l  d6,d2
       move.l  d7,d3
       move.l  bit2map,a0
       move.l  bit1map,a1
       move.w  #15,d4
       move.w  #7,d5
       move.l  #$c0,d6
       move.l  #$ff,d7
       move.l  gfxbase,a6
       jsr     _LVOBltBitMap(a6)  ;remove special gold blocks
       move.l  d2,d6
       move.l  d3,d7
TSGnxt:add.w   #15,d6
       addq.l  #1,a3
       cmp.w   #310,d6
       blt.s   TSG5
       moveq   #10,d6
       addq.w  #7,d7
TSG5:  cmp.w   #155,d7
       blt     TSG2
       movem.l (sp)+,d0-a6
       rts

CheckBlock:           ;Check if ball or laser hit something.
       move    #1,mLoopie
       moveq.l #0,d2
       moveq.l #0,d3
       move.w  d0,d2  ;d0,d1 are basically sx and sy
       move.w  d1,d3
       tst     d4
       bne     FB1
       cmp.w   #1,dx
       bne     FB2b
       addq.w  #3,d2
       bra     FB2b
FB1:   cmp.w   #1,dy
       bne     FB2b
       addq.w  #3,d3
       bra     FB2b
FB2:   clr     mLoopie  ;Laser hit starts here.
FB2b:  cmp.w   #155,d3
       bge     ok8
       cmp.w   #8,d3
       blt     ok8
       sub     #10,d2
       divu    #15,d2
       ext.l   d2
       move.w  d2,ddx
       subq.w  #8,d3
       divu    #7,d3
       move.w  d3,ddy   ;ddx and ddy are the block's coords
       mulu    #20,d3
       add.l   d3,d2    ;d2 becomes offset into board (0 - 419)
       move.l  CurBrdPtr,a3
       moveq.l #0,d3
       move.b  (a3,d2),d3
       tst.b   d3
       beq     _rts    ;Nothing here!  Just get to an RTS, any RTS.

       cmp.b   #41,d3  ;red gold
       beq     HackKludgeGold
       cmp.b   #47,d3  ;green gold
       beq     HackKludgeGold
       cmp.b   #43,d3  ;blue gold
       bne     DontHackKludgeGold
HackKludgeGold:
       moveq   #5,d3
DontHackKludgeGold:

       cmp.b   #12,d3  ;An AGA block?
       blo     OldBlk
       cmp.b   #TheExplodingKind,d3
       bhs     ok8     ;Don't hit the exploding ones....
       cmp.b   #36,d3  ;Blue exploder?
       bne.s   NoBlu
       move.l  #TheExplodingKind+18,-(sp)
       bra.s   Kaboom
NoBlu: cmp.b   #46,d3  ;Gold exploder?
       bne.s   NoGld
       move.l  #TheExplodingKind+37,-(sp)
       bra.s   Kaboom
NoGld: cmp.b   #37,d3  ;SLIME?
       blt.s   NoSli
       cmp.b   #40,d3
       bgt.s   NoSli
       move.l  #TheExplodingKind+56,-(sp)
       clr     SlimeMorph
       bra.s   Kaboom
NoSli: cmp.b   #24,d3  ;What kind of beaumbe was it?
       bne     TrigR
       move.l  #TheExplodingKind-1,-(sp)
Kaboom:move.l  d2,-(sp)   ;Push offset
       lea     ExplodingBits,a3
       move    #$80,d3
       and     #7,d2
       lsr     d2,d3
       move.l  (sp),d2    ;just peek at offset
       lsr     #3,d2
       or.b    d3,(a3,d2) ;Write to the ExplodingBits
       move.l  (sp)+,d2   ;Pop offset
       move.l  CurBrdPtr,a3
       move.l  (sp)+,d3
       bra     OldBlk
TrigR: cmp.b   #42,d3  ;Red-gold trigger
       bne.s   TrigG
       moveq   #41,d3  ;Kills red-gold bricks
       bsr     Trigger_gold
       bra     NbAGA
TrigG: cmp.b   #44,d3  ;Green-gold trigger
       bne.s   TrigB
       moveq   #47,d3  ;Kills green-gold bricks
       bsr     Trigger_gold
       bra     NbAGA
TrigB: cmp.b   #45,d3  ;Blue-gold trigger
       bne.s   NbAGA
       moveq   #43,d3  ;Kills blue-gold bricks
       bsr     Trigger_gold
       ;D3 is gone, continue into NbAGA.
NbAGA: moveq   #1,d3   ;treat as normal block
OldBlk:tst     mLoopie
       beq     DSP
       clr     mLoopie
       cmp.b   #5,d3
       bne     LkLk

       movem.l d0-d2,-(sp)   ;GoldWeird section.
       tst     Got_Brick
       bne     NoGW          ;Nicht fuer brickthru!
       moveq   #15,d2
       bsr     rnd
       tst     d0
       bne     NoGW
       moveq   #2,d2
       bsr     rnd
       tst     d0
       bne     GW1
       cmp     #2,spx
       ble     NoGW
       sub     #1,spx
       add     #1,spy
GW1:   cmp     #1,d0
       bne     NoGW
       cmp     #2,spy
       ble     NoGW
       add     #1,spx
       sub     #1,spy
NoGW:  movem.l (sp)+,d0-d2   ;end of GoldWeird section.

       cmp     #5,Loopie
       bgt     ESP
       cmp     #4,Loopie
       bge     EESP
       move    sx,msx
       move    sy,msy
       move    dx,mdx
       move    dy,mdy
EESP:  addq    #1,Loopie
       bra     DSP
ESP:   move    sx,d3
       cmp     msx,d3
       bne     Fixd3
       move    sy,d3
       cmp     msy,d3     ;Testing for infinite loops around here...
       bne     Fixd3
       move    dx,d3
       cmp     mdx,d3
       bne     Fixd3
       move    dy,d3
       cmp     mdy,d3
       bne     Fixd3
       move    PaddleX,cylx  ;Found one!  POW!!!!
       add     #12,cylx
       move    #175,cyly
       move.b  #10,cyln
       move.l  #7,BallSpeed
       move.l  d0,-(sp)
       move    #11,d0
       bsr     playme        ;Go on, play it, *POW*!!!!
       move.l  (sp)+,d0
       move    #2,Self_Sound
Fixd3: clr     d3
       move.b  #5,d3        ;All gold is 5 for rest of this routine
       bra     DSP
LkLk:  clr     Loopie
DSP:   cmp.b   #10,d3       ;er... coming back from the loop mess,
       blo     FDH          ;d3 has block#
       cmp.b   #TheExplodingKind-1,d3
       bhs     FDU
       subq.w  #1,BlocksLeft
FDH:   cmp.b   #5,d3
       bhs     FDU
       subq.w  #1,BlocksLeft
FDU:   move.l  d0,-(sp)     ;<\
       cmp.b   #TheExplodingKind-1,d3
       blo     NB1d         ;   \
       move.w  ExpBrickPeriodSave,ExpBrickPeriod
       add.w   #1,ExpBrickVoice;  \
       and.w   #3,ExpBrickVoice;   \
       moveq   #17,d0       ;       \
       bra     NB1          ;        \
NB1d:  move    #4,d0        ;         \
       cmp.b   #5,d3        ;          \
       bhs     NB1b         ;           \ Stack Stuff!
       clr.b   d3           ;           / Keep Together!!
       move    #1,d0        ;          /
       bra     NB1          ;         /
NB1b:  cmp.b   #10,d3       ;        /
       blo     NB1c         ;       /
       move    #1,d0        ;      /
       bra     NB1          ;     /
NB1c:  tst     Got_Brick    ;    /     (playing a sound)
       bne     NB1a         ;   /
NB1:   bsr     playme       ;  /
NB1a:  move.l  (sp)+,d0     ;</
       cmp.b   #5,d3
       bls     NB2             ;All normal blocks goto NB2
       cmp.b   #7,d3
       bne     Goki
       move.b  #3,d3           ;Inviso becomes viso, and goes to NB2
       bra     NB2
Goki:  addq.b  #1,d3           ;Multihit -> next, exploding -> next, etc
       cmp.b   #7,d3
       bne     Gokiii
       addq.b  #1,d3           ;passing over inviso
Gokiii:cmp.b   #11,d3          ;past end of multihit ->
       bne     NB2
       clr.b   d3              ;    -> *poof*
NB2:   cmp.b   #5,d3           ;Gold requires no more processing.
       beq     ok88

       move.l  d2,-(sp)
       move.l  BallSpeed,d2
;       tst     Mus_Play
;       beq     NoMPt           ;No Music Point
;       addq.l  #1,d2
NoMPt: subq.l  #2,d2
       add.l   d2,Score        ;Add score for block
       move.l  (sp)+,d2

       cmp.b   #12,d3          ;One hit Inde (11) -> next becomes...
       bne     Gokii
       move    #5,d3           ;..gold, of course.
       move.b  d3,(a3,d2)
       bra     NBf
Gokii: move.b  d3,(a3,d2)
       tst.b   d3      ;Multi-hit blocks don't release cyl's.
       bne     NB3
NBf:   tst.b   cyln
       bne     NB3
       movem.l d0-d2,-(sp)
       cmp     #4,You_Looped
       beq     Giv12    ; fifth time thru, Dynamite!
       cmp     #3,You_Looped
       bge     Giv2     ; >= fourth time thru, KILLs galore!
       move.l  #4,d2
       bsr     rnd      ;Will this block release a cyl?
       tst     d0
       bne     SryDud   ;Sorry, Dude.  No cyl.
       move.l  #100,d2
       bsr     rnd      ;Pick a cyl.
       cmp     #10,d0   ;What did you pick?
       blt     Giv1
       cmp     #30,d0
       blt     Giv2
       cmp     #33,d0
       blt     Giv3
       cmp     #34,d0
       blt     Giv4
       cmp     #39,d0
       blt     Giv5
       cmp     #45,d0
       blt     Giv6
       cmp     #53,d0
       blt.s   Giv7
       cmp     #57,d0
       blt.s   Giv8
       cmp     #65,d0
       blt.s   Giv9
       cmp     #70,d0
       blt.s   Giv10
       cmp     #80,d0
       blt.s   Giv11
       cmp     #88,d0
       blt.s   Giv12
       cmp     #93,d0
       blt.s   Giv13
       move.b  #14,cyln
       bra     SryDud
Giv13: move.b  #13,cyln
       bra.s   SryDud
Giv12: move.b  #12,cyln
       bra.s   SryDud
Giv11: move.b  #11,cyln
       bra.s   SryDud
Giv10: move.b  #10,cyln
       bra.s   SryDud
Giv9:  move.b  #9,cyln
       bra.s   SryDud
Giv8:  move.b  #8,cyln
       bra.s   SryDud
Giv7:  move.b  #7,cyln
       bra.s   SryDud
Giv6:  move.b  #6,cyln
       bra.s   SryDud
Giv5:  move.b  #5,cyln
       bra.s   SryDud
Giv4:  move.b  #4,cyln
       bra.s   SryDud
Giv3:  move.b  #3,cyln
       bra.s   SryDud
Giv2:  move.b  #2,cyln
       bra.s   SryDud
Giv1:  move.b  #1,cyln
SryDud:movem.l (sp)+,d0-d2
       move.w  ddx,d2
       mulu    #15,d2
       add     #10,d2
       move.w  d2,cylx
       move.w  ddy,d2
       mulu    #7,d2
       add.w   #8,d2
       move.w  d2,cyly
NB3:   movem.l d0-d7/a0-a6,-(sp)
       lsl     #2,d3
       lea     BlockCoords,a0
       move.w  0(a0,d3),d0
       move.w  2(a0,d3),d1
       move.w  ddx,d2
       mulu    #15,d2
       add     #10,d2
       move.w  ddy,d3
       mulu    #7,d3
       add.w   #8,d3
       move.l  bit2map,a0
       move.l  bit1map,a1
       move.w  #15,d4
       move.w  #7,d5
       move.l  #$c0,d6
       move.l  #$ff,d7
       move.l  gfxbase,a6
       bsr     HideBobsHere
       jsr     _LVOBltBitMap(a6)  ;erase block, or put new one in place
       bsr     ShowScore          ;show new score
       movem.l (sp)+,d0-d7/a0-a6
ok88:  moveq.l #0,d3
       move    Got_Brick,d3  ;Should we tell main prog we hit a
       xor     #1,d3         ;block?  Not if we have Brickthrough!!
       tst     d3
       rts
ok8:   moveq.l #0,d3
       tst     d3
       rts

WarpAnywhere:
       move.l  a5,a1
       move.l  ExecBase,a6
       jsr     _LVOReplyMsg(a6)
       clr     FadeMus
       bsr     FadeOut
       bsr     clrscr
       move.l  Rast,a1
       moveq   #0,d0
       move    #100,d1
       move.l  gfxbase,a6
       jsr     _LVOMove(a6)
       move.l  Rast,a1
       move.l  #end_WarpAnyTxt-WarpAnyTxt,d0
       lea     WarpAnyTxt,a0
       jsr     _LVOText(a6)
       bsr     FadeIn
       moveq   #0,d5    ;d5 = position
       moveq   #0,d6    ;d6 = value
WA1:   moveq   #0,d7
       movem.l d5-d6,-(sp)
       bsr     tloop
       movem.l (sp)+,d5-d6
       cmp.b   #'0',d7
       blt     WA2
       cmp.b   #'9',d7
       bgt     WA2
       lea     PutLdHere,a0
       move.b  d7,(a0)
       move.l  Rast,a1
       moveq   #1,d0
       move.l  gfxbase,a6
       jsr     _LVOText(a6)
       mulu    #10,d6
       sub.b   #'0',d7
       add.b   d7,d6
       addq    #1,d5
       cmp     #2,d5
       blt     WA1
WA2:   tst     d5
       beq     WA3
       tst     d6
       ble     WA3
       cmp     #50,d6
       bgt     WA3
       mulu    #4,d6
       subq    #8,d6
       move.w  d6,CurrentBoard
WA3:   move    #1,FadeMus
       bsr     FadeOut
       or      #$8000,PlayerUp
       move    #1,NeedSetup
       cmp     #8,Mus_Play
       beq     DrawBoard
       bsr     mt_end
       bra     DrawBoard

PrtNum:            ;PRTNUM -> ;Convert word integer to printable ASCII.
       move.l  #10000,d1      ;d0 = word to convert
Prt2:  divu    d1,d0          ;a5 = pointer to ASCII text buffer
       cmp.l   #10000,d1                      ;(i.e. TexBuf)
       bne     Prt3
       swap    d0
       move    d0,-(sp)
       clr.w   d0
       swap    d0             ;Now handles 6 digits!
       divu    #10,d0
       add     #$30,d0
       move.b  d0,(a5)+
       move.w  (sp)+,d0
       swap    d0
Prt3:  add     #$30,d0
       move.b  d0,(a5)+
       clr     d0             ;d1 will be erased and used as scratch
       swap    d0
       divu    #10,d1         ;Leading zeros will be output:
       tst     d1             ; so $00A0 becomes 00160, etc.
       bne     Prt2
       rts                    ;End of PrtNum!  Now that didn't hurt, did it?

CheckLifePts:
       moveq   #0,d1
       move.l  Score,d0
       divu    #20000,d0      ;Free life every 20,000 points.
       cmp     LifePts,d0
       bls     _rts
       move    d0,LifePts
       addq    #1,LivesLeft
       bsr     PlayLifeTune
       move.l  #12,d0
       bsr     playme
       moveq   #1,d1
       rts          ;D1 is non-zero if a life was given.

ShowLives:
       cmp     #16,bhy
       bgt.s   NoHB4
       bsr     HideBobs
NoHB4: tst     LivesLeft
       ble.s   ShowScore
       move.l  gfxbase,a6
       move    LivesLeft,a5
       move    #$c0,d6
       move.l  #292,d2
       move.l  #8,d3
       move.l  #15,d4
       move.l  #5,d5
SL2:   move.l  bit3map,a0
       move.l  bit1map,a1
       move.l  #49,d0
       move.l  #191,d1

;Al's A1200 has a bug in BltBitMap where D7 is not preserved!!!!
;SO, I have to initialize d7 for EVERY SINGLE BLIT........

       move    #$ff,d7
       jsr     _LVOBltBitMap(a6)  ;Put life on screen
       sub     #18,d2
       subq    #1,a5
       cmp     #15,d2
       ble.s   ShowScore   ;Make sure it doesn't go off screen!
       cmp     #0,a5
       bgt     SL2      ;Any more lives?
ShowScore:
       movem.l d2-d5,-(sp)
       moveq   #0,d2
       moveq   #0,d3
       move    #320,d4
       move    #16,d5
       bsr     HideBobsHere
       movem.l (sp)+,d2-d5
       bsr     CheckLifePts
       tst     d1
       bne     ShowLives
       move.l  Score,d0
       lea     TexBuf,a5
       move.l  #' Sco',(a5)+  ;It says, " Score: ".
       move.l  #'re: ',(a5)+  ;Isn't this CUTE????
       tst     You_Cheated
       bne     SSc1
       bsr     PrtNum
       bra     SSc2
SSc1:  move.l  #'CHEA',(a5)+
       move.w  #'T!',(a5)+
SSc2:  tst     ScoreShowing
       bne     SSc3
       move    #1,ScoreShowing
       move.l  #'   B',(a5)+  ;Guess what it says now!
       move.l  #'oard',(a5)+
       move.w  #': ',(a5)+
       moveq.l #0,d0
       move.w  CurrentBoard,d0
       lsr     #2,d0
       addq    #1,d0
       moveq.l #10,d1
       bsr     Prt2
       moveq   #10,d0
SSc4:  move.b  #' ',(a5)+
       dbra    d0,SSc4
       move.l  Rast,a1
       move.l  #12,d0
       move.l  #6,d1
       move.l  gfxbase,a6
       jsr     _LVOMove(a6)
       move.l  #37,d0          ;Length of text
       lea     TexBuf,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)    ;show the dude his score.
       rts
SSc3:  move.l  Rast,a1
       move.l  #76,d0
       move.l  #6,d1
       move.l  gfxbase,a6
       jsr     _LVOMove(a6)
       move.l  #6,d0     ;Len
       lea     TexBuf+8,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)    ;show the dude his score.
       rts

DrawCyl:
       movem.l d0-d7/a0-a6,-(sp)
       moveq.l #0,d0
       moveq.l #0,d1       ;show one of these bonus thingies.
       moveq.l #0,d2
       moveq.l #0,d3
       moveq.l #0,d4
       move.w  cylx,d2
       move.w  cyly,d3
       subq.w  #1,d3
       move.b  cyln,d4
       lea     BonusCoords,a5
       lsl     #2,d4
       move.w  (a5,d4),d0
       move.w  2(a5,d4),d1
       subq.w  #1,d1
       tst     You_Looped
       beq.s   NoQues
       cmp     #3,You_Looped
       beq.s   NoQues
       cmp     #1,You_Looped
       bgt.s   Ques
       cmp     #155,cyly
       bgt.s   NoQues
Ques:  move    #243,d0     ;silly goofy <?> cyl.
       move    #131,d1
NoQues:move.l  bit3map,a0
       move.l  bit1map,a1
       move.l  #15,d4
       move.l  #15,d5   ;Cyl must be drawn at cyly - 1.
       move.l  #$c0,d6    ;(so it can erase its tracks!)
       move.l  #$ff,d7
       move.l  gfxbase,a6
       bsr     HideBobsHere
       jsr     _LVOBltBitMap(a6) ;draw it.
       moveq.l #0,d2
       moveq.l #0,d3
       move.w  cyly,d3
       sub.w   #16,d3  ;8 above: 7 for block, 1 for erase line.
       divu    #7,d3
       swap    d3
       tst     d3
       bne     NoRedr
       swap    d3
       cmp     #21,d3
       bge     NoRedr
       mulu    #20,d3       ;If cyl passes over a block, we
       move.w  cylx,d2      ;must find out what was there
       sub     #10,d2       ;and put it back.
       divu    #15,d2
       and.l   #$ffff,d2
       add.l   d3,d2
       move.l  CurBrdPtr,a3
       moveq.l #0,d3
       move.b  (a3,d2),d3
       tst.b   d3
       beq     NoRedr
       lsl     #2,d3
       lea     BlockCoords,a0
       move.w  (a0,d3),d0
       move.w  2(a0,d3),d1
       move.w  cylx,d2
       move.w  cyly,d3
       subq.w  #8,d3
       move.l  bit2map,a0
       move.l  bit1map,a1
       move.w  #15,d4
       move.w  #7,d5
       move.l  #$c0,d6
       move.l  #$ff,d7
       bsr     HideBobsHere
       jsr     _LVOBltBitMap(a6)  ;we found out, now draw it!
NoRedr:movem.l (sp)+,d0-d7/a0-a6
       rts
EraseCyl:
       movem.l d0-d7/a0-a6,-(sp)
       moveq.l #0,d2
       moveq.l #0,d3
       move.w  cylx,d2         ;get rid of an un-needed cyl
       move.w  cyly,d3         ;from screen.
       move.l  #142,d0
       move.l  #154,d1
       move.l  bit3map,a0
       move.l  bit1map,a1
       move.l  #15,d4
       move.l  #14,d5
       move.l  #$c0,d6
       move.l  #$ff,d7
       move.l  gfxbase,a6
       bsr     HideBobsHere
       jsr     _LVOBltBitMap(a6)
       movem.l (sp)+,d0-d7/a0-a6
       rts
NoTrans:
       cmp     #8,Mus_Play
       beq     _rts
       bsr     mt_end
       rts
ComputeDeathTune:
       moveq   #0,d1
       moveq   #0,d5
       tst     LivesLeft2
       bge     NoTrans
       tst     LivesLeft
       bgt     _rts
       move.l  Name_Dead,a0
       move.l  mts_dead,d5
       move.l  Score,d0
       move.l  end_ScoreList-4,d1
       tst     You_Cheated
       bne.s   YDNS3
       cmp.l   d0,d1
       bge.s   YDNS3
       move.l  Name_High,a0
       move.l  mts_high,d5
YDNS3: move.l  Score2,d0
       tst     You_Cheated2
       bne.s   YDNS4
       cmp.l   d0,d1
       bge.s   YDNS4
       move.l  Name_High,a0
       move.l  mts_high,d5
YDNS4: move.l  a0,d1
       rts
LoopieDeath:      ;Someone loaded Blank.BDS.  STUPID!!
       bsr     ColorOn
       clr     LivesLeft
       move    #-1,LivesLeft2
       clr.l   Score
       clr.l   Score2
       move.w  #-40,sx
       move.w  #-4,sy
       move.w  #41,Paddle_Size
       move.w  #140,PaddleX
       move.w  #((MOUSESPEED*160)/320),PaddleXbig    ;Start pos for paddle
       bra     YourDead
AbortGame:
       clr     LivesLeft
SelfDest:
       bsr     mt_end
       or.b    #2,$bfe001   ;Filter off.
       move    #5,d0
       bsr     Playme  ;Boy, do I love this sound effect!
       bsr     ComputeDeathTune
       tst.l   d1
       beq     YDNS
       clr     VolMult
       clr     FadeMus
       move    #1,NoVoice0
       bsr     OMed_LoadPlayD1D5
       bra     YDNS
YourDead:
       clr     FadeMus
       bsr     ComputeDeathTune
       tst.l   d1
       beq     YDNS2
       bsr     OMed_LoadPlayD1D5
YDNS2: move    #2,d0
       bsr     playme
YDNS:  move.l  #183,d3
       moveq.l #0,d2
       moveq.l #0,d4
       move.w  PaddleX,d2
       move.w  #320,d1
       sub.w   Paddle_Size,d1
       cmp.w   d1,d2
       ble     Yup2
       move.w  d1,d2
Yup2:  move.l  bit2map,a0
       move.l  bit1map,a1
       move.l  #17,d0
       move.l  #34,d1
       move.w  Paddle_Size,d4
       move.l  #15,d5
       move.l  #$c0,d6
       move.l  #$ff,d7
       move.l  gfxbase,a6
       jsr     _LVOBltBitMap(a6) ;erase you!
       move    sx,d0
       move    sy,d1
       move.l  ViewPort,a0
       move.l  ballsp,a1
       jsr     MoveBallSprite
       move.l  #183,d3
;       move.l  Rast,a0
;       move.l  screenhd,a5
;       move.w  $12(a5),d2
       move    PaddleXbig,d2
       mulu    #259,d2         ;Adjust position for size change
       divu    #MOUSESPEED,d2
       add     #10,d2
       move.w  d2,PaddleX
       bsr     WarpOut
       tst.w   LivesLeft
       beq     GameOver
       subq.w  #1,LivesLeft
       move.w  DeathRecover,CurrentBoard
       subq    #1,d1
       subq    #2,d3
       addq    #2,d5
       move    #$ff,d7  ;OS bug, DUH!
BlowEmUpGood:         ;He blew up.  Yeah, he blew up good.  Yeah, he
       addq    #1,d3  ;blew up REAL GOOD!!!!
       subq    #1,d5
       movem.l d0-d7,-(sp)
       bsr     NewTim
       move.l  bit3map,a0
       move.l  bit1map,a1
       move.l  gfxbase,a6
       move.l  a7,a5          ;Check this move out.  I peek at
       movem.l (a5)+,d0-d7    ;what's on the stack without touching it!
       jsr     _LVOBltBitMap(a6)   ;<=- and now I'm blowing you up!
       movem.l (sp)+,d0-d7
       cmp     #1,d5
       bgt     BlowEmUpGood
       bsr     FadeOut
       jmp     DrawBoard
GameOver:                  ;You be dead.
       move    CurrentBoard,GameRecover
       move.l  #179,d0     ;Ending seconds (3).
       bsr     NewTimM
       move    VolMult,-(sp)
       bsr     FadeOut
       move    (sp)+,VolMult
       subq    #1,LivesLeft
       tst     LivesLeft2
       bge     DrawBoard
       tst     VolMult
       bne     EOGmessage
       move    #1,FadeMus
       moveq   #13,d0    ;Shut off v0.
       bsr     playme
       clr     NoVoice0
       move.l  #$dff0a0,Voice0HW
       bra     EOGmessage
WarpOut:                 ;WarpOut, i.e. BOOM!
       lea     WarpOutList,a5
WarpOutLoop:
       moveq.l #3,d0
       bsr     NewTimM      ;Warp-out speed.
       moveq.l #0,d2
       move.w  PaddleX,d2
       move.l  bit3map,a0
       move.l  bit1map,a1
       moveq.l #0,d0
       moveq.l #0,d1
       moveq.l #0,d4
       moveq.l #0,d5
       move.w  (a5)+,d0  ;src x
       move.w  (a5)+,d1  ;src y
       move.w  (a5)+,d4  ;size x
       move.w  (a5)+,d5  ;size y
       move.l  d4,d6
       sub.w   #40,d6
       lsr.l   #1,d6
       move.l  #198,d3
       sub.w   d5,d3
       sub.w   d6,d2
       btst    #15,d2
       beq     Out2ok
       moveq.l #0,d2
Out2ok:move.l  #320,d7
       sub.w   d4,d7
       cmp.w   d7,d2
       blt     Out1ok
       move.l  d7,d2
Out1ok:move.l  #$c0,d6
       move.l  #$ff,d7
       move.l  gfxbase,a6
       movem.l d0-d7,-(sp)
       jsr     _LVOBltBitMap(a6)  ;some nice flames on the screen
       move.l  a5,d0
       moveq.l #0,d1
       move    LivesLeft,d1
       cmp     #4,d1
       ble     ZipZip
       move    #6,d1
ZipZip:lsl     #3,d1
       add.l   d1,d0
       move.l  d0,a4
       movem.l (sp)+,d0-d7
       cmp.l   #end_out_list,a4
       bne     WarpOutLoop
       rts
fixpaddle:                ;move and redraw paddle
       move.l  #183,d3
       moveq.l #0,d2
       moveq.l #0,d4
       move.w  PaddleX,d2
       move.w  #310,d1
       move.w  Paddle_Size,d4
       tst     BigFP
       beq     Nope
       move    #164,d4
       clr     BigFP
Nope:  sub     d4,d1
       cmp.w   d1,d2
       ble     Yup
       move.w  d1,d2
Yup:   move.l  bit2map,a0
       move.l  bit1map,a1
       move.l  #17,d0
       move.l  #34,d1
       move.l  #15,d5
       move.l  #$c0,d6
       move.l  #$ff,d7
       move.l  gfxbase,a6
       bsr     HideBobsHere
       jsr     _LVOBltBitMap(a6)  ;erase old paddle
       move.l  #183,d3
;       move.l  Rast,a0
;       move.l  screenhd,a5
;       move.w  $12(a5),d2
       move.l  #300,d1
       sub.w   Paddle_Size,d1
;       mulu    d1,d2
;       divu    #319,d2
;       add     #10,d2
       move.w  PaddleXmod,d2
       clr     PaddleXmod
       add.w   PaddleXbig,d2
       tst     d2
       bge     fp3ok
       moveq   #0,d2
fp3ok: cmp.w   #MOUSESPEED,d2
       ble     fp4ok
       move.l  #MOUSESPEED,d2
fp4ok: move.w  d2,PaddleXbig
       mulu    d1,d2
       divu    #MOUSESPEED,d2
       add     #10,d2
       move    d2,PaddleX
       move.l  bit2map,a0
       move.l  bit1map,a1
       moveq.l #0,d4                 ;computing new position
       move.l  #248,d0
       move.l  #88,d1
       cmp.w   #-1,Got_Expand
       bne     NoEm1
       move.w  #290,d0
NoEm1: cmp.w   #1,Got_Expand
       bne     NoE1
       move.w  #165,d0
NoE1:  cmp.w   #2,Got_Expand
       bne     NoE2
       moveq   #0,d0
NoE2:  tst     Got_Laser
       beq     NoLas
       move.w  #138,d1
NoLas: cmp.w   #-1,Stuck
       beq     NoCach
       sub.w   #16,d1
NoCach:move.w  Paddle_Size,d4
       move.l  #15,d5
       move.l  #$c0,d6
       move.l  #$ff,d7
       bsr     HideBobsHere
       jsr     _LVOBltBitMap(a6)  ;draw new paddle
       cmp.w   #-1,Stuck
       beq     loop
       move.l  ViewPort,a0
       move.l  ballsp,a1
       moveq.l #0,d0
       move.w  PaddleX,d0
       add.w   Stuck,d0
       move.l  #186,d1
       jsr     MoveBallSprite  ;move ball, if stuck to paddle
       bra     loop

MyReadJoyTitle:
       moveq   #0,d0
       tst.l   LowLevelBase
       beq     _rts
       movem.l d1/a0-a1/a6,-(sp)
       move.l  LowLevelBase,a6
       moveq   #1,d0
       jsr     _LVOReadJoyPort(a6)
       move.l  d0,d1
       moveq   #0,d0
       tst.l   d1      ;JP_TYPE_NOTAVAIL
       beq     mrjt0
       btst    #22,d1  ;JPB_BUTTON_RED
       beq.s   mrjt1
       moveq   #1,d0   ;one player
mrjt1: btst    #23,d1  ;JPB_BUTTON_BLUE
       beq.s   mrjt2
       moveq   #2,d0   ;two player
mrjt2: btst    #17,d1  ;JPB_BUTTON_PLAY
       beq.s   mrjt0
       moveq   #3,d0   ;continue game

mrjt0: movem.l (sp)+,d1/a0-a1/a6
       rts

MyReadJoyLoop:
       tst     d7
       bne     _rts
       tst.l   LowLevelBase
       beq     _rts
       movem.l d0-d1/a0-a1/a6,-(sp)
       move.l  LowLevelBase,a6
       moveq   #1,d0
       jsr     _LVOReadJoyPort(a6)
       move.l  d0,d1
       moveq   #0,d0
       tst.l   d1      ;JP_TYPE_NOTAVAIL
       beq     mrjl0
       btst    #22,d1  ;JPB_BUTTON_RED
       beq.s   mrjl1
       moveq   #1,d0   ;click.
mrjl1: btst    #23,d1  ;JPB_BUTTON_BLUE
       beq.s   mrjl2
       moveq   #'2',d0 ;two player?
mrjl2: btst    #17,d1  ;JPB_BUTTON_PLAY
       beq.s   mrjl0
       moveq   #'C',d0 ;continue game?
mrjl0: move.l  d0,d7
       movem.l (sp)+,d0-d1/a0-a1/a6
       rts

MyReadJoy:
       tst.l   LowLevelBase
       beq     _rts
       movem.l d0-d2/a0-a1/a6,-(sp)
       move.l  LowLevelBase,a6
       moveq   #1,d0
       jsr     _LVOReadJoyPort(a6)
       tst.l   d0      ;JP_TYPE_NOTAVAIL
       beq     mrj0
       move.b  JoyFire+1,JoyFire
       moveq   #0,d1
       btst    #22,d0  ;JPB_BUTTON_RED
       beq.s   mrj1
       moveq   #1,d1
mrj1:  move.b  d1,JoyFire+1
       moveq   #10,d1  ;normal target speed
       moveq   #1,d2   ;normal accell
       btst    #21,d0  ;JPB_BUTTON_YELLOW
       beq.s   mrj2
       moveq   #5,d1   ;slow target speed
       moveq   #1,d2   ;slow accell
mrj2:  btst    #20,d0  ;JPB_BUTTON_GREEN
       beq.s   mrj3
       moveq   #25,d1  ;turbo target speed
       moveq   #3,d2   ;turbo accell
mrj3:  btst    #19,d0  ;JPB_BUTTON_FORWARD
       beq.s   mrj4
       bset    #0,d0   ;converts to JPB_JOY_RIGHT
mrj4:  btst    #18,d0  ;JPB_BUTTON_REVERSE
       beq.s   mrj5
       bset    #1,d0   ;converts to JPB_JOY_LEFT
mrj5:  move.l  d0,-(sp)
       and     #3,d0
       bne.s   mrj5b
       moveq   #0,d1   ;stopping target speed
       addq    #1,d2   ;stopping decell
       bra.s   mrj5d
mrj5b: cmp     #3,d0
       bne.s   mrj5c
       moveq   #0,d1   ;quik brakes
       clr     PaddleSpeed
       bra     mrj5g
mrj5c: cmp     #1,d0
       beq.s   mrj5d
       neg     d1
mrj5d: cmp     PaddleSpeed,d1
       blt.s   mrj5e
       add     d2,PaddleSpeed
       cmp     PaddleSpeed,d1
       bge.s   mrj5f
       move    d1,PaddleSpeed
       bra.s   mrj5f
mrj5e: sub     d2,PaddleSpeed
       cmp     PaddleSpeed,d1
       ble.s   mrj5f
       move    d1,PaddleSpeed
mrj5f: move    PaddleSpeed,d1
mrj5g: add     d1,PaddleXmod
       move.l  (sp)+,d0
       btst    #17,d0  ;JPB_BUTTON_PLAY
       beq.s   mrj6
       move    #8,PauBak
       bset    #3,d7
mrj6:
;       btst    #23,d0  ;JPB_BUTTON_BLUE
;       beq.s   mrj0

mrj0:  movem.l (sp)+,d0-d2/a0-a1/a6
       rts

ShowTiredText:
 IFEQ REGISTERED,0
       movem.l d0-a6,-(sp)
       move.l  gfxbase,a6
       move.l  Rast,a1
       moveq   #0,d0
       move.b  Converter+5,d0   ;Yellow
       jsr     _LVOSetAPen(a6)
       move.l  Rast,a1
       move    #88,d0
       move    #190,d1
       jsr     _LVOMove(a6)
       move.l  #end_PTC-PTC,d0
       lea     PTC,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
       moveq   #20,d2
       lea     TiredText,a2
       move.l  Rast,a1
       moveq   #1,d0
       jsr     _LVOSetAPen(a6)
STT1:  move.l  Rast,a1
       moveq.l #0,d0
       move.l  d2,d1
       jsr     _LVOMove(a6)
       moveq.l #40,d0
       move.l  a2,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
       add     #10,d2
       add.l   #40,a2
       cmp.l   #end_TiredText,a2
       blo     STT1
       move.l  bit3map,a0
       move.l  bit1map,a1
       move.l  #183,d0
       move.l  #149,d1
       moveq   #0,d2
       moveq   #0,d3
       move.l  #120,d4
       move.l  #43,d5
       move.l  #$c0,d6
       move.l  #$ff,d7
       jsr     _LVOBltBitMap(a6)  ;get IAM logo on there
       bsr     FadeIn
       moveq   #0,d7
       bsr     tloop
       bsr     FadeOut
       bsr     clrscr
       movem.l (sp)+,d0-a6
 ENDIF
       rts

;Preserve D7 in here please.
ColorFitch:
       move.l  gfxbase,a6
       move.l  ViewPort,a0     ;Sub-color fitch
       moveq   #0,d0
       move    FitchSubCol,d0
       beq     CFnsf   ;ColorFitch: No Sub-Fitch
       moveq.l #0,d1
       moveq.l #$F,d2
       moveq.l #$F,d3
       sub     Fcol,d2
       jsr     _LVOSetRGB4(a6)
       move.l  ViewPort,a0     ;Main color fitch
       moveq   #0,d0
CFnsf: move    FitchCol,d0
       moveq.l #0,d1
       moveq.l #0,d2
       moveq.l #$F,d3
       move    Fcol,d2
       add     Fdir,d2
       move    d2,Fcol
       tst     d2
       bgt     NoFc1m
       move    #1,Fdir
NoFc1m:cmp     #$F,d2
       blt     NoFc2m
       move    #-1,Fdir
NoFc2m:jsr     _LVOSetRGB4(a6)
       rts
ColorOn:
       move.l  gfxbase,a6
       jsr     _LVOWaitBlit(a6)
       move.l  ViewPort,a0
       tst     v39
       beq     coOld
       lea     numcolors,a1    ;Followed by ctable32
       jsr     _LVOLoadRGB32(a6)
       rts
coOld: move.l  #32,d0
       lea     ctable,a1
       jsr     _LVOLoadRGB4(a6)
       rts
ColorOff:
       move.l  gfxbase,a6
       move.l  ViewPort,a0
       lea     ftable,a1
       move.l  a1,a2
       tst     v39
       bne     COff3
       move.l  #32,d0
       move.l  #31,d2
COff2: clr     (a2)+
       dbra    d2,COff2
       jsr     _LVOLoadRGB4(a6)
       jsr     _LVOWaitTOF(a6)
       rts
COff3: move.l  numcolors,d0    ;number & initial
       move.l  d0,(a2)+        ;ditto
       swap    d0              ;just number
       mulu    #3,d0           ;RGB
; Normally I would subtract 1 for dbra, but I keep the 1 for LoadRGB32 EOL.
COff4: clr.l   (a2)+
       dbra    d0,COff4
       jsr     _LVOLoadRGB32(a6)
       jsr     _LVOWaitTOF(a6)
       rts
FadeInGrey:
       clr     Fcol
       move    #1,Fdir
       tst     v39
       bne     FIG39
       move.l  #$0,d7      ;Now:  some fading routines!
       move.l  #1,d6
       move    #$333,d5
       move    #$d,a5
       bsr     FO1
       bra     ColorOn
FadeOutGrey:
       tst     v39
       bne     FOG39
       move.l  #$c,d7
       move.l  #-1,d6
       move    #$333,d5
       move.l  #-1,a5
       bra     FO1
FadeIn:
       clr     Fcol
       move    #1,Fdir
       tst     v39
       bne     FI39
       move.l  #$0,d7
       move.l  #1,d6
       clr     d5
       move    #$10,a5
       bsr     FO1
       bra     ColorOn
FadeOut:
       tst     v39
       bne     FO39
       move.l  #$f,d7
       move.l  #-1,d6
       clr     d5
       move.l  #-1,a5
FO1:   lea     ctable,a3
       lea     ftable,a4
       move    (a3)+,(a4)+  ;Leave color 0 alone.
FO2:   move    (a3)+,d2
       move    d2,d1
       move    d1,d0
       and     #$00f,d0
       and     #$0f0,d1
       and     #$f00,d2
       mulu    d7,d0
       divu    #$f,d0
       mulu    d7,d1
       divu    #$f,d1
       mulu    d7,d2
       divu    #$f,d2
       and     #$00f,d0
       and     #$0f0,d1
       and     #$f00,d2
       or      d0,d1
       or      d1,d2
       add     d5,d2
       move    d2,(a4)+
       cmp.l   #ftable+64,a4  ;pre-v39 restricted to 32 colors
       bne     FO2
       move.l  gfxbase,a6
       moveq   #0,d0
       move    numcolors,d0
       move.l  ViewPort,a0
       lea     ftable,a1
       jsr     _LVOLoadRGB4(a6)  ;Fade away!
       move.l  d4,-(sp)
       move.l  #2,d4      ;Fade in/out speed.
       tst     FadeMus
       beq     WTDL1
       tst     Mus_Play
       beq     WTDL1
       cmp     #8,Mus_Play
       beq     WTDL1
       addq.l  #2,d4
       move    d7,VolMult
       clr     Mus_Pause
WTDL1: bsr     mt_music
       bsr     NewTim
       dbra    d4,WTDL1
       move.l  (sp)+,d4
       add     d6,d7
       cmp     d7,a5
       bne     FO1
FOxv39:tst     d6
       bgt     FO8
       tst     FadeMus
       beq     FO8
       move    #1,Mus_Pause
FO8:   move    #$f,VolMult
       rts

FIG39: moveq   #0,d7
       move.l  #$0400,d6
       move.l  #$33333333,d5
       move.l  #$fc00,d3
       bsr     FO1v39
       bra     ColorOn
FOG39: move.l  #$fc00,d7
       move.l  #-$0400,d6
       move.l  #$33333333,d5
       moveq   #0,d3
       bra     FO1v39
FI39:  moveq   #0,d7
       move.l  #$0400,d6
       moveq   #0,d5
       move.l  #$fc00,d3
       bsr     FO1v39
       bra     ColorOn
FO39:  move.l  #$fc00,d7
       move.l  #-$0400,d6
       moveq   #0,d5
       moveq   #0,d3
;Continue into FO1v39

; D7 = start intensity, D6 = direction,
; D5 = grey or not,     D3 = finish intensity.
FO1v39:
       tst     FadeMus
       beq     FO139b
       tst     Mus_Play
       beq     FO139b
       cmp     #8,Mus_Play
       beq     FO139b
       asr.l   #1,d6
FO139b:lea     numcolors,a3    ;main v39 fade loop
       lea     ftable,a4
       move.w  (a3),d1
       moveq   #3,d0
FO2v39:move.l  (a3)+,(a4)+     ;(numcolors, initial color), R, G, B (of color 0)
       dbra    d0,FO2v39
       move    d1,d0
       subq    #1,d0   ;because color 0 doesn't get faded!
       mulu    #3,d0   ;RGB
       subq    #1,d0
       movem.l d5-d6,-(sp)
       move    #$fc00,d6
       sub     d7,d6      ;d6 (temp) = grey multiplier
       mulu    d6,d5      ;d5 (temp) = grey intensity
FO3v39:move.l  (a3)+,d1
       swap    d1
       mulu    d7,d1
       add.l   d5,d1
       move.l  d1,(a4)+
       dbra    d0,FO3v39
       clr.l   (a4)+           ;Terminate the colorlist you dweeb!!!!
       movem.l (sp)+,d5-d6
       move.l  ViewPort,a0
       lea     ftable,a1
       move.l  gfxbase,a6
       jsr     _LVOLoadRGB32(a6)
       tst     FadeMus
       beq     FO4v39
       tst     Mus_Play
       beq     FO4v39
       cmp     #8,Mus_Play
       beq     FO4v39
       move    d7,d0
       moveq   #12,d1
       lsr     d1,d0
       move    d0,VolMult
       clr     Mus_Pause
FO4v39:bsr     NewTim
       move    d7,d0
       add     d6,d7
       cmp     d0,d3
       bne     FO139b
       bra     FOxv39

;DontWaitForQuiet:
;       move.l  #3,d0
;       lea     othermessages,a2
;       move.l  ExecBase,a6
;DWFQ1: move.l  a2,a1
;       jsr     _LVOAbortIO(a6)
;       add.l   #68,a2
;       dbra    d0,DWFQ1
;       rts
;WaitForQuiet:
;       move.l  #3,d0
;       lea     othermessages,a2
;       move.l  ExecBase,a6
;WFQ1:  move.l  a2,a1
;       jsr     _LVOWaitIO(a6)
;       add.l   #68,a2
;       dbra    d0,WFQ1
;       rts
NoCCylS:
       clr     Self_Sound
       rts
playme:                            ;Sound # in d0
       tst     NoVoice0
       bne     pmKG
       cmp     #8,Mus_Play
       beq     pmKG
       tst     Mus_Play      ;No sounds during a song
       bne     _rts          ;unless that song has no Voice 0.
pmKG:  cmp     #6,d0         ;PlayMe KeepGoing.
       bne     SkipNC
       cmp     #2,Self_Sound
       beq     NoCCylS
SkipNC:movem.l d0/d1/a0-a2/a6,-(sp)
       cmp     #-1,d0
       beq     FirstAudio        ;Main sound-playing routine
       move    d0,-(sp)
       lsl     #1,d0
       lea     sVoiceTable,a0           ;find out which voice for sound
       move    (a0,d0),d0
       mulu    #68,d0
       lea     othermessages,a2
       cmp     #8,Mus_Play
       beq     CDDA
       tst     Mus_Play
       bne     MustV0         ;Sounds during 3-voice music must use voice 0.
CDDA:  add.l   d0,a2
MustV0:move.l  ExecBase,a6
       cmp     #1,Self_Sound
       beq     WSS
       move.l  a2,a1
       jsr     _LVOAbortIO(a6)
WSS:   move.l  a2,a1
       jsr     _LVOWaitIO(a6)
       cmp     #1,Self_Sound
       bne     WSSa
       clr     Self_Sound
       cmp     #8,Mus_Play
       beq     CDDA3
       tst     Mus_Play
       bne     WSSa
CDDA3: bsr     mt_filter   ;filter on.
WSSa:  move    (sp)+,d0
       bra     AudOK
FirstAudio:
       move.l  #68,d0   ;68*4/4=68
       lea     othermessages,a2
Fab:   clr.l   (a2)+
       dbra    d0,Fab;ulous
       lea     Message,a2
       move    #3,d0
AudOK: cmp     #13,d0
       blt     noR
       cmp     #16,d0
       bgt     noR
       move.l  ExecBase,a6
       move.w  #CMD_RESET,Aud_Cmd-Message(a2)
       move.l  a2,a1
       move    d0,-(sp)
       jsr     _LVODoIO(a6)
       move    (sp)+,d0
noR:   move.w  #CMD_WRITE,Aud_Cmd-Message(a2)
       move.b  #ADIOF_PERVOL,Aud_Flags-Message(a2)
       move.b  #5,8(a2)
       cmp     #5,d0
       bne     NSSS
       move    #1,Self_Sound
NSSS:  lsl     #2,d0
       lea     saddrTable,a0            ;find sound's address
       move.l  (a0,d0),34(a2)    ;AData
       lea     slenTable,a0             ;find sound's length
       move.l  (a0,d0),d1
       bclr    #0,d1                    ;(fix length if odd!)
       move.l  d1,38(a2)         ;Aud_Length
       lea     sperTable,a0             ;find sound's period
       lsr     #1,d0
       move.w  (a0,d0),42(a2)    ;Period
       move    #$40,d0
       tst     Mus_Play
       beq     RealLoud
       cmp     #8,Mus_Play
       beq     RealLoud
       lsr     #1,d0     ;Softer volume during music.
RealLoud:
       move    d0,44(a2)         ;Volume
       lea     Message,a0
       cmp.l   a0,a2
       beq     All4
       move.l  a2,a1
       move.l  Device,a6
       jsr     -30(a6)    ;DEV_BEGINIO     Play it!
PD:    movem.l (sp)+,d0/d1/a0-a2/a6
       rts
All4:  move.l  d2,-(sp)
       move.l  #3,d2
All4b: move    d2,d0
       move.l  #1,d1
       lsl     d0,d1
       move.l  d1,Unit
       move    d0,d1
       mulu    #68,d0
       lea     othermessages,a2
       add.l   d0,a2
       move.b  #5,8(a2)
       lsl.l   #6,d1
       lea     MsgPort,a0
       add.l   d1,a0          ;initial sound needs more init stuff
       move.l  a0,-(sp)
       add.l   #20,a0
       NEWLIST a0
       move.l  (sp)+,a0
       move.l  a0,14(a2)
       add.l   #256,a0
       move.l  a0,-(sp)
       lea     Message,a0
       move.b  #5,8(a0)
       move.l  a2,a1
       add.l   #20,a0
       add.l   #20,a1
       move.l  #48,d0
       move.l  ExecBase,a6
       jsr     _LVOCopyMem(a6)
       move.l  (sp)+,a0
       move.l  a0,62(a2)
       move.l  a2,a1
       move.l  Device,a6
       jsr     -30(a6)    ;DEV_BEGINIO
       dbra    d2,All4b
       move.l  (sp)+,d2
       bra     PD

InReqBoards:
 IFEQ REGISTERED,1
       lea     FileRequestor,a0
       move.l  reqbase,a6
       jsr     _LVOFileRequester(a6)
       tst     d0
       beq     ReqDonLod
       bra     LSreqG
 ENDIF
ReqNFdErr:
 IFEQ REGISTERED,1
       lea     FileRequestor,a0
       move.l  #f_FNF,frq_Title(a0)
       bra     InReqBoards
 ENDIF
ReqVerErr:
 IFEQ REGISTERED,1
       lea     FileRequestor,a0
       move.l  #f_VER,frq_Title(a0)
       bra     InReqBoards
 ENDIF
ReqLodErr:
 IFEQ REGISTERED,1
       lea     FileRequestor,a0
       move.l  #f_NBD,frq_Title(a0)
       bra     InReqBoards
 ENDIF
ReqDonLod:
 IFEQ REGISTERED,1
       lea     FileRequestor,a0
       move.l  #f_Title,frq_Title(a0)
       bsr     DumpMsgs
       movem.l (sp)+,d0-d7/a0-a5   ;Get message back
       bra     Rep2
 ENDIF
InAslBoards:
 IFEQ REGISTERED,1
       move.l  AslFR,a0
       lea     AslReqTags,a1
       move.l  aslbase,a6
       jsr     _LVOAslRequest(a6)
       tst     d0
       beq     AslDonLod

       lea     TexBuf+4,a0
       move.l  AslFR,a1
       move.l  8(a1),a1    ;fr_Drawer
       cmp.l   #0,a1
       beq     IAB1
       tst.b   (a1)
       beq     IAB1
 ENDIF
IAB2:  move.b  (a1)+,(a0)+
       bne     IAB2
       subq.l  #1,a0
       cmp.b   #':',-1(a0)
       beq     IAB1
       cmp.b   #'/',-1(a0)
       beq     IAB1
       move.b  #'/',(a0)+
IAB1:  move.l  AslFR,a1
       move.l  4(a1),a1    ;fr_File
       cmp.l   #0,a1
       beq     IAB3
       tst.b   (a1)
       beq     IAB3
IAB4:  move.b  (a1)+,(a0)+
       bne     IAB4
IAB3:  clr.b   (a0)
       bra     LSreqG
AslNFdErr:
 IFEQ REGISTERED,1
       lea     AslReqTags,a1
       move.l  #f_FNF,4(a1)
       bra     InAslBoards
 ENDIF
AslVerErr:
 IFEQ REGISTERED,1
       lea     AslReqTags,a1
       move.l  #f_VER,4(a1)
       bra     InAslBoards
 ENDIF
AslLodErr:
 IFEQ REGISTERED,1
       lea     AslReqTags,a1
       move.l  #f_NBD,4(a1)
       bra     InAslBoards
 ENDIF
AslDonLod:
 IFEQ REGISTERED,1
       lea     AslReqTags,a1
       move.l  #f_Title,4(a1)
       bsr     DumpMsgs
       movem.l (sp)+,d0-d7/a0-a5   ;Get message back
       bra     Rep2
 ENDIF

InBoards:
 IFEQ REGISTERED,0
       bra     NoLoadAllowed
 ELSE
       movem.l d0-d7/a0-a5,-(sp)      ;Message needs ReplyMsg()ing!
       tst.l   reqbase
       bne     InReqBoards
       tst.l   AslFR
       bne     InAslBoards
       bsr     FadeOut
       bsr     mt_end
       bsr     clrscr
       move.l  gfxbase,a6
       move.l  Rast,a1
       moveq.l #0,d0
       move.l  #100,d1
       jsr     _LVOMove(a6)
       move.l  #end_ReqMsg-ReqMsg,d0
       lea     ReqMsg,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
 ENDIF
LSLoop:
 IFEQ REGISTERED,1
       lea     TexBuf,a5
       addq.l  #4,a5
       move    #35,LenStr
       move.l  a5,-(sp)    ;Poped by GetLB
       move.l  gfxbase,a6
       move.l  Rast,a1
       moveq.l #0,d0
       move.l  #65,d1
       jsr     _LVOMove(a6)
       move.l  #end_LodMsg-LodMsg,d0
       lea     LodMsg,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
       bra     GetLB
 ENDIF
INBdsCnt:
 IFEQ REGISTERED,1
       move.b  #0,(a5)
       bsr     FadeOut
       bsr     clrscr
       bsr     ColorOn
 ENDIF
LSreqG:
 IFEQ REGISTERED,1
       move.l  dosbase,a6
       move.l  #MODE_OLD,d2
       move.l  #TexBuf,d1
       addq.l  #4,d1
       move.l  d1,a0
       tst.b   (a0)
       beq     DonLod
       jsr     _LVOOpen(a6)
       move.l  d0,d7
       tst.l   d7
       beq     NFdErr
       move.l  d7,d1
       move.l  #LodSavHdr,d2
       move.l  #21012,d3
       jsr     _LVORead(a6)
       move.l  d0,d6
       move.l  d7,d1
       jsr     _LVOClose(a6)
       move.l  LodSavHdr,d0
       clr.b   d0    ;Clear JUST the low byte.
       cmp.l   #'BDS'<<8,d0
       bne     NoV
       subq.l  #4,d6
       cmp.b   #VERSION,LodSavHdr+3
       bls     Vok
       bra     VerErr
 ENDIF
NoV:
 IFEQ REGISTERED,1
       lea     LodSavHdr+21008,a0
       lea     4(a0),a1
       move.l  #5251,d0   ;21008 / 4 - 1
 ENDIF
NoVb:
 IFEQ REGISTERED,1
       move.l  -(a0),-(a1)
       dbra    d0,NoVb
 ENDIF
Vok:   
 IFEQ REGISTERED,1
       move.l  MemPtr,a2
       moveq.l #0,d7
       bsr     DecodeBoards
       tst     d0
       beq     LodErr
       bra     INBc
 ENDIF

CopyBoards:    ;Send boards to (a2)+
       movem.l d1-a6,-(sp)
       lea     CompBoards,a0
       lea     Chk2,a1
       move.l  #(CompBoardSiz-1),d0
       lsr     #2,d0
CpBds1:move.l  (a0)+,(a1)+
       dbra    d0,CpBds1
       move.l  #CompBoardSiz,d6
       move.l  #$534d3a7f,d7      ; $fe21489a XOR $ad6c72e5
       bsr     DecodeBoards       ; ^ Magic key!  ^Serial number encryptor
       movem.l (sp)+,d1-a6
       rts

; a2 = dest
; d6 = length of file
; d7 = required key XOR $ad6c72e5, or 0 for any key.
DecodeBoards:
       cmp.l   #10,d6
       subq.l  #8,d6
       lsr.l   #2,d6
       move.l  d6,d3
       ble     DecErr
       lea     chk1,a3
;       move.l  #5250,d3
       move.l  chk2,d5      ;d5 = chk2
Mov1:  sub.l   (a3)+,d5
       dbra    d3,Mov1
 IFEQ REGISTERED,1
       tst.l   d5           ;d5 = MyKey XOR $ad6c72e5
       beq     DecErr
       cmp.l   #$ad6c72e5,d5
       beq     DecErr
       tst.l   d7
       beq     Mov1b
 ENDIF
       cmp.l   d5,d7
       bne     DecErr
Mov1b:
;       move.l  #5250,d3
       move.l  d6,d3
       lea     chk1,a3
Mov2:  xor.l   d5,(a3)+
       dbra    d3,Mov2
       moveq.l #0,d4
;       move.l  #5249,d3
       move.l  d6,d3
       subq.l  #1,d3
       lea     LodSavBuf,a3
Mov3:  add.l   (a3)+,d4
       dbra    d3,Mov3
       cmp.l   chk1,d4
       bne     DecErr
       move.l  #20999,d3
       lea     LodSavBuf,a3
       move.l  MemPtr,a2
       moveq.l #0,d0
INB1:  tst.b   d0          ;Run-length decoding
       blt     INBa
       tst.b   d0
       bgt     INBb
       move.b  (a3)+,d0
       bra     INB1
INBa:  add.b   #1,d0
       beq     INBaa
       move.b  (a3),(a2)+
       dbra    d3,INBa
       moveq   #1,d0
       rts
INBb:  subq    #1,d0
INBaa: move.b  (a3)+,(a2)+
       dbra    d3,INB1
       moveq   #1,d0
       rts
DecErr:moveq   #0,d0
       rts

INBc:                      ;finished decompression
 IFEQ REGISTERED,1
       lea     TexBuf,a0
       addq.l  #4,a0
       lea     ScoreName,a1
 ENDIF
INBd:  
 IFEQ REGISTERED,1
       move.b  (a0)+,(a1)+
       tst.b   (a0)
       bne     INBd
       move.b  #'.',(a1)+
       move.b  #'s',(a1)+
       move.b  #'c',(a1)+
       move.b  #'r',(a1)+
       clr.b   (a1)
       bsr     LoadScores
       bra     DonLod
 ENDIF
LodErr:
 IFEQ REGISTERED,1
       tst.l   reqbase
       bne     ReqLodErr
       tst.l   AslFR
       bne     AslLodErr
       bsr     ColorOff
       bsr     clrscr
       move.l  gfxbase,a6
       move.l  Rast,a1
       moveq.l #0,d0
       move.l  #100,d1
       jsr     _LVOMove(a6)
       move.l  #end_CorMsg-CorMsg,d0
       lea     CorMsg,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
       bra     LSloop
 ENDIF
NFdErr:
 IFEQ REGISTERED,1
       tst.l   reqbase
       bne     ReqNFdErr
       tst.l   AslFR
       bne     AslNFdErr
       bsr     ColorOff
       bsr     clrscr
       move.l  gfxbase,a6
       move.l  Rast,a1
       moveq.l #0,d0
       move.l  #100,d1
       jsr     _LVOMove(a6)
       move.l  #end_NFdMsg-NFdMsg,d0
       lea     NFdMsg,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
       bra     LSloop
 ENDIF
VerErr:
 IFEQ REGISTERED,1
       tst.l   reqbase
       bne     ReqVerErr
       tst.l   AslFR
       bne     AslVerErr
       bsr     ColorOff
       bsr     clrscr
       move.l  gfxbase,a6
       move.l  Rast,a1
       moveq.l #0,d0
       move.l  #100,d1
       jsr     _LVOMove(a6)
       move.l  #end_VerMsg-VerMsg,d0
       lea     VerMsg,a0
       move.l  Rast,a1
       jsr     _LVOText(a6)
       bra     LSloop
 ENDIF
DonLod:
 IFEQ REGISTERED,1
       tst.l   reqbase
       bne     ReqDonLod
       tst.l   AslFR
       bne     AslDonLod
       bsr     ColorOff
       movem.l (sp)+,d0-d7/a0-a5  ;Get message back
 ENDIF
NoLoadAllowed:
       move.l  a5,a1
       move.l  ExecBase,a6
       jsr     _LVOReplyMsg(a6)
 IFEQ REGISTERED,0
       clr     FadeMus
       bsr     FadeOut
       bsr     clrscr
       bsr     ShowTiredText
 ENDIF
       bsr     DumpMsgs
       bra     TitScr

MoveBallSprite:
       tst     UseBallBob
       bne     MoveBallBob
       tst     v39
       beq     MBSx
       move    d0,sx
       move    d1,sy
       addq.w  #1,d0
MBSx:  jsr     _LVOMoveSprite(a6)
       rts
MoveBallBob:
       bsr     HideBallBob
       move    d0,sx
       move    d1,sy
       tst     d0
       blt     _rts
       cmp     #315,d0
       bgt     _rts
       tst     d1
       blt     _rts
       cmp     #200,d1
       bge     _rts
       addq    #1,d0   ;Sprites are shifted by one!
       move    d0,bhx
       move    d1,bhy
       movem.l d2-d7/a2,-(sp)
       moveq   #4,d4
       moveq   #4,d5
       move    d0,d2
       move    d1,d3
       bsr     HideBobsHere
       move.l  #302,d2
       move.l  #15,d3
       cmp     #196,d1   ;bottom part chopped off?
       ble     mbb2
       move    #200,d5
       sub     d1,d5
mbb2:  move    #$c0,d6
       move    #$ff,d7
       move.l  bit2map,a1
       move.l  bit1map,a0
       suba.l  a2,a2
       jsr     _LVOBltBitMap(a6)       ;bkg store
       move.l  #297,d0
       move.l  #15,d1
       move    bhx,d2
       move    bhy,d3
       move.l  bit2map,a0
       move.l  bit1map,a1
       move    #$ff,d7  ;OS bug, DUH!
       jsr     _LVOBltBitMap(a6)       ;draw ball
       move    #1,BallVis
       movem.l (sp)+,d2-d7/a2
       rts
HideBallBob:
       tst     BallVis
       beq     _rts
       movem.l d0-a2/a6,-(sp)
       move.l  #302,d0
       move.l  #15,d1
       move    bhx,d2
       move    bhy,d3
       moveq   #4,d4
       moveq   #4,d5
       cmp     #196,d3   ;bottom part chopped off?
       ble     hbb1
       move    #200,d5
       sub     d3,d5
hbb1:  move    #$c0,d6
       move    #$ff,d7
       move.l  bit2map,a0
       move.l  bit1map,a1
       suba.l  a2,a2
       move.l  gfxbase,a6
       jsr     _LVOBltBitMap(a6)
       clr     BallVis
       movem.l (sp)+,d0-a2/a6
       rts
ShowBobs:
       movem.l d0-d1/a0-a1/a6,-(sp)
       move.l  gfxbase,a6
       tst     UseBallBob
       beq     sb2
       tst     BallVis
       bne     sb2
       move    sx,d0
       move    sy,d1
       bsr     MoveBallBob
sb2:   tst     UseLasBobs
       beq     sb0
       tst     Las1Vis
       bne     sb3
       move    Lasx1,d0
       move    Lasy1,d1
       bsr     MoveLas1Bob
sb3:   tst     Las2Vis
       bne     sb0
       move    Lasx2,d0
       move    Lasy2,d1
       bsr     MoveLas2Bob
sb0:   movem.l (sp)+,d0-d1/a0-a1/a6
       rts
HideBobs:
       bsr     HideBallBob
       bsr     HideLas1Bob
       bsr     HideLas2Bob
       rts

; Hide the bobs in a specific part of the screen.
; inputs: d2 = x, d3 = y, d4 = wid, d5 = hig (of protected area).
; output: all registers preserved.
HideBobsHere:
       movem.l d0-d3/d6-d7/a2,-(sp)
       move    d2,d6
       move    d3,d7
       tst     BallVis
       beq     hbh1
       move    bhx,d0
       move    bhy,d1
       lea     HideBallBob,a2
       bsr     hbhA
hbh1:  tst     Las1Vis
       beq     hbh2
       move    l1hx,d0
       move    l1hy,d1
       move    d6,d2
       move    d7,d3
       lea     HideLas1Bob,a2
       bsr     hbhA
hbh2:  tst     Las2Vis
       beq     hbh0
       move    l2hx,d0
       move    l2hy,d1
       move    d6,d2
       move    d7,d3
       lea     HideLas2Bob,a2
       bsr     hbhA
hbh0:  movem.l (sp)+,d0-d3/d6-d7/a2
       rts
hbhA:  addq    #4,d0
       addq    #5,d1
       cmp     d0,d2
       bgt     _rts
       cmp     d1,d3
       bgt     _rts
       subq    #4,d0
       subq    #5,d1
       add     d4,d2
       add     d5,d3
       cmp     d2,d0
       bgt     _rts
       cmp     d3,d1
       bgt     _rts
       jmp     (a2)

ToggleBallBob:
       movem.l d0-d3/a0-a1/a6,-(sp)
       move    sx,d2
       move    sy,d3
       moveq.l #0,d0
       moveq.l #0,d1
       move.w  #-40,d0
       move.w  #-4,d1
       move.l  gfxbase,a6
       move.l  ViewPort,a0
       move.l  ballsp,a1
       jsr     MoveBallSprite  ;Yank ball off screen
       eor     #1,UseBallBob
       moveq.l #0,d0
       moveq.l #0,d1
       move    d2,d0
       move    d3,d1
       move.l  gfxbase,a6
       move.l  ViewPort,a0
       move.l  ballsp,a1
       jsr     MoveBallSprite  ;Put ball back
       movem.l (sp)+,d0-d3/a0-a1/a6
       rts
MoveLas1Sprite:
       tst     UseLasBobs
       bne     MoveLas1Bob
       tst     v39
       beq     ML1Sx
       move    d0,Lasx1
       move    d1,Lasy1
       addq.w  #1,d0
ML1Sx: jsr     _LVOMoveSprite(a6)
       rts
MoveLas1Bob:
       bsr     HideLas1Bob
       move    d0,Lasx1
       move    d1,Lasy1
       tst     d0
       blt     _rts
       cmp     #316,d0
       bgt     _rts
       tst     d1
       blt     _rts
       cmp     #194,d1
       bgt     _rts
       addq    #1,d0   ;Sprites are shifted by one!
       move    d0,l1hx
       move    d1,l1hy
       movem.l d2-d7/a2,-(sp)
       moveq   #3,d4
       moveq   #5,d5
       move    d0,d2
       move    d1,d3
       bsr     HideBobsHere
       move.l  #295,d2
       move.l  #27,d3
       move    #$c0,d6
       move    #$ff,d7
       move.l  bit2map,a1
       move.l  bit1map,a0
       suba.l  a2,a2
       jsr     _LVOBltBitMap(a6)       ;bkg store
       move.l  #295,d0
       move.l  #21,d1
       move    l1hx,d2
       move    l1hy,d3
       move.l  bit2map,a0
       move.l  bit1map,a1
       move    #$ff,d7  ;OS bug, DUH!
       jsr     _LVOBltBitMap(a6)       ;draw las1
       move    #1,Las1Vis
       movem.l (sp)+,d2-d7/a2
       rts
HideLas1Bob:
       tst     Las1Vis
       beq     _rts
       movem.l d0-a2/a6,-(sp)
       move.l  #295,d0
       move.l  #27,d1
       move    l1hx,d2
       move    l1hy,d3
       moveq   #3,d4
       moveq   #5,d5
       move    #$c0,d6
       move    #$ff,d7
       move.l  bit2map,a0
       move.l  bit1map,a1
       suba.l  a2,a2
       move.l  gfxbase,a6
       jsr     _LVOBltBitMap(a6)
       clr     Las1Vis
       movem.l (sp)+,d0-a2/a6
       rts
ToggleLasBobs:
       movem.l d0-d5/a0-a1/a6,-(sp)
       move    Lasx1,d2
       move    Lasy1,d3
       move    Lasx2,d4
       move    Lasy2,d5
       moveq.l #0,d0
       moveq.l #0,d1
       move.w  #-40,d0
       move.w  #-4,d1
       move.l  gfxbase,a6
       move.l  ViewPort,a0
       move.l  las1sp,a1
       jsr     MoveLas1Sprite  ;Yank las1 off screen
       moveq.l #0,d0
       moveq.l #0,d1
       move.w  #-40,d0
       move.w  #-4,d1
       move.l  ViewPort,a0
       move.l  las2sp,a1
       jsr     MoveLas2Sprite  ;Yank las2 off screen
       eor     #1,UseLasBobs
       moveq.l #0,d0
       moveq.l #0,d1
       move    d2,d0
       move    d3,d1
       move.l  ViewPort,a0
       move.l  las1sp,a1
       jsr     MoveLas1Sprite  ;Put las1 back
       moveq.l #0,d0
       moveq.l #0,d1
       move    d4,d0
       move    d5,d1
       move.l  ViewPort,a0
       move.l  las2sp,a1
       jsr     MoveLas2Sprite  ;Put las2 back
       movem.l (sp)+,d0-d5/a0-a1/a6
       rts
MoveLas2Sprite:
       tst     UseLasBobs
       bne     MoveLas2Bob
       tst     v39
       beq     ML2Sx
       move    d0,Lasx2
       move    d1,Lasy2
       addq.w  #1,d0
ML2Sx: jsr     _LVOMoveSprite(a6)
       rts
MoveLas2Bob:
       bsr     HideLas2Bob
       move    d0,Lasx2
       move    d1,Lasy2
       tst     d0
       blt     _rts
       cmp     #316,d0
       bgt     _rts
       tst     d1
       blt     _rts
       cmp     #194,d1
       bgt     _rts
       addq    #1,d0   ;Sprites are shifted by one!
       move    d0,l2hx
       move    d1,l2hy
       movem.l d2-d7/a2,-(sp)
       moveq   #3,d4
       moveq   #5,d5
       move    d0,d2
       move    d1,d3
       bsr     HideBobsHere
       move.l  #300,d2
       move.l  #27,d3
       move    #$c0,d6
       move    #$ff,d7
       move.l  bit2map,a1
       move.l  bit1map,a0
       suba.l  a2,a2
       jsr     _LVOBltBitMap(a6)       ;bkg store
       move.l  #300,d0
       move.l  #21,d1
       move    l2hx,d2
       move    l2hy,d3
       move.l  bit2map,a0
       move.l  bit1map,a1
       move    #$ff,d7  ;OS bug, DUH!
       jsr     _LVOBltBitMap(a6)       ;draw las2
       move    #1,Las2Vis
       movem.l (sp)+,d2-d7/a2
       rts
HideLas2Bob:
       tst     Las2Vis
       beq     _rts
       movem.l d0-a2/a6,-(sp)
       move.l  #300,d0
       move.l  #27,d1
       move    l2hx,d2
       move    l2hy,d3
       moveq   #3,d4
       moveq   #5,d5
       move    #$c0,d6
       move    #$ff,d7
       move.l  bit2map,a0
       move.l  bit1map,a1
       suba.l  a2,a2
       move.l  gfxbase,a6
       jsr     _LVOBltBitMap(a6)
       clr     Las2Vis
       movem.l (sp)+,d0-a2/a6
       rts
opendos:
       move.l  ExecBase,a6
       lea     dosname,a1
       moveq.l #36,d0
       jsr     _LVOopenlibrary(a6)  ;open dos.library
       move.l  d0,dosbase
       tst.l   d0
       bne     odos1
       clr     UseOS20
       clr     UseBallBob
       move.l  ExecBase,a6
       lea     dosname,a1
       moveq.l #0,d0
       jsr     _LVOopenlibrary(a6)  ;open dos.library
       move.l  d0,dosbase
odos1: tst.l   d0
       rts
closedos:
       move.l  ExecBase,a6
       move.l  dosbase,a1
       jsr     _LVOcloselibrary(a6) ;close dos.library
       rts
opendatatypes:
       moveq   #1,d0
       tst     v39
       beq     odt1
       move.l  ExecBase,a6
       lea     datatypesname,a1
       moveq.l #39,d0
       jsr     _LVOopenlibrary(a6)  ;open datatypes.library
       move.l  d0,DataTypesBase
odt1:  tst.l   d0
       rts
closedatatypes:
       tst     DataTypesBase
       beq     _rts
       move.l  ExecBase,a6
       move.l  DataTypesBase,a1
       jsr     _LVOcloselibrary(a6) ;close datatypes.library
       clr.l   DataTypesBase
       rts
openint:
       move.l  ExecBase,a6
       lea     intname,a1
       moveq.l #0,d0
       jsr     _LVOopenlibrary(a6)  ;open intuition.library
       move.l  d0,intbase
       tst.l   d0
       rts
closeint:
       move.l  ExecBase,a6
       move.l  intbase,a1
       jsr     _LVOcloselibrary(a6) ;close intuition.library
       rts
freeanim1:
  IFEQ CDROM,1
       movem.l d0/d1/a0/a1/a6,-(sp)
       move.l  ExecBase,a6
       lea     freeanimname,a1
       moveq.l #0,d0
       jsr     _LVOopenlibrary(a6)  ;start freeing that silly animation!
       move.l  d0,freeanimbase
       movem.l (sp)+,d0/d1/a0/a1/a6
       rts
  ENDIF
freeanim2:
  IFEQ CDROM,1
       tst.l   freeanimbase
       beq     _rts
       movem.l d0/d1/a0/a1/a6,-(sp)
       move.l  ExecBase,a6
       move.l  freeanimbase,a1
       jsr     _LVOcloselibrary(a6) ;Wait for anim to finish...
       movem.l (sp)+,d0/d1/a0/a1/a6
       rts
  ENDIF
openlow:
       move.l  ExecBase,a6
       lea     lowlevelname,a1
       moveq.l #0,d0
       jsr     _LVOopenlibrary(a6)  ;open lowlevel.library
       move.l  d0,LowLevelBase
       tst.l   d0
       rts
closelow:
       tst.l   LowLevelBase
       beq     _rts
       move.l  ExecBase,a6
       move.l  LowLevelBase,a1
       jsr     _LVOcloselibrary(a6) ;close lowlevel.library
       rts
opengfx:
       move.l  ExecBase,a6
       lea     gfxname,a1
       moveq.l #39,d0
       jsr     _LVOopenlibrary(a6)  ;open graphics.library v39
       move.l  d0,gfxbase
       tst.l   d0
       bne     gv39
       clr     v39
       clr     UseLasBobs
       move.l  #1,Ignore_below_v39  ;TAG_IGNORE
       move.l  #ballsprite,BallSP
       move.l  #Las1Sprite,Las1SP   ;Init pre-v39 SimpleSprite pointers
       move.l  #Las2Sprite,Las2SP
       lea     gfxname,a1
       moveq.l #0,d0
       jsr     _LVOopenlibrary(a6)  ;open old graphics.library
       move.l  d0,gfxbase
gv39:  tst.l   d0
       rts
closegfx:
       move.l  ExecBase,a6
       move.l  gfxbase,a1
       jsr     _LVOcloselibrary(a6) ;close graphics.library
       rts
opendiskfont:
       move.l  ExecBase,a6
       lea     DiskFontName,a1
       moveq.l #0,d0
       jsr     _LVOopenlibrary(a6)  ;open diskfont.library
       move.l  d0,fontbase
       tst.l   d0
       rts
closediskfont:
       move.l  ExecBase,a6
       move.l  fontbase,a1
       jsr     _LVOcloselibrary(a6) ;close diskfont.library
       rts

; inputs: a0 = string, d0 = default.  Output: d0.
GetBool:
       lea     TexBuf,a1
       moveq   #0,d1
GB1:   move.b  (a0)+,d1
       cmp.b   #'a',d1
       blt     GB2
       cmp.b   #'z',d1
       bgt     GB2
       sub.b   #'a'-'A',d1
GB2:   move.b  d1,(a1)+
       bne     GB1
       moveq   #3,d1
GB3:   clr.b   (a1)+
       dbra    d1,GB3
       move.l  TexBuf,d1
       cmp.l   #'ON'<<16,d1
       beq.s   GB_on
       cmp.l   #'OFF'<<8,d1
       beq.s   GB_off
       cmp.l   #'YES'<<8,d1
       beq.s   GB_on
       cmp.l   #'NO'<<16,d1
       beq.s   GB_off
       cmp.l   #'1'<<24,d1
       beq.s   GB_on
       cmp.l   #'0'<<24,d1
       beq.s   GB_off
       rts
GB_on: moveq   #1,d0
       rts
GB_off:moveq   #0,d0
       rts

openicon:
       clr.l   iconbase
       clr.l   MyDiskObj
       clr.l   MyToolTypes
       tst.l   SaveArgs
       beq     _rts
       move.l  ExecBase,a6
       lea     iconname,a1
       moveq.l #0,d0
       jsr     _LVOopenlibrary(a6)  ;open icon.library
       move.l  d0,iconbase
       tst.l   d0
       beq     _rts
       move.l  SaveArgs,a0
       tst.l   WBMsg
       bne     oi1
       tst     Debug
       bne     oi1
       lea     TexBuf,a1
       moveq   #0,d0
       cmp.l   #1,ArgLen
       bls.s   Arg2
       move.l  ArgLen,d0
       bra.s   Arg3
Arg2:  move.b  (a0)+,d0
Arg3:  subq.l  #1,d0
oi2:   cmp.b   #' ',(a0)
       bls     oi3
       move.b  (a0)+,(a1)+
       dbra    d0,oi2
oi3:   clr.b   (a1)
       lea     TexBuf,a0
oi1:   move.l  iconbase,a6
       jsr     _LVOGetDiskObject(a6)
       tst.l   d0
       beq     _rts
       move.l  d0,MyDiskObj
       move.l  d0,a0
       move.l  $36(a0),d2
       tst.l   d2
       beq     _rts
       move.l  d2,MyToolTypes
       move.l  d2,a0
       lea     Tool_Title,a1
       jsr     _LVOFindToolType(a6)
       tst.l   d0
       beq.s   oi4
       move.l  d0,Name_Title
oi4:   move.l  d2,a0
       lea     Tool_High,a1
       jsr     _LVOFindToolType(a6)
       tst.l   d0
       beq.s   oi5
       move.l  d0,Name_High
oi5:   move.l  d2,a0
       lea     Tool_Dead,a1
       jsr     _LVOFindToolType(a6)
       tst.l   d0
       beq.s   oi6
       move.l  d0,Name_Dead
oi6:   move.l  d2,a0
       lea     Tool_Life,a1
       jsr     _LVOFindToolType(a6)
       tst.l   d0
       beq.s   oi6b
       move.l  d0,Name_Life
oi6b:  move.l  d2,a0
       lea     Tool_Pause,a1
       jsr     _LVOFindToolType(a6)
       tst.l   d0
       beq.s   oi7
       move.l  d0,Name_Pause
oi7:   move.l  d2,a0
       lea     Tool_Music,a1
       jsr     _LVOFindToolType(a6)
       tst.l   d0
       beq     oi9
       move.l  d0,a0
       moveq   #1,d0
       bsr     GetBool
       move    d0,Music
oi9:   move.l  d2,a0
       lea     Tool_BallBob,a1
       jsr     _LVOFindToolType(a6)
       tst.l   d0
       beq     oi10
       move.l  d0,a0
       moveq   #0,d0
       move    UseBallBob,d0
       bsr     GetBool
       move    d0,UseBallBob
oi10:  move.l  d2,a0
       lea     Tool_LaserBobs,a1
       jsr     _LVOFindToolType(a6)
       tst.l   d0
       beq     oi11
       move.l  d0,a0
       moveq   #0,d0
       move    UseLasBobs,d0
       bsr     GetBool
       move    d0,UseLasBobs
oi11:  move.l  d2,a0
       lea     Tool_ModeID,a1
       jsr     _LVOFindToolType(a6)
       tst.l   d0
       beq     oi8e
       move.l  d0,a0
       moveq   #0,d0
       moveq   #0,d1
oi11b: move.b  (a0)+,d1
       cmp.b   #'0',d1
       blt     oi11f
       cmp.b   #'9',d1
       bgt     oi11c
       sub.b   #'0',d1
oi11c: cmp.b   #'A',d1
       blt     oi11d
       cmp.b   #'F',d1
       bgt     oi11d
       sub.b   #'A'-10,d1
oi11d: cmp.b   #'a',d1
       blt     oi11e
       cmp.b   #'f',d1
       bgt     oi11e
       sub.b   #'a'-10,d1
oi11e: cmp.b   #15,d1
       bgt     oi11f
       lsl.l   #4,d0
       or.b    d1,d0
       bra     oi11b
oi11f: move.l  #$80000032,MId   ;SA_DisplayID
       move.l  d0,MId+4
oi8e:  move.l  d2,a0
       lea     Tool_Random,a1
       jsr     _LVOFindToolType(a6)
       tst.l   d0
       beq     oi8
       move.l  d0,a0
       moveq   #1,d0
       bsr     GetBool
       tst     d0
       beq     _rts
oi8:   moveq   #0,d3    ;This is the randomizer.  Don't come here if
oi8c:  addq.l  #1,d3    ;you found RANDOM=NO.
       move.l  d3,d0
       lea     TexBuf,a5
       bsr     PrtNum
       clr.b   (a5)+
       lea     Tool_TuneX+4,a0
       lea     TexBuf,a1
oi8a:  cmp.b   #'0',(a1)+
       beq     oi8a
       subq.l  #1,a1
oi8b:  move.b  (a1)+,(a0)+
       bne     oi8b
       move.l  MyToolTypes,a0
       lea     Tool_TuneX,a1
       jsr     _LVOFindToolType(a6)
       tst.l   TuneList
       bne     oi8d
       tst.l   d0
       bne     oi8c
       subq.l  #1,d3
       cmp     #4,d3  ;Less than 4 tunes can't be random.
       blo     _rts
       move    d3,NumTunes
       mulu    #6,d3
       move.l  d3,d0
       move.l  #MEMF_CLEAR,d1
       move.l  ExecBase,a6
       bsr     AllocVec
       move.l  d0,TuneList
       beq     _rts
       move.l  iconbase,a6
       move.l  d0,a4
       bra     oi8
oi8d:  tst.l   d0
       beq     RandomizeTuneList  ;And don't come back!!
       addq.l  #2,a4
       move.l  d0,(a4)+
       bra     oi8c
closeicon:
       tst.l   iconbase
       beq     _rts
       tst.l   MyDiskObj
       beq     ci1
       move.l  MyDiskObj,a0
       move.l  iconbase,a6
       jsr     _LVOFreeDiskObject(a6)
ci1:   move.l  ExecBase,a6
       move.l  iconbase,a1
       jsr     _LVOcloselibrary(a6) ;close icon.library
       clr.l   iconbase
       rts
openiff:
       moveq   #1,d0
       tst     v39
       bne     gv39
       move.l  ExecBase,a6
       lea     iffname,a1
       moveq.l #0,d0
       jsr     _LVOopenlibrary(a6)  ;open iff.library
       move.l  d0,iffbase
       tst.l   d0
       bne     _rts
       move.l  #no_iff,ErrPtr
       tst.l   d0
_rts:  rts
closeiff:
       tst.l   iffbase
       beq     _rts
       move.l  ExecBase,a6
       move.l  iffbase,a1
       jsr     _LVOcloselibrary(a6) ;close iff.library
       clr.l   iffbase
       rts

LoadScores:
       lea     ScoreList,a0
       lea     end_ScoreList,a1
IniScr:move.l  (a1)+,(a0)+
       cmp.l   #end_ScoreList,a0
       blt     IniScr
       move.l  dosbase,a6
       move.l  #ScoreName,d1
       move.l  #MODE_OLD,d2
       jsr     _LVOOpen(a6)
       move.l  d0,scorehd
       tst.l   d0
       beq     _rts
       move.l  #end_ScoreList-ScoreList,d3
       move.l  #ScoreList,d2
       move.l  d0,d1
       jsr     _LVORead(a6)      ;Load high score list, if available
       move.l  scorehd,d1
       jsr     _LVOClose(a6)
       rts
SaveScores:
       bsr     clrscr
       bsr     ColorOn
       move.l  dosbase,a6
       move.l  #ScoreName,d1
       move.l  #MODE_NEW,d2
       jsr     _LVOOpen(a6)
       move.l  d0,scorehd
       tst.l   d0
       beq     _rts
       move.l  #end_ScoreList-ScoreList,d3
       move.l  #ScoreList,d2
       move.l  d0,d1
       jsr     _LVOWrite(a6)   ;try to save high score list
       move.l  scorehd,d1
       jsr     _LVOClose(a6)
       rts
pic2plane:                   ;IFF ptr must be in a1!
       movem.l a0/a1,-(sp)   ;dest bitmap must be in a0!
       move.l  iffbase,a6
       lea     ctable,a0
       jsr     _LVOGetColorTab(a6)
       tst.l   d0
       bne     dop2p
       addq.l  #8,sp         ;don't need pichd/bitmap
       move.l  #no_color,ErrPtr
       bra     IffError
dop2p: movem.l (sp)+,a0/a1
       jsr     _LVODecodePic(a6)
       tst.l   d0
       bne     _rts
       move.l  #no_decode,ErrPtr   ;Fall into IFFerror.
IFFerror:
       move.l  iffbase,a6
       jsr     _LVOIffError(a6)    ;Fall into sorrybud.
sorrybud:
       moveq.l #0,d1
       tst.l   d1
       rts
openreq:
 IFEQ REGISTERED,1
       move.l  ExecBase,a6
       lea     reqname,a1
       move.l  #ReqVersion,d0
       jsr     _LVOopenlibrary(a6)  ;open req.library
       move.l  d0,reqbase
       tst.l   d0
       beq     _rts
       lea     FileRequestor,a0
       move.l  #f_Title,frq_Title(a0)
       move.l  #f_Dir,frq_Dir(a0)
       move.l  #f_File,frq_File(a0)
       move.w  #6,frq_WindowLeftEdge(a0)
       move.w  #15,frq_WindowTopEdge(a0)
       move.w  #9,frq_dirnamescolor(a0)
       move.w  #17,frq_devicenamescolor(a0)
       move.w  #21,frq_gadgettextcolor(a0)
       move.w  #26,frq_stringnamecolor(a0)
       move.w  #4,frq_boxbordercolor(a0)
       move.w  #13,frq_stringgadgetcolor(a0)
       move.w  #13,frq_gadgetboxcolor(a0)
       move.l  #TexBuf+4,frq_PathName(a0)
       move.l  #FRQCACHINGM+FRQNODRAGM+FRQABSOLUTEXYM+FRQLOADINGM,frq_Flags(a0)
       lea     frq_ExtendedSelect+4+WILDLENGTH+2(a0),a0
       lea     f_Show,a1
 ENDIF
orq1: 
 IFEQ REGISTERED,1
       move.b  (a1)+,(a0)+
       bne     orq1
       rts
 ENDIF
closereq:
 IFEQ REGISTERED,1
       move.l  reqbase,a6
       cmp.l   #0,a6
       beq     _rts
       lea     FileRequestor,a0
       jsr     _LVOPurgefiles(a6)
       move.l  a6,a1
       move.l  ExecBase,a6
       jsr     _LVOcloselibrary(a6) ;close req.library
       rts
 ENDIF
openasl:
 IFEQ REGISTERED,1
       moveq   #0,d0
       tst     UseOS20
       beq     NoAsl
       move.l  ExecBase,a6
       lea     aslname,a1
       moveq.l #37,d0
       jsr     _LVOOpenLibrary(a6)  ;open asl.library
 ENDIF
NoAsl: 
 IFEQ REGISTERED,1
       move.l  d0,aslbase
       tst.l   d0
       beq     _rts
       move.l  d0,a6
       moveq   #0,d0           ;ASL_FileRequest
       lea     AslAllocTags,a0
       jsr     _LVOAllocAslRequest(a6)
       move.l  d0,AslFR
       tst.l   d0
       rts
 ENDIF
closeasl:
 IFEQ REGISTERED,1
       move.l  aslbase,a6
       cmp.l   #0,a6
       beq     _rts
       move.l  AslFR,a0
       cmp.l   #0,a0
       beq     NoAFR
       jsr     _LVOFreeAslRequest(a6)
 ENDIF
NoAFR: 
 IFEQ REGISTERED,1
       move.l  a6,a1
       move.l  ExecBase,a6
       jsr     _LVOcloselibrary(a6) ;close asl.library
       rts
 ENDIF
openscreen:                 ;handle returned in d0.
       move.l  intbase,a6
       lea     screendef,a0
       jsr     _LVOOpenScreen(a6)
       tst.l   d0
       rts
closescreen:                ;put handle in a0.
       move.l  intbase,a6
       jsr     _LVOCloseScreen(a6)
       rts
allocbitmap:                ;handle returned in d0.
       tst     v39
       beq     abmOld
       move.l  gfxbase,a6
       move.l  #320,d0
       move.l  #200,d1
       moveq.l #0,d2
       move    Depth,d2
       move.l  #5,d3        ;Flags, 5 = BMF_INTERLEAVED|BMF_CLEAR
       move.l  screenhd,a0
       add.l   #84,a0
       move.l  4(a0),a0     ;Friend bitmap.
       jsr     _LVOAllocBitMap(a6)
       tst.l   d0
       rts
abmOld:move.l  ExecBase,a6
       move.l  #40,d0
       move.l  #MEMF_CLEAR,d1
       jsr     _LVOAllocMem(a6)
       tst.l   d0
       beq     _rts
       moveq   #0,d2
       move    Depth,d2
       move.l  d0,a2
       move.l  d0,a3
       move.w  #40,(a3)+   ;BytesPerRow
       move.w  #200,(a3)+  ;Rows
       clr.b   (a3)+       ;Flags
       move.b  d2,(a3)+    ;Depth
       addq.l  #2,a3       ;Pad
       subq    #1,d2
       move.l  gfxbase,a6
abmo1: move.l  #320,d0
       move.l  #200,d1
       jsr     _LVOAllocRaster(a6)
       move.l  a2,a0
       tst.l   d0
       beq     freebitmap
       move.l  d0,(a3)+
       dbra    d2,abmo1
       move.l  a2,d0
       tst.l   d0
       rts
freebitmap:                 ;put handle in a0.
       move.l  gfxbase,a6
       tst     v39
       beq     fbmOld
       jsr     _LVOFreeBitMap(a6)
       rts
fbmOld:move.l  a0,a2
       lea     8(a2),a3
       moveq   #0,d2
       move    Depth,d2
       subq    #1,d2
fbmo1: tst.l   (a3)+
       beq.s   fbmo2
       move.l  -4(a3),a0
       move.l  #320,d0
       move.l  #200,d1
       jsr     _LVOFreeRaster(a6)
fbmo2: dbra    d2,fbmo1
       move.l  a2,a1
       move.l  #40,d0
       move.l  ExecBase,a6
       jsr     _LVOFreeMem(a6)
       moveq   #0,d0
       rts
Errwindopen:
       move.l  intbase,a6
       lea     Errwinddef,a0
       jsr     _LVOopenwindow(a6)   ;make my error window.
       move.l  d0,windowhd
       tst.l   d0
       rts
windopen:
       move.l  intbase,a6
       lea     windowdef,a0
       jsr     _LVOopenwindow(a6)   ;make my window.
       move.l  d0,windowhd
       tst.l   d0
       bne     _rts
       move.l  #no_window,ErrPtr
       tst.l   d0
       rts
windclose:
       move.l  intbase,a6
       move.l  windowhd,a0
       jsr     _LVOclosewindow(a6)  ;close it.
       rts
rnd:
       move.l  GfxBase,D0         ;Calculate random number:
       move.l  IntBase,D1          ;INPUTS:
       eor.l   D1,D0                ;d0,d1 = scratch
       move.l  ViewPort,D1          ;d2    = maximum value (0 for 32bit output)
       eor.l   D1,D0               ;OUTPUT:
       move.l  windowhd,D1          ;d0    = answer
       eor.l   D1,D0
       add.l   D0,rMicros
       move.l  rMicros,D1
       swap    d0
       add     d0,d1
       swap    d0
       mulu    d1,d0
       swap    d1
       swap    d0
       add     d0,d1
       swap    d0
       muls    d1,d0
       eor.l   d1,d0
       swap    d0
       add.l   #$3f8a2695,d0
       addq    #1,RndCount
       add     RndCount,d0
       cmp     #200,RndCount
       blt     R1
       swap    d0
       add.l   #$1d301,d0
R1:    move.l  d0,rMicros
       eor.l   #$47C19DA5,D0
       move.l  D0,D1
       swap    D1
       eor.l   D1,D0
       tst.l   d2
       beq     _rts
       and.l   #$ffff,d0
       move.l  D2,D1
       addq    #1,D1
       divu    D1,D0
       swap    D0
       rts

; TuneList points to an array of:
;   WORD number
;   STRPTR name
; The numbers are randomized and used to sort the names.
RandomizeTuneList:
       tst.l   TuneList
       beq     _rts
       movem.l d0-d3/a0-a3,-(sp)
       move.l  TuneList,a0
       moveq   #0,d3
       move    NumTunes,d3
       subq    #1,d3
rtl1:  moveq   #0,d2    ;0 for full randomness.
       bsr     rnd
       move.w  d0,(a0)+
       addq.l  #4,a0
       dbra    d3,rtl1
       moveq   #0,d0       ;Exchange sort!
       subq.l  #6,a0       ;  a0 = end of list.
       move.l  TuneList,a1 ;  a1 = start of list.
rtl3:  move.l  a1,a3       ;  a3 = position of max val.
       move.l  a1,a2       ;  a2 = current ptr.
       move    (a2),d0     ;  d0 = max value seen
rtl2:  cmp     (a2),d0
       bhs.s   rtl4
       move    (a2),d0     ;Find max.
       move.l  a2,a3
rtl4:  addq.l  #6,a2
       cmp.l   a2,a0
       bhs     rtl2
       move    (a0),(a3)   ;Exchange!!
       move    d0,(a0)
       move.l  2(a3),d0
       move.l  2(a0),2(a3)
       move.l  d0,2(a0)
       subq.l  #6,a0
       cmp.l   a1,a0
       bhi     rtl3
       movem.l (sp)+,d0-d3/a0-a3
       rts

       Include "proplayer.include"   ;OctaMED play routines.
       CODE

; d0 = size, d1 = requirements, a6 = ExecBase.
AllocVec:
       addq.l  #7,d0
       and.l   #-4,d0   ;Size mod 4, for CopyMemQuick.
       move.l  d0,-(sp)
       jsr     _LVOAllocMem(a6)
       move.l  (sp)+,d1
       tst.l   d0
       beq     _rts
       move.l  d0,a0
       move.l  d1,(a0)
       addq.l  #4,d0
       rts

; a1 = pointer, a6 = ExecBase
FreeVec:
       move.l  -(a1),d0
       jsr     _LVOFreeMem(a6)
       rts

; a1 = pointer, d1 = requirements, a6 = ExecBase.
CopyVec:
       move.l  -(a1),d0
       move.l  a1,-(sp)
       move.l  d0,-(sp)
       jsr     _LVOAllocMem(a6)
       move.l  (sp)+,d1
       move.l  (sp)+,a0  ;a0 = source
       tst.l   d0
       beq     _rts
       move.l  d0,a1     ;a1 = dest
       move.l  d0,-(sp)
       move.l  d1,d0     ;d0 = size
       jsr     _LVOCopyMemQuick(a6)
       move.l  (sp)+,d0
       addq.l  #4,d0
       rts

; inputs:  d0.l is NULL if a Chip pre-loaded tune needs to be dumped.
;          a6 = ExecBase
; output:  All regs preserved except D1!
;          Zero flag is set if nothing happened, clear if mem was freed.
MaybeDumpChip:
       moveq   #0,d1
       tst.l   d0
       bne     mdcX
       movem.l d0/a0-a2,-(sp)
       lea     mts_pause,a2
       bsr     mdcS
       lea     mts_title,a2
       bsr     mdcS
       lea     mts_high,a2
       bsr     mdcS
       lea     mts_dead,a2
       bsr     mdcS
       lea     mts_life,a2
       bsr     mdcS
       movem.l (sp)+,d0/a0-a2
mdcX:  tst     d1
       rts
mdcS:  tst     d1
       bne     _rts
       move.l  (a2),a1
       cmp.l   #0,a1
       beq     _rts
       jsr     _LVOTypeOfMem(a6)
       moveq   #0,d1
       and.l   #MEMF_CHIP,d0
       beq     _rts
       move.l  (a2),a1
       bsr     FreeVec
       clr.l   (a2)
       moveq   #1,d1
       rts

UnLoadMusic:
       move.l  ExecBase,a6
       tst.l   mts_pause
       beq     ulm1b
       move.l  mts_pause,a1
       bsr     FreeVec
ulm1b: tst.l   mts_title
       beq     ulm1
       move.l  mts_title,a1
       bsr     FreeVec
ulm1:  tst.l   mts_high
       beq     ulm2
       move.l  mts_high,a1
       bsr     FreeVec
ulm2:  tst.l   mts_dead
       beq     ulm3
       move.l  mts_dead,a1
       bsr     FreeVec
ulm3:  tst.l   mts_life
       beq     ulm4
       move.l  mts_life,a1
       bsr     FreeVec
ulm4:  tst.l   TuneList
       beq     _rts
       move.l  TuneList,a1
       bsr     FreeVec
       rts

MIN_MEM_FREE = 50000

LoadMusic:
       move    #'x',LdStat1
       move.l  ExecBase,a6
;       move.l  #MEMF_LARGEST,d1
       moveq   #0,d1
       jsr     _LVOAvailMem(a6)
       cmp.l   #MIN_MEM_FREE,d0       ;Minimum free
       bls     _rts
       move    #'0',LdStat1
       move.l  Name_Life,a0
       lea     mts_life,a4
       bsr     LMsub
       move.l  Name_Dead,a0
       lea     mts_dead,a4
       bsr     LMsub1
       move.l  Name_High,a0
       lea     mts_high,a4
       bsr     LMsub1
       move.l  Name_Title,a0
       lea     mts_title,a4
       bsr     LMsub1
       move.l  Name_Pause,a0
       lea     mts_pause,a4
       bsr     LMsub1
       rts

LMsub:
       cmp.l   #0,a0
       beq     _rts
       tst.b   (a0)
       beq     LMsub1
       tst.b   1(a0)
       beq     LMsub1
       cmp.b   #'|',2(a0)
       bne     LMsub1
       addq.l  #3,a0
LMsub1:moveq   #0,d4
       move.l  a0,d1
       bsr     OMed_LoadD1
       tst.l   d5
       beq     _rts
       move.l  d5,(a4)
       addq.w  #1,LdStat1
       move.l  ExecBase,a6
       move.l  d5,a1
       jsr     _LVOTypeOfMem(a6)
       and.l   #MEMF_CHIP,d0
       beq     _rts
       move.l  d5,a2
       bsr     _RelocModule   ;If it's CHIP, fix the pointers.
       tst     d0
       beq     _rts
       clr.l   (a4)   ;Oops, it's bad!
       move.l  d5,a1
       bsr     FreeVec
       subq.w  #1,LdStat1
       moveq   #0,d5
; Continue into ModCorrupt.

ModCorrupt:
       move.l  #'BAD!',MusName+32
       rts
ModMem:
       move.l  #'MEM!',MusName+32
       rts
ModDisk:
       move.l  #'DISK',MusName+32
       rts
ModNA:
       move.l  #'N/A ',MusName+32
       rts

; Inputs: d1 = path/filename. Output: MusName = filename.
OMed_SaveD1:
       move.l  a1,-(sp)
       lea     MusName,a1
       tst.l   d1
       beq     OMS3
       move.l  d1,a0
OMS1:  lea     MusName,a1
OMS2:  move.b  (a0)+,d0
       cmp.b   #':',d0
       beq     OMS1
       cmp.b   #'/',d0
       beq     OMS1
       tst.b   d0
       beq.s   OMS3
       move.b  d0,(a1)+
       cmp.l   #MusName+31,a1
       blo     OMS2
OMS3:  move.b  #' ',(a1)+
       cmp.l   #MusName+36,a1
       blo     OMS3
       move.l  (sp)+,a1
       rts

; inputs: d1 = name, d4 = Mem requirements.
; output: d5 = mem.  A3 is scratch.
OMed_LoadD1:
       moveq   #0,d5
       lea     _rts,a3   ;(a3) = error routine.
       tst.l   d1
       beq     OMLxx
       move.l  d1,a0
       tst.b   (a0)
       beq     OMLxx
       move.l  dosbase,a6
       move.l  #MODE_OLD,d2
       jsr     _LVOOpen(a6)
       lea     ModNA,a3
       move.l  d0,d7
       beq     OMLxx
       lea     ModDisk,a3
       move.l  d0,d1
       moveq   #0,d2
       moveq   #1,d3           ;OFFSET_END
       jsr     _LVOSeek(a6)    ;seek to eof...
       cmp.l   #-1,d0
       beq     OMLx            ;File read kicked, close d7!
       move.l  d7,d1
       moveq   #0,d2
       moveq   #-1,d3          ;OFFSET_BEGINNING
       jsr     _LVOSeek(a6)    ;seek back.  *poof* get length of file!
       cmp.l   #-1,d0
       beq     OMLx
       move.l  d0,d6
       lea     ModMem,a3
       move.l  ExecBase,a6
OMLrt: move.l  d6,d0   ;in case of DumpChip
       move.l  d4,d1           ;Type of mem.
       bsr     AllocVec        ;Get mem for file
       bsr     MaybeDumpChip
       bne     OMLrt
       move.l  d0,d5
       beq     OMLx
       tst.l   d4         ;Is this pre-load?
       bne     OML1
       moveq   #0,d1      ;Yes, so check avail.
       jsr     _LVOAvailMem(a6)
       cmp.l   #MIN_MEM_FREE,d0       ;Minimum free
       bls     OMLx2
OML1:  move.l  dosbase,a6
       move.l  d7,d1           ;d7 has filehandle
       move.l  d5,d2           ;d5 has memory
       move.l  d6,d3           ;d6 has length
       lea     ModDisk,a3
       jsr     _LVORead(a6)
       cmp.l   d0,d6
       bne     OMLx2      ;File read kicked, free d5/d6 and close d7!
       move.l  d5,a2
       move.l  (a2),d0
       lea     ModCorrupt,a3
       sub.l   #'MMD0',d0
       cmp.l   #1,d0
       bhi     OMLx2
       bsr     CloseD7
       rts                  ;Success!
OMLx2: move.l  ExecBase,a6  ;Failure...
       move.l  d5,a1
       bsr     FreeVec
       moveq   #0,d5
OMLx:  bsr     CloseD7
OMLxx: clr     NoVoice0
       clr     DoSJump
       jmp     (a3)

OMed_PlayD5:
       move.l  d5,a0
       bsr     _PlayModule
       move    #2,Mus_Play
       rts

; **** Check if CD-DA needs updating ****
CD_CheckTune:
  IFEQ CDROM,1
       tst     Music
       beq     _rts
       sub     #1,CTcnt
       bgt     _rts
       movem.l d0-d1/a0-a1/a6,-(sp)
       move    #30,CTcnt
       cmp     #8,Mus_Play
       blt.s   cdct1
       move.l  ExecBase,a6     ;If we're already playing CD-DA,
       lea     MyCD,a1
       jsr     _LVOCheckIO(a6) ;see if it finished.
       tst.l   d0
       bne.s   cdct2           ;If so, start a new one.
       bra.s   cdct0
cdct1: tst     Mus_Play        ;If we're playing a mod,
       bne.s   cdct0           ;get lost.
       move.l  ExecBase,a6     ;If there is silence,
       lea     MyCD,a1         ;see if we have cd.device,
       tst.l   $14(a1)         ;and if so, see if there's a new disc...
       beq.s   cdct0
       move.w  #13,$1c(a1)     ;CD_CHANGENUM
       jsr     _LVODoIO(a6)
       lea     MyCD,a1
       tst.b   $1f(a1)
       bne.s   cdct0
       move.l  $20(a1),d0
       cmp.l   CDchange,d0
       beq.s   cdct0           ;If we got a new disc,
cdct2: bsr.s   CD_PlayTune     ;play something already.
cdct0: movem.l (sp)+,d0-d1/a0-a1/a6
  ENDIF
       rts

; **** Main CD-DA player entry point ****
CD_PlayTune:
  IFEQ CDROM,1
       tst     Music
       beq     _rts
       movem.l d0-d2/a0-a2/a5-a6,-(sp)
       moveq   #0,d2
       lea     MyCD,a2
       move.l  a2,a1
       tst.l   $14(a1)
       beq     cdpt0
       move.l  ExecBase,a6
       cmp     #8,Mus_Play
       bne     cdpt1
       jsr     _LVOCheckIO(a6)
       tst.l   d0
       beq     cdpt0
       clr     Mus_Play
       move.l  a2,a1
       jsr     _LVOWaitIO(a6)
       move.l  a2,a1
cdpt1: bsr     mt_end
       move.l  #CDmsg_change,d1
       bsr     OMed_SaveD1
       move.w  #13,$1c(a1)     ;CD_CHANGENUM
       jsr     _LVODoIO(a6)
       move.l  a2,a1
       tst.b   $1f(a1)
       bne     cdpt0
       move.l  $20(a1),d0
       cmp.l   CDchange,d0
       beq     cdpt2        ;same disk, same TOC.
       move.l  d0,CDchange
cdpt3: clr.l   MyTOC
       tst     d2           ;deja-vu, anyone?
       bne     cdpt0
       move.l  #CDmsg_TOC,d1
       bsr     OMed_SaveD1
       move.l  a2,a1
       moveq   #1,d2
       move.w  #34,$1c(a1)     ;CD_TOCMSF
       move.l  #MyTOC,$28(a1)
       move.l  #100,$24(a1)
       clr.l   $2c(a1)
       jsr     _LVODoIO(a6)
       move.l  a2,a1
       tst.b   $1f(a1)
       bne     cdpt0
cdpt2: move.l  #CDmsg_find,d1  ;Got TOC, find a good track...
       bsr     OMed_SaveD1
       lea     MyTOC,a0
       moveq   #0,d1
       move.b  1(a0),d1
       beq     cdpt3
       subq    #1,d1
cdpt4: addq.l  #6,a0
       move.b  (a0),d0
       btst    #6,d0     ;0x40 == CDROM track
       beq.s   cdpt5
       dbra    d1,cdpt4
       bra     cdpt3
cdpt5: moveq   #0,d0     ;Ahh, found some audio!
       move.b  1(a0),d0  ;er.. where was this audio exactly?
       or.b    #$40,(a0) ;don't play it twice.
       move.w  #8,Mus_Play
       move.w  #37,$1c(a1)     ;CD_PLAYTRACK
       move.l  #1,$24(a1)      ;number of tracks to play
       clr.l   $28(a1)
       move.l  d0,$2c(a1)      ;start track
       move.l  d0,-(sp)        ;push
       move.l  #CDmsg_play,d1
       bsr     OMed_SaveD1
       jsr     _LVOSendIO(a6)
       move.l  (sp)+,d0        ;pop track
       lea     MusName+12,a5
       bsr     PrtNum
cdpt0: movem.l (sp)+,d0-d2/a0-a2/a5-a6
  ENDIF
       rts

; **** MAIN MUSIC PLAYER ENTRY POINT ****
; D1 = name, D5 = pointer (from mts_#?) or NULL.
OMed_LoadPlayD1D5:
       bsr     OMed_SaveD1
       tst.l   d5
       beq     OMed_LoadPlayD1
       movem.l d0-d1/a0-a2/a6,-(sp)
       bsr     mt_end
       move.l  ExecBase,a6
       move.l  d5,a1
       jsr     _LVOTypeOfMem(a6)
       and.l   #MEMF_CHIP,d0
       bne     OMLPD1
OMLPrt:move.l  d5,a1
       moveq.l #MEMF_CHIP,d1
       bsr     CopyVec
       bsr     MaybeDumpChip
       bne     OMLPrt
       tst.l   d0
       beq     OMLPD0mem
       move.l  d0,mt_data
       move.l  d0,d5
       move.l  d0,a2
       bsr     _RelocModule
       tst     d0
       beq.s   OMLPD1
       bsr     ModCorrupt
       bsr     mt_unload
       bra.s   OMLPD0
OMLPD1:bsr     OMed_PlayD5
OMLPD0:movem.l (sp)+,d0-d1/a0-a2/a6
       rts
OMLPD0mem:
       bsr     ModMem
       bra     OMLPD0

OMed_LoadPlayD1:
       movem.l d0-a6,-(sp)
       bsr     mt_end
       move.l  #MEMF_CHIP,d4
       bsr     OMed_LoadD1
       tst.l   d5
       beq     OMLP0
       move.l  d5,mt_data
       move.l  d5,a2
       bsr     _RelocModule
       tst     d0
       beq.s   OMLP1
       bsr     ModCorrupt
       bsr     mt_unload
       bra.s   OMLP0
OMLP1: bsr     OMed_PlayD5
OMLP0: movem.l (sp)+,d0-a6
       rts

mt_Imusic:
;       movem.l d2-d7/a2-a4,-(sp)
;       bsr     mt_rmusic
;       movem.l (sp)+,d2-d7/a2-a4
       move.l  #$DFF000,a0
       moveq.l #0,d0        ;Set Z flag
       rts
mt_music:
       movem.l d0-d2,-(sp)
       move.l  #100,d2
       bsr     rnd            ;Just give this random doohickie
       movem.l (sp)+,d0-d2    ;a few good shakes for fun.
       rts

mt_end:tst     Mus_Play
       beq     _rts
       movem.l d0/d1/a0/a1/a6,-(sp)
       cmp     #8,Mus_Play
       bne     me1
       clr     Mus_Play
       move.l  ExecBase,a6
       lea     MyCD,a1
       jsr     _LVOAbortIO(a6)
       lea     MyCD,a1
       jsr     _LVOWaitIO(a6)
       bra     me2
me1:   clr     Mus_Play
       bsr     _StopPlayer
       bsr     mt_unload
       tst     NoVoice0
       bne     men01    ;Mt_End No voice 0
       moveq   #13,d0
       bsr     playme
men01: moveq   #14,d0
       bsr     playme
       moveq   #15,d0
       bsr     playme
       moveq   #16,d0
       bsr     playme
me2:   movem.l (sp)+,d0/d1/a0/a1/a6
       rts
mt_filter:
       and.b   #$fd,$bfe001   ;Filtering back on.
       rts
mt_unload:
       movem.l d0/d1/a0/a1/a6,-(sp)
       move.l  ExecBase,a6
       tst.l   mt_data
       beq     NoFreMtData
       move.l  mt_data,a1
       bsr     FreeVec
       clr.l   mt_data
NoFreMtData:
       move.l  #$dff0a0,Voice0HW
       clr     NoVoice0
       clr     DoSJump
       movem.l (sp)+,d0/d1/a0/a1/a6
       rts

       ;DATA section!!    (Still part of code hunk, because
       ;                   the data hunk goes in CHIP RAM!!)
timename:
       dc.b    'timer.device',0
       align
audname:
       dc.b    'audio.device',0
       align
Event:
       dc.b    0
       align
devio:
;       dc.l    devio,devio
;       dc.b    $20,0
       dc.l    0,0
       dc.b    5,0
       dc.l    0
port:
       dc.l    0
Tm_Length:
       dc.w    0
       dc.l    0,0  ;device,unit
Tm_Cmd:
       dc.w    0
io:
       dc.b    0,0
secs:
       dc.l    0
msecs:
       dc.l    0
readreply:
       blk.l   16,0
CDreply:
       blk.l   16,0

saddrTable:
       dc.l    s_Catch,s_Brick1,s_Exp1,s_WarpIn,s_Dink,s_ShiftQ
       dc.l    s_CylCatch1,s_Piew2,s_Bonk,s_Dink,s_Piew,s_ShiftQ
       dc.l    s_CylCatch1,blksnd,blksnd,blksnd,blksnd,s_ExpBrick

slenTable:
       dc.l    ends_Catch-s_Catch,ends_Brick1-s_Brick1,ends_Exp1-s_Exp1
       dc.l    ends_WarpIn-s_WarpIn,ends_Dink-s_Dink
       dc.l    ends_ShiftQ-s_ShiftQ,ends_CylCatch1-s_CylCatch1
       dc.l    ends_Piew2-s_Piew2,ends_Bonk-s_Bonk,ends_Dink-s_Dink
       dc.l    ends_Piew-s_Piew,10000,ends_CylCatch1-s_CylCatch1
       dc.l    16,16,16,16,ends_ExpBrick-s_ExpBrick

sperTable:   ;3579546/Saples_per_sec
       dc.w    856,340,428,428,329,390,568,600,334,284,246,390,1712
       dc.w    4000,4000,4000,4000
ExpBrickPeriod:
       dc.w    143     ;This starting period is saved, and increased per frame.

sVoiceTable:
       dc.w    3,0,2,2,0,0,1,3,3,0,3,1,1,0,1,2,3    ;Voice Choice Table
ExpBrickVoice:
       dc.w    0       ;This rotates.

CombOps:
       dc.b    15,0
Signal:
       dc.l    0
MsgPort:
       dc.l    0,0
       dc.b    4,0
       blk.b   5,0
MsgSig:
       dc.b    0
MyTask:
       blk.b   48,0
otherports:
       blk.b   64*7,0
Message:
       dc.l    0,0
       dc.b    5,127
       dc.l    0
       dc.l    MsgPort
MsgLn: dc.w    68       ;Length
Device:
       dc.l    0
Unit:
       dc.l    0
Aud_Cmd:
       dc.w    0
Aud_Flags:
       dc.b    0
Aud_Error:
       dc.b    0
AllocKey:
       dc.w    0
AData:
       dc.l    0  ;body of sound
Aud_Length:
       dc.l    0  ;length of sound in bytes
Period:
       dc.w    0  ;period of sound
Volume:
       dc.w    64
Cycles:
       dc.w    1
WriteMsg:
       dc.l    0,0
       dc.b    5,0
       dc.l    0
       dc.l    otherports+192
       dc.w    20
screendef:
       dc.w    0,0,320,200
Depth:
       dc.w    5
       dc.b    3,2
       dc.w    $4002     ;$4000 = SPRITES
SType: dc.w    $100F     ;$100F = NS_EXTENDED|CUSTOMSCREEN
ScreenTextAttr:
       dc.l    TopazTextAttr,title,0,0
       dc.l    ScrTags

; SA_Dummy =   $80000020
ScrTags:
       dc.l    $80000042,-1        ;SA_Interleaved,TRUE
       dc.l    $8000003A,SApens    ;SA_Pens,SApens
MId:   dc.l    1,0                 ;TAG_IGNORE,0  (For SA_DisplayID).
Ignore_below_v39:
       dc.l    $80000044,vcTags    ;SA_VideoControl,vcTags
       dc.l    0                   ;TAG_END
SApens:
       dc.w    1,0     ;Detail,block
       dc.w    1       ;Text on bkg
       dc.w    20,22   ;Shine,Shadow
       dc.w    21,18   ;Active window (bar,title)
       dc.w    0,17    ;bkg, hilite text
       dc.w    0,1,1   ;v39 menu bar detail, block, trim
       dc.w    -1      ;End
vcTags:
       dc.l    $80000080,0         ;VC_IntermediateCLUpdate,FALSE (v40)
       dc.l    $80000031,0         ;VTAG_SPRITERESN_SET,SPRITERESN_ECS
       dc.l    0,0
windowdef:
       dc.w    0,0,320,200
       dc.b    0,1
       dc.l    $780018,$4031B00,0,0,0  ;Flag $40 = SIMPLE_REFRESH.
screenhd:dc.l  0,0
       dc.w    0,0,0,0,15     ;rest of windowdef
Errwinddef:
       dc.w    50,90,500,10
       dc.b    3,2
       dc.l    $200,$100e,0,0
ErrPtr:dc.l    0,0,0
       dc.w    0,0,0,0,1   ;rest of Errwinddef
RndCount:
       dc.l    0
FileRequestor:
       blk.b   frq_SIZEOF,0
       align
f_Dir:
       dc.b    'Boards'
       blk.b   DSIZE+1,0
f_File:
       dc.b    'UnNamed.BDS'
       blk.b   FCHARS+1,0
f_Show:
       dc.b    '#?.BDS',0
f_PathName:
       blk.b   DSIZE+FCHARS+2,0
f_Title:
       dc.b    'Select a board file!',0
f_FNF:
       dc.b    'Last try: File not found.',0
f_VER:
       dc.b    'Last try: Needs newer version of MegaBall.',0
f_NBD:
       dc.b    'Last try: Not a board file.',0
IntRName:
       dc.b    'MegaballMusicServer',0
no_iff:
       dc.b    "Error: Can't find LIBS:iff.library",0
no_pic:
       dc.b    "Error: Can't load graphics file.",0
no_ram:
       dc.b    "Error: No RAM for graphics!",0
no_allocsprite:
       dc.b    "Error: Can't allocate sprite data.",0
no_sprites:
       dc.b    "Error: Can't allocate three sprites.",0
no_bitmap:
       dc.b    "Error: Can't allocate bitmaps from CHIP mem.",0
no_gfx:
       dc.b    "Error: Can't load graphics!  See docs...",0
no_cols:
       dc.b    "Error: Can't access CRegs colors!",0
no_DTbm:
       dc.b    "Error: Can't access DataTypes bitmap!",0
no_boards:
       dc.b    "Error: Internal data corrupt!  Get new copy.",0
no_decode:
       dc.b    'Error: DecodePic() failed, IFF is invalid.',0
no_color:
       dc.b    'Error: GetColorTab() failed, IFF is invalid.',0
no_audio:
       dc.b    "Error: Amiga's audio already allocated.",0
no_omed:
       dc.b    "Error: Can't initialize OctaMED player.",0
no_datatypes:
       dc.b    "Error: Can't open datatypes.library",0
no_window:
       dc.b    "Error: Can't open main window",0
ScrMsg:
       dc.b    'WOW!  What a score!!  Type your name:'
end_ScrMsg:
       align
LodMsg:
       dc.b    'Enter the filename of the board file:'
end_LodMsg:
       align
NFdMsg:
       dc.b    'File not found - Try full path?'
end_NFdMsg:
       align
VerMsg:
       dc.b    'Needs newer version of MegaBall.'
end_VerMsg:
       align
CorMsg:
       dc.b    'Not a board file, or file corrupt.'
end_CorMsg:
       align
ReqMsg:
       dc.b    'You need V1+ of req.library!!'
end_ReqMsg:
       align
title:
       dc.b    '  >> MEGABALL <<  by Ed Mackey',0
       align
IAM1:
       dc.b    'IAM has distributors'
end_IAM1:
       align
IAM2:
       dc.b    'all over the world.'
end_IAM2:
       align
IAM3:
       dc.b    'Email: info@iam.com'
end_IAM3:
       align
IAM4:
       dc.b    'URL:   http://www.iam.com'
end_IAM4:
       align
IAM5:
       dc.b    'Intangible Assets Manufacturing'
end_IAM5:
       align
IAM6:
       dc.b    '828 Ormond Avenue'
end_IAM6:
       align
IAM7:
       dc.b    'Drexel Hill, PA 19026-2604, USA'
end_IAM7:
       align
MBbanner1:
  IFEQ CD32,0
    IFEQ REGISTERED,0
       dc.b    'MegaBall v4.0, Demo version.'
    ELSE
       dc.b    'MegaBall v4.0, Commercial version.'
    ENDIF
  ELSE
       dc.b    '    * MegaBall CD32! *'
  ENDIF
end_MBbanner1:
       align
MBbanner2:
       dc.b    'Copyright 1995 by Ed Mackey.'
end_MBbanner2:
       align
MBbanner3:
  IFEQ CD32,0
    IFEQ REGISTERED,0
       dc.b    'Spread this version all around!'
    ELSE
       dc.b    'Please do not give copies of this!'
    ENDIF
  ELSE
       dc.b    "Beta test - Don't distribute!"
  ENDIF
end_MBbanner3:
       align
NoDF:
       dc.b    'Missing LIBS:diskfont.library'
end_NoDF:
       align
NoMF:
       dc.b    'Missing FONTS:MegaBall.font'
end_NoMF:
       align
FdMF:
       dc.b    'Found custom font.'
end_FdMF:
       align
LdMus:
       dc.b    'Pre-loading music...'
end_LdMus:
       align
NoMus:
       dc.b    "Can't pre-load music."
end_NoMus:
       align
NoMusMem:
       dc.b    'Not enough memory to pre-load music!'
end_NoMusMem:
       align
SmMus:
       dc.b    'Pre-loaded '
PutLdHere:
       dc.b    '? of 5 songs.'
end_SmMus:
       align
AlMus:
       dc.b    'All five songs pre-loaded for speed!'
end_AlMus:
       align
PTC:
  IFEQ CD32,0
       dc.b    'Click to continue.'
  ELSE
       dc.b    'SELECT to continue.'
  ENDIF
end_PTC:
       align
WarpAnyTxt:
       dc.b    'Enter Board # to Warp to > '
end_WarpAnyTxt:
       align
title2:
       dc.b    '                    v4.0, by Ed Mackey.'
end_title2:
       align
instr:
  IFEQ CD32,0
       dc.b    ' Press mousebutton for one player,'
  ELSE
       dc.b    ' Press SELECT for one player,'
  ENDIF
end_instr:
       align
instr2:
  IFEQ CD32,0
       dc.b    ' "2" for two, or SHIFT-Q to exit.'
  ELSE
       dc.b    ' STOP for two, or PLAY (continue).'
  ENDIF
end_instr2:
       align
ALTL:
;       dc.b    'ALT-L to Load boards.'
       dc.b    'Type L to Load boards.'
end_ALTL:
       align
Al:
       dc.b    'Graphics & music by Al Mackey.'
end_Al:
       align
C2cont:
  IFEQ CD32,0
       dc.b    'Press C to continue game.'
  ELSE
       dc.b    'Press PLAY to continue game.'
  ENDIF
end_C2cont:
       align

TiredText:     ;1234567890123456789012345678901234567890
 IFEQ REGISTERED,0
       dc.b    '               Getting tired of the same'
       dc.b    '               old boards?  Need some   '
       dc.b    '               new challenges, perhaps? '
       dc.b    'Intangible Assets Manufacturing presents'
       dc.b    "the MegaBall4 commercial release!  It's "
       dc.b    'got a working "Load" feature, hundreds  '
       dc.b    'of pre-made boards to load, and a full  '
       dc.b    'board editor program that lets you      '
       dc.b    'design your own boards!  Great fun!!    '
       dc.b    '  IAM has distributors        See docs  '
       dc.b    '  all over the world.         for full  '
       dc.b    '  Email info@iam.com          details.  '
       dc.b    '  URL   http://www.iam.com/             '
       dc.b    'Intangible Assets Manufacturing         '
       dc.b    '828 Ormond Avenue                       '
       dc.b    'Drexel Hill, PA 19026-2604, USA         '
 ENDIF
end_TiredText:

; 1 = blinkenlichten, 2 = pink (Ed's text), 3 = yellow (Al's text)
; 4 = red text,       5 = topaz.font,       6 = MegaBall.font.
; 7 = purple (Dale's text)

ScrollText:
       dc.b    'Welcome to MEGABALL v4.0 by Ed and Al Mackey.  '
;       dc.b    4,'-= Beta Test  **NOT FOR SALE** =-  ',1
  IFEQ REGISTERED,0
       dc.b    'This is the demo version.  It is freely distributable, '
       dc.b    'as long as it remains unmodified, and stays with its '
       dc.b    'documentation, graphics files, and other support files.  '
       dc.b    'Spread it via BBSs, PD disks, Fish Disks, Aminet, '
       dc.b    'CD-ROMs, online services, and any other way imaginable, '
       dc.b    'as long as all files are present and unmodified.  '
       dc.b    'Dealers are specifically invited to bundle this '
       dc.b    'version with Amigas and Video Toasters they sell.  '
       dc.b    'For more information, press L or read the documentation.  '
  ELSE
       dc.b    'This is the first commercial release of this program.  ',4
       dc.b    'Thanks for not copying it!  ',1
  ENDIF
       dc.b    "Dale Larson's company IAM (Intangible Assets "
       dc.b    "Manufacturing) publishes "
       dc.b    'the commercial version '
       dc.b    'of MegaBall4.  '
       dc.b    "Grab your browser and look for IAM's World-Wide Web page at "
       dc.b    5,'http://www.iam.com',6,' or just send email to the '
       dc.b    'IAM info-bot at ',5,'info@iam.com',6,'.'
       dc.b    '  -- @ --  All code, graphics, sound, and '
       dc.b    'music in this program are copyright 1991-1995 Ed & Al Mackey '
       dc.b    'EXCEPT the music playing routines, which come from '
       dc.b    'OctaMED Pro V4 by Teijo Kinnunen (thanks Teijo!).  '
;       dc.b    'and the "Self Destruct" '
;       dc.b    'sound effect which was sampled from a movie.  '
;       dc.b    'Some boards in this version were designed by registered '
;       dc.b    'MegaBall users of previous versions.  See the documentation '
;       dc.b    'for a description of who did which boards.    '

;       dc.b    'Call ',4,'Somerton Telecomm',$b3,' BBS',1,' at ',5,'(215) 464-6775 ',6
;       dc.b    'for the latest releases from Mackey Software!  '
  IFEQ REGISTERED,0
;       dc.b    'Somerton has many phone lines, about ',$be,' of a gigabyte '
;       dc.b    'of file space, and is based near Philadelpha, PA!  All new '
;       dc.b    'shareware releases of MegaBall (and other programs of ours) '
;       dc.b    'can be found on Somerton before they can be found anywhere '
;       dc.b    'else.  ',5,'(215) 464-6775',6,'.    '
  ENDIF

       dc.b    2,'Now, after all that mess, I would like to say hello and '
       dc.b    'thanks to all play-testers and board-designers, including '
;       dc.b    'registered MegaBall users Bill Grixti, Doris and Dena '
;       dc.b    'Ballard, and also '
       dc.b    'my mother (Betty Mackey, who has done countless boards '
       dc.b    'for us over the years), '
       dc.b    'my friends Eric Parkin, Sue Rankin (who has also done '
       dc.b    'an impressive number of boards), Joe '
       dc.b    'Campbell, Ched Wheeler',1,' EEK!',2,', and Larry David Jex @.  '
       dc.b    'Special board-designing thanks go to Doris Ballard, Dena '
       dc.b    'Ballard, and Jim Kieran.  '
       dc.b    'Thanks also go to ',1,'Dale Larson',2,' for his help and '
       dc.b    'advice, for telling me how to become a "certified developer," '
       dc.b    'telling me the usefulness of DevCon notes, '
       dc.b    'for publishing this game under the IAM name, '
       dc.b    'and giving me & Al '
       dc.b    'not one but ',4,'two',2,' tours of Commodore.  '
       dc.b    "Be sure to check out Dale's World-Wide Web page at "
       dc.b    5,"http://www.iam.com",6,".  And while you're at it, check out "
       dc.b    'my own home page on ',5,'http://www.early.com/~emackey/',6,'.  '
;       dc.b    'Thanks also go '
;       dc.b    'to MLCUG leader John Deker, for helping to make this AGA '
;       dc.b    'version possible by beta-testing MegaBall AGA on an '
;       dc.b    'A1200 when Al and his A1200 were away at Rider College.  '
;       dc.b    'MLCUG meets once a month at Villanova University (PA).  '
;       dc.b    'Call the MLCUG BBS for details, ',5,'(215) 828-1359',6,'.  '
;       dc.b    'Thanks also to the helpful people on BIX amiga.cert, '
;       dc.b    'for advice, beta testing on A4000s, and generally being cool.  '
;       dc.b    'Good luck to my ex-roommate Marc Gabriel, who is currently '
;       dc.b    'designing and building the National LymeNet computer network '
;       dc.b    'to help victims of Lyme Disease.  Get well soon, Marc!    '

       dc.b    "... WHAT? YOU'RE "
       dc.b    'STILL READING THIS?!  Are you expecting YOUR name to '
       dc.b    "show up here, or are you just dying to read my brother's "
       dc.b    "text??  Well, OK, fine, here's Al....  ",3,"   Hi!!  I'd like "
       dc.b    "to say thanks to some weird people who have helped me since "
       dc.b    "the last version.  First of all, I guess I have to say thanks "
       dc.b    "to Jim Kieran for his...  uh...  original insights.   "
       dc.b    "Thanks also to the rather interesting group of internet "
       dc.b    "cartoonists that have supported my efforts.. (to see some "
       dc.b    "of my cartoons, see our web page, address is earlier in the "
       dc.b    "scrolltext.)  "
       dc.b    "Many thanks to all the organizers of Amiga Convention '95 "
       dc.b    "that was held in Montreal.  "
       dc.b    "I've lost my toy bunny!  He kept going, and "
       dc.b    "going, and he went!  Even more "
;       dc.b    "also go to my hanging toy bunny I got as a graduation present "
;       dc.b    'and the "D00DZ" who frequent the #amiga channel on IRC, who '
;       dc.b    "also have very original insights.  Even more thanks go to "
;       dc.b    "the people I now live with and from time to time try valiantly "
;       dc.b    "to make boards:  Mark Scafidi, Aaron Weinberg, Mike Metelski, "
;       dc.b    "Chris Matera, Mark Bonnano, and (sorry, guys, I have to include "
;       dc.b    "him, at least he tried..)  Barry Nussbaum.  Oh, yeah, one more.. "
       dc.b    "thanks to Corey Horton for introducing me to the video lab, "
       dc.b    "where I now have a job (working with Video Toasters!!).  "
       dc.b    "  Thanks also to Andrew and Robbie Blanco and Brian and "
       dc.b    "Amy Reid (our four cousins) for their ideas and encouragement.  "
       dc.b    "Now I'm out of things to write, and I bet you're expecting the "
       dc.b    "scroll to repeat, right? ",4," WRONG!!",3,"  Here's Dale Larson....  "
       dc.b    7,"Hi everyone!  It's a privilege to be scrolling to you. "
       dc.b    "To Ed and Al's thank-yous, you're welcome, and thank "
       dc.b    "YOU for publishing MegaBall with IAM. I also want to thank "
       dc.b    "the crew who helped with the translations and box design and "
       dc.b    "other stuff, "
       dc.b    "including Betty Mackey, Sue Rankin, Jan McIlvaine, Claudio "
       dc.b    'Dosio and Heinz Wrobel. Hi to Teresa McIlvaine, who said "that game is '
       dc.b    'cool!"'," Of course, that's supposed to be Dave's line. Speaking "
       dc.b    'of Dave, I think it is safe for me to extend to you (the reader) '
       dc.b    'best wishes from all the former West Chester crew.  You helped '
       dc.b    "make the Amiga dream just as much as we did.  I think I'll quit "
       dc.b    "on that sappy note.  Here's Ed again..."
       dc.b    2,"  OK!  I'm back!  And Al is playing weird music behind "
       dc.b    "me, as usual!  I see Al mentioned our cousins.  I was "
       dc.b    "JUST ABOUT to do that :-> !!!  (Hi Amy! ",4,$99,$99,$99,2,"!)  "
       dc.b    "Geez, are you STILL READING this?!?  You must be some kind of "
       dc.b    "compulsive scroll-text reader!  Which is good, because "
       dc.b    "Al just remembered something he forgot to put in his "
       dc.b    "previous section.  Here he is....  ",3,"  Hi again... "
       dc.b    "I'd like to thank all the people who registered Megaball, "
       dc.b    "because without them, we probably wouldn't have any of the new "
       dc.b    "fun stuff that we used to make this version.  Topping the list "
       dc.b    "of stuff is my new synthesizer, from which many of the sounds "
       dc.b    "in the music were sampled.  "
;       dc.b    "And, of course, I'm sure you were "
;       dc.b    "all wondering exactly how original the insights are of the "
;       dc.b    "people mentioned above.  Well, to give you an example, I was "
;       dc.b    "kicking around the idea of an AGA dungeon game, and asked the "
;       dc.b    "people on IRC what monster they would like to kill in a "
;       dc.b    "dungeon, and their original and insightful answer was....  "
;       dc.b    "Bill Gates.    OK, I guess I'll "
       dc.b    "Oh yeah, keep an eye on Aminet for new releases of weird "
       dc.b    "pieces of extra Megaball music.  Right now, there is an "
       dc.b    "archive of two songs there, but I plan to put up more in "
       dc.b    "the future.  Also while you're on aminet you might as well "
       dc.b    "see my animation, pix/anim/Fool.lha @@!    Well kids, that's "
       dc.b    "all ya get!  That's it!!  READ A BOOK!!!  "
       dc.b    1,"    Finally!  It's repeating!...."
       dc.b    '                                       ',0
       align

; The following are IntuiText structures for describing bonuses.
; The first byte in each one (the foreground pen) is actually a
; BRICK number, NOT a pen number!  These will be run through the
; converter on startup.
BonusDescribe:
       dc.b    1,0,1,0         ;Blue (21 on non-AGA)
       dc.w    0,0
       dc.l    0,asc1,tex2
asc1:
       dc.b    'Slow ball',0
       align
tex2:
       dc.b    20,0,1,0        ;Red (29 on non-AGA)
       dc.w    160,0
       dc.l    0,asc2,tex3
asc2:
       dc.b    'Kill (you)',0
       align
tex3:
       dc.b    1,0,1,0
       dc.w    0,15
       dc.l    0,asc3,tex4
asc3:
       dc.b    'Next board',0
       align
tex4:
       dc.b    24,0,1,0        ;Blinkenlichten (24 on non-AGA)
       dc.w    160,15
       dc.l    0,asc4,tex5
asc4:
       dc.b    'Get a life',0
       align
tex5:
       dc.b    1,0,1,0
       dc.w    0,30
       dc.l    0,asc5,tex6
asc5:
       dc.b    'Lasers',0
       align
tex6:
       dc.b    5,0,1,0         ;Yellow (26 on non-AGA)
       dc.w    160,30
       dc.l    0,asc6,tex7
asc6:
       dc.b    'Expand paddle',0
       align
tex7:
       dc.b    20,0,1,0
       dc.w    0,45
       dc.l    0,asc7,tex8
asc7:
       dc.b    'Gravity ball',0
       align
tex8:
       dc.b    1,0,1,0
       dc.w    160,45
       dc.l    0,asc8,tex9
asc8:
       dc.b    'Brickthrough',0
       align
tex9:
       dc.b    1,0,1,0
       dc.w    0,60
       dc.l    0,asc9,tex10
asc9:
       dc.b    'Catch ball',0
       align
tex10:
       dc.b    1,0,1,0
       dc.w    160,60
       dc.l    0,asc10,tex11
asc10:
       dc.b    'Zap Gold',0
       align
tex11:
       dc.b    20,0,1,0
       dc.w    0,75
       dc.l    0,asc11,tex12
asc11:
       dc.b    'New Quicksand',0
       align
tex12:
       dc.b    1,0,1,0
       dc.w    160,75
       dc.l    0,asc12,tex13
asc12:
       dc.b    'Dynamite',0
       align
tex13:
       dc.b    5,0,1,0
       dc.w    0,90
       dc.l    0,asc13,tex14
asc13:
       dc.b    'Diet Pill',0
       align
tex14:
       dc.b    20,0,1,0
       dc.w    160,90
       dc.l    0,asc14,0
asc14:
       dc.b    'Magnetism',0
       align

NameLength = 20     ;Use Cpos for Cursor Position when entering name.
       dc.l    $7fffffff  ;Marks top-of-scorelist.
ScoreList:
       blk.b   360
end_ScoreList:
       dc.b    '********************',0,0,0,200
       dc.b    '**  MegaBall 4.0  **',0,0,0,200
       dc.b    '********************',0,0,0,200
       dc.b    'MEGA  Programming   ',0,0,0,100
       dc.b    'BALL    By          ',0,0,0,100
       dc.b    'MEGA     Ed         ',0,0,0,100
       dc.b    'BALL      Mackey    ',0,0,0,100
       dc.b    'MEGA                ',0,0,0,50
       dc.b    'BALL  Gfx & Music   ',0,0,0,25
       dc.b    'MEGA    By          ',0,0,0,25
       dc.b    'BALL     Al         ',0,0,0,25
       dc.b    'MEGA      Mackey    ',0,0,0,25
       dc.b    'BALL                ',0,0,0,0
       dc.b    $98,' @ ',$98,' ',$7f,' ',$98,' @ ',$98,' ',$7f,' ',$98,' @ ',0,0,0,0
       dc.b    'MEGABALL RULES!!!!!!',0,0,0,0
WarpInList:
       dc.w    8,58, 57,58, 106,58, 154,58, 201,58, 248,58
       dc.w    8,107, 58,107, 106,107, 157,107, 203,107, 248,107
       dc.w    11,154, 59,154, 117,154, 179,154, 237,154, 17,34
end_list:
WarpOutList:   ;srcX, srcY, sizeX, sizeY
       dc.w    11,3,41,9, 54,3,41,9, 97,3,41,9, 140,3,41,9
       dc.w    11,36,41,9, 63,27,43,18, 113,23,55,22, 1,60,63,29
       dc.w    66,61,73,29, 140,57,74,29
end_out_list:
BlockCoords:
       dc.w    17,34, 206,11, 222,11, 206,18, 222,18, 206,25
       dc.w    222,25, 17,34, 273,184, 289,177, 289,184, 273,177
; And the AGA blocks:
       dc.w    136,4, 136,11, 136,18, 136,25, 214,39, 214,46
       dc.w    152,4, 152,11, 152,18, 152,25, 230,39, 230,46
       dc.w    168,4, 168,11, 168,18, 168,25, 246,39, 246,46
       dc.w    184,4, 184,11, 184,18, 184,25, 262,39, 262,46
; And the CD32 blocks:
       dc.w    184,50,   8,50, 24,50,  40,50,  56,50, 136,50
       dc.w     72,50, 168,50, 88,50, 104,50, 120,50, 152,50

       dc.w    40,25,  8,4,   8,11,  8,18,  8,25, 40,4
       dc.w    24,4,  40,18, 24,11, 24,18, 24,25, 40,11

       dc.w    88,25, 56,4,  56,11, 56,18, 56,25, 88,4
       dc.w    72,4,  88,18, 72,11, 72,18, 72,25, 88,11
; And the Exploding kind:
       dc.w    294,46, 120,4,120,4, 120,11,120,11, 120,18,120,18, 120,25,120,25
       dc.w            104,4,104,4, 104,11,104,11, 104,18,104,18, 104,25,104,25
       dc.w    17,34, 17,34
; Explode to blue
       dc.w    294,46,   120,4,120,4, 120,11,120,11, 120,18,120,18, 120,25,120,25
       dc.w            304,10,304,10, 304,17,304,17, 304,24,304,24, 304,31,304,31
       dc.w    17,34, 17,34
; Explode the Gold
       dc.w    304,191, 304,191,304,191, 304,184,304,184, 304,177,304,177, 304,170,304,170
       dc.w             104,4,104,4, 104,11,104,11, 104,18,104,18, 104,25,104,25
       dc.w    17,34, 17,34
; Transform the slime!
       dc.w    199,1, 199,1,199,1, 214,1,214,1, 229,1,229,1, 244,1,244,1
       dc.w           259,1,259,1, 274,1,274,1, 289,1,289,1, 304,1,304,1
       dc.w    17,34, 17,34

PastTransform:
       dc.b    0,0,0,0,0,0,0,0,0,0,0,0
       dc.b    0,0,0,0,0,0,0,0,0,0,0,0
       dc.b    TheExplodingKind,0,0,0,0,0,0,0,0,0,0,0
       dc.b    TheExplodingKind+19,0,0,0,0,0,0,0,0,0,TheExplodingKind+38,0
       dc.b    0,0,0,0,0,0,0,0,0,0,0,0
       dc.b    0,0,0,0,0,0,0,0,0,0,0,0
FutureTransform:
       dc.b    0,0,0,0,0,0,0,0,0,0,0,0
       dc.b    0,0,0,0,0,0,0,0,0,0,0,0
       dc.b    TheExplodingKind+18,0,0,0,0,0,0,0,0,0,0,0
       dc.b    TheExplodingKind+37,0,0,0,0,0,0,0,0,0,TheExplodingKind+56,0
       dc.b    0,0,0,0,0,0,0,0,0,0,0,0
       dc.b    0,0,0,0,0,0,0,0,0,0,0,0

BonusCoords:
       dc.w    142,154, 297,102, 297,117, 297,132, 279,102, 279,117
       dc.w    279,132, 261,102, 261,117, 261,132, 243,117, 225,117
       dc.w    225,132, 243,102, 225,102
end_BonusCoords:
VBInterrupt:
       dc.l    0,0
       dc.b    2,-60
       dc.l    IntRName,mt_data,mt_Imusic
; ASL_TB = $80080000
AslAllocTags:
       dc.l    $80080002,0         ;ASLFR_Window,0
       dc.l    $80080008,f_File    ;ASLFR_InitialFile,f_File
       dc.l    $80080009,f_Dir     ;ASLFR_InitialDrawer,f_Dir
       dc.l    $8008000A,f_Show    ;ASLFR_InitialPattern,f_Show
       dc.l    $80080003,0         ;ASLFR_InitialLeftEdge,0
       dc.l    $80080004,0         ;ASLFR_InitialTopEdge,0
       dc.l    $80080005,320       ;ASLFR_InitialWidth,320
       dc.l    $80080006,200       ;ASLFR_InitialHeight,200
       dc.l    $8008002c,0         ;ASLFR_DoSaveMode,0
       dc.l    $8008002e,-1        ;ASLFR_DoPatterns,-1
       dc.l    0                   ;TAG_END
AslReqTags:
       dc.l    $80080001,f_Title   ;ASLFR_Titletext,f_Title
       dc.l    0                   ;TAG_END
AllocSPTags:
       dc.l    $81000000,16, 0,0   ;SPRITEA_WIDTH
BallSTags:
       dc.l    $82000020,4,  0,0   ;STAG_SPRITE_NUM
;DTA_Dummy = $80001000
DTtags:
       dc.l    $80001065,2         ;DTA_SourceType, DTST_FILE
;       dc.l    $80001066,0         ;DTA_Handle, 0
       dc.l    $8000101F,'pict'    ;DTA_GroupID, GID_PICTURE
       dc.l    $800010D3,0         ;PDTA_Remap, 0
       dc.l    0                   ;TAG_END
DTGAtags:
       dc.l    $800010D1,numcolors ;PDTA_NumColors,numcolors
       dc.l    $800010CC,CRegs     ;PDTA_CRegs,CRegs
       dc.l    $800010CA,newbm     ;PDTA_BitMap,newbm
       dc.l    0                   ;TAG_END
CRegs:
       dc.l    0
newbm:
       dc.l    0
;dtf:                   ;struct dtFrameBox
;       dc.l    $601    ;DTM_FRAMEBOX
;       dc.l    0,fri,fri,36   ;sizeof(struct FrameInfo)
;fri:                   ;struct FrameInfo
;       dc.l    0       ;PropertyFlags
;       dc.w    0,0     ;Res x,y
;       dc.b    0,0,0,0 ;RGB bits
;       dc.l    0,0,0   ;Wid,Hig,Dep
;       dc.l    0,0,0   ;Screen, ColorMap, Flags
gpl:                   ;struct gpLayout
       dc.l    $602    ;DTM_PROCLAYOUT
       dc.l    0,1
UseOS20:
       dc.w    1
v39:
       dc.w    1
Debug:
       dc.w    0
Music:
       dc.w    1
FitchCol:
       dc.w    24
FitchSubCol:
       dc.w    0
EndExploder:
       dc.w    40
TuneList:
       dc.l    0
mts_title:
       dc.l    0
mts_high:
       dc.l    0
mts_dead:
       dc.l    0
mts_life:
       dc.l    0
mts_pause:
       dc.l    0

;       INCLUDE "Boards.include"

CompBoards:
       IBYTES  "Main.BDS"
end_CompBoards:
       dc.w    0
CompBoardSiz = end_CompBoards-CompBoards

TextAttr:
       dc.l    FontName
       dc.w    8
       dc.b    0,0
TopazTextAttr:
       dc.l    TopazName
       dc.w    8
       dc.b    0,1
CDchange:
       dc.l    $8fff00ed
Name_Title:
       dc.l    Def_Title
Name_High:
       dc.l    Def_High
Name_Dead:
       dc.l    Def_Dead
Name_Life:
       dc.l    Def_Life
Name_Pause:
       dc.l    0
GfxNameList:
       dc.l    picname       ; was newpicname,picname
GfxNameNonAGAList:
       dc.l    pic2name,0
;newpicname:
;       dc.b    'MegaBall4.Gfx.CD32',0
picname:
       dc.b    'MegaBall4.Gfx.AGA',0
pic2name:
       dc.b    'MegaBall4.Gfx.non-AGA',0
DebugCurDirName:
       dc.b    'MBL:',0
DebugProgName:
       dc.b    'BALL',0
MBgfxTempName:
       dc.b    'RAM:MegaBall.temp.junk',0
Tool_Title:
       dc.b    'TITLE',0
Tool_High:
       dc.b    'HIGH',0
Tool_Dead:
       dc.b    'DEAD',0
Tool_Life:
       dc.b    'LIFE',0
Tool_Pause:
       dc.b    'PAUSE',0
Tool_TuneX:
       dc.b    'TUNExxxxxx',0
Tool_Music:
       dc.b    'MUSIC',0
Tool_Random:
       dc.b    'RANDOM',0
Tool_BallBob:
       dc.b    'BALLBOB',0
Tool_LaserBobs:
       dc.b    'LASERBOBS',0
Tool_ModeID:
       dc.b    'MODEID',0
CDmsg_change:
       dc.b    'CD diskchange check failed',0
CDmsg_TOC:
       dc.b    "CD can't get TOC!",0
CDmsg_find:
       dc.b    "CD can't find an audio track!",0
CDmsg_play:
       dc.b    'CD-DA track',0
Def_Title:
       dc.b    'MB_Music/Title4.tune',0
Def_High:
       dc.b    'MB_Music/HighScore4.tune',0
Def_Dead:
       dc.b    'MB_Music/GameOver4.tune',0
Def_Life:
       dc.b    '3E|MB_Music/ExtraLife.tune',0
FontName:
       dc.b    'MegaBall.font',0
TopazName:
       dc.b    'topaz.font',0
LoaderName:
       dc.b    'MegaBall4LoaderAnim',0
ScoreName:
       dc.b    'MegaBall4.scores',0
       blk.b   DSIZE+FCHARS+2,0
DiskFontName:
       dc.b    'diskfont.library',0
DataTypesName:
       dc.b    'datatypes.library',0
gfxname:
       dc.b    'graphics.library',0
intname:
       dc.b    'intuition.library',0
freeanimname:
  IFEQ CDROM,1
       dc.b    'freeanim.library',0
  ENDIF
cdname:
  IFEQ CDROM,1
       dc.b    'cd.device',0
  ENDIF
lowlevelname:
       dc.b    'lowlevel.library',0
iconname:
       dc.b    'icon.library',0
dosname:
       dc.b    'dos.library',0
iffname:
       dc.b    'iff.library',0
reqname:
       dc.b    'req.library',0
aslname:
       dc.b    'asl.library',0
       align

UseBallBob:
       dc.w    1
UseLasBobs:
       dc.w    1
BallVis:
       dc.w    0
bhx:   dc.w    0
bhy:   dc.w    0
Las1Vis:
       dc.w    0
l1hx:  dc.w    0
l1hy:  dc.w    0
Las2Vis:
       dc.w    0
l2hx:  dc.w    0
l2hy:  dc.w    0
ballsprite:
       dc.l    balldat
       dc.w    4
sx:    dc.w    0
sy:    dc.w    0
spnum: dc.w    -1
       dc.w    0,0     ;ExtSprite use only
Las1Sprite:
       dc.l    Las1Dat
       dc.w    5
Lasx1: dc.w    0
Lasy1: dc.w    0
SpL1n: dc.w    -1
       dc.w    0,0     ;ExtSprite use only
Las2Sprite:
       dc.l    Las2Dat
       dc.w    5
Lasx2: dc.w    0
Lasy2: dc.w    0
SpL2n: dc.w    -1
       dc.w    0,0     ;ExtSprite use only

ballbitmap:
       dc.w    4       ;BytesPerRow
       dc.w    4       ;Rows
       dc.b    0,2     ;Flags,Depth
       dc.w    0       ;Pad
       dc.l    balldat+4, balldat+6
las1bitmap:
       dc.w    4       ;BytesPerRow
       dc.w    5       ;Rows
       dc.b    0,2     ;Flags,Depth
       dc.w    0       ;Pad
       dc.l    las1dat+4, las1dat+6
las2bitmap:
       dc.w    4       ;BytesPerRow
       dc.w    5       ;Rows
       dc.b    0,2     ;Flags,Depth
       dc.w    0       ;Pad
       dc.l    las2dat+4, las2dat+6

BallSP:dc.l    0
Las1SP:dc.l    0       ;Pointers to SimpleSprites or ExtSimpleSprites.
Las2SP:dc.l    0

       DATA    ;This part is all CHIP RAM stuff!!!!
balldat:
       dc.w    0,0
       dc.w    %0110000000000000 , %0000000000000000
       dc.w    %1000000000000000 , %0111000000000000
       dc.w    %0011000000000000 , %1111000000000000
       dc.w    %0110000000000000 , %0110000000000000
       dc.w    0,0,0,0,0,0
Las1Dat:
       dc.w    0,0
       dc.w    %0100000000000000 , %0100000000000000
       dc.w    %1010000000000000 , %1110000000000000
       dc.w    %0100000000000000 , %1010000000000000
       dc.w    %1010000000000000 , %1110000000000000
       dc.w    %0100000000000000 , %0100000000000000
       dc.w    0,0,0,0
Las2Dat:
       dc.w    0,0
       dc.w    %0100000000000000 , %0100000000000000
       dc.w    %1010000000000000 , %1110000000000000
       dc.w    %0100000000000000 , %1010000000000000
       dc.w    %1010000000000000 , %1110000000000000
       dc.w    %0100000000000000 , %0100000000000000
       dc.w    0,0,0,0
blkptr:
       dc.l    0,0,0,0     ;Blank mouse pointer.
blksnd:
       dc.l    0,0,0,0     ;Blank sound.
s_Catch:
       IBYTES  'dh10:audio/ballsounds/NewCatch.dump'
ends_catch:
       align
s_Brick1:
       IBYTES  'dh10:audio/ballsounds/NewBrick.dump'
ends_Brick1:
       align
s_Exp1:
       IBYTES  'dh10:audio/ballsounds/BANG.dump'
ends_Exp1:
       align
s_WarpIn:
       IBYTES  'dh10:audio/ballsounds/WarpIn.dump'
ends_WarpIn:
       align
s_Dink:
       IBYTES  'dh10:audio/ballsounds/NewDink.dump'
ends_Dink:
       align
s_ShiftQ:
       IBYTES  'dh10:audio/ballsounds/ShiftQ.dump'
ends_ShiftQ:
       align
s_CylCatch1:
       IBYTES  'dh10:audio/ballsounds/Bonus.dump'
ends_CylCatch1:
       align
s_Piew2:
       IBYTES  'dh10:audio/ballsounds/Laz-1.dump'
ends_Piew2:
       align
s_Bonk:
       IBYTES  'dh10:audio/ballsounds/Bonk.dump'
ends_Bonk:
       align
s_Piew:
       IBYTES  'dh10:audio/ballsounds/ES2.sd3.dump'
ends_Piew:
       align
s_ExpBrick:
       IBYTES  'dh10:audio/ballsounds/ExpBrick.dump'
ends_ExpBrick:
       align

       BSS     ;Danger: Uninitialized variable zone!
mt_pdata:
       ds.l    1
mt_data:
       ds.l    1
ctable:
       ds.w    256  ;More than required space, just to be sure!
ftable:
       ds.l    258*3
numcolors:             ;Keep numcolors and ctable32 together.
       ds.w    2       ;Format:  # colors .w
ctable32:              ;         initial color .w
       ds.l    257*3   ;         RGB values .l
TexBuf:
       ds.b    DSIZE+FCHARS+6
MusName:
       ds.b    36
LdStat1:
       ds.w    1
Cpos:
       ds.w    1
Fcol:
       ds.w    1
Fdir:
       ds.w    1
PaddleX:
       ds.w    1
PaddleXbig:
       ds.w    1
CurrentBoard:
       ds.w    1
CurrentBoard2:
       ds.w    1
DeathRecover:
       ds.w    1
GameRecover:
       ds.w    1
GameRecover2:
       ds.w    1
JoyFire:
       ds.w    1
GPlayRec:
       ds.w    1
PlayerUp:
       ds.w    1  ;1 = Player 1, 2 = Player 2, 0 = One-Player game.
Stuck:
       ds.w    1
LivesLeft:
       ds.w    1
LivesLeft2:
       ds.w    1
StickCounter:
       ds.w    1
BlocksLeft:
       ds.w    1
MemBlocksLeft:
       ds.w    1
You_Cheated:
       ds.w    1
You_Cheated2:
       ds.w    1
You_Looped:
       ds.w    1
You_Looped2:
       ds.w    1
Got_Catch:
       ds.w    1
Got_Laser:
       ds.w    1
Got_Brick:
       ds.w    1
Got_Grav:
       ds.w    1
Got_Expand:
       ds.w    1
Got_Down:
       ds.w    1
Paddle_Size:
       ds.w    1
Mark1:
       ds.w    1
Mark2:
       ds.w    1
Self_Sound:
       ds.w    1
dx:
       ds.w    1
dy:
       ds.w    1
ddx:
       ds.w    1
ddy:
       ds.w    1
spx:
       ds.w    1
spy:
       ds.w    1
cx:
       ds.w    1
cy:
       ds.w    1
cylx:
       ds.w    1
cyly:
       ds.w    1
cyln:
       ds.w    1   ;Use as byte!
SCount:
       ds.w    1
CTcnt:
       ds.w    1
ExpBrickPeriodSave:
       ds.w    1
VolMult:
       ds.w    1
SJump:
       ds.w    1
DoSJump:
       ds.w    1
WhichMus:
       ds.w    1
ScoreShowing:
       ds.w    1
OldPri:
       ds.w    1
BigFP:
       ds.w    1
SlimeMorph:
       ds.w    1
NumTunes:
       ds.w    1
FadeMus:
       ds.w    1
Mus_Play:
       ds.w    1
Mus_Pause:
       ds.w    1
NoVoice0:
       ds.w    1
Loopie:
       ds.w    1
Mloopie:
       ds.w    1
PauBak:
       ds.w    1
msx:
       ds.w    1
msy:
       ds.w    1
mdx:
       ds.w    1
mdy:
       ds.w    1
LenStr:
       ds.w    1
NeedSetup:
       ds.w    1
NeedSetup2:
       ds.w    1
       align.L
PaddleXmod:        ;\  Keep these together, so
       ds.w    1   ; \ that "clr.l PaddleXmod"
PaddleSpeed:       ; / will make the paddle
       ds.w    1   ;/  come to a full stop.
       ;We're still longword aligned here.
rSecs:
       ds.l    1
rMicros:
       ds.l    1
P2Offset:
       ds.l    1
Score:
       ds.l    1
Score2:
       ds.l    1
BallSpeed:
       ds.l    1
Rast:
       ds.l    1
Rast3:
       ds.l    1
Font:
       ds.l    1
TopazFont:
       ds.l    1
intbase:
       ds.l    1
fontbase:
       ds.l    1
iconbase:
       ds.l    1
freeanimbase:
  IFEQ CDROM,1
       ds.l    1
  ENDIF
LowLevelBase:
       ds.l    1
dosbase:
       ds.l    1
iffbase:
       ds.l    1
reqbase:
       ds.l    1
aslbase:
       ds.l    1
DataTypesBase:
       ds.l    1
gfxbase:
       ds.l    1
MyDiskObj:
       ds.l    1
MyToolTypes:
       ds.l    1
AslFR:
       ds.l    1
Scorehd:
       ds.l    1
MemPtr:
       ds.l    1
End_Board:
       ds.l    1
bit1map:
       ds.l    1
bit2map:
       ds.l    1
bit3map:
       ds.l    1
windowhd:
       ds.l    1
CurBrdPtr:
       ds.l    1
OldDir:
       ds.l    1
LifePts:
       ds.l    1
LifePts2:
       ds.l    1
ViewPort:
       ds.l    1
SaveArgs:
       ds.l    1
ArgLen:
       ds.l    1
WBMsg:
       ds.l    1
OldWindowPtr:
       ds.l    1
MusBuf:
       ds.l    1
MusBufSiz:
       ds.l    1
ExplodingBits:
       ds.l    14     ;bitmap of the exploding bricks
Converter:
       ds.l    18     ;72 bytes of brick colors.
FakeRast:
       ds.b    102    ;sizeof(struct RastPort) + 2 bytes safety
QSandBuf:
       ds.b    420
end_QSandBuf:
MyTOC:
       ds.b    612
MyCD:
       ds.b    48
otherMessages:
       ds.b    68 * 4
Pl2Boards:
       ds.b    440        ;Bottom row for exploding deal
MyMem:
       ds.b    Whole_Thing
Board1:
       ds.b    440        ;likewise.
LodSavHdr:            ;\
       ds.l    1      ; \
Chk2:                 ;  \
       ds.l    1      ;   \ Keep
Chk1:                 ;   / Together
       ds.l    1      ;  /
LodSavBuf:            ; /
       ds.b    21000  ;/
       END
