
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "util.h"

typedef struct {
	int x, y;
	const uint8 *data;
} text_t;

static const uint8 credits_text1[] = {
	0x43, 0x4F, 0x4E, 0x47, 0x52, 0x41, 0x54, 0x55, 0x4C, 0x41, 0x54, 0x49, 0x4F, 0x4E, 0x53, 0x5B, 
	0x01, 0x20, 0x5A, 0x4F, 0x4C, 0x44, 0x52, 0x41, 0x4E, 0x45, 0x20, 0x54, 0x48, 0x45, 0x20, 0x53, 
	0x4F, 0x52, 0x43, 0x45, 0x52, 0x45, 0x53, 0x53, 0x5B, 0x53, 0x45, 0x4E, 0x54, 0x20, 0x42, 0x41, 
	0x43, 0x4B, 0x01, 0x20, 0x54, 0x4F, 0x20, 0x54, 0x48, 0x45, 0x20, 0x4E, 0x4F, 0x54, 0x48, 0x49, 
	0x4E, 0x47, 0x4E, 0x45, 0x53, 0x53, 0x5B, 0x44, 0x45, 0x46, 0x45, 0x41, 0x54, 0x45, 0x44, 0x20, 
	0x42, 0x59, 0x01, 0x20, 0x54, 0x48, 0x45, 0x20, 0x56, 0x41, 0x4C, 0x4F, 0x52, 0x4F, 0x55, 0x53, 
	0x20, 0x4E, 0x49, 0x43, 0x4B, 0x59, 0x5C, 0x01, 0x01, 0x4F, 0x4E, 0x20, 0x54, 0x48, 0x45, 0x20, 
	0x46, 0x4C, 0x4F, 0x4F, 0x52, 0x20, 0x41, 0x54, 0x20, 0x54, 0x48, 0x45, 0x20, 0x50, 0x4C, 0x41, 
	0x43, 0x45, 0x20, 0x57, 0x48, 0x45, 0x52, 0x45, 0x01, 0x20, 0x53, 0x48, 0x45, 0x20, 0x48, 0x41, 
	0x53, 0x20, 0x44, 0x49, 0x53, 0x41, 0x50, 0x50, 0x45, 0x41, 0x52, 0x45, 0x44, 0x5B, 0x4E, 0x49, 
	0x43, 0x4B, 0x59, 0x20, 0x50, 0x49, 0x43, 0x4B, 0x53, 0x20, 0x55, 0x50, 0x01, 0x20, 0x41, 0x20, 
	0x4C, 0x49, 0x54, 0x54, 0x4C, 0x45, 0x20, 0x47, 0x4F, 0x4C, 0x44, 0x45, 0x4E, 0x20, 0x4B, 0x45, 
	0x59, 0x5C, 0x01, 0x01, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x49, 0x4E, 0x47, 0x20, 0x54, 0x48, 
	0x52, 0x4F, 0x55, 0x47, 0x48, 0x20, 0x54, 0x48, 0x45, 0x20, 0x43, 0x41, 0x53, 0x54, 0x4C, 0x45, 
	0x01, 0x20, 0x52, 0x4F, 0x4F, 0x4D, 0x53, 0x5B, 0x4E, 0x49, 0x43, 0x4B, 0x59, 0x20, 0x44, 0x49, 
	0x53, 0x43, 0x4F, 0x56, 0x45, 0x52, 0x53, 0x20, 0x49, 0x4E, 0x20, 0x41, 0x20, 0x44, 0x41, 0x4D, 
	0x50, 0x01, 0x20, 0x44, 0x55, 0x4E, 0x47, 0x45, 0x4F, 0x4E, 0x5C, 0x5C, 0x5C, 0x41, 0x20, 0x43, 
	0x48, 0x45, 0x53, 0x54, 0x5C, 0x00
};

static const uint8 credits_text2[] = {
	0x48, 0x49, 0x53, 0x20, 0x48, 0x41, 0x4E, 0x44, 0x20, 0x54, 0x52, 0x45, 0x4D, 0x42, 0x4C, 0x49, 
	0x4E, 0x47, 0x20, 0x57, 0x49, 0x54, 0x48, 0x20, 0x48, 0x4F, 0x50, 0x45, 0x5B, 0x4E, 0x49, 0x43, 
	0x4B, 0x59, 0x01, 0x20, 0x43, 0x4F, 0x4D, 0x45, 0x53, 0x20, 0x4E, 0x45, 0x41, 0x52, 0x20, 0x41, 
	0x4E, 0x44, 0x20, 0x49, 0x4E, 0x53, 0x45, 0x52, 0x54, 0x53, 0x20, 0x54, 0x48, 0x45, 0x20, 0x4B, 
	0x45, 0x59, 0x01, 0x20, 0x49, 0x4E, 0x54, 0x4F, 0x20, 0x54, 0x48, 0x45, 0x20, 0x4C, 0x4F, 0x43, 
	0x4B, 0x5C, 0x01, 0x01, 0x01, 0x54, 0x48, 0x45, 0x20, 0x43, 0x48, 0x45, 0x53, 0x54, 0x20, 0x4F, 
	0x50, 0x45, 0x4E, 0x53, 0x20, 0x57, 0x49, 0x54, 0x48, 0x4F, 0x55, 0x54, 0x20, 0x44, 0x49, 0x46, 
	0x46, 0x49, 0x43, 0x55, 0x4C, 0x54, 0x59, 0x01, 0x20, 0x55, 0x4E, 0x46, 0x4F, 0x4C, 0x44, 0x49, 
	0x4E, 0x47, 0x20, 0x49, 0x54, 0x53, 0x20, 0x53, 0x45, 0x43, 0x52, 0x45, 0x54, 0x5C, 0x01, 0x4E, 
	0x49, 0x43, 0x4B, 0x59, 0x20, 0x44, 0x49, 0x53, 0x43, 0x4F, 0x56, 0x45, 0x52, 0x53, 0x20, 0x41, 
	0x4E, 0x20, 0x45, 0x4C, 0x49, 0x58, 0x49, 0x52, 0x5B, 0x01, 0x20, 0x54, 0x48, 0x45, 0x20, 0x4F, 
	0x4E, 0x4C, 0x59, 0x20, 0x4D, 0x45, 0x44, 0x49, 0x43, 0x49, 0x4E, 0x45, 0x20, 0x54, 0x4F, 0x20, 
	0x54, 0x48, 0x45, 0x20, 0x45, 0x56, 0x49, 0x4C, 0x20, 0x53, 0x50, 0x45, 0x4C, 0x4C, 0x01, 0x20, 
	0x43, 0x41, 0x53, 0x54, 0x20, 0x42, 0x59, 0x20, 0x5A, 0x4F, 0x4C, 0x44, 0x52, 0x41, 0x4E, 0x45, 
	0x20, 0x4F, 0x4E, 0x20, 0x48, 0x49, 0x53, 0x20, 0x47, 0x52, 0x41, 0x4E, 0x44, 0x46, 0x41, 0x54, 
	0x48, 0x45, 0x52, 0x01, 0x20, 0x44, 0x55, 0x52, 0x49, 0x4E, 0x47, 0x20, 0x48, 0x49, 0x53, 0x20, 
	0x43, 0x41, 0x50, 0x54, 0x49, 0x56, 0x49, 0x54, 0x59, 0x5C, 0x00
};

static const uint8 credits_text3[] = {
	0x01, 0x01, 0x47, 0x52, 0x41, 0x42, 0x42, 0x49, 0x4E, 0x47, 0x20, 0x54, 0x48, 0x45, 0x20, 0x50, 
	0x52, 0x45, 0x43, 0x49, 0x4F, 0x55, 0x53, 0x20, 0x46, 0x4C, 0x41, 0x53, 0x4B, 0x5B, 0x4E, 0x49, 
	0x43, 0x4B, 0x59, 0x01, 0x20, 0x54, 0x41, 0x4B, 0x45, 0x53, 0x20, 0x54, 0x48, 0x45, 0x20, 0x50, 
	0x41, 0x54, 0x48, 0x20, 0x48, 0x4F, 0x4D, 0x45, 0x5C, 0x01, 0x01, 0x01, 0x43, 0x52, 0x4F, 0x53, 
	0x53, 0x49, 0x4E, 0x47, 0x20, 0x54, 0x48, 0x52, 0x4F, 0x55, 0x47, 0x48, 0x20, 0x54, 0x48, 0x45, 
	0x20, 0x46, 0x4F, 0x52, 0x45, 0x53, 0x54, 0x5B, 0x48, 0x45, 0x20, 0x54, 0x48, 0x49, 0x4E, 0x4B, 
	0x53, 0x01, 0x20, 0x4F, 0x46, 0x20, 0x48, 0x49, 0x53, 0x20, 0x47, 0x52, 0x41, 0x4E, 0x44, 0x46, 
	0x41, 0x54, 0x48, 0x45, 0x52, 0x20, 0x57, 0x48, 0x4F, 0x20, 0x57, 0x49, 0x4C, 0x4C, 0x20, 0x42, 
	0x45, 0x20, 0x53, 0x4F, 0x4F, 0x4E, 0x01, 0x20, 0x48, 0x45, 0x41, 0x4C, 0x45, 0x44, 0x5C, 0x00
};

static const uint8 credits_text4[] = {
	0x47, 0x52, 0x45, 0x45, 0x54, 0x49, 0x4E, 0x47, 0x53, 0x20, 0x54, 0x4F, 0x01, 0x01, 0x44, 0x41, 
	0x4E, 0x49, 0x45, 0x4C, 0x20, 0x4C, 0x41, 0x4D, 0x42, 0x49, 0x4E, 0x01, 0x4D, 0x49, 0x43, 0x48, 
	0x45, 0x4C, 0x45, 0x20, 0x4C, 0x41, 0x4D, 0x42, 0x49, 0x4E, 0x01, 0x4D, 0x55, 0x52, 0x49, 0x45, 
	0x4C, 0x20, 0x4C, 0x45, 0x43, 0x48, 0x45, 0x4E, 0x45, 0x01, 0x53, 0x59, 0x4C, 0x56, 0x49, 0x41, 
	0x4E, 0x45, 0x20, 0x56, 0x4F, 0x59, 0x4E, 0x4E, 0x45, 0x54, 0x01, 0x50, 0x41, 0x54, 0x52, 0x49, 
	0x43, 0x45, 0x20, 0x4C, 0x41, 0x4D, 0x42, 0x49, 0x4E, 0x01, 0x50, 0x41, 0x54, 0x52, 0x49, 0x43, 
	0x4B, 0x20, 0x52, 0x45, 0x47, 0x4E, 0x41, 0x55, 0x4C, 0x44, 0x01, 0x56, 0x41, 0x4E, 0x45, 0x53, 
	0x53, 0x41, 0x20, 0x4C, 0x41, 0x4D, 0x42, 0x49, 0x4E, 0x01, 0x53, 0x41, 0x4E, 0x44, 0x52, 0x49, 
	0x4E, 0x45, 0x20, 0x46, 0x45, 0x41, 0x55, 0x56, 0x45, 0x41, 0x55, 0x01, 0x41, 0x4C, 0x41, 0x49, 
	0x4E, 0x20, 0x52, 0x45, 0x47, 0x4E, 0x41, 0x55, 0x4C, 0x44, 0x01, 0x50, 0x49, 0x45, 0x52, 0x52, 
	0x45, 0x20, 0x56, 0x4F, 0x59, 0x4E, 0x4E, 0x45, 0x54, 0x01, 0x4C, 0x55, 0x44, 0x4F, 0x56, 0x49, 
	0x43, 0x01, 0x50, 0x41, 0x54, 0x52, 0x49, 0x43, 0x49, 0x41, 0x20, 0x47, 0x41, 0x4C, 0x49, 0x42, 
	0x45, 0x52, 0x54, 0x01, 0x54, 0x48, 0x49, 0x45, 0x52, 0x52, 0x59, 0x20, 0x42, 0x4C, 0x41, 0x4E, 
	0x4F, 0x54, 0x00
};

static uint8 temp_buffer[4096];

static uint8 *read_file(const char *filename, int *sz) {
	int size;
	uint8 *buf = 0;
	FILE *fp = fopen(filename, "rb");
	assert(fp);
	fseek(fp, 0, SEEK_END);
	size = ftell(fp);
	fseek(fp, 0, SEEK_SET);
	buf = (uint8 *)malloc(size);
	assert(buf);
	fread(buf, size, 1, fp);
	fclose(fp);
	if (sz) *sz = size;
	return buf;
}

static uint8 sprite_palette_map[16];

void build_sprite_palette_map(const uint8 *bmp_pal, const uint8 *spr_pal) {
	int i, k;
	for (i = 0; i < 16; ++i) {
		uint8 best_match;
		uint32 best_diff;
		int r, g, b, r0, g0, b0;
		
		uint16 color = read_uint16BE(spr_pal); spr_pal += 2;
		r = (color >> 8) & 0xF;
		g = (color >> 4) & 0xF;
		b = (color >> 0) & 0xF;
		r |= r << 4;
		g |= g << 4;
		b |= b << 4;
		
		best_match = 0;
		best_diff = 0xFFFFFFFF;
		for (k = 0; k < 256; ++k) {
			uint32 diff;
			b0 = bmp_pal[k * 4 + 0];
			g0 = bmp_pal[k * 4 + 1];
			r0 = bmp_pal[k * 4 + 2];
			diff = (r0 - r) * (r0 - r) + (g0 - g) * (g0 - g) + (b0 - b) * (b0 - b);
			if (diff < best_diff) {
				best_diff = diff;
				best_match = k;
			}
		}
		sprite_palette_map[i] = best_match;

		b0 = bmp_pal[best_match * 4 + 0];
		g0 = bmp_pal[best_match * 4 + 1];
		r0 = bmp_pal[best_match * 4 + 2];
		printf("map[%d]=%d r,g,b=%d,%d,%d r0,g0,b0=%d,%d,%d\n", i, best_match, r, g, b, r0, g0, b0);
	}
}

static void blit_sprite(const uint8 *font_data, uint8 spr, int x, int y, uint8 *dst) {
	int j;
	const uint8 *spr_data = font_data + read_uint16LE(font_data + spr * 2);
	const int spr_w = read_uint16LE(spr_data + 0);
	const int spr_h = read_uint16LE(spr_data + 2);
	assert(spr_w == 8 || spr_h == 8);
	spr_data += 4;
	dst += (160 - 1) * 240; /* bitmap are bottom-top */
	dst -= y * 240;
	for (j = 0; j < spr_h; ++j) {
		int i;
		int cy = y + j;
		for (i = 0; i < (spr_w + 7) / 8; ++i) {
			int b;
			uint8 data[4];
			data[0] = *spr_data++;
			data[1] = *spr_data++;
			data[2] = *spr_data++;
			data[3] = *spr_data++;
			for (b = 0; b < 8; ++b) {
				int p;
				int cx = x + i * 8 + b;
				if (cx >= 0 && cx < 240 - 8 && cy >= 0 && cy < 160 - 8) {
					uint8 color = 0;
					for (p = 0; p < 4; ++p) {
						if (data[p] & (1 << (7 - b))) {
							color |= 1 << p;
						}
					}
					if (color != 0) {
						dst[cx] = sprite_palette_map[color];
					}
				}
			}
		}
		dst -= 240;
	}
}


static int text_lines_offs_count;
static int text_lines_offs_table[50];

static void split_text_line(const uint8 *text_line, int x) {
	int left_x = x;
	const uint8 *last_word = 0;
	const uint8 *p = text_line;
	while (1) {
		uint8 ch = *p++;
		if (ch == 0) {
			text_lines_offs_table[text_lines_offs_count++] = p - text_line;
			text_line = p;
/*			printf(" -- len=%d\n", p - text_line);*/
			break;
		}
		assert(ch != 1);
		if (ch == 0x20 || ch == '\\' || ch =='[') {
			last_word = p;
		}
/*		printf("%c", ch);*/
		if (x >= 240 - 8 - 2) {
			text_lines_offs_table[text_lines_offs_count++] = last_word - text_line;
/*			printf(" -- len=%d\n", last_word - text_line);*/
			text_line = last_word;
			p = last_word;
			x = left_x;
		}
		x += 8;
	}
}

static void draw_text(uint8 *bmp, const uint8 *spr_data, int x, int y, const uint8 *text_data) {
	int i, len;
	int left_x = x;
	
	text_lines_offs_count = 0;
	split_text_line(text_data, x);
	
/*	printf("text_lines_offs_count = %d\n", text_lines_offs_count);*/
	for (i = 0; i < text_lines_offs_count; ++i) {
		len = text_lines_offs_table[i];
/*		printf("len = %d -- ", len);*/
		while (len-- > 0) {
			uint8 ch = *text_data++;
			if (ch == 0) {
				return;
			}
			if (ch != 0x20) {
				blit_sprite(spr_data, ch - 0x40, x, y, bmp);
/*				printf("%c", ch);*/
			}
			x += 8;
		}
		x = left_x;
		y += 12;
/*		printf("\n");*/
	}
}

/*const text_t credits_page_table[4] = {
	{ 24, 40, seq_credits_text1 },
	{ 24, 34, seq_credits_text2 },
	{ 24, 34, seq_credits_text3 },
	{ 88, 14, seq_credits_text4 }
};*/

static void cleanup_text(const uint8 *src, uint8 *p) {
	while (1) {
		uint8 ch = *src++;
		if (ch == 0) {
			*p = 0;
			break;
		}
		if (ch == '[' || ch == '\\') {
			*p++ = ch;
/*			printf("%c", p[-1]);*/
			while (*src == 0x20 || *src == 0x01) {
				++src;
			}
			continue;
		}
		if (ch == 1) {
			continue;
		}
		*p++ = ch;
/*		printf("%c", p[-1]);*/
	}
}

void make_credits_bmp(int x, int y, const uint8 *t, int num) {
	FILE *fp;
	int i07_bmp_sz;
	char filename[200];
	uint32 offs_bmp, offs_pal;
	uint8 *fontend_spr = read_file("pics_nicky1/FONTEND.SPR", 0);
	uint8 *i07_bmp = read_file("pics_nicky1/I07.BMP", &i07_bmp_sz);
	uint8 *i07_pal = read_file("pics_nicky1/I07.PAL", 0);
	assert(read_uint16LE(i07_bmp) == 0x4D42);
	offs_bmp = read_uint16LE(i07_bmp + 10);
	offs_pal = 14 + read_uint32LE(i07_bmp + 14);
	build_sprite_palette_map(i07_bmp + offs_pal, i07_pal);
	cleanup_text(t, temp_buffer);
	draw_text(i07_bmp + offs_bmp, fontend_spr, x, y, temp_buffer);
	sprintf(filename, "I07_%d.BMP", num);
	fp = fopen(filename, "wb");
	if (fp) {
		fwrite(i07_bmp, 1, i07_bmp_sz, fp);
		fclose(fp);
	}
}

int main(int argc, char *argv[]) {
	make_credits_bmp(18, 20, credits_text1, 1);
	make_credits_bmp(18, 20, credits_text2, 2);
	make_credits_bmp(18, 50, credits_text3, 3);
/*	make_credits_bmp(40, 20, credits_text4, 4);*/
	return 0;
}
