#ifndef INC_STATE_H
#define INC_STATE_H

#include <SDL/SDL.h>
#include "coords.h"
#include "gfx.h"
#include "shot.h"
#include "invaders.h"
#include "player.h"
#include "node.h"

#include <vector>

#define MAX(x,y) ((x) > (y) ? (x) : (y))
#define MIN(x,y) ((x) < (y) ? (x) : (y))
#define BOUNDED(x,min,max) (MAX(MIN((x),(max)),(min)))

enum EndState
{
    END_NOT,
    END_DEAD,
    END_EXTRACTED,
    END_WIN
};

class GameState
{
    private:
	std::vector<Shot> shots;
	std::vector<Invader*> invaders;
	std::vector<Node> nodes;

	Node* targettedNode;
	int timeSinceLastInvader;

	bool youHaveNode(NodeColour colour);
	bool youHaveShotNode(int type);
	bool evilHasNode(NodeColour colour);

	int shotHeat(int type);
	int shotDelay(int type);

	float mutilationWave;
	void updateMutilation(int time);

	int rateOfRating(int rating);
	void updateObjects(int time);
	void handleInput(int time);
	void updateZoom(int time);
	void evilAI(int time);
	bool deadShots;
	void cleanup();

	void drawGrid(SDL_Surface* surface, const View& view,
		bool blank=false);
	void drawTargettingLines(SDL_Surface* surface, const View& view,
		bool blank=false);
	void drawNodeTargetting(SDL_Surface* surface, const View& view,
		bool blank=false);
	void drawIndicators(SDL_Surface* surface, const View& view,
		bool blank=false);
	void drawObjects(SDL_Surface* surface, const View& view,
		View* boundView=NULL, bool blank=false);

    public:
	int extracted;
	Player you;
	float zoomdist;
	int invaderRate;
	double rating;
	int extractMax;
	EndState end;

	void setRating(double rating);
	void update(int time);
	void draw(SDL_Surface* surface, bool blank=false);

	const char* getHint();

    GameState();
};

const char* ratingString(int rating);

#endif /* INC_STATE_H */
