#ifndef INC_NODE_H
#define INC_NODE_H

#include "invaders.h"

enum NodeStatus
{
    NODEST_NONE,
    NODEST_EVIL,
    NODEST_YOU,
    NODEST_DESTROYED
};
enum NodeColour
{
    NODEC_RED,
    NODEC_YELLOW,
    NODEC_GREEN,
    NODEC_BLUE,
    NODEC_PURPLE,
    NODEC_CYAN
};

class Node : public HPInvader, public SpirallingPolygonalInvader
{
    protected:
	void doUpdate(int time);
	Uint32 colour() const;
	Uint32 innerColour() const;
    public:
	float radius;

	float spinRate;

	NodeColour nodeColour;
	NodeStatus status;

	float primed;
	float primeRate;
	float glowPhase;

	CapturePod* capturer;
	InfestingInvader* targettingInfester;
	bool infest(InfestingInvader* inv);
	void uninfest();
	bool capture(CapturePod* pod);
	void uncapture();

	int hit(int weight);
	int die() { return 0; }
	bool dead() const { return false; }

	float extractionProgress;

	void setPoints();

	void draw(SDL_Surface* surface, const View& view, View*
		boundView=NULL, bool blank=false, bool noAA=false) const;

	Node(RelPolarCoord ipos, float ids, NodeColour inodeColour, float iradius=6);
};

#endif /* INC_NODE_H */
