/*
 * Kuklomenos
 * Copyright (C) 2008 Martin Bays <mbays@sdf.lonestar.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see http://www.gnu.org/licenses/.
 */

#include <iostream>
#include <fstream>
#include <string>
using namespace std;

#include <SDL/SDL_gfxPrimitives.h>

#include "data.h"

char fontSmall[3328];
char fontBig[10240];

#ifndef DATADIR
const int numDataPaths = 4;
const string dataPaths[numDataPaths] = { "./", "data/kuklomenos/"};
#else
const int numDataPaths = 5;
const string dataPaths[numDataPaths] = { DATADIR "data/kuklomenos/"};
#endif

ifstream* openDataFile(string relPath)
{
    ifstream* f = new ifstream;
    for (int i=0; i < numDataPaths; i++)
    {
	f->open((dataPaths[i]+relPath).c_str(), ios::binary);
	if (f->is_open())
	    return f;
	else
	    continue;
    }
    return f;
}

const char* findDataPath(string relPath)
{
    ifstream* f = new ifstream;
    for (int i=0; i < numDataPaths; i++)
    {
	const char* absPath = (dataPaths[i] + relPath).c_str();
	f->open(absPath, ios::binary);
	if (f->is_open())
	    return absPath;
	else
	    continue;
    }
    return NULL;
}

bool initFont()
{
    ifstream* f = openDataFile("7x13.fnt");
    ifstream* f2 = openDataFile("10x20.fnt");

    if (!f->is_open())
	return false;

    f->read(fontSmall, 3328);
    f2->read(fontBig, 10240);

    delete f;

    return true;
}
