/*
 * Kuklomenos
 * Copyright (C) 2008 Martin Bays <mbays@sdf.lonestar.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see http://www.gnu.org/licenses/.
 */

#include <iostream>
#include <fstream>
#include <string>
#include <cstdlib>
using namespace std;

#include "conffile.h"

Config::Config() :
    rating(5.0),
    shouldUpdateRating(false)
{
    ifstream* f = new ifstream;
    char* home = "/PROGDIR/";
    
    if (home != NULL)
    {
	string homeStr = home;
	f->open((home + (string)"kuklomenosrc").c_str());
    }
    if (!f->is_open())
	f->open("kuklomenosrc");

    if (f->is_open())
    {
	int ret;
	char line[50];

	f->getline(line, 50);
	ret = sscanf(line, "rating: %lf", &rating);
	if (ret != 1)
	{
	    fprintf(stderr, "Bad config file.\n");
	}
    }
}

void Config::write()
{
    ofstream* f = new ofstream;
    char* home = "/PROGDIR/";
    
    if (home != NULL)
    {
	string homeStr = home;
	f->open((home + (string)"kuklomenosrc").c_str());
    }
    if (!f->is_open())
	f->open("kuklomenosrc");

    if (!f->is_open())
	fprintf(stderr, "Couldn't write config file.\n");
    else
    {
	int n;
	char line[50];

	n = snprintf(line, 50, "rating: %.2f\n", rating);
	f->write(line, n);
	f->flush();
    }
}

Config config;
