
;----------------------------------------------------------------------------;
;                psxport.device patch for lowlevel.library                   ;
;----------------------------------------------------------------------------;

		output	c:psxlowlevel

		incdir	devpac:includes
		include	exec/exec.i
		include	devices/inputevent.i
		include devices/gameport.i
		include	libraries/lowlevel.i

		include	offsets.lib

GPD_COMMUNICATE	equ	14

PSX_LEFT	equ	15
PSX_DOWN	equ	14
PSX_RIGHT	equ	13
PSX_UP		equ	12
PSX_START	equ	11
PSX_R3		equ	10
PSX_L3		equ	9
PSX_SELECT	equ	8
PSX_SQUARE	equ	7
PSX_CROSS	equ	6
PSX_CIRCLE	equ	5
PSX_TRIANGLE	equ	4
PSX_R1		equ	3
PSX_L1		equ	2
PSX_R2		equ	1
PSX_L2		equ	0

PSX_LMB		equ	PSX_R1
PSX_RMB		equ	PSX_L1


pp_msgport	equ	0
pp_ioreq	equ	4
pp_type		equ	8
pp_attrs	equ	12
pp_ie		equ	16


CALLSYS		macro
		jsr	_LVO\1(a6)
		endm

;-------------------------------------------------------------------------
; d0 = command line length
; a0 = command line

Start		bra.b	.0

		dc.b	'$VER: psxlowlevel 1.0 (19.07.99)',0

.0		movem.l	d1-d7/a0-a6,-(a7)
		move.l	d0,cmd_length
		move.l	a0,cmd_line

		movea.l	4.w,a6
		move.l	a6,_SysBase

		moveq	#0,d0
		lea	lowlevelname,a1
		CALLSYS	OpenLibrary
		move.l	d0,_LowLevelBase
		beq	.exit

		moveq	#0,d0
		lea	gfxname,a1
		CALLSYS	OpenLibrary
		move.l	d0,_GfxBase

		lea	port0,a2
		move.b	#'0',d0
		bsr	FindParam
		bne.b	.1
		bsr	SetupPort

.1		lea	port1,a2
		move.b	#'1',d0
		bsr	FindParam
		bne.b	.2
		bsr	SetupPort

.2		lea	port2,a2
		move.b	#'2',d0
		bsr	FindParam
		bne.b	.3
		bsr	SetupPort

.3		lea	port3,a2
		move.b	#'3',d0
		bsr	FindParam
		bne.b	.4
		bsr	SetupPort

.4		movea.l	_LowLevelBase,a1
		lea	-30.w,a0		; ReadJoyPort
		move.l	#ReadJoyPort,d0
		CALLSYS	SetFunction
		move.l	d0,oldReadJoyPort

		movea.l	_LowLevelBase,a1
		lea	-132.w,a0
		move.l	#SetJoyPortAttrsA,d0
		CALLSYS	SetFunction
		move.l	d0,oldSetJoyPortAttrsA

.loop		lea	port0,a2
		bsr	HandleIO
		lea	port1,a2
		bsr	HandleIO
		lea	port2,a2
		bsr	HandleIO
		lea	port3,a2
		bsr	HandleIO

		movea.l	_GfxBase,a6
		CALLSYS	WaitTOF

		movea.l	_SysBase,a6
		bra.b	.loop

.exit		movem.l	(a7)+,d1-d7/a0-a6
		moveq	#0,d0
		rts

;-------------------------------------------------------------------------

FindParam	movea.l	cmd_line,a0
		move.l	cmd_length,d1
.loop		cmp.b	(a0)+,d0
		beq.b	.check
		subq.l	#1,d1
		bne.b	.loop
		moveq	#1,d0			; not found
		rts

.check		cmpi.b	#'=',(a0)+
		rts

;-------------------------------------------------------------------------

SetupPort	move.b	(a0),d2
		subi.b	#'0',d2			; unit

		CALLSYS	CreateMsgPort
		move.l	d0,pp_msgport(a2)

		movea.l	d0,a0
		moveq	#IOSTD_SIZE,d0
		CALLSYS	CreateIORequest
		move.l	d0,pp_ioreq(a2)

		movea.l	d0,a1
		lea	psxportname,a0
		moveq	#3,d0
		and.b	d2,d0
		moveq	#0,d1
		CALLSYS	OpenDevice
		tst.l	d0
		bne	.1			; no device

		movea.l	pp_ioreq(a2),a1
		move.w	#GPD_ASKCTYPE,IO_COMMAND(a1)
		move.l	#psxctype,IO_DATA(a1)
		move.l	#1,IO_LENGTH(a1)
		bset	#0,IO_FLAGS(a1)
		movea.l	IO_DEVICE(a1),a6
		jsr	DEV_BEGINIO(a6)
		movea.l	_SysBase,a6
		cmpi.b	#GPCT_NOCONTROLLER,psxctype
		bne.b	.1			; device allocated

		move.b	#GPCT_ALLOCATED,psxctype
		movea.l	pp_ioreq(a2),a1
		move.w	#GPD_SETCTYPE,IO_COMMAND(a1)
		move.l	#psxctype,IO_DATA(a1)
		move.l	#1,IO_LENGTH(a1)
		bset	#0,IO_FLAGS(a1)
		movea.l	IO_DEVICE(a1),a6
		jsr	DEV_BEGINIO(a6)
		movea.l	_SysBase,a6

		movea.l	pp_ioreq(a2),a1
		move.w	#GPD_READEVENT,IO_COMMAND(a1)
		lea	pp_ie(a2),a0
		move.l	a0,IO_DATA(a1)
		move.l	#ie_SIZEOF,IO_LENGTH(a1)
		CALLSYS	DoIO
		move.l	#JP_TYPE_GAMECTLR,pp_type(a2)
		cmpi.b	#$12,pp_ie+ie_Class(a2)
		bne.b	.1
		move.l	#JP_TYPE_MOUSE,pp_type(a2)

.1		rts

;-------------------------------------------------------------------------

HandleIO	cmpi.l	#JP_TYPE_NOTAVAIL,pp_type(a2)
		beq.b	.exit

		movea.l	pp_ioreq(a2),a1
		move.w	#GPD_READEVENT,IO_COMMAND(a1)
		lea	pp_ie(a2),a0
		move.l	a0,IO_DATA(a1)
		move.l	#ie_SIZEOF,IO_LENGTH(a1)
		CALLSYS	DoIO

.exit		rts

;-------------------------------------------------------------------------

ReadJoyPort	movem.l	d0-d1/a0,-(a7)
		cmpi.l	#3,d0
		bhi	.pass
		lea	porttable,a0
		movea.l	(a0,d0.w*4),a0
		cmpi.l	#JP_TYPE_NOTAVAIL,pp_type(a0)
		beq	.pass

		move.l	pp_type(a0),d0
		move.w	pp_ie+ie_Code(a0),d1
		cmpi.b	#$12,pp_ie+ie_Class(a0)
		beq.b	.mouse

		btst	#PSX_CIRCLE,d1
		bne.b	.j0
		bset	#JPB_BUTTON_BLUE,d0
.j0		btst	#PSX_CROSS,d1
		bne.b	.j1
		bset	#JPB_BUTTON_RED,d0
.j1		btst	#PSX_TRIANGLE,d1
		bne.b	.j2
		bset	#JPB_BUTTON_YELLOW,d0
.j2		btst	#PSX_SQUARE,d1
		bne.b	.j3
		bset	#JPB_BUTTON_GREEN,d0
.j3		btst	#PSX_R1,d1
		bne.b	.j4
		bset	#JPB_BUTTON_FORWARD,d0
.j4		btst	#PSX_L1,d1
		bne.b	.j5
		bset	#JPB_BUTTON_REVERSE,d0
.j5		btst	#PSX_START,d1
		bne.b	.j6
		bset	#JPB_BUTTON_PLAY,d0
.j6		btst	#PSX_UP,d1
		bne.b	.j7
		bset	#JPB_JOY_UP,d0
.j7		btst	#PSX_DOWN,d1
		bne.b	.j8
		bset	#JPB_JOY_DOWN,d0
.j8		btst	#PSX_LEFT,d1
		bne.b	.j9
		bset	#JPB_JOY_LEFT,d0
.j9		btst	#PSX_RIGHT,d1
		bne.b	.exit
		bset	#JPB_JOY_RIGHT,d0
		bra.b	.exit

.mouse		btst	#PSX_RMB,d1
		bne.b	.m0
		bset	#JPB_BUTTON_BLUE,d0
.m0		btst	#PSX_LMB,d1
		bne.b	.m1
		bset	#JPB_BUTTON_RED,d0
.m1		move.b	pp_ie+ie_Y+1(a0),d0
		lsl.w	#8,d0
		move.b	pp_ie+ie_X+1(a0),d0
		clr.l	pp_ie+ie_X(a0)

.exit		move.l	d0,(a7)
		movem.l	(a7)+,d0-d1/a0
		rts

.pass		movem.l	(a7)+,d0-d1/a0
		move.l	oldReadJoyPort,-(a7)
		rts

;-------------------------------------------------------------------------

SetJoyPortAttrsA:
		movem.l	d0/a0-a1,-(a7)
		cmpi.l	#3,d0
		bhi.b	.pass
		lea	porttable,a1
		movea.l	(a1,d0.w*4),a1
		cmpi.l	#JP_TYPE_NOTAVAIL,pp_type(a1)
		beq.b	.pass

		moveq	#1,d0
		clr.l	pp_attrs(a1)
		cmpi.l	#SJA_Type,(a0)+
		bne.b	.exit
		move.l	(a0),pp_attrs(a1)

.exit		move.l	d0,(a7)
		movem.l	(a7)+,d0/a0-a1
		rts

.pass		movem.l	(a7)+,d0/a0-a1
		move.l	oldSetJoyPortAttrsA,-(a7)
		rts

;-------------------------------------------------------------------------

		cnop	0,16

cmd_length	dc.l	0
cmd_line	dc.l	0

_SysBase	dc.l	0
_GfxBase	dc.l	0
_LowLevelBase	dc.l	0

oldReadJoyPort	dc.l	0
oldSetJoyPortAttrsA:
		dc.l	0

porttable	dc.l	port0
		dc.l	port1
		dc.l	port2
		dc.l	port3

port0		dc.l	0			; MsgPort
		dc.l	0			; IORequest
		dc.l	JP_TYPE_NOTAVAIL	; Type
		dc.l	0			; Attrs
		dcb.b	ie_SIZEOF,0

port1		dc.l	0			; MsgPort
		dc.l	0			; IORequest
		dc.l	JP_TYPE_NOTAVAIL	; Type
		dc.l	0			; Attrs
		dcb.b	ie_SIZEOF,0

port2		dc.l	0			; MsgPort
		dc.l	0			; IORequest
		dc.l	JP_TYPE_NOTAVAIL	; Type
		dc.l	0			; Attrs
		dcb.b	ie_SIZEOF,0

port3		dc.l	0			; MsgPort
		dc.l	0			; IORequest
		dc.l	JP_TYPE_NOTAVAIL	; Type
		dc.l	0			; Attrs
		dcb.b	ie_SIZEOF,0


psxportname	dc.b	'psxport.device',0
lowlevelname	dc.b	'lowlevel.library',0
gfxname		dc.b	'graphics.library',0

psxctype	dc.b	0


		END
