
/*
 * FS1541 - volume, BAM and lock handling (header)
 *
 * Copyright (C) 1996 - 1999 Michael Krause
 * Copyright (C) 1998        John "Graham" Selck (portions)
 * Copyright (C) 2000 - 2008 Helmut Schoettner (many portions)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <dos/dosextens.h>

LONG InitVolumeSS (void);
void QuitVolumeSS (void);
void DoDiskInsert (BOOL bForce);
void DoDiskRemove (BOOL bForce);

UWORD Block2TS (UWORD blk);

UWORD AllocBlock (UBYTE fromt, UBYTE froms);
void FreeBlock (UBYTE t, UBYTE s);
UWORD UsedBlocks (void);

void OptimizeDirectory (void);

void StartUDSTimer (void);
void StopUDSTimer (void);
void UpdateDiskStructure (void);

BPTR MakeLock (LONG flkey, LONG axs);
void FreeLock (struct FileLock *fl);
int FreeAllLocks(BOOL bForce);
BOOL Lockable (UBYTE t, UBYTE s, LONG mode);

extern BYTE diskchgintbit;
extern struct VolumeNode *curvolumenode;
extern struct DosList *curdoslist;
extern int disk_inserted;

extern struct timerequest *UDStimer;

extern struct BAM *bam;
extern struct DirEntry directory[144];
extern int dirsize;

extern UBYTE interleave;

struct VolumeNode {
	struct MinNode node;
	struct DosList *volnode;
	struct FileLock *locklist;
	UBYTE name[30];	/* this is a BCPL string */
	ULONG dollarlen;
	/* 144 dir entries a 29 bytes incl. CR + 1 volume name incl. ESCs and CR */
	/* + 128 bytes for 'BLOCKS FREE' and other information */
	UBYTE dollarbuf[(30* 144)+ 40+ 1024];
};

struct BAM {
	UBYTE dirt,dirs;    /* track of next block (always 18), sector of next block (always 1)      */
	UBYTE id;           /* format classification - always 'A' (CBM 1541/1551/1571/4040)          */
	UBYTE dside;        /* flag for double sided - for 1571 only                                 */
	ULONG tracks[35];   /* 35x (free sectors of track, sec 0-7 map, sec 8-16 map, sec 17-23 map) */
	UBYTE name[16];     /* disk-name at format time                                              */
	UBYTE pad1[2];      /* filled with 160 (shift-space)                                         */

/*	UBYTE name2[5]; - replaced by following: */
/*	UBYTE pad2[89]; - replaced by following: */

    UBYTE ubDiskIdAr[2];    /* disk-id at format time                                                */
    UBYTE pad3[1];      /* filled with 160 (shift-space)                                         */
    UBYTE dostype[2];   /* always contains '2A'                                                  */

    UBYTE pad4[4];      /* filled with 160 (shift-space)                                         */
    UBYTE pad5[55];     /* filled with 000 - unused                                              */
    UBYTE pad6[30];     /* filled with 000 - unused and undocumented - only to get 256 bytes     */
};

struct DirEntry {
	UBYTE t, s;
	UBYTE type;
	UBYTE datat, datas;
	UBYTE name[16];
	UBYTE relsst, relsss;
	UBYTE rellen;
	UBYTE pad[4];
	UBYTE tmpdatat, tmpdatas;
	UBYTE lengthl, lengthh;
};

struct DataBlock {
	UBYTE t, s;
	UBYTE data[254];
};
