
/*
 * FS1541 - support routines
 *
 * Copyright (C) 1996 - 1999 Michael Krause
 * Copyright (C) 1998        John "Graham" Selck (portions)
 * Copyright (C) 2000 - 2008 Helmut Schoettner (many portions)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <string.h>

#include <exec/types.h>
#include <exec/execbase.h>
#include <exec/memory.h>
#include <dos/dosextens.h>
#include <dos/filehandler.h>
#include <devices/input.h>
#include <devices/inputevent.h>

#include <proto/exec.h>

#include "support.h"
#include "main.h"

__inline UBYTE AsciiFilter (UBYTE chr, UBYTE level);

/*-------------------------------------------------------------------------*/

void ReturnPacket (struct DosPacket *packet, LONG res1, LONG res2)
{
	struct MsgPort *mp= packet->dp_Port;

	packet->dp_Port= ourport;
	packet->dp_Res1= res1;
	packet->dp_Res2= res2;

	PutMsg(mp, packet->dp_Link);
}

struct DosPacket *GetPacket (struct MsgPort *port)
{
	struct Message *msg;

	if ((msg= GetMsg(port)))
	{
		return((struct DosPacket *)msg->mn_Node.ln_Name);
	}
	else
	{
		return(NULL);
	}
}

/*-------------------------------------------------------------------------*/

void Ascii2Cbm (STRPTR dest, STRPTR src, UBYTE maxlen)
{
	UBYTE ascii2cbmAr[256] =
	{
		  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,	/* 000 - 009 */
		 10,  11,  12,  13,  14,  15,  16,  17,  18,  19,	/* 010 - 019 */
		 20,  21,  22,  23,  24,  25,  26,  27,  28,  29,	/* 020 - 029 */
		 30,  31,  32,  33,  34,  35,  36,  37,  38,  39,	/* 030 - 039 */
		 40,  41,  42,  43,  44,  45,  46,  47,  48,  49,	/* 040 - 049 */
		 50,  51,  52,  53,  54,  55,  56,  57,  58,  59,	/* 050 - 059 */
		 60,  61,  62,  63,  64,  65,  66,  67,  68,  69,	/* 060 - 069 */
		 70,  71,  72,  73,  74,  75,  76,  77,  78,  79,	/* 070 - 079 */
		 80,  81,  82,  83,  84,  85,  86,  87,  88,  89,	/* 080 - 089 */
		 90,  91, 109,  93,  94, 164, 106,  65,  66,  67,	/* 090 - 099 */
		 68,  69,  70,  71,  72,  73,  74,  75,  76,  77,	/* 100 - 109 */
		 78,  79,  80,  81,  82,  83,  84,  85,  86,  87,	/* 110 - 119 */
		 88,  89,  90, 179, 103, 171, 101, 127, 128, 129,	/* 120 - 129 */
		130, 131, 132, 133, 134, 135, 136, 137, 138, 139,	/* 130 - 139 */
		140, 141, 142, 143, 144, 145, 146, 147, 148, 149,	/* 140 - 149 */
		150, 151, 152, 153, 154, 155, 156, 157, 158, 159,	/* 150 - 159 */
		160, 180, 190,  92,  95,  96,  97,  98,  99, 100,	/* 160 - 169 */
		102, 104, 105, 110, 111, 112, 113, 114, 115, 116,	/* 170 - 179 */
		117, 118, 119, 120, 121, 122, 123, 124, 125, 126,	/* 180 - 189 */
		161, 162, 163, 165, 166, 167, 168, 169, 170, 172,	/* 190 - 199 */
		173, 174, 175, 176, 177, 178, 181, 182, 183, 184,	/* 200 - 209 */
		185, 186, 187, 188, 189, 107, 108, 191, 192, 193,	/* 210 - 219 */
		194, 195, 196, 197, 198, 199, 200, 201, 202, 203,	/* 220 - 229 */
		204, 205, 206, 207, 208, 209, 210, 211, 212, 213,	/* 230 - 239 */
		214, 215, 216, 217, 218, 219, 220, 221, 222, 223,	/* 240 - 249 */
		224, 225, 226, 227, 228, 229								/* 250 - 255 */
	};

	UBYTE a;

	while((a= *src++) && maxlen--)
	{
		*dest++= ascii2cbmAr[a];
	}

	while(maxlen--)
	{
		*dest++= 0xa0;
	}

}

void Cbm2Ascii (STRPTR dest, STRPTR src, UBYTE maxlen, UBYTE level)
{
	UBYTE cbm2asciiAr[256] =
	{
		  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,	/* 000 - 009 */
		 10,  11,  12,  13,  14,  15,  16,  17,  18,  19,	/* 010 - 019 */
		 20,  21,  22,  23,  24,  25,  26,  27,  28,  29,	/* 020 - 029 */
		 30,  31,  32,  33,  34,  35,  36,  37,  38,  39,	/* 030 - 039 */
		 40,  41,  42,  43,  44,  45,  46,  47,  48,  49,	/* 040 - 049 */
		 50,  51,  52,  53,  54,  55,  56,  57,  58,  59,	/* 050 - 059 */
		 60,  61,  62,  63,  64,  65,  66,  67,  68,  69,	/* 060 - 069 */
		 70,  71,  72,  73,  74,  75,  76,  77,  78,  79,	/* 070 - 079 */
		 80,  81,  82,  83,  84,  85,  86,  87,  88,  89,	/* 080 - 089 */
		 90,  91, 163,  93,  94, 164, 165, 166, 167, 168,	/* 090 - 099 */
		169, 126, 170, 124, 171, 172,  96, 215, 216,  92,	/* 100 - 109 */
		173, 174, 175, 176, 177, 178, 179, 180, 181, 182,	/* 110 - 119 */
		183, 184, 185, 186, 187, 188, 189, 127, 128, 129,	/* 120 - 129 */
		130, 131, 132, 133, 134, 135, 136, 137, 138, 139,	/* 130 - 139 */
		140, 141, 142, 143, 144, 145, 146, 147, 148, 149,	/* 140 - 149 */
		150, 151, 152, 153, 154, 155, 156, 157, 158, 159,	/* 150 - 159 */
		160, 190, 191, 192,  95, 193, 194, 195, 196, 197,	/* 160 - 169 */
		198, 125, 199, 200, 201, 202, 203, 204, 205, 123,	/* 170 - 179 */
		161, 206, 207, 208, 209, 210, 211, 212, 213, 214,	/* 180 - 189 */
		162, 217, 218, 219, 220, 221, 222, 223, 224, 225,	/* 190 - 199 */
		226, 227, 228, 229, 230, 231, 232, 233, 234, 235,	/* 200 - 209 */
		236, 237, 238, 239, 240, 241, 242, 243, 244, 245,	/* 210 - 219 */
		246, 247, 248, 249, 250, 251, 252, 253, 254, 255,	/* 220 - 229 */
		193, 194, 195, 196, 197, 198, 199, 200, 201, 202,	/* 230 - 239 */
		203, 204, 205, 206, 207, 208, 209, 210, 211, 212,	/* 240 - 249 */
		213, 214, 215, 216, 217, 189								/* 250 - 255 */
	};

	UBYTE a;

	while(((a= *src++) != 0xa0) && maxlen--)
	{
		*dest++= AsciiFilter(cbm2asciiAr[a], level);
	}

	*dest= '\0';

}

__inline UBYTE AsciiFilter (UBYTE chr, UBYTE level)
{
	UBYTE result;
	UBYTE exchange= '_';

	switch (level)
	{
		case CHR_LEVEL_ALPHA:
			result= ((chr > 0x00) && ((chr < 0x20) || (chr > 0x7F))) ? exchange : chr;
			break;

		case CHR_LEVEL_PRINT:
			result= ((chr > 0x00) && (chr < 0x20)) ? exchange : chr;
			break;

		case CHR_LEVEL_CRLF:
			result= ((chr > 0x00) && (chr < 0x20) && (chr != 0x0A) && (chr != 0x0D)) ? exchange : chr;
			break;

		case CHR_LEVEL_ESC:
			result= ((chr > 0x00) && (chr < 0x20) && (chr != 0x0A) && (chr != 0x0D) && (chr != 0x1B)) ? exchange : chr;
			break;

		default:
			result= chr;
	}

	return (result);
}

/*-------------------------------------------------------------------------*/

void SendEvent (BOOL insert)
{
	struct IOStdReq *InputRequest;
	struct MsgPort *InputPort;
	struct InputEvent *ie;

	if ((InputPort= (struct MsgPort*)CreateMsgPort()))
	{
		if ((InputRequest= (struct IOStdReq*)CreateIORequest(InputPort, sizeof(struct IOStdReq))))
		{
			if (!OpenDevice("input.device", 0, (struct IORequest*)InputRequest, 0))
			{
				if ((ie= AllocVec(sizeof(struct InputEvent), MEMF_PUBLIC|MEMF_CLEAR)))
				{
					ie->ie_Class= insert ? IECLASS_DISKINSERTED : IECLASS_DISKREMOVED;
					InputRequest->io_Command= IND_WRITEEVENT;
					InputRequest->io_Data= ie;
					InputRequest->io_Length= sizeof(struct InputEvent);
					DoIO((struct IORequest*)InputRequest);
					FreeVec(ie);
				}

				CloseDevice((struct IORequest*)InputRequest);
			}

			DeleteIORequest (InputRequest);
		}

		DeleteMsgPort (InputPort);
	}
}
