
/*
 * FS1541 - packet processor (header)
 *
 * Copyright (C) 1996 - 1999 Michael Krause
 * Copyright (C) 1998        John "Graham" Selck (portions)
 * Copyright (C) 2000 - 2008 Helmut Schoettner (many portions)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

BOOL DoPackets(void);

extern int inhibited;

/* This structure is used both as the one stored in fh_Arg1 of our
   filehandles as well as for passing around data about files internally. */
struct FHArg1 {
	BPTR lock;
	ULONG len, len0;
	ULONG pos;
	UBYTE t, s, p;
	UBYTE t0, s0;
	UBYTE number;
	UWORD numblocks;
};

#define FLKEY_SPECIALMASK 0xf0000
#define FLKEY_SPECIALSHIFT 16

#define FLKEY_DOLLAR 0x10000
#define VIRTUAL_FILE_DOLLAR "$"
#define FLKEY_D64 0x20000
#define VIRTUAL_FILE_D64 "$d64"
#define FLKEY_OPT 0x30000
#define VIRTUAL_FILE_OPT "$opt"
#define FLKEY_DISKINFO 0x40000
#define VIRTUAL_FILE_DISKINFO "Disk.info"

#define NUM_VIRTUAL 255
