
/*
 * FS1541 - basic disk interaction routines (header)
 *
 * Copyright (C) 1996 - 1999 Michael Krause
 * Copyright (C) 1998        John "Graham" Selck (portions)
 * Copyright (C) 2000 - 2008 Helmut Schoettner (many portions)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <devices/trackdisk.h>

LONG InitDiskSS (STRPTR pszDevice, ULONG ulUnit, ULONG ulFlags);
void QuitDiskSS (void);

void ResetDisk (void);
BOOL LoadDisk (void);
void MotorOff (void);

int SectorsOnTrack (BYTE sbTrack);
UWORD Block2TS (UWORD uwBlock);

struct DataBlock *GetBlockTS (UBYTE ubTrack, UBYTE ubSector);
struct DataBlock *PutBlockTS (UBYTE ubTrack, UBYTE ubSector, APTR apData);
struct DataBlock *GetPutBlock (ULONG ulBlock, BOOL bWrite);

extern BOOL bAutoscan;
extern BOOL bSectorLabel;
extern LONG lNumSoftErrors;
extern struct IOExtTD *SExtDiskReq;
extern int iWriteProtect, iHardWriteProtect;
extern struct MsgPort *SDpSender;
extern ULONG ulDiskChangeCount;

extern int iDiskScanned;
extern UBYTE ubDiskIdAr[683][16];

#define D64_SIZE 683*256		/* 174848 */

#define SEC_NOT_LOADED 0
#define SEC_OK 1
#define SEC_ERROR -1
