#include <exec/types.h>
#include <intuition/intuition.h>
#include <intuition/classes.h>
#include <intuition/classusr.h>
#include <intuition/imageclass.h>
#include <intuition/gadgetclass.h>
#include <libraries/gadtools.h>
#include <graphics/displayinfo.h>
#include <graphics/gfxbase.h>
#include <clib/exec_protos.h>
#include <clib/intuition_protos.h>
#include <clib/gadtools_protos.h>
#include <clib/graphics_protos.h>
#include <clib/utility_protos.h>
#include <clib/dos_protos.h>
#include <clib/alib_protos.h>
#include <clib/wb_protos.h>

#include "maingui.h"

struct Screen         *Scr = NULL;
UBYTE                 *PubScreenName = NULL;
APTR                   VisualInfo = NULL;
struct Window         *CDPlayerWnd = NULL;
struct Gadget         *CDPlayerGList = NULL;
struct Menu           *CDPlayerMenus = NULL;
struct Gadget         *CDPlayerGadgets[22];
UWORD                  CDPlayerLeft = 186;
UWORD                  CDPlayerTop = 37;
UWORD                  CDPlayerWidth = 344;
UWORD                  CDPlayerHeight = 188;
UBYTE                 *CDPlayerWdt = (UBYTE *)"Interplay V2.1 Main window";
struct TextAttr       *Font, Attr;
UWORD                  FontX, FontY;
UWORD                  OffX, OffY;

UBYTE *CycleLoop_CD0Labels[] = {
	(UBYTE *)"No Loop",
	(UBYTE *)"Loop one",
	(UBYTE *)"Loop CD",
	NULL };

UBYTE *TimeStatus_CD0Labels[] = {
	(UBYTE *)"Show Elapsed track-time",
	(UBYTE *)"Show Time left of track",
	(UBYTE *)"Show Elapsed CD time",
	(UBYTE *)"Show Time left of CD",
	NULL };

struct NewMenu CDPlayerNewMenu[] = {
	NM_TITLE, (STRPTR)"Project", NULL, 0, NULL, NULL,
	NM_ITEM, (STRPTR)"Preferences", (STRPTR)"P", 0, 0L, NULL,
	NM_ITEM, (STRPTR)"List window", (STRPTR)"L", 0, 0L, NULL,
	NM_ITEM, (STRPTR)NM_BARLABEL, NULL, 0, 0L, NULL,
	NM_ITEM, (STRPTR)"Iconify", (STRPTR)"I", 0, 0L, NULL,
	NM_ITEM, (STRPTR)"About", (STRPTR)"A", 0, 0L, NULL,
	NM_ITEM, (STRPTR)"Quit", (STRPTR)"Q", 0, 0L, NULL,
	NM_END, NULL, NULL, 0, 0L, NULL };

UWORD CDPlayerGTypes[] = {
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	BUTTON_KIND,
	TEXT_KIND,
	BUTTON_KIND,
	CYCLE_KIND,
	BUTTON_KIND,
	SLIDER_KIND,
	CHECKBOX_KIND,
	CYCLE_KIND,
	TEXT_KIND,
	BUTTON_KIND,
	STRING_KIND,
	STRING_KIND,
	CHECKBOX_KIND,
	CHECKBOX_KIND,
	LISTVIEW_KIND,
	SLIDER_KIND
};

struct NewGadget CDPlayerNGad[] = {
	4, 29, 72, 12, (UBYTE *)" Search", NULL, GD_BackSearch_CD, PLACETEXT_IN, NULL, NULL,
	76, 29, 70, 12, (UBYTE *)"Search ", NULL, GD_ForwardSearch_CD, PLACETEXT_IN, NULL, NULL,
	194, 2, 64, 15, (UBYTE *)"Stop", NULL, GD_Stop_CD, PLACETEXT_IN, NULL, NULL,
	68, 2, 63, 15, (UBYTE *)"Pause", NULL, GD_Pause_CD, PLACETEXT_IN, NULL, NULL,
	131, 2, 63, 15, (UBYTE *)"Play", NULL, GD_Play_CD, PLACETEXT_IN, NULL, NULL,
	4, 17, 72, 12, (UBYTE *)"<< Skip", NULL, GD_Prev_CD, PLACETEXT_IN, NULL, NULL,
	76, 17, 70, 12, (UBYTE *)"Skip >>", NULL, GD_Next_CD, PLACETEXT_IN, NULL, NULL,
	267, 2, 73, 16, NULL, NULL, GD_CounterTime_CD, 0, NULL, NULL,
	228, 94, 112, 12, (UBYTE *)"Eject CD", NULL, GD_Eject_CD, PLACETEXT_IN, NULL, NULL,
	116, 94, 112, 12, NULL, NULL, GD_CycleLoop_CD, 0, NULL, NULL,
	4, 2, 64, 15, (UBYTE *)"Prev", NULL, GD_SekPrev_CD, PLACETEXT_IN, NULL, NULL,
	146, 17, 163, 12, (UBYTE *)"Track   ", NULL, GD_SlideTrack_CD, PLACETEXT_LEFT, NULL, NULL,
	177, 107, 26, 11, (UBYTE *)"Random", NULL, GD_Random_CD, PLACETEXT_LEFT, NULL, NULL,
	4, 41, 336, 12, NULL, NULL, GD_TimeStatus_CD, 0, NULL, NULL,
	8, 81, 328, 11, NULL, NULL, GD_Information_CD, 0, NULL, NULL,
	4, 94, 112, 12, (UBYTE *)"Make Prog", NULL, GD_CD_ProgramEditor, PLACETEXT_IN, NULL, NULL,
	4, 53, 336, 13, NULL, NULL, GD_NameOfSong_CD, 0, NULL, NULL,
	4, 66, 336, 13, NULL, NULL, GD_NameOfGroup_CD, 0, NULL, NULL,
	311, 107, 26, 11, (UBYTE *)"List window", NULL, GD_CD_List, PLACETEXT_LEFT, NULL, NULL,
	81, 107, 26, 11, (UBYTE *)"Use Prog", NULL, GD_Program_CD, PLACETEXT_LEFT, NULL, NULL,
	1, 120, 342, 72, NULL, NULL, GD_CD_AL_ListView, 0, NULL, NULL,
	146, 29, 163, 12, NULL, NULL, GD_CD_SpeedSearch, 0, NULL, NULL
};

ULONG CDPlayerGTags[] = {
	(GA_RelVerify), TRUE, (GA_Immediate), TRUE, (TAG_DONE),
	(GA_RelVerify), TRUE, (GA_Immediate), TRUE, (TAG_DONE),
	(TAG_DONE),
	(TAG_DONE),
	(TAG_DONE),
	(TAG_DONE),
	(TAG_DONE),
	(GTTX_Text), (ULONG)"00:00:00", (TAG_DONE),
	(TAG_DONE),
	(GTCY_Labels), (ULONG)&CycleLoop_CD0Labels[ 0 ], (TAG_DONE),
	(TAG_DONE),
	(GTSL_Max), 0, (GTSL_MaxLevelLen), 99, (GTSL_LevelFormat), (ULONG)"%02ld", (GTSL_LevelPlace), (PLACETEXT_RIGHT), (PGA_Freedom), LORIENT_HORIZ, (GA_RelVerify), TRUE, (TAG_DONE),
	(TAG_DONE),
	(GTCY_Labels), (ULONG)&TimeStatus_CD0Labels[ 0 ], (TAG_DONE),
	(GTTX_Text), (ULONG)"       Welcome to Interplay V2.1", (GTTX_Border), TRUE, (TAG_DONE),
	(TAG_DONE),
	(GTST_MaxChars), 60, (STRINGA_Justification), (GACT_STRINGCENTER), (TAG_DONE),
	(GTST_MaxChars), 60, (STRINGA_Justification), (GACT_STRINGCENTER), (TAG_DONE),
	(TAG_DONE),
	(TAG_DONE),
	(GTLV_ShowSelected), NULL, (TAG_DONE),
	(GTSL_Max), 99, (GTSL_MaxLevelLen), 99, (GTSL_LevelFormat), (ULONG)"%02ld", (GTSL_LevelPlace), (PLACETEXT_RIGHT), (PGA_Freedom), LORIENT_HORIZ, (GA_RelVerify), TRUE, (TAG_DONE)
};

static UWORD ComputeX( UWORD value )
{
	return(( UWORD )((( FontX * value ) + 4 ) / 8 ));
}

static UWORD ComputeY( UWORD value )
{
	return(( UWORD )((( FontY * value ) + 4 ) / 8 ));
}

static void ComputeFont( UWORD width, UWORD height )
{
	Font = &Attr;
	Font->ta_Name = (STRPTR)Scr->RastPort.Font->tf_Message.mn_Node.ln_Name;
	Font->ta_YSize = FontY = Scr->RastPort.Font->tf_YSize;
	FontX = Scr->RastPort.Font->tf_XSize;

	OffX = Scr->WBorLeft;
	OffY = Scr->RastPort.TxHeight + Scr->WBorTop + 1;

	if ( width && height ) {
		if (( ComputeX( width ) + OffX + Scr->WBorRight ) > Scr->Width )
			goto UseTopaz;
		if (( ComputeY( height ) + OffY + Scr->WBorBottom ) > Scr->Height )
			goto UseTopaz;
	}
	return;

UseTopaz:
	Font->ta_Name = (STRPTR)"topaz.font";
	FontX = FontY = Font->ta_YSize = 8;
}

int SetupScreen( void )
{
	if ( ! ( Scr = LockPubScreen( PubScreenName )))
		return( 1L );

	ComputeFont( 0, 0 );

	if ( ! ( VisualInfo = GetVisualInfo( Scr, TAG_DONE )))
		return( 2L );

	return( 0L );
}

void CloseDownScreen( void )
{
	if ( VisualInfo ) {
		FreeVisualInfo( VisualInfo );
		VisualInfo = NULL;
	}

	if ( Scr        ) {
		UnlockPubScreen( NULL, Scr );
		Scr = NULL;
	}
}

void CDPlayerRender( void )
{
	ComputeFont( CDPlayerWidth, CDPlayerHeight );

	DrawBevelBox( CDPlayerWnd->RPort, OffX + ComputeX( 308 ),
					OffY + ComputeY( 17 ),
					ComputeX( 32 ),
					ComputeY( 12 ),
					GT_VisualInfo, VisualInfo, TAG_DONE );
	DrawBevelBox( CDPlayerWnd->RPort, OffX + ComputeX( 308 ),
					OffY + ComputeY( 29 ),
					ComputeX( 32 ),
					ComputeY( 12 ),
					GT_VisualInfo, VisualInfo, TAG_DONE );
	DrawBevelBox( CDPlayerWnd->RPort, OffX + ComputeX( 258 ),
					OffY + ComputeY( 2 ),
					ComputeX( 82 ),
					ComputeY( 15 ),
					GT_VisualInfo, VisualInfo, TAG_DONE );
	DrawBevelBox( CDPlayerWnd->RPort, OffX + ComputeX( 262 ),
					OffY + ComputeY( 4 ),
					ComputeX( 74 ),
					ComputeY( 11 ),
					GT_VisualInfo, VisualInfo, GTBB_Recessed, TRUE, TAG_DONE );
	DrawBevelBox( CDPlayerWnd->RPort, OffX + ComputeX( 4 ),
					OffY + ComputeY( 79 ),
					ComputeX( 336 ),
					ComputeY( 15 ),
					GT_VisualInfo, VisualInfo, TAG_DONE );
	DrawBevelBox( CDPlayerWnd->RPort, OffX + ComputeX( 8 ),
					OffY + ComputeY( 81 ),
					ComputeX( 328 ),
					ComputeY( 11 ),
					GT_VisualInfo, VisualInfo, GTBB_Recessed, TRUE, TAG_DONE );
	DrawBevelBox( CDPlayerWnd->RPort, OffX + ComputeX( 1 ),
					OffY + ComputeY( 0 ),
					ComputeX( 342 ),
					ComputeY( 120 ),
					GT_VisualInfo, VisualInfo, TAG_DONE );
}

int OpenCDPlayerWindow( void )
{
	struct NewGadget	ng;
	struct Gadget	*g;
	UWORD		lc, tc;
	UWORD		wleft = CDPlayerLeft, wtop = CDPlayerTop, ww, wh;

	ComputeFont( CDPlayerWidth, CDPlayerHeight );

	ww = ComputeX( CDPlayerWidth );
	wh = ComputeY( CDPlayerHeight );

	if (( wleft + ww + OffX + Scr->WBorRight ) > Scr->Width ) wleft = Scr->Width - ww;
	if (( wtop + wh + OffY + Scr->WBorBottom ) > Scr->Height ) wtop = Scr->Height - wh;

	if ( ! ( g = CreateContext( &CDPlayerGList )))
		return( 1L );

	for( lc = 0, tc = 0; lc < CDPlayer_CNT; lc++ ) {

		CopyMem((char * )&CDPlayerNGad[ lc ], (char * )&ng, (long)sizeof( struct NewGadget ));

		ng.ng_VisualInfo = VisualInfo;
		ng.ng_TextAttr   = Font;
		ng.ng_LeftEdge   = OffX + ComputeX( ng.ng_LeftEdge );
		ng.ng_TopEdge    = OffY + ComputeY( ng.ng_TopEdge );
		ng.ng_Width      = ComputeX( ng.ng_Width );
		ng.ng_Height     = ComputeY( ng.ng_Height);

		CDPlayerGadgets[ lc ] = g = CreateGadgetA((ULONG)CDPlayerGTypes[ lc ], g, &ng, ( struct TagItem * )&CDPlayerGTags[ tc ] );

		while( CDPlayerGTags[ tc ] ) tc += 2;
		tc++;

		if ( NOT g )
			return( 2L );
	}

	if ( ! ( CDPlayerMenus = CreateMenus( CDPlayerNewMenu, GTMN_FrontPen, 0L, TAG_DONE )))
		return( 3L );

	LayoutMenus( CDPlayerMenus, VisualInfo, TAG_DONE );

	if ( ! ( CDPlayerWnd = OpenWindowTags( NULL,
				WA_Left,	wleft,
				WA_Top,		wtop,
				WA_Width,	ww + OffX + Scr->WBorRight,
				WA_Height,	wh + OffY + Scr->WBorBottom,
				WA_IDCMP,	BUTTONIDCMP|TEXTIDCMP|CYCLEIDCMP|SLIDERIDCMP|CHECKBOXIDCMP|STRINGIDCMP|LISTVIEWIDCMP|IDCMP_MENUPICK|IDCMP_CLOSEWINDOW|IDCMP_REFRESHWINDOW,
				WA_Flags,	WFLG_DRAGBAR|WFLG_DEPTHGADGET|WFLG_CLOSEGADGET|WFLG_SMART_REFRESH|WFLG_ACTIVATE,
				WA_Gadgets,	CDPlayerGList,
				WA_Title,	CDPlayerWdt,
				WA_ScreenTitle,	"Interplay V2.1 (c) 1994/95 Stian Andr Olsen & Espen Skog",
				WA_PubScreen,	Scr,
				TAG_DONE )))
	return( 4L );

	SetMenuStrip( CDPlayerWnd, CDPlayerMenus );
	GT_RefreshWindow( CDPlayerWnd, NULL );

	CDPlayerRender();

	return( 0L );
}

void CloseCDPlayerWindow( void )
{
	if ( CDPlayerMenus      ) {
		ClearMenuStrip( CDPlayerWnd );
		FreeMenus( CDPlayerMenus );
		CDPlayerMenus = NULL;	}

	if ( CDPlayerWnd        ) {
		CloseWindow( CDPlayerWnd );
		CDPlayerWnd = NULL;
	}

	if ( CDPlayerGList      ) {
		FreeGadgets( CDPlayerGList );
		CDPlayerGList = NULL;
	}
}