#!/bin/ksh
# KSH Version: 'Version AJM 93u+ 2012-08-01'
# From both ${.sh.version} and ${KSH_VERSION}.
#
# Awk Version: 'awk version 20070501'
#
# OSX 10.13.6, default bash terminal running ksh.
# Darwin Barrys-MacBook-Pro.local 17.7.0 Darwin Kernel Version 17.7.0:
# Thu Jun 21 22:53:14 PDT 2018; root:xnu-4570.71.2~1/RELEASE_X86_64 x86_64
# All of this code assumes functions can use global variables, arrays, etc...
#
# Barry Walker, G0LCU.

# Only constant required, 11 decimal places.
PI=3.14159265359

Discrete_Fourier_Transform()
{
	# Check for equal length real and imaginary arrays.
	if [ ${#REAL_ARRAY[@]} -ne ${#IMAG_ARRAY[@]} ] || [ ${#REAL_ARRAY[@]} -le 1 ] || [ ${#IMAG_ARRAY[@]} -le 1 ]
	then
		echo "ERROR 1:"
		echo "Number of elements, both real and imaginary, must be the same."
		exit 1
	fi
	# Check for powers of 2.
	N=${#REAL_ARRAY[@]}
	if [ $(( $N&(N-1) )) -ne 0 ]
	then
		echo "ERROR 2:"
		echo "Padding or cropping is required to the nearest power of 2 elements."
		exit 2
	fi
	REAL=()
	IMAG=()
	# For each element into REAL() and IMAG() arrays...
	K=0
	while [ ${K} -lt ${N} ]
	do
		SUMREAL=0.0
		SUMIMAG=0.0
		# For each element from REAL_ARRAY() and IMAG_ARRAY() arrays...
		T=0
		while [ ${T} -lt ${N} ]
		do
			ANGLE=$(( 2.0*PI*$T.0*$K.0/$N.0 ))
			# Use awk for the COSINE and SINE values...
			COS_ANGLE=$( awk 'BEGIN { printf("%.11f", cos('$ANGLE')); }' )
			SIN_ANGLE=$( awk 'BEGIN { printf("%.11f", sin('$ANGLE')); }' )
			SUMREAL=$(( $SUMREAL+${REAL_ARRAY[$T]}*$COS_ANGLE+${IMAG_ARRAY[$T]}*$SIN_ANGLE ))
			SUMIMAG=$(( $SUMIMAG-${REAL_ARRAY[$T]}*$SIN_ANGLE+${IMAG_ARRAY[$T]}*$COS_ANGLE ))
			T=$(( T + 1 ))
		done
		REAL[$K]=$SUMREAL
		IMAG[$K]=$SUMIMAG
		K=$(( K + 1 ))
	done
}

abs()
{
	SQUARE=$(( (${REAL[COUNT]}**2)+(${IMAG[COUNT]}**2) ))
	ABS=$( awk 'BEGIN { printf(sqrt('$SQUARE')); }' )
}

# 16 samples of single cycle square wave, floating point values must always be positive.
#
# REAL_ARRAY=( 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 )
# IMAG_ARRAY=( 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 )
#
# 8.000000 5.125830 0.000000 1.799950 0.000000 1.202690 0.000000 1.019590
# 0.000000 1.019590 0.000000 1.202690 0.000000 1.799950 0.000000 5.125830

# This has midway '0.5' value padding at the end to bring to the power of 2.
# This is the running default.
#
REAL_ARRAY=( 1.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 0.5 0.5 0.5 )
IMAG_ARRAY=( 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 )
#
# 8.500000 4.118420 1.778820 0.246880 1.802780 0.496650 0.579470 1.315670
# 0.500000 1.315670 0.579470 0.496650 1.802780 0.246880 1.778820 4.118420

# Standard test values.
#
# REAL_ARRAY=( 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 )
# IMAG_ARRAY=( 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 )
#
# 4.000000 2.613130 0.000000 1.082390 0.000000 1.082390 0.000000 2.613130

# This assumes all needed variables are global!
Discrete_Fourier_Transform

# This lot can be discarded...
echo ""
echo "Real floating point values:"
echo "${REAL[@]}"
echo ""
echo "Imaginary floating point values:"
echo "${IMAG[@]}"
echo ""
echo "Absolute values of complex numbers:"

for COUNT in $( seq 0 1 $(( ${#REAL[@]}-1 )) )
do
	abs
	printf "%.5f " "$ABS"
done
echo ""
echo ""
echo "Done..."
