#!/bin/dash

# #!/usr/local/bin/dash
# #!/bin/sh

# DFT_POSIX_DISK.sh
# NO utilities allowed except for the GCC suite.
# Author: B.Walker, G0LCU.

# Variables...
PI=3.141592653589793

: > /tmp/DFT_Array
: > /tmp/DFT_Result

# **************************************************
if [ ! -f /tmp/calc ]
then

# Create a sin command.
cat << "SINE_C" > /tmp/sin.c
/* 'sin(x)' as a command. */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int main(int argc, const char * argv[])
{
	float RADIANS;
	float RESULT;

	if (argc <= 1)
	{
		printf("\nERROR! Argument missing!\nUSAGE: sin radians<CR>\nExample: sin 1.23456<CR>\n\n");
		exit(1);
	}

	RADIANS = atof(argv[1]);
	RESULT = sin(RADIANS);
	printf("%.12f\n", RESULT);
	return 0;
}

SINE_C

# Create a cos command.
cat << "COSINE_C" > /tmp/cos.c
/* 'cos(x)' as a command. */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int main(int argc, const char * argv[])
{
	float RADIANS;
	float RESULT;

	if (argc <= 1)
	{
		printf("\nERROR! Argument missing!\nUSAGE: cos radians<CR>\nExample: cos 1.23456<CR>\n\n");
		exit(1);
	}

	RADIANS = atof(argv[1]);
	RESULT = cos(RADIANS);
	printf("%.12f\n", RESULT);
	return 0;
}

COSINE_C

# Create a calc command.
cat << "MYCALC_C" > /tmp/mycalc.c
/* Simple Calculator and very basic inline assembly code example. */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

/* 'float' used to suit old 32 bit only systems. */
float SOLUTION;
float FLOAT_1;
float FLOAT_2;
char OPERATOR;

float calc(float FLOAT_1, float FLOAT_2, char OPERATOR)
{
	float SOLUTION = 0.0;
	switch(OPERATOR)
	{
		case '+':
			SOLUTION = FLOAT_1 + FLOAT_2;
			break;
		case '-':
			SOLUTION = FLOAT_1 - FLOAT_2;
			break;
		case 'x':
			SOLUTION = FLOAT_1 * FLOAT_2;
			break;
		case '/':
			SOLUTION = FLOAT_1 / FLOAT_2;
			break;
		case '^':
			SOLUTION = pow(FLOAT_1, FLOAT_2);
			break;
		case 'r':
			FLOAT_2 = 1.0 / FLOAT_2;
			SOLUTION = pow(FLOAT_1, FLOAT_2);
			break;
	}
	return SOLUTION;
}

int main(int argc, char *argv[])
{
	char OPERATOR;
	float FLOAT_1;
	float FLOAT_2;
	float SOLUTION;

	if (argc <= 3)
	{
		printf("\nERROR!\n\n");
		printf("Usage: calc FLOAT_1 <|+|-|x|/|^|r|> FLOAT_2<CR>\n");
		printf("Where: '+'=ADD; '-'=SUBTRACT; 'x'=MULTIPLY; '/'=DIVIDE; '^'=POWER; 'r'=NTHROOT!\n\n");
		printf("Example: calc 1000 r 3.3<CR>, (NOTE the spaces), where <CR> is the ENTER key!\n\n");
		exit(1);
	}

	SOLUTION = 0.0;
	OPERATOR = *argv[2];
	FLOAT_1 = atof(argv[1]);
	FLOAT_2 = atof(argv[3]);

	SOLUTION = calc(FLOAT_1, FLOAT_2, OPERATOR);
	printf("%.12f\n", SOLUTION);
	return(0);
}

MYCALC_C

echo ''
echo 'Please wait while gcc compiles...'
echo 'Compiling "sin"...'
gcc -Wall -pedantic -ansi -o /tmp/sin /tmp/sin.c -lm
echo 'Compiling "cos"...'
gcc -Wall -pedantic -ansi -o /tmp/cos /tmp/cos.c -lm
echo 'Finally compiling "calc"...'
gcc -Wall -pedantic -ansi -o /tmp/calc /tmp/mycalc.c -lm
echo 'Done!'

fi
# **************************************************

# **************************************************
dft()
{
	# For each element to output...
	K=0
	while [ ${K} -lt ${N} ]
	do
		M=0
		SUBSCRIPT=0
		SUMREAL=0.0
		SUMIMAG=0.0
		# For each element from input...
		T=0
		while [ ${T} -lt ${N} ]
		do
			# Equation is ( 2 * PI * T * K ) / N...
			ANGLE=$( /tmp/calc 2.0 x ${PI} )
			ANGLE=$( /tmp/calc ${ANGLE} x ${T} )
			ANGLE=$( /tmp/calc ${ANGLE} x ${K} )
			ANGLE=$( /tmp/calc ${ANGLE} / ${N} )

			# Use /tmp/cos and /tmp/sin for COS_ANGLE and SIN_ANGLE...
			COS_ANGLE=$( /tmp/cos ${ANGLE} )
			SIN_ANGLE=$( /tmp/sin ${ANGLE} )

			# Obtain REAL and IMAG values.
			M=0
			while read -r REAL
			do
				if [ ${M} -eq ${SUBSCRIPT} ]
				then
					# The REAL part already found.
					# Now read again for the IMAG part.
					read -r IMAG
					# Remove the 'i' from the imaginary number.
					IMAG=${IMAG%?}
					# All found! Now get out of loop.
					break
				fi
				M=$(( M + 1 ))
			done < /tmp/DFT_Array

			# Equation is ( SUMREAL + ( REAL * COS_ANGLE ) + ( IMAG * SIN_ANGLE ) )
			SUMREAL1=$( /tmp/calc ${REAL} x ${COS_ANGLE} )
			SUMREAL2=$( /tmp/calc ${SUMREAL} + ${SUMREAL1} )
			SUMREAL3=$( /tmp/calc ${IMAG} x ${SIN_ANGLE} )
			SUMREAL=$( /tmp/calc ${SUMREAL2} + ${SUMREAL3} )

			# Equation is ( SUMIMAG - ( REAL * SIN_ANGLE ) + ( IMAG * COS_ANGLE ) )
			SUMIMAG1=$( /tmp/calc ${REAL} x ${SIN_ANGLE} )
			SUMIMAG2=$( /tmp/calc ${SUMIMAG} - ${SUMIMAG1} )
			SUMIMAG3=$( /tmp/calc ${IMAG} x ${COS_ANGLE} )
			SUMIMAG=$( /tmp/calc ${SUMIMAG2} + ${SUMIMAG3} )

			SUBSCRIPT=$(( SUBSCRIPT + 2 ))
			T=$(( T + 1 ))
		done
		echo "${SUMREAL}" >> /tmp/DFT_Result
		echo "${SUMIMAG}i" >> /tmp/DFT_Result
		R=$( /tmp/calc ${SUMREAL} ^ 2 )
		I=$( /tmp/calc ${SUMIMAG} ^ 2 )
		SQR=$( /tmp/calc ${R} + ${I} )
		SQRT=$( /tmp/calc ${SQR} r 2 )
		printf "%.5f " "${SQRT}"	
		K=$(( K + 1 ))
	done
}
# **************************************************

# **************************************************
# 16 samples of single cycle square wave, floating point values must always be positive.
#
# echo '1.0
#0.0i
#1.0
#0.0i
#1.0
#0.0i
#1.0
#0.0i
#1.0
#0.0i
#1.0
#0.0i
#1.0
#0.0i
#1.0
#0.0i
#0.0
#0.0i
#0.0
#0.0i
#0.0
#0.0i
#0.0
#0.0i
#0.0
#0.0i
#0.0
#0.0i
#0.0
#0.0i
#0.0
#0.0i' > /tmp/DFT_Array
#
# 8.00000 5.12583 0.00000 1.79995 0.00000 1.20269 0.00000 1.01959
# 0.00000 1.01959 0.00000 1.20269 0.00000 1.79995 0.00000 5.12583

# This has midway '0.5' value padding at the end to bring to the power of 2.
# This is the running default.
#
echo '1.0
0.0i
1.0
0.0i
1.0
0.0i
1.0
0.0i
1.0
0.0i
1.0
0.0i
0.0
0.0i
0.0
0.0i
0.0
0.0i
0.0
0.0i
0.0
0.0i
0.0
0.0i
1.0
0.0i
0.5
0.0i
0.5
0.0i
0.5
0.0i' > /tmp/DFT_Array
#
# 8.50000 4.11842 1.77882 0.24688 1.80278 0.49665 0.57947 1.31567
# 0.50000 1.31567 0.57947 0.49665 1.80278 0.24688 1.77882 4.11842

# Standard test values.
#
# echo '1.0
#0.0i
#1.0
#0.0i
#1.0
#0.0i
#1.0
#0.0i
#0.0
#0.0i
#0.0
#0.0i
#0.0
#0.0i
#0.0
#0.0i' > /tmp/DFT_Array
#
# 4.00000 2.61313 0.00000 1.08239 0.00000 1.08239 0.00000 2.61313
# **************************************************

# START.

# **************************************************
# Get the length of the REAL and IMAGINARY pair combined.
# No *NIX tools are allowed so doing it longhand.
# DO NOT USE 'wc'...
N=0
while read -r M
do
	N=$(( N + 1 ))
done < /tmp/DFT_Array
# Check for powers of 2 and exit if not.
if [ $(( $N&(N-1) )) -ne 0 ]
then
	echo "ERROR: Padding or cropping is required to the nearest power of 2 elements."
	exit 1
fi
N=$(( N / 2 ))
# **************************************************

# **************************************************
# Finally Run the 'dft' function... 
echo ''

dft
# **************************************************

# **************************************************
# The code below added for ease but not needed...
echo ''
echo ''

while read -r REAL
do
	echo "${REAL}"
done < /tmp/DFT_Result

echo ''
# **************************************************

# END.
