# IDFT_AMIGA_MATH.py
# Inverse_Discrete_Fourier_Transform.py
# Python 1.4.0 to 3.10.4...
#
# Issued as Creative Commons CC0 licence; Public Domain.
# Barry Walker, G0LCU.
#
# Minimum requirements:
# 1) Standard A1200(HD), AMIGA OS3.0.x, (HDD).
# 2) Python 1.4.0, absolute minimum, full install on AMINET.
# https://aminet.net/package/dev/lang/Python_14
#
# Checked on:
# A stock or expanded AMIGA A1200(HD), OS3.0x using Python 1.4.0 and 2.0.1.
# FS-UAE using AMIGA OS3.1x, using Python 1.4.0 to 2.0.1.
# A Macbook Pro, OSX 10.15.7, Python, 2.7.x, 3.5.x, 3.8.x, 3.9.x and 3.10.4.
# A Linux Mint 21.2 machine with Python 2.7.x or 3.8.x.
# NOT tested on Windows or WinUAE but will more than likely work.

import sys
import math

def Inverse_Discrete_Fourier_Transform(REAL_DATA, IMAG_DATA):
	N=len(REAL_DATA)
	WAVEFORM=[]
	for K in range(0,N,1):
		REAL_VALUE=0.0
		for ELEMENT in range(0,N,1):
			RADIAN=(ELEMENT*2.0*math.pi*K)/(int(N))
			REAL_VALUE=REAL_VALUE+REAL_DATA[ELEMENT]*math.cos(RADIAN)-IMAG_DATA[ELEMENT]*math.sin(RADIAN)
		REAL_VALUE=REAL_VALUE/(int(N))
		WAVEFORM.append(REAL_VALUE)
	return WAVEFORM

# The default test IDFT...
REAL_DATA=[8.5000000000, 3.6378211867, -1.7071067812, 0.0514252105, 1.5000000000, -0.1727455541, -0.2928932188, 0.4834991568, 0.5000000000, 0.4834991568, -0.2928932188, -0.1727455541, 1.5000000000, 0.0514252105, -1.7071067812, 3.6378211867]
IMAG_DATA=[0.0000000000, -1.9307144055, -0.5000000000, -0.2414680083, -1.0000000000, 0.4656387729, 0.5000000000, -1.2236076244, 0.0000000000, 1.2236076244, -0.5000000000, -0.4656387729, 1.0000000000, 0.2414680083, 0.5000000000, 1.9307144055]

IDFT=Inverse_Discrete_Fourier_Transform(REAL_DATA, IMAG_DATA)
print('')
print("Inverse of Fourier Transform...")
print(IDFT)

print('')
LENGTH=len(IDFT)
print("Absolute REAL waveform values...")
for N in range(0,LENGTH,1): print("    %.1f" %(abs(IDFT[N])))
print('')

sys.exit()

# *********************************************************
# This test Fourier Transform should return...
#
# Inverse real values of Fourier Transform...
# [0.9999999999875, 0.99999999999671, 0.9999999999918346, 1.000000000001465,
# 0.9999999999874993, 1.0000000000050644, -4.75804118327261e-12, -5.066808084208674e-12,
# 1.2499572707590598e-11, -1.4663964487127146e-12, 8.16573197948145e-12, 3.2913394232281235e-12,
# 1.0000000000125036, 0.4999999999996918, 0.5000000000047589, 0.5000000000003098]
#
# Absolute REAL waveform values...
# 1.0
# 1.0
# 1.0
# 1.0
# 1.0
# 1.0
# 0.0
# 0.0
# 0.0
# 0.0
# 0.0
# 0.0
# 1.0
# 0.5
# 0.5
# 0.5
# *********************************************************
