# IDFT_AMIGA_CMATH.py
# Inverse_Discrete_Fourier_Transform.py
# Python 1.4.0 to 3.10.4...
#
# Issued as Creative Commons CC0 licence; Public Domain.
# Barry Walker, G0LCU.
#
# Minimum requirements:
# 1) Standard A1200(HD), AMIGA OS3.0.x, (HDD).
# 2) Python 1.4.0, absolute minimum, full install on AMINET.
# https://aminet.net/package/dev/lang/Python_14
#
# Checked on:
# A stock or expanded AMIGA A1200(HD), OS3.0x using Python 1.4.0 and 2.0.1.
# FS-UAE using AMIGA OS3.1x, using Python 1.4.0 to 2.0.1.
# A Macbook Pro, OSX 10.15.7, Python, 2.7.x, 3.5.x, 3.8.x, 3.9.x and 3.10.4.
# A Linux Mint 21.2 machine with Python 2.7.x or 3.8.x.
# NOT tested on Windows or WinUAE but will more than likely work.


import sys
import cmath

def Inverse_Discrete_Fourier_Transform(DATA):
	N=len(DATA)
	WAVEFORM=[]
	for K in range(0,N,1):
		REAL_IMAG=complex(0.0+0.0j)
		for ELEMENT in range(0,N,1):
			REAL_IMAG=REAL_IMAG+DATA[ELEMENT]*cmath.exp(1j*2*cmath.pi*ELEMENT*K/(int(N)))
		REAL_IMAG=REAL_IMAG/(int(N))
		WAVEFORM.append(REAL_IMAG)
	return WAVEFORM

IDFT=Inverse_Discrete_Fourier_Transform([(8.5+0j), (3.6378211867292967-1.930714405542749j), (-1.7071067811865475-0.5000000000000001j), (0.05142521051217004-0.24146800830128268j), (1.5-1j), (-0.17274555407181275+0.4656387728852651j), (-0.29289321881345254+0.5j), (0.4834991568303464-1.2236076243562013j), (0.5+0j), (0.4834991568303464+1.2236076243562015j), (-0.29289321881345254-0.4999999999999999j), (-0.1727455540718124-0.465638772885265j), (1.5+1j), (0.05142521051216992+0.24146800830128226j), (-1.7071067811865475+0.49999999999999994j), (3.6378211867292958+1.9307144055427488j)])

# This is a standard test IDFT, commented out...
# IDFT=Inverse_Discrete_Fourier_Transform([(4.0+0.0j), (1.0-2.414213562373095j), (0.0+0.0j), (1.0-0.4142135623730949j), (0.0+0.0j), (0.9999999999999999+0.4142135623730949j), (0.0+0.0j), (0.9999999999999997+2.414213562373095j)])

print('')
print("Inverse of Fourier Transform...")
print(IDFT)

print('')
LENGTH=len(IDFT)
print("Absolute REAL waveform values...")
for N in range(0,LENGTH,1): print("    %.1f" %(abs(IDFT[N])))
print('')

sys.exit()

# *********************************************************
# This is the default running test IDFT...
# This test should return...
#
# Inverse of Fourier Transform...
# [(0.9999999999999999-5.551115123125783e-17j), (1.0000000000000002-1.942890293094024e-16j),
# (1-2.914335439641036e-16j), (0.9999999999999993-6.106226635438361e-16j),
# (0.9999999999999992-4.163336342344337e-16j), (0.9999999999999994-4.440892098500626e-16j),
# (-2.0122792321330962e-15+9.159339953157541e-16j), (-1.6653345369377348e-15+1.6930901125533637e-15j),
# (-3.885780586188048e-16+1.304512053934559e-15j), (-3.3306690738754696e-16+8.604228440844963e-16j),
# (4.996003610813204e-16+1.1379786002407855e-15j), (1.2212453270876722e-15+1.915134717478395e-15j),
# (1.0000000000000036+9.71445146547012e-16j), (0.5000000000000006+1.1102230246251565e-16j),
# (0.5000000000000026-1.0269562977782698e-15j), (0.5000000000000004-8.326672684688674e-16j)]
#
# Absolute REAL waveform values...
# 1.0
# 1.0
# 1.0
# 1.0
# 1.0
# 1.0
# 0.0
# 0.0
# 0.0
# 0.0
# 0.0
# 0.0
# 1.0
# 0.5
# 0.5
# 0.5
# *********************************************************

# The standard test Fourier Transform...
# [(4.0+0.0j), (1.0-2.414213562373095j), (0.0+0.0j), (1.0-0.4142135623730949j), (0.0+0.0j),
# (0.9999999999999999+0.4142135623730949j), (0.0+0.0j), (0.9999999999999997+2.414213562373095j)]
# To give the results...
# ****************************
# For 1 full cycle, 8 samples.
# ****************************
#
# Inverse of Fourier Transform...
# [(1+0j), (1+0j), (1-8.326672684688674e-17j), (1-1.6653345369377348e-16j),
# (-1.942890293094024e-16+2.220446049250313e-16j), (-3.3306690738754696e-16+5.412337245047638e-16j),
# (-3.3306690738754696e-16-3.0531133177191805e-16j), (1.2906342661267445e-15+7.216449660063518e-16j)]
#
# Absolute REAL waveform values...
# 1.0
# 1.0
# 1.0
# 1.0
# 0.0
# 0.0
# 0.0
# 0.0
