/* IDFT_VBCC_GCC.c */

/* Author:- B.Walker, G0LCU, Issued as CC0, Public Domain... */
/* ********************************************************** */
/* Written for the AMIGA A1200, ADE *NIX emulator. */
/* gcc version 2.95.3 20010315 (release) */
/* gcc -Wall -o FFT_VBCC_GCC FFT_VBCC_GCC.c -lm<CR> */
/* ********************************************************** */
/* Using the VBCC C compiler for the AMIGA. */
/* VBCC Version:- $VER: vbcc 0.810 (05.06.2006) */
/* vc FFT_VBCC_GCC.c -o FFT_VBCC_GCC -lmieee<CR> */
/* ********************************************************** */
/* IMPORTANT NOTE! There is no 'cmath.h' in the above gcc suite for the AMIGA. */
/* Hence this is a 'math.h' version instead. */
/* It might well compile using Dice-C but not attempted. */

/* Apple gcc --version brings up...... */
/* Apple LLVM version 10.0.0 (clang-1000.11.45.5) */
/* Target: x86_64-apple-darwin19.6.0 */
/* Thread model: posix */
/* clang -Wall -pedantic -ansi -std=c99 -o FFT_VBCC_GCC FFT_VBCC_GCC.c -lm<CR> */

/* gcc (Ubuntu 9.3.0-17ubuntu1~20.04) 9.3.0 */
/* Copyright (C) 2019 Free Software Foundation, Inc. */
/* This is free software; see the source for copying conditions.  There is NO */
/* warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. */
/* gcc -Wall -pedantic -ansi -std=c99 -o FFT_VBCC_GCC FFT_VBCC_GCC.c -lm<CR> */

#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#define PI 3.141592653589793
#define LENGTH 16

int Inverse_Discrete_Fourier_Transform(double REAL_DATA[], double IMAG_DATA[], const int N)
{
	double WAVEFORM[LENGTH];
	double RADIAN=0.0;
	double RESULT=0.0;
	int K=0;
	int ELEMENT=0;
	for (K=0; K<N; K++)
	{
		RESULT=0.0;
		for (ELEMENT=0; ELEMENT<N; ELEMENT++)
		{
			RADIAN=((2.0*PI*K*ELEMENT)/N);
			RESULT=RESULT+REAL_DATA[ELEMENT]*cos(RADIAN)-IMAG_DATA[ELEMENT]*sin(RADIAN);
		}
		WAVEFORM[K]=RESULT/N;
		printf("    %.1f 	%.1f\n", WAVEFORM[K], fabs(WAVEFORM[K]));
	}
	return 0;
}

int main()
{
	/* A Fourier Transform of a 16 sample pseudo-squarewave with 0.5 padding at the end. */
	double REAL_DATA[]={8.5000000000, 3.6378211867, -1.7071067812, 0.0514252105, 1.5000000000, -0.1727455541, -0.2928932188, 0.4834991568, 0.5000000000, 0.4834991568, -0.2928932188, -0.1727455541, 1.5000000000, 0.0514252105, -1.7071067812, 3.6378211867};
	double IMAG_DATA[]={0.0000000000, -1.9307144055, -0.5000000000, -0.2414680083, -1.0000000000, 0.4656387729, 0.5000000000, -1.2236076244, 0.0000000000, 1.2236076244, -0.5000000000, -0.4656387729, 1.0000000000, 0.2414680083, 0.5000000000, 1.9307144055};

	/* Standard 8 sample test data. */
	/* double REAL_DATA[]={4.0000000000, 1.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 1.0000000000}; */
	/* double IMAG_DATA[]={0.0000000000, -2.4142135624, 0.0000000000, -0.4142135624, 0.0000000000, 0.4142135624, 0.0000000000, 2.4142135624}; */

	const int N=sizeof(REAL_DATA)/sizeof(REAL_DATA[0]);
	printf("\nWAVEFORM...\n        IDFT:\n  Actual:    Absolute:\n");
	Inverse_Discrete_Fourier_Transform(REAL_DATA, IMAG_DATA, N);
	printf("\n");
	exit(0);
}

/*
  REAL_DATA    IMAG_DATA
8.5000000000+0.0000000000
3.6378211867-1.9307144055
-1.7071067812-0.5000000000
0.0514252105-0.2414680083
1.5000000000-1.0000000000
-0.1727455541+0.4656387729
-0.2928932188+0.5000000000
0.4834991568-1.2236076244
0.5000000000+0.0000000000
0.4834991568+1.2236076244
-0.2928932188-0.5000000000
-0.1727455541-0.4656387729
1.5000000000+1.0000000000
0.0514252105+0.2414680083
-1.7071067812+0.5000000000
3.6378211867+1.9307144055
Should return absolute 16 sample pseudo-squarewave WAVEFORM with 0.5 as padding at the end.
1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.5, 0.5, 0.5
Actual values:
1.0, 1.0, 1.0, 1.0, 1.0, 1.0, -0.0, -0.0, 0.0, -0.0, 0.0, 0.0, 1.0, 0.5, 0.5, 0.5
*/

/* Standard test data...
  REAL_DATA    IMAG_DATA
4.0000000000+0.0000000000
1.0000000000-2.4142135624
0.0000000000+0.0000000000
1.0000000000-0.4142135624
0.0000000000+0.0000000000
1.0000000000+0.4142135624
0.0000000000+0.0000000000
1.0000000000+2.4142135624
Should return absolute 8 sample squarewave WAVEFORM.
1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0
Actual values:
1.0, 1.0, 1.0, 1.0, -0.0, -0.0, -0.0, -0.0
*/
