/* DFT_GCC_ONLY.c */

/* Author:- B.Walker, G0LCU, Issued as CC0, Public Domain... */
/* Written for the AMIGA A1200, ADE *NIX emulator. */
/* gcc version 2.95.3 20010315 (release) */
/* gcc -Wall -o DFT_GCC_ONLY DFT_GCC_ONLY.c -lm<CR> */
/* IMPORTANT NOTE! There is no 'complex.h' in the above gcc suite for the AMIGA. */
/* Hence this is a 'math.h' version instead. */

/* Apple gcc --version brings up...... */
/* Apple LLVM version 10.0.0 (clang-1000.11.45.5) */
/* Target: x86_64-apple-darwin19.6.0 */
/* Thread model: posix */
/* clang -Wall -pedantic -ansi -std=c99 -o DFT_GCC_ONLY DFT_GCC_ONLY.c -lm<CR> */

/* gcc (Ubuntu 9.3.0-17ubuntu1~20.04) 9.3.0 */
/* Copyright (C) 2019 Free Software Foundation, Inc. */
/* This is free software; see the source for copying conditions.  There is NO */
/* warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. */
/* gcc -Wall -pedantic -ansi -std=c99 -o DFT_GCC_ONLY DFT_GCC_ONLY.c -lm<CR> */

#include <math.h>
#include <stdio.h>
#include <stdlib.h>

int Discrete_Fourier_Transform(double DATA_REAL[], double DATA_IMAG[], const int N)
{
	double REAL[N];
	double IMAG[N];
	double RADIAN=0.0;
	int K=0;
	int ELEMENT=0;
	const double PI=3.141592653589793;
	if (N<=1)
	{
		return 0;
	}
	if ((N&(N-1))!=0)
	{
		printf("Power of 2 ERROR!\n");
		printf("Padding or cropping is required to the nearest power of 2 elements.\n");
		printf("Exiting with a return code of 1!\n\n");
		exit(1);
	}
	for (K=0; K<N; K++)
	{
		REAL[K]=0.0;
		IMAG[K]=0.0;
		for (ELEMENT=0; ELEMENT<N; ELEMENT++)
		{
			RADIAN=(2*PI*K*ELEMENT/N);
			REAL[K]=(REAL[K]+(DATA_REAL[ELEMENT]*cos(RADIAN))+(DATA_IMAG[ELEMENT]*sin(RADIAN)));
			IMAG[K]=(IMAG[K]-(DATA_REAL[ELEMENT]*sin(RADIAN))+(DATA_IMAG[ELEMENT]*cos(RADIAN)));
		}
		printf("((%.10f)+(%.10fj))\n", REAL[K], IMAG[K]);
	}
	return 0;
}

int main()
{
	double REAL_DATA[]={1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.5, 0.5, 0.5};
	double IMAG_DATA[]={0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
	const int N=sizeof(REAL_DATA)/sizeof(REAL_DATA[0]);
	printf("\nDFT array values:-\n      Real:         Imaginary:\n");
	Discrete_Fourier_Transform(REAL_DATA, IMAG_DATA, N);
	printf("\n");
	exit(0);
}

/*
# Power of 2 with 0.5 padding.
# {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.5, 0.5, 0.5}
# 
# ((8.5000000000)+(0.0000000000j))
# ((3.6378211867)+(-1.9307144055j))
# ((-1.7071067812)+(-0.5000000000j))
# ((0.0514252105)+(-0.2414680083j))
# ((1.5000000000)+(-1.0000000000j))
# ((-0.1727455541)+(0.4656387729j))
# ((-0.2928932188)+(0.5000000000j))
# ((0.4834991568)+(-1.2236076244j))
# ((0.5000000000)+(0.0000000000j))
# ((0.4834991568)+(1.2236076244j))
# ((-0.2928932188)+(-0.5000000000j))
# ((-0.1727455541)+(-0.4656387729j))
# ((1.5000000000)+(1.0000000000j))
# ((0.0514252105)+(0.2414680083j))
# ((-1.7071067812)+(0.5000000000j))
# ((3.6378211867)+(1.9307144055j))
*/

