10 REM IDFT_BWBasic.bas
20 REM Author:- B.Walker, G0LCU, issued as CC0, Public Domain.
30 REM https://aminet.net/package/dev/lang/bwbasic111
40 REM This is AMIGA Bywater Basic specific.
50 REM *******************************************
60 REM N are the array sizes, in powers of 2 and e$ is the escape character.
70 N=8
80 e$=CHR$(27)
90 REM *******************************************
100 REM Clear the screen.
110 PRINT e$;"c";
120 REM ******************************************
130 REM Inverse Discrete Fourier Transform in BWBasic.
140 REM Set up the arrays.
150 DIM R(N)
160 DIM I(N)
170 REM Input REAL array.
180 R(0)=4.0000000000
190 R(1)=1.0000000000
200 R(2)=0.0000000000
210 R(3)=1.0000000000
220 R(4)=0.0000000000
230 R(5)=1.0000000000
240 R(6)=0.0000000000
250 R(7)=1.0000000000
260 REM Input IMAGINARY array.
270 I(0)=0.0000000000
280 I(1)=-2.4142135623
290 I(2)=0.0000000000
300 I(3)=-0.4142135623
310 I(4)=0.0000000000
320 I(5)=0.4142135623
330 I(6)=0.0000000000
340 I(7)=2.4142135623
350 REM Output WAVEFORM array.
360 DIM r(N)
370 REM ******************************************
380 REM Display the input arrays.
390 PRINT ""
400 PRINT "     Display REAL  and  IMAGINARY input pairs:-"
410 FOR n=0 TO (N-1) STEP 1
420 	PRINT "",R(n),"	";I(n)
430 NEXT n
440 REM ******************************************
450 PRINT ""
460 PRINT "     Calculating the original waveform..."
470 REM Call the IDFT routine.
480 GOSUB 730
490 REM ******************************************
500 REM Finally print out the ABSOLUTE values.
510 PRINT ""
520 PRINT "     And finally the WAVEFORM of the COMPLEX pairs:-"
530 PRINT ""
540 FOR n=0 TO (N-1) STEP 1
550	W=r(n)
560	PRINT USING "###.#";ABS(W);
570 NEXT n
580 PRINT ""
590 REM ******************************************
600 REM Exit the program.
610 SYSTEM
620 REM ******************************************
630 REM ** Inverse Discrete Fourier Transform. ***
640 REM K is an integer _pointer_ to each r() array.
650 REM E is an integer _pointer_ to each ELEMENT in the R() and I() arrays.
660 REM N is the length of the arrays.
670 REM P is the constant pi.
680 REM R() is the REAL input array.
690 REM I() is the IMAGINARY input array.
700 REM W is the WAVEFORM.
710 REM A is the ANGLE in radians.
720 REM r() is the WAVEFORM output array.
730 REM ************** IDFT start. ***************
740 P=3.1415926536
750 FOR K=0 TO (N-1) STEP 1
760	W=0.0
770		FOR E=0 TO (N-1) STEP 1
780			A=(2.0*P*E*K)/(N)
790			W=W+R(E)*COS(A)-I(E)*SIN(A)
800		NEXT E
810	r(K)=(W/N)
820 NEXT K
830 RETURN
840 REM *************** IDFT end. ****************
850 REM **** Compare with the values below. ******
860 REM  1.0  1.0  1.0  1.0  0.0  0.0  0.0  0.0
870 REM ******************************************

