/* DFT_ARexx.rexx DEMO. */
/* Barry Walker, G0LCU. */

NUMERIC DIGITS 14

/* Only constant required, 14 decimal places. */
PI=3.14159265358979 
/* Assign variables. */
REAL_ARRAY.0=0.0
IMAG_ARRAY.0=0.0
APPROX=1.0
CLOSER=0.0
THETA=0.0
ANGLE=THETA
NUMBER=0.0
SINE=0.0
COSINE=1.0
ABSOLUTE=0.0
ABSOLUTE.0=1
ARRAY_LIMIT=0
N=0
M=0
STR=""

/* Use system 'Echo' to clear the screen. */
ADDRESS COMMAND 'Echo "*ec"'
SAY "An experimental method to do a DFT in PURE"
SAY "ARexx only using test values with padding."
SAY ""

/* A test _ARRAY_ using 0.5 as padding to bring to a power of 2. */
/* This has midway '0.5' value padding at the end to bring to the power of 2. */
/* Note: SIX 1.0s, SIX 0.0s, ONE extra 1.0 and finally the THREE 0.5s padding! */
/* Real values: '1.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 0.5 0.5 0.5' */
/* Imag values: '0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0' */
/* This gives the DFT _array_ of...... */
/* '8.50000 4.11842 1.77882 0.24688 1.80278 0.49665 0.57947 1.31567' */
/* '0.50000 1.31567 0.57947 0.49665 1.80278 0.24688 1.77882 4.11842' */
/* Not really ARRAYS but good enough for this DEMO! */

/* A file access method first... */
N=0
OPEN(data, "DFT_ARexx.data", "R")
	DO UNTIL EOF(data)
		REAL_ARRAY.N=READLN(data)
		IMAG_ARRAY.N=READLN(data)
		N=N+1
	END
	/* N does a final loop to EOF to give the value 17 instead of 16. */
	ARRAY_LIMIT=N-2
CLOSE(data)
/* File access method end. */

/* #####################################
/* This whole block is commented out. */
/* Manual method Second. */
/* REAL ARRAY first... */
DO N=0 TO 5 BY 1
	REAL_ARRAY.N=1.0
END
DO N=6 TO 11 BY 1
	REAL_ARRAY.N=0.0
END
REAL_ARRAY.12=1.0
DO N=13 TO 15 BY 1
	REAL_ARRAY.N=0.5
END
/* IMAGINARY ARRAY second... */
DO N=0 TO 15 BY 1
	IMAG_ARRAY.N=0.0
END
ARRAY_LIMIT=N-1
/* Manual method end. */
##################################### */

/* Display them. */
SAY "Input, REAL: IMAG:"
DO N=0 TO ARRAY_LIMIT BY 1
	SAY "        "||REAL_ARRAY.N||"   "||IMAG_ARRAY.N
END
SAY ""
SAY "Calculating DFT REAL and IMAGINARY values, (16 periods), please wait..."

CALL DFT

SAY ""
DO N=0 TO ARRAY_LIMIT BY 1
	SAY "REAL: "||+OUT_REAL.N||"	IMAG: "||+OUT_IMAG.N||"i"
END

SAY ""
SAY "Final ABSOLUTE DFT values to 5 decimal places NOT rounded up or down:-"
STR=""
DO N=0 TO ARRAY_LIMIT BY 1
	CALL ABSOLUTE_COMPLEX
	NUMERIC DIGITS 14
	ABSOLUTE.N=TRUNC(ABSOLUTE,5)
	STR=STR||+ABSOLUTE.N||" "
END
SAY STR
SAY ""
SAY "Compare with the correct results rounded as required:-"
SAY "8.50000 4.11842 1.77882 0.24688 1.80278 0.49665 0.57947 1.31567"
SAY "0.50000 1.31567 0.57947 0.49665 1.80278 0.24688 1.77882 4.11842"
SAY ""
SAY "Plot a simple UNCALIBRATED spectrum display..."
SAY ""
DO N=1 TO ARRAY_LIMIT BY 1
	STR="|"
	ABSOLUTE=TRUNC((ABSOLUTE.N*10),0)
		DO M=1 TO ABSOLUTE BY 1
			STR=STR||"*"
		END
	SAY STR
END
SAY ""
EXIT

/* Create the subroutines required. */
/* DFT subroutine. */
DFT:
/* Use system 'Echo' to print string without a newline. */
ADDRESS COMMAND 'Echo "Very SLOW progress:- " NOLINE'
DO K=0 TO ARRAY_LIMIT BY 1
	SUMREAL=0.0
	SUMIMAG=0.0
	DO T=0 TO ARRAY_LIMIT BY 1
		/* RADIAN=(2*PI*T*K)/(ARRAY_LIMIT+1) */
		/* Convert THETA in radians to angle in degrees. */
		THETA=((2*PI*T*K)/(ARRAY_LIMIT+1))*(180/PI)
		/* Set new 'THETA' angle into 'ANGLE' for COS[INE]. */
		ANGLE=THETA
		CALL COS
		/* Reset new 'THETA' angle into 'ANGLE' for SIN[E]. */
		ANGLE=THETA
		CALL SIN
		SUMREAL=SUMREAL+(REAL_ARRAY.T*COSINE)+(IMAG_ARRAY.T*SINE)
		SUMIMAG=SUMIMAG-(REAL_ARRAY.T*SINE)+(IMAG_ARRAY.T*COSINE)
	END
	/* Use system 'Echo' to print progress dots, 16 in total. */
	ADDRESS COMMAND 'Echo "." NOLINE'
	/* Truncated to make it look good on screen. */
	OUT_REAL.K=TRUNC(SUMREAL,11)
	OUT_IMAG.K=TRUNC(SUMIMAG,11)
END
SAY " DONE!"
RETURN
/* DFT subroutine end. */

/* SINe ANGLE subroutine. */
SIN:
	/* Allow for angles greater than 360.0 degrees. */
	IF ANGLE>360.0
	THEN
		DO FOREVER
		ANGLE=ANGLE-360.0
			IF ANGLE<360.0 THEN BREAK
		END
	ENDIF
	/* Allow for angles less than or equal to 0.0 degrees if required. */
	IF ANGLE<=0.0
	THEN
		DO FOREVER
			ANGLA=ANGLE+360.0
			IF ANGLE>=0.0 THEN BREAK
		END
	ENDIF
	/* Only the 0.0 to 90.0 degree quadrant is actually catered for. */
	/* The line below will probably never be needed. */
	IF ANGLE=360.0 THEN ANGLE=0.0
	/* The three quadrants below are derivates of 0.0 to 90.0 degrees. */
	IF ANGLE>270.0 THEN ANGLE=ANGLE-360.0
	IF ANGLE>180.0 THEN ANGLE=-(ANGLE-180.0)
	IF ANGLE>90.0 THEN ANGLE=180.0-ANGLE
	/* Convert ANGLE to RADIANs. */
	RADIAN=((ANGLE*PI)/180.0)
	SINE=RADIAN-((RADIAN**3)/6)+((RADIAN**5)/120)-((RADIAN**7)/5040)+((RADIAN**9)/362880)-((RADIAN**11)/39916800)+((RADIAN**13)/6227020800.0)
	IF ANGLE=0.0 THEN SINE=0.0
	IF ANGLE=90.0 THEN SINE=1.0
	IF ANGLE=-90.0 THEN SINE=-1.0
/* 'SINE' returns the floating point value. */
RETURN
/* SINe ANGLE subroutine end. */

/* COSine ANGLE subroutine. */
COS:
	ANGLE=ANGLE+90.0
	/* NOTE: SIN is the prime mover here. */
	CALL SIN
	COSINE=SINE
/* COSine ANGLE returns 'COSINE' a floating point value. */
RETURN
/* COSine ANGLE subroutine end. */

/* SQuaRe rooT subroutine. */
SQRT:
APPROX=1
DO M=0 TO 100 BY 1
	CLOSER=(((NUMBER/APPROX)+APPROX)/2.0)
	IF APPROX=CLOSER THEN BREAK
	/* This line included to guarantee an exit on very, very tiny floats. */
	IF +APPROX<=0.000000000001
	THEN
		APPROX=TRUNC(0.0,11)
	ENDIF
	APPROX=CLOSER
END
ABSOLUTE=APPROX
RETURN
/* SQuaRe rooT subroutine end. */

/* ABSOLUTE value of complex number subroutine. */
ABSOLUTE_COMPLEX:
	NUMBER=((OUT_REAL.N**2)+(OUT_IMAG.N**2))
	CALL SQRT
RETURN
/* ABSOLUTE value of complex number subroutine end. */

