/* 
 * File:   main.cpp
 * Author: Piotr Hoppe
 *
 * Created on 11 listopada 2015, 00:10
 */

//#define MUIPP_DEBUG         // Turn debugging mode on for invalid use of classes

#include <cstdlib>
#include <iostream>

#include <libraries/mui.hpp>
#include <proto/exec.h>

using namespace std;

int addThirdWindow(CMUI_Application &app);

int main(int argc, char** argv) {
    STRPTR cycleOS[] = {"Amiga OS 3.x", "Amiga OS 4.x", "Aros", "MorphOS", NULL};
    const char *radioOS[] = {"Amiga OS 3.x", "Amiga OS 4.x", "Aros", "MorphOS", NULL};
    char *amigasList[] = {"Amiga 1000", "Amiga 500", "Amiga 2000", "Amiga 3000", "Amiga 500+",
        "Amiga CDTV", "Amiga 600", "Amiga 1200", "Amiga CD32", "Amiga 4000", "Amiga 4000T", NULL};

    cout << "start" << endl;

    CMUI_Window window;
    CMUI_List list;

    CMUI_Menu appMenu(
        MUIA_Menu_Title, "File",
        MUIA_Family_Child, CMUI_Menuitem(
            MUIA_Menuitem_Title, "Quit",   
            TAG_DONE),
        TAG_DONE
    );
    CMUI_Menustrip menuStrip(MUIA_Family_Child, appMenu, TAG_DONE);

    CMUI_Application app (
        MUIA_Application_Title, "Example - MUIPlus.Aros",
        MUIA_Application_Author, "Piotr Hoppe",
        MUIA_Application_Base, "TEST",
        MUIA_Application_Copyright, "Piotr Hoppe",
        MUIA_Application_Description, "Sample application",
        MUIA_Application_Version, "$VER: Example 1.0 (11.11.2015)",
        MUIA_Application_Menustrip, menuStrip,
        SubWindow, window = CMUI_Window (
            MUIA_Window_Title, "MUIPlus.Aros - example C++ class",
            MUIA_Window_ID, 10,
            WindowContents, CMUI_Group(
                Child, CMUI_Text(MUIA_Text_Contents, "Hello world.",
                TAG_DONE),
                Child, CMUI_Button("Button"),
                Child, CMUI_HGroup(
                    Child, CMUI_Button("A"),
                    Child, CMUI_Button("B"),
                    Child, CMUI_Checkmark("Checkmark"),
                TAG_DONE),
                Child, CMUI_HGroup(
                    Child, CMUI_Text(MUIA_Text_Contents, "Name", TAG_DONE),
                    Child, CMUI_String(MUIA_Frame, MUIV_Frame_String, TAG_DONE),
                    Child, CMUI_Cycle("Select OS", cycleOS),
                TAG_DONE),
                Child, CMUI_HGroup(
                    Child, CMUI_Radio(MUIA_Radio_Entries, radioOS, TAG_DONE),
                TAG_DONE),
                Child, CMUI_HGroup(
                    Child, CMUI_Coloradjust(MUIA_Weight, 100, TAG_DONE),
                    Child, list = CMUI_List(MUIA_Frame, MUIV_Frame_ReadList, MUIA_List_SourceArray, amigasList, TAG_DONE),    
                TAG_DONE), 
            TAG_DONE),
        TAG_DONE),
    TAG_DONE
    );
    
    cout << "Create the secondary window" << endl;
    CMUI_Window *windowTwo = new CMUI_Window(
        MUIA_Window_Title, "MUIPlus.Aros - example C++ class - secondly window",
        MUIA_Window_ID, 20,
        WindowContents, (new CMUI_Group(
        Child, (new CMUI_Text(MUIA_Text_Contents, "Hello world - the window created dynamic.",
            TAG_DONE))->operator*(),
        TAG_DONE))->operator*(),
    TAG_DONE);
    
    if (!app.IsValid()) {
        cout << "Could not create application!\n" << endl;
        return 10;
    }
    if (!window.IsValid()) {
        cout << "Could not create window!\n" << endl;
        return 10;
    }

    if (windowTwo && !windowTwo->IsValid()) {
        delete windowTwo;
        cout << "Could not create secondly window!\n" << endl;
        return 10;
    } else if (!windowTwo) {
        cout << "Could not create secondly window!\n" << endl;
        return 10;
    }

    window.Notify(sva, MUIA_Window_CloseRequest, TRUE,
        *app, 2, MUIM_Application_ReturnID, MUIV_Application_ReturnID_Quit);
    window.SetOpen(TRUE);
    
    cout << "Open the secondary window" << endl;
    app.AddWindow(windowTwo->operator*());
    windowTwo->SetOpen(TRUE);
    addThirdWindow(app);

    ULONG sigs = 0;
    BOOL running = TRUE;
    
    while (running) {
        switch (app.NewInput(&sigs)) {
            case MUIV_Application_ReturnID_Quit:
                running = FALSE;
                break;
        }

        if (sigs) {
            sigs = Wait(sigs | SIGBREAKF_CTRL_C);
            if (sigs & SIGBREAKF_CTRL_C) break;
        }
    }

    // This disposes of the application and all windows and objects in the
    // windows.

    app.Dispose();
    
    if (windowTwo) {
        delete windowTwo;
    }
    
    cout << "end" << endl;
    return 0;
}

int addThirdWindow(CMUI_Application &app) {
    int result = 0;
    CMUI_Window window = CMUI_Window(
        MUIA_Window_Title, "MUIPlus.Aros - example C++ class - third window",
        MUIA_Window_ID, 30,
        WindowContents, CMUI_Group(
            Child, CMUI_Text(MUIA_Text_Contents, "Hello world - the window created in function.", TAG_DONE),
        TAG_DONE),
    TAG_DONE);
    
    if (!window.IsValid()) {
        result++;
    }
    if (!result) {
        cout << "Open the third window" << endl;
        app.AddWindow(window.operator*());
        window.SetOpen(TRUE);
    }
    return result;
}