/* 
 * File:   mui_declarations.hpp
 * Author: Piotr Hoppe
 *
 * Created on 6 grudnia 2015, 22:04
 */

#ifndef MUI_DECLARATIONS_HPP
#define	MUI_DECLARATIONS_HPP

#ifndef MUI_NOSHORTCUTS
#define MUI_NOSHORTCUTS
#endif

#ifndef LIBRARIES_MUI_H
#include <libraries/mui.h>
#endif

#ifdef __GNUC__
#include <proto/intuition.h>
#include <proto/muimaster.h>
//#include <inline/muimaster.h>
//#include <inline/intuition.h>
#else
#include <clib/muimaster_protos.h>
#include <clib/intuition_protos.h>
#endif
//#include <libraries/mui.hpp>

#include <clib/alib_protos.h>
#include <cstdlib>

// Shortcuts that are compatiable with this header are redefined here.
// The standard MUI <class>Object shortcuts for creating objects
// (eg. WindowObject etc) have been redefined as <class>Obj
// (eg. WindowObj) so as not to conflict with member functions of the
// same name within classes.

#ifndef MUIPP_NOSHORTCUTS

#define MenustripObj 		MUI_NewObject(MUIC_Menustrip
#define MenuObj  			MUI_NewObject(MUIC_Menu
#define MenuObjT(name)   	MUI_NewObject(MUIC_Menu,MUIA_Menu_Title,name
#define MenuitemObj  		MUI_NewObject(MUIC_Menuitem
#define WindowObj			MUI_NewObject(MUIC_Window
#define ImageObj 			MUI_NewObject(MUIC_Image
#define BitmapObj			MUI_NewObject(MUIC_Bitmap
#define BodychunkObj 		MUI_NewObject(MUIC_Bodychunk
#define NotifyObj			MUI_NewObject(MUIC_Notify
#define ApplicationObj   	MUI_NewObject(MUIC_Application
#define TextObj  			MUI_NewObject(MUIC_Text
#define RectangleObj 		MUI_NewObject(MUIC_Rectangle
#define BalanceObj   		MUI_NewObject(MUIC_Balance
#define ListObj  			MUI_NewObject(MUIC_List
#define PropObj  			MUI_NewObject(MUIC_Prop
#define StringObj			MUI_NewObject(MUIC_String
#define ScrollbarObj 		MUI_NewObject(MUIC_Scrollbar
#define ListviewObj  		MUI_NewObject(MUIC_Listview
#define RadioObj 			MUI_NewObject(MUIC_Radio
#define VolumelistObj		MUI_NewObject(MUIC_Volumelist
#define FloattextObj 		MUI_NewObject(MUIC_Floattext
#define DirlistObj   		MUI_NewObject(MUIC_Dirlist
#define CycleObj 			MUI_NewObject(MUIC_Cycle
#define GaugeObj 			MUI_NewObject(MUIC_Gauge
#define ScaleObj 			MUI_NewObject(MUIC_Scale
#define NumericObj   		MUI_NewObject(MUIC_Numeric
#define SliderObj			MUI_NewObject(MUIC_Slider
#define NumericbuttonObj 	MUI_NewObject(MUIC_Numericbutton
#define KnobObj  			MUI_NewObject(MUIC_Knob
#define LevelmeterObj		MUI_NewObject(MUIC_Levelmeter
#define BoopsiObj			MUI_NewObject(MUIC_Boopsi
#define ColorfieldObj		MUI_NewObject(MUIC_Colorfield
#define PenadjustObj 		MUI_NewObject(MUIC_Penadjust
#define ColoradjustObj   	MUI_NewObject(MUIC_Coloradjust
#define PaletteObj   		MUI_NewObject(MUIC_Palette
#define GroupObj 			MUI_NewObject(MUIC_Group
#define RegisterObj  		MUI_NewObject(MUIC_Register
#define VirtgroupObj 		MUI_NewObject(MUIC_Virtgroup
#define ScrollgroupObj   	MUI_NewObject(MUIC_Scrollgroup
#define PopstringObj 		MUI_NewObject(MUIC_Popstring
#define PopObjObj 			MUI_NewObject(MUIC_Popobject
#define PoplistObj   		MUI_NewObject(MUIC_Poplist
#define PopaslObj			MUI_NewObject(MUIC_Popasl
#define PendisplayObj		MUI_NewObject(MUIC_Pendisplay
#define PoppenObj			MUI_NewObject(MUIC_Poppen
#define AboutmuiObj  		MUI_NewObject(MUIC_Aboutmui
#define ScrmodelistObj   	MUI_NewObject(MUIC_Scrmodelist
#define KeyentryObj  		MUI_NewObject(MUIC_Keyentry
#define VGroup  			MUI_NewObject(MUIC_Group
#define HGroup  			MUI_NewObject(MUIC_Group,MUIA_Group_Horiz,TRUE
#define ColGroup(cols)  	MUI_NewObject(MUIC_Group,MUIA_Group_Columns,(cols)
#define RowGroup(rows)  	MUI_NewObject(MUIC_Group,MUIA_Group_Rows   ,(rows)
#define PageGroup   		MUI_NewObject(MUIC_Group,MUIA_Group_PageMode,TRUE
#define VGroupV 			MUI_NewObject(MUIC_Virtgroup
#define HGroupV 			MUI_NewObject(MUIC_Virtgroup,MUIA_Group_Horiz,TRUE
#define ColGroupV(cols) 	MUI_NewObject(MUIC_Virtgroup,MUIA_Group_Columns,(cols)
#define RowGroupV(rows) 	MUI_NewObject(MUIC_Virtgroup,MUIA_Group_Rows   ,(rows)
#define PageGroupV  		MUI_NewObject(MUIC_Virtgroup,MUIA_Group_PageMode,TRUE
#define RegisterGroup(t)	MUI_NewObject(MUIC_Register,MUIA_Register_Titles,(t)
#define End 				TAG_DONE)

#define Child       	  	MUIA_Group_Child
#define FChild				MUIA_Family_Child
#define SubWindow   	  	MUIA_Application_Window
#define WindowContents    	MUIA_Window_RootObject
#define CMUI_VGroup			CMUI_Group

// Frame types

#define NoFrame 		 MUIA_Frame, MUIV_Frame_None
#define ButtonFrame 	 MUIA_Frame, MUIV_Frame_Button
#define ImageButtonFrame MUIA_Frame, MUIV_Frame_ImageButton
#define TextFrame   	 MUIA_Frame, MUIV_Frame_Text
#define StringFrame 	 MUIA_Frame, MUIV_Frame_String
#define ReadListFrame    MUIA_Frame, MUIV_Frame_ReadList
#define InputListFrame   MUIA_Frame, MUIV_Frame_InputList
#define PropFrame   	 MUIA_Frame, MUIV_Frame_Prop
#define SliderFrame 	 MUIA_Frame, MUIV_Frame_Slider
#define GaugeFrame  	 MUIA_Frame, MUIV_Frame_Gauge
#define VirtualFrame	 MUIA_Frame, MUIV_Frame_Virtual
#define GroupFrame  	 MUIA_Frame, MUIV_Frame_Group
#define GroupFrameT(s)   MUIA_Frame, MUIV_Frame_Group, MUIA_FrameTitle, s, MUIA_Background, MUII_GroupBack

// Spacing objects

#define HVSpace 		  MUI_NewObject(MUIC_Rectangle,TAG_DONE)
#define HSpace(x)   	  MUI_MakeObject(MUIO_HSpace,x)
#define VSpace(x)   	  MUI_MakeObject(MUIO_VSpace,x)
#define HCenter(obj)	  (HGroup, GroupSpacing(0), Child, HSpace(0), Child, (obj), Child, HSpace(0), End)
#define VCenter(obj)	  (VGroup, GroupSpacing(0), Child, VSpace(0), Child, (obj), Child, VSpace(0), End)
#define InnerSpacing(h,v) MUIA_InnerLeft,(h),MUIA_InnerRight,(h),MUIA_InnerTop,(v),MUIA_InnerBottom,(v)
#define GroupSpacing(x)   MUIA_Group_Spacing,x

// Labelling objects. The standard Label shortcut has been redefined as RLabel
// because some classes have an attribute called "Label".

#define RLabel(label)  MUI_MakeObject(MUIO_Label,label,0)
#define RLabel1(label) MUI_MakeObject(MUIO_Label,label,MUIO_Label_SingleFrame)
#define RLabel2(label) MUI_MakeObject(MUIO_Label,label,MUIO_Label_DoubleFrame)
#define LLabel(label)  MUI_MakeObject(MUIO_Label,label,MUIO_Label_LeftAligned)
#define LLabel1(label) MUI_MakeObject(MUIO_Label,label,MUIO_Label_LeftAligned|MUIO_Label_SingleFrame)
#define LLabel2(label) MUI_MakeObject(MUIO_Label,label,MUIO_Label_LeftAligned|MUIO_Label_DoubleFrame)
#define CLabel(label)  MUI_MakeObject(MUIO_Label,label,MUIO_Label_Centered)
#define CLabel1(label) MUI_MakeObject(MUIO_Label,label,MUIO_Label_Centered|MUIO_Label_SingleFrame)
#define CLabel2(label) MUI_MakeObject(MUIO_Label,label,MUIO_Label_Centered|MUIO_Label_DoubleFrame)

#define FreeLabel(label)   MUI_MakeObject(MUIO_Label,label,MUIO_Label_FreeVert)
#define FreeLabel1(label)  MUI_MakeObject(MUIO_Label,label,MUIO_Label_FreeVert|MUIO_Label_SingleFrame)
#define FreeLabel2(label)  MUI_MakeObject(MUIO_Label,label,MUIO_Label_FreeVert|MUIO_Label_DoubleFrame)
#define FreeLLabel(label)  MUI_MakeObject(MUIO_Label,label,MUIO_Label_FreeVert|MUIO_Label_LeftAligned)
#define FreeLLabel1(label) MUI_MakeObject(MUIO_Label,label,MUIO_Label_FreeVert|MUIO_Label_LeftAligned|MUIO_Label_SingleFrame)
#define FreeLLabel2(label) MUI_MakeObject(MUIO_Label,label,MUIO_Label_FreeVert|MUIO_Label_LeftAligned|MUIO_Label_DoubleFrame)
#define FreeCLabel(label)  MUI_MakeObject(MUIO_Label,label,MUIO_Label_FreeVert|MUIO_Label_Centered)
#define FreeCLabel1(label) MUI_MakeObject(MUIO_Label,label,MUIO_Label_FreeVert|MUIO_Label_Centered|MUIO_Label_SingleFrame)
#define FreeCLabel2(label) MUI_MakeObject(MUIO_Label,label,MUIO_Label_FreeVert|MUIO_Label_Centered|MUIO_Label_DoubleFrame)

#define KeyLabel(label,key)   MUI_MakeObject(MUIO_Label,label,key)
#define KeyLabel1(label,key)  MUI_MakeObject(MUIO_Label,label,MUIO_Label_SingleFrame|(key))
#define KeyLabel2(label,key)  MUI_MakeObject(MUIO_Label,label,MUIO_Label_DoubleFrame|(key))
#define KeyLLabel(label,key)  MUI_MakeObject(MUIO_Label,label,MUIO_Label_LeftAligned|(key))
#define KeyLLabel1(label,key) MUI_MakeObject(MUIO_Label,label,MUIO_Label_LeftAligned|MUIO_Label_SingleFrame|(key))
#define KeyLLabel2(label,key) MUI_MakeObject(MUIO_Label,label,MUIO_Label_LeftAligned|MUIO_Label_DoubleFrame|(key))
#define KeyCLabel(label,key)  MUI_MakeObject(MUIO_Label,label,MUIO_Label_Centered|(key))
#define KeyCLabel1(label,key) MUI_MakeObject(MUIO_Label,label,MUIO_Label_Centered|MUIO_Label_SingleFrame|(key))
#define KeyCLabel2(label,key) MUI_MakeObject(MUIO_Label,label,MUIO_Label_Centered|MUIO_Label_DoubleFrame|(key))

#define FreeKeyLabel(label,key)   MUI_MakeObject(MUIO_Label,label,MUIO_Label_FreeVert|(key))
#define FreeKeyLabel1(label,key)  MUI_MakeObject(MUIO_Label,label,MUIO_Label_FreeVert|MUIO_Label_SingleFrame|(key))
#define FreeKeyLabel2(label,key)  MUI_MakeObject(MUIO_Label,label,MUIO_Label_FreeVert|MUIO_Label_DoubleFrame|(key))
#define FreeKeyLLabel(label,key)  MUI_MakeObject(MUIO_Label,label,MUIO_Label_FreeVert|MUIO_Label_LeftAligned|(key))
#define FreeKeyLLabel1(label,key) MUI_MakeObject(MUIO_Label,label,MUIO_Label_FreeVert|MUIO_Label_LeftAligned|MUIO_Label_SingleFrame|(key))
#define FreeKeyLLabel2(label,key) MUI_MakeObject(MUIO_Label,label,MUIO_Label_FreeVert|MUIO_Label_LeftAligned|MUIO_Label_DoubleFrame|(key))
#define FreeKeyCLabel(label,key)  MUI_MakeObject(MUIO_Label,label,MUIO_Label_FreeVert|MUIO_Label_Centered|(key))
#define FreeKeyCLabel1(label,key) MUI_MakeObject(MUIO_Label,label,MUIO_Label_FreeVert|MUIO_Label_Centered|MUIO_Label_SingleFrame|(key))
#define FreeKeyCLabel2(label,key) MUI_MakeObject(MUIO_Label,label,MUIO_Label_FreeVert|MUIO_Label_Centered|MUIO_Label_DoubleFrame|(key))

#define NO_TAGS     	  	((Tag)TAG_DONE)

#endif				// MUIPP_NOSHORTCUTS

// All variable args methods must start with a StartVarArgs object

class StartVarArgs
{
public:
    IPTR methodID;
};

static StartVarArgs sva;    // Use this object at the start of variable
                            // argument methods.

// When MUIPP_DEBUG is defined then checking is performed to ensure objects
// create successfully, required tags are passed and indexes into lists aren't
// out of range. Depending on the error found either an error or a warning
// message will be generated and printed on stderr. If an error occurs then
// the application is terminated but a warning will just print a message.
// At present, errors can only occur if you use a template Listview or List
// object (ie CTMUI_Listview or CTMUI_List classes) and supply an invalid index
// to the [] operator.

#ifdef MUIPP_DEBUG

#ifdef __GNUC__
#include <proto/alib.h>
#include <proto/utility.h>
//#include <inline/exec.h>
//#include <inline/utility.h>
#else
#include <clib/exec_protos.h>
#include <clib/utility_protos.h>
#endif

#include <stdio.h>

// This defines the maximum number of tags that are likely to be passed to an
// object during creation. If TAG_DONE is not found within this number of tags
// then an error message will be generated. The default is 30 but this can be
// overridden by defining it to something else or this feature can be turned off
// by defining it to be 0.

#ifndef MUIPP_DEBUG_NUMTAGS
#define MUIPP_DEBUG_NUMTAGS 30
#endif

static void
_MUIPPWarning (const char *message, ...)
{
	fprintf (stderr, "MUIPP Warning: ");
//	vfprintf (stderr, message, (_VA_LIST_)(&message + 1));
}

static void
_MUIPPError (const char *message, ...)
{
	fprintf (stderr, "MUIPP Error: ");
//	vfprintf (stderr, message, (_VA_LIST_)(&message + 1));

	fprintf (stderr, "Do you wish to quit your application (q) or continue (c)?");
	fflush (stderr);
	char response[10];
	fscanf (stderr, "%s", response);

	if (response[0] == 'q' || response[0] == 'Q')
		exit (10);
}

static void
_CheckTagsSpecifiedA (const char *className,
                      struct TagItem *tags,
                      struct TagItem *requiredTags)
{
	struct TagItem *tag, *tstate;
	int i;

    // Make sure utility.library has been opened first

//    if (UtilityBase == NULL)
//    {
//     	if ((UtilityBase = (struct UtilityBase *)OpenLibrary ("utility.library", 0)) == NULL)
//     	{
//     	 	_MUIPPWarning ("Could not open utility.library for debugging purposes:\n"
//     	 				   "Cannot check correct tags specified or for missing TAG_DONE\n");
//     	 	return;
//     	}
//    }

    // Check for possible missing TAG_DONE

    if (MUIPP_DEBUG_NUMTAGS != 0)
    {
		for (tstate = tags, i = 0; (tag = NextTagItem(&tstate)) != NULL && i < MUIPP_DEBUG_NUMTAGS;)
    		;

    	if (i == MUIPP_DEBUG_NUMTAGS)
    		_MUIPPError ("Possible missing TAG_DONE during construction of a %s object\n", className);
    }

    // Check all required tags are passed

    for (tstate = requiredTags; (tag = NextTagItem(&tstate)) != NULL;)
    {

        if (FindTagItem (tag->ti_Tag, tags) == NULL)
            _MUIPPWarning ("When constructing %s objects the %s attribute should be specified\n",
                           className,
                           (const char *)tag->ti_Data);
    }
}

static void
_CheckTagsSpecified (const char *className,
                     struct TagItem *tags,
                     Tag tag1, ...)
{
    _CheckTagsSpecifiedA (className, tags, (struct TagItem *)&tag1);
}

#endif      /* MUIPP_DEBUG */

#endif	/* MUI_DECLARATIONS_HPP */

