
/* 
 * File:   CTMUI_NList.h
 * Author: Piotr Hoppe
 *
 * Created on 14 grudnia 2015, 23:16
 */

#ifndef CTMUI_NLIST_H
#define CTMUI_NLIST_H

#include "CMUI_NList.h"

/***************************************************************************
 **                       CMUI_NList class definition
 ***************************************************************************/

template <typename Type> class CTMUI_NList : public CMUI_Area {
public:
    CTMUI_NList(void);
    CTMUI_NList(Tag tag1, ...);
    CTMUI_NList(Object * obj);
    CTMUI_NList & operator=(Object * obj);
    Type & operator[](LONG pos);
    LONG Length(void) const;
    IPTR NumSelected(void);

    void AddHead(Type * entry);
    void AddHead(Type & entry);
    void AddTail(Type * entry);
    void AddTail(Type & entry);
    void InsertTop(Type * entry);
    void InsertTop(Type & entry);
    void InsertBottom(Type * entry);
    void InsertBottom(Type & entry);
    void InsertSorted(Type * entry);
    void InsertSorted(Type & entry);
    void InsertActive(Type * entry);
    void InsertActive(Type & entry);
    LONG Active(void) const;
    void SetActive(LONG value);
    void SetAutoCopyToClip(BOOL value);
    BOOL AutoVisible(void) const;
    void SetAutoVisible(BOOL value);
    LONG ClickColumn(void) const;
    void SetCompareHook(struct Hook * value);
    void SetConstructHook(struct Hook * value);
    void SetCopyColumnToClipHook(struct Hook * value);
    void SetCopyEntryToClipHook(struct Hook * value);
    void SetDefaultObjectOnClick(BOOL value);
    LONG DefClickColumn(void) const;
    void SetDefClickColumn(LONG value);
    void SetDestructHook(struct Hook * value);
    void SetDisplayHook(struct Hook * value);
    void SetDisplayRecall(BOOL value);
    BOOL MDoubleClick(void) const;
    BOOL DragSortable(void) const;
    void SetDragSortable(BOOL value);
    LONG DragType(void) const;
    void SetDragType(LONG value);
    LONG DropMark(void) const;
    LONG Entries(void) const;
    BOOL EntryValueDependent(void) const;
    void SetEntryValueDependent(BOOL value);
    LONG First(void) const;
    void SetFirst(LONG value);
    STRPTR Format(void) const;
    void SetFormat(STRPTR value);
    LONG HorizDeltaFactor(void) const;
    LONG Horiz_Entries(void) const;
    LONG Horiz_First(void) const;
    void SetHoriz_First(LONG value);
    LONG Horiz_Visible(void) const;
    BOOL Input(void) const;
    void SetInput(BOOL value);
    LONG InsertPosition(void) const;
    void SetKeepActive(Object * value);
    void SetMakeActive(Object * value);
    void SetMinLineHeight(LONG value);
    BOOL MultiClick(void) const;
    void SetMultiTestHook(struct Hook * value);
    APTR PrivateData(void) const;
    void SetPrivateData(APTR value);
    LONG Prop_Entries(void) const;
    LONG Prop_First(void) const;
    void SetProp_First(LONG value);
    LONG Prop_Visible(void) const;
    void SetQuiet(BOOL value);
    BOOL ShowDropMarks(void) const;
    void SetShowDropMarks(BOOL value);
    char * SkipChars(void) const;
    void SetSkipChars(char * value);
    IPTR TabSize(void) const;
    void SetTabSize(IPTR value);
    char * Title(void) const;
    void SetTitle(char * value);
    BOOL TitleSeparator(void) const;
    void SetTitleSeparator(BOOL value);
    void SetTypeSelect(LONG value);
    LONG VertDeltaFactor(void) const;
    LONG Visible(void) const;
    LONG TitleBackground(void) const;
    void SetTitleBackground(LONG value);
    LONG TitlePen(void) const;
    void SetTitlePen(LONG value);
    IPTR Clear(void);
    IPTR CopyToClip(LONG pos, IPTR clipnum);
    IPTR CreateImage(Object * imgobj, IPTR flags);
    IPTR DeleteImage(APTR listimg);
    IPTR Exchange(LONG pos1, LONG pos2);
    IPTR GetEntry(LONG pos, Type * * entry);
    IPTR GetEntryInfo(struct MUI_NList_GetEntryInfo * res);
    IPTR Insert(Type * * entries, LONG count, LONG pos);
    IPTR InsertSingle(Type * entry, LONG pos);
    IPTR InsertSingleWrap(void);
    IPTR InsertWrap(Type * * entries);
    IPTR Jump(LONG pos);
    IPTR Move(LONG from, LONG to);
    IPTR NextSelected(LONG * pos);
    IPTR Redraw(LONG pos);
    IPTR Remove(LONG pos);
    IPTR ReplaceSingle(LONG pos, LONG seltype, LONG * state);
    IPTR Sort(void);
    IPTR TestPos(LONG x, LONG y, struct MUI_NList_TestPos_Result * res);
    IPTR UseImage(Object * obj, IPTR imgnum, IPTR flags);
};


#endif /* CTMUI_NLIST_H */

