
/* 
 * File:   CTMUI_List.h
 * Author: Piotr Hoppe
 *
 * Created on 20 grudnia 2015, 21:32
 */

#ifndef CTMUI_LIST_H
#define CTMUI_LIST_H

#include <libraries/muiplus/CMUI_Area.h>

/***************************************************************************
 **        CTMUI_List : Template version of CMUI_List class definition
 ***************************************************************************/

template <class Type>
class CTMUI_List : public CMUI_Area {
public:
    CTMUI_List(void);
    CTMUI_List(Tag tag1, ...);
    CTMUI_List(Object * obj);
    CTMUI_List & operator=(Object * obj);
    Type & operator[](LONG pos);
    LONG Length(void) const;
    IPTR NumSelected(void);

    // These methods can be used as shortcuts for inserting objects into lists
    void InsertTop(Type *entry);
    void InsertTop(Type &entry);
    void InsertBottom(Type *entry);
    void InsertBottom(Type &entry);
    void InsertSorted(Type *entry);
    void InsertSorted(Type &entry);
    void InsertActive(Type *entry);
    void InsertActive(Type &entry);
    void InsertSingle(Type &entry, LONG pos);
    LONG Active(void) const;
    void SetActive(LONG value);
    BOOL AutoVisible(void) const;
    void SetAutoVisible(BOOL value);
    void SetCompareHook(struct Hook * value);
    void SetConstructHook(struct Hook * value);
    void SetDestructHook(struct Hook * value);
    void SetDisplayHook(struct Hook * value);
    BOOL DragSortable(void) const;
    void SetDragSortable(BOOL value);
    LONG DropMark(void) const;
    LONG Entries(void) const;
    LONG First(void) const;
    STRPTR Format(void) const;
    void SetFormat(STRPTR value);
    LONG InsertPosition(void) const;
    void SetMultiTestHook(struct Hook * value);
    void SetQuiet(BOOL value);
    BOOL ShowDropMarks(void) const;
    void SetShowDropMarks(BOOL value);
    char * Title(void) const;
    void SetTitle(char * value);
    LONG Visible(void) const;
    IPTR Clear(void);
    IPTR CreateImage(Object * obj, IPTR flags);
    IPTR DeleteImage(APTR listimg);
    IPTR Exchange(LONG pos1, LONG pos2);
    IPTR GetEntry(LONG pos, Type ** entry);
    IPTR Insert(Type ** entries, LONG count, LONG pos);
    IPTR InsertSingle(Type * entry, LONG pos);
    IPTR Jump(LONG pos);
    IPTR Move(LONG from, LONG to);
    IPTR NextSelected(LONG * pos);
    IPTR Redraw(LONG pos);
    IPTR Remove(LONG pos);
    IPTR Select(LONG pos, LONG seltype, LONG * state);
    IPTR Sort(void);
    IPTR TestPos(LONG x, LONG y, struct MUI_List_TestPos_Result * res);
};

#endif /* CTMUI_LIST_H */

