/* 
 * File:   CMUI_Window.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 26 listopada 2015, 21:03
 */

#include "CMUI_Window.h"

CMUI_Window::CMUI_Window()
: CMUI_Notify() {
}

CMUI_Window::CMUI_Window(TagItem* tags)
: CMUI_Notify() {
#ifdef MUIPP_DEBUG
    _CheckTagsSpecified("CMUI_Window", tags, MUIA_Window_RootObject, "MUIA_Window_RootObject", TAG_DONE);
#endif
    object = MUI_NewObjectA(MUIC_Window, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Window object\n");
#endif
}

CMUI_Window::CMUI_Window(Tag tag1, ...)
: CMUI_Notify() {
#ifdef MUIPP_DEBUG
    _CheckTagsSpecified("CMUI_Window", (struct TagItem *) &tag1, MUIA_Window_RootObject, "MUIA_Window_RootObject", TAG_DONE);
#endif
    object = MUI_NewObjectA(MUIC_Window, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Window object\n");
#endif
}

CMUI_Window & CMUI_Window::operator=(Object *obj) {
    object = obj;
    return *this;
}

BOOL CMUI_Window::Activate(void) const {
    return (BOOL) MGetAttr(MUIA_Window_Activate);
}

void CMUI_Window::SetActivate(BOOL value) {
    SetAttr(MUIA_Window_Activate, (IPTR) value);
}

Object * CMUI_Window::ActiveObject(void) const {
    return (Object *) MGetAttr(MUIA_Window_ActiveObject);
}

void CMUI_Window::SetActiveObject(Object * value) {
    SetAttr(MUIA_Window_ActiveObject, (IPTR) value);
}

LONG CMUI_Window::AltHeight(void) const {
    return (LONG) MGetAttr(MUIA_Window_AltHeight);
}

LONG CMUI_Window::AltLeftEdge(void) const {
    return (LONG) MGetAttr(MUIA_Window_AltLeftEdge);
}

LONG CMUI_Window::AltTopEdge(void) const {
    return (LONG) MGetAttr(MUIA_Window_AltTopEdge);
}

LONG CMUI_Window::AltWidth(void) const {
    return (LONG) MGetAttr(MUIA_Window_AltWidth);
}

BOOL CMUI_Window::CloseRequest(void) const {
    return (BOOL) MGetAttr(MUIA_Window_CloseRequest);
}

Object * CMUI_Window::DefaultObject(void) const {
    return (Object *) MGetAttr(MUIA_Window_DefaultObject);
}

void CMUI_Window::SetDefaultObject(Object * value) {
    SetAttr(MUIA_Window_DefaultObject, (IPTR) value);
}

BOOL CMUI_Window::FancyDrawing(void) const {
    return (BOOL) MGetAttr(MUIA_Window_FancyDrawing);
}

void CMUI_Window::SetFancyDrawing(BOOL value) {
    SetAttr(MUIA_Window_FancyDrawing, (IPTR) value);
}

LONG CMUI_Window::Height(void) const {
    return (LONG) MGetAttr(MUIA_Window_Height);
}

IPTR CMUI_Window::ID(void) const {
    return (IPTR) MGetAttr(MUIA_Window_ID);
}

void CMUI_Window::SetID(IPTR value) {
    SetAttr(MUIA_Window_ID, (IPTR) value);
}

struct InputEvent * CMUI_Window::InputEvent(void) const {
    return (struct InputEvent *) MGetAttr(MUIA_Window_InputEvent);
}

BOOL CMUI_Window::IsSubWindow(void) const {
    return (BOOL) MGetAttr(MUIA_Window_IsSubWindow);
}

void CMUI_Window::SetIsSubWindow(BOOL value) {
    SetAttr(MUIA_Window_IsSubWindow, (IPTR) value);
}

LONG CMUI_Window::LeftEdge(void) const {
    return (LONG) MGetAttr(MUIA_Window_LeftEdge);
}

IPTR CMUI_Window::MenuAction(void) const {
    return (IPTR) MGetAttr(MUIA_Window_MenuAction);
}

void CMUI_Window::SetMenuAction(IPTR value) {
    SetAttr(MUIA_Window_MenuAction, (IPTR) value);
}

Object * CMUI_Window::Menustrip(void) const {
    return (Object *) MGetAttr(MUIA_Window_Menustrip);
}

Object * CMUI_Window::MouseObject(void) const {
    return (Object *) MGetAttr(MUIA_Window_MouseObject);
}

void CMUI_Window::SetNoMenus(BOOL value) {
    SetAttr(MUIA_Window_NoMenus, (IPTR) value);
}

BOOL CMUI_Window::Open(void) const {
    return (BOOL) MGetAttr(MUIA_Window_Open);
}

void CMUI_Window::SetOpen(BOOL value) {
    SetAttr(MUIA_Window_Open, (IPTR) value);
}

STRPTR CMUI_Window::PublicScreen(void) const {
    return (STRPTR) MGetAttr(MUIA_Window_PublicScreen);
}

void CMUI_Window::SetPublicScreen(STRPTR value) {
    SetAttr(MUIA_Window_PublicScreen, (IPTR) value);
}

void CMUI_Window::SetRefWindow(Object * value) {
    SetAttr(MUIA_Window_RefWindow, (IPTR) value);
}

Object * CMUI_Window::RootObject(void) const {
    return (Object *) MGetAttr(MUIA_Window_RootObject);
}

void CMUI_Window::SetRootObject(Object * value) {
    SetAttr(MUIA_Window_RootObject, (IPTR) value);
}

struct Screen * CMUI_Window::Screen(void) const {
    return (struct Screen *) MGetAttr(MUIA_Window_Screen);
}

void CMUI_Window::SetScreen(struct Screen * value) {
    SetAttr(MUIA_Window_Screen, (IPTR) value);
}

STRPTR CMUI_Window::ScreenTitle(void) const {
    return (STRPTR) MGetAttr(MUIA_Window_ScreenTitle);
}

void CMUI_Window::SetScreenTitle(STRPTR value) {
    SetAttr(MUIA_Window_ScreenTitle, (IPTR) value);
}

BOOL CMUI_Window::Sleep(void) const {
    return (BOOL) MGetAttr(MUIA_Window_Sleep);
}

void CMUI_Window::SetSleep(BOOL value) {
    SetAttr(MUIA_Window_Sleep, (IPTR) value);
}

STRPTR CMUI_Window::Title(void) const {
    return (STRPTR) MGetAttr(MUIA_Window_Title);
}

void CMUI_Window::SetTitle(STRPTR value) {
    SetAttr(MUIA_Window_Title, (IPTR) value);
}

LONG CMUI_Window::TopEdge(void) const {
    return (LONG) MGetAttr(MUIA_Window_TopEdge);
}

BOOL CMUI_Window::UseBottomBorderScroller(void) const {
    return (BOOL) MGetAttr(MUIA_Window_UseBottomBorderScroller);
}

void CMUI_Window::SetUseBottomBorderScroller(BOOL value) {
    SetAttr(MUIA_Window_UseBottomBorderScroller, (IPTR) value);
}

BOOL CMUI_Window::UseLeftBorderScroller(void) const {
    return (BOOL) MGetAttr(MUIA_Window_UseLeftBorderScroller);
}

void CMUI_Window::SetUseLeftBorderScroller(BOOL value) {
    SetAttr(MUIA_Window_UseLeftBorderScroller, (IPTR) value);
}

BOOL CMUI_Window::UseRightBorderScroller(void) const {
    return (BOOL) MGetAttr(MUIA_Window_UseRightBorderScroller);
}

void CMUI_Window::SetUseRightBorderScroller(BOOL value) {
    SetAttr(MUIA_Window_UseRightBorderScroller, (IPTR) value);
}

LONG CMUI_Window::Width(void) const {
    return (LONG) MGetAttr(MUIA_Window_Width);
}

struct Window * CMUI_Window::Window(void) const {
    return (struct Window *) MGetAttr(MUIA_Window_Window);
}

IPTR CMUI_Window::AddEventHandler(struct MUI_EventHandlerNode * ehnode) {
    return MDoMethod(MUIM_Window_AddEventHandler, ehnode);
}

IPTR CMUI_Window::RemEventHandler(struct MUI_EventHandlerNode * ehnode) {
    return MDoMethod(MUIM_Window_RemEventHandler, ehnode);
}

IPTR CMUI_Window::MScreenToBack(void) {
    return MDoMethod(MUIM_Window_ScreenToBack);
}

IPTR CMUI_Window::MScreenToFront(void) {
    return MDoMethod(MUIM_Window_ScreenToFront);
}

IPTR CMUI_Window::Snapshot(LONG flags) {
    return MDoMethod(MUIM_Window_Snapshot, flags);
}

IPTR CMUI_Window::ToBack(void) {
    return MDoMethod(MUIM_Window_ToBack);
}

IPTR CMUI_Window::ToFront(void) {
    return MDoMethod(MUIM_Window_ToFront);
}
