/* 
 * File:   CMUI_Text.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 29 listopada 2015, 08:14
 */

#include "CMUI_Text.h"

CMUI_Text::CMUI_Text()
: CMUI_Area() {
}

CMUI_Text::CMUI_Text(TagItem* tags)
: CMUI_Area() {
    object = MUI_NewObjectA(MUIC_Text, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Text object\n");
#endif
}

CMUI_Text::CMUI_Text(Tag tag1, ...)
: CMUI_Area() {
    object = MUI_NewObjectA(MUIC_Text, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Text object\n");
#endif
}

CMUI_Text::CMUI_Text(Object* obj)
: CMUI_Area() {
    object = obj;
}

CMUI_Text& CMUI_Text::operator=(Object* obj) {
    object = obj;
    return *this;
}

CMUI_Text::operator const char * () {
    return (const char *) Contents();
}

STRPTR CMUI_Text::Contents(void) const {
    return (STRPTR) MGetAttr(MUIA_Text_Contents);
}

void CMUI_Text::SetContents(STRPTR value) {
    SetAttr(MUIA_Text_Contents, (IPTR) value);
}

STRPTR CMUI_Text::PreParse(void) const {
    return (STRPTR) MGetAttr(MUIA_Text_PreParse);
}

void CMUI_Text::SetPreParse(STRPTR value) {
    SetAttr(MUIA_Text_PreParse, (IPTR) value);
}
