/* 
 * File:   CMUI_String.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 30 listopada 2015, 18:28
 */

#include "CMUI_String.h"

CMUI_String::CMUI_String()
: CMUI_Gadget() {
}

CMUI_String::CMUI_String(TagItem* tags)
: CMUI_Gadget() {
    object = MUI_NewObjectA(MUIC_String, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_String object\n");
#endif
}

CMUI_String::CMUI_String(Tag tag1, ...)
: CMUI_Gadget() {
    object = MUI_NewObjectA(MUIC_String, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_String object\n");
#endif
}

CMUI_String::CMUI_String(Object* obj)
: CMUI_Gadget() {
    object = obj;
}

CMUI_String::CMUI_String(STRPTR label, LONG maxlen)
: CMUI_Gadget() {
    object = MUI_MakeObject(MUIO_String, label, maxlen);
}

CMUI_String& CMUI_String::operator=(Object* obj) {
    object = obj;
    return *this;
}

CMUI_String::operator IPTR() {
    return Integer();
}

CMUI_String::operator const char * () {
    return (const char *) Contents();
}

STRPTR CMUI_String::Accept(void) const {
    return (STRPTR) MGetAttr(MUIA_String_Accept);
}

void CMUI_String::SetAccept(STRPTR value) {
    SetAttr(MUIA_String_Accept, (IPTR) value);
}

STRPTR CMUI_String::Acknowledge(void) const {
    return (STRPTR) MGetAttr(MUIA_String_Acknowledge);
}

BOOL CMUI_String::AdvanceOnCR(void) const {
    return (BOOL) MGetAttr(MUIA_String_AdvanceOnCR);
}

void CMUI_String::SetAdvanceOnCR(BOOL value) {
    SetAttr(MUIA_String_AdvanceOnCR, (IPTR) value);
}

Object * CMUI_String::AttachedList(void) const {
    return (Object *) MGetAttr(MUIA_String_AttachedList);
}

void CMUI_String::SetAttachedList(Object * value) {
    SetAttr(MUIA_String_AttachedList, (IPTR) value);
}

LONG CMUI_String::BufferPos(void) const {
    return (LONG) MGetAttr(MUIA_String_BufferPos);
}

void CMUI_String::SetBufferPos(LONG value) {
    SetAttr(MUIA_String_BufferPos, (IPTR) value);
}

STRPTR CMUI_String::Contents(void) const {
    return (STRPTR) MGetAttr(MUIA_String_Contents);
}

void CMUI_String::SetContents(STRPTR value) {
    SetAttr(MUIA_String_Contents, (IPTR) value);
}

LONG CMUI_String::DisplayPos(void) const {
    return (LONG) MGetAttr(MUIA_String_DisplayPos);
}

void CMUI_String::SetDisplayPos(LONG value) {
    SetAttr(MUIA_String_DisplayPos, (IPTR) value);
}

struct Hook * CMUI_String::EditHook(void) const {
    return (struct Hook *) MGetAttr(MUIA_String_EditHook);
}

void CMUI_String::MSetEditHook(struct Hook * value) {
    SetAttr(MUIA_String_EditHook, (IPTR) value);
}

LONG CMUI_String::Format(void) const {
    return (LONG) MGetAttr(MUIA_String_Format);
}

IPTR CMUI_String::Integer(void) const {
    return (IPTR) MGetAttr(MUIA_String_Integer);
}

void CMUI_String::SetInteger(IPTR value) {
    SetAttr(MUIA_String_Integer, (IPTR) value);
}

BOOL CMUI_String::LonelyEditHook(void) const {
    return (BOOL) MGetAttr(MUIA_String_LonelyEditHook);
}

void CMUI_String::SetLonelyEditHook(BOOL value) {
    SetAttr(MUIA_String_LonelyEditHook, (IPTR) value);
}

LONG CMUI_String::MaxLen(void) const {
    return (LONG) MGetAttr(MUIA_String_MaxLen);
}

STRPTR CMUI_String::Reject(void) const {
    return (STRPTR) MGetAttr(MUIA_String_Reject);
}

void CMUI_String::SetReject(STRPTR value) {
    SetAttr(MUIA_String_Reject, (IPTR) value);
}

BOOL CMUI_String::Secret(void) const {
    return (BOOL) MGetAttr(MUIA_String_Secret);
}
