/* 
 * File:   CMUI_Rectangle.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 29 listopada 2015, 21:28
 */

#include "CMUI_Rectangle.h"

CMUI_Rectangle::CMUI_Rectangle()
: CMUI_Area() {
}

CMUI_Rectangle::CMUI_Rectangle(TagItem* tags)
: CMUI_Area() {
    object = MUI_NewObjectA(MUIC_Rectangle, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Rectangle object\n");
#endif
}

CMUI_Rectangle::CMUI_Rectangle(Tag tag1, ...)
: CMUI_Area() {
    object = MUI_NewObjectA(MUIC_Rectangle, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Rectangle object\n");
#endif
}

CMUI_Rectangle::CMUI_Rectangle(Object* obj)
: CMUI_Area() {
    object = obj;
}

CMUI_Rectangle& CMUI_Rectangle::operator=(Object* obj) {
    object = obj;
    return *this;
}

STRPTR CMUI_Rectangle::BarTitle(void) const {
    return (STRPTR) MGetAttr(MUIA_Rectangle_BarTitle);
}

BOOL CMUI_Rectangle::MHBar(void) const {
    return (BOOL) MGetAttr(MUIA_Rectangle_HBar);
}

BOOL CMUI_Rectangle::MVBar(void) const {
    return (BOOL) MGetAttr(MUIA_Rectangle_VBar);
}
