/* 
 * File:   CMUI_Object.h
 * Author: Piotr Hoppe
 *
 * Created on 11 listopada 2015, 00:15
 */

#ifndef CMUI_OBJECT_H
#define CMUI_OBJECT_H

#include <libraries/muiplus/mui_declarations.hpp>

class CMUI_Object {
public:
    CMUI_Object();

    BOOL IsValid(void) const;
    IPTR MGetAttr(Tag attr, IPTR *value) const;
    IPTR MGetAttr(Tag attr) const;
    void SetAttr(Tag attr, IPTR value);
    IPTR MDoMethod(IPTR methodID, ...);
    IPTR MDoMethodA(Msg msg);
    void Dispose(void);

    Object * operator*() const;
    Tag operator()() const;
    void AddMember(Object *child);
    void RemMember(Object *child);
protected:
    Object *object; // Pointer to MUI BOOPSI based object
};

#endif /* CMUI_OBJECT_H */

