/* 
 * File:   CMUI_Object.cpp
 * Author: piotr
 * 
 * Created on 11 listopada 2015, 00:15
 */

#include "CMUI_Object.h"

CMUI_Object::CMUI_Object() {
    object = NULL;
}

/*
    If you wish to check if the object was created successfully then
    call this.
 */

BOOL CMUI_Object::IsValid() const {
    return (object != NULL);
}

/*
    Methods to get and set attributes by tag ID. You can use these
    in derived classes to get and set attributes, instead of having
    to call the intuition.library/GetAttr() and SetAttrs() functions.

    Get value of attribute and place value in supplied value address.
 */

IPTR CMUI_Object::MGetAttr(Tag attr, IPTR *value) const {
    return GetAttr(attr, object, value);
}

// Get and return value of attribute

IPTR CMUI_Object::MGetAttr(Tag attr) const {
    IPTR value;
    MGetAttr(attr, &value);
    return value;
}

void CMUI_Object::SetAttr(Tag attr, IPTR value) {
    SetAttrs(object, attr, value, TAG_DONE);
}

// Call a method on this object specified by the supplied method id
// and parameters.

IPTR CMUI_Object::MDoMethod(IPTR methodID, ...) {
    return DoMethodA(object, (Msg) & methodID);
}

IPTR CMUI_Object::MDoMethodA(Msg msg) {
    return DoMethodA(object, msg);
}

// This can be called to dispose of an object
// Note: this should only be called for objects that are allocated
// dynamically and are not disposed when the application object gets
// disposed. If debugging is turned on then a warning message will
// be printed if you try to do this and the object won't be disposed.

void CMUI_Object::Dispose(void) {
#ifdef MUIPP_DEBUG
    if ((Object *) GetAttr(MUIA_Parent) != NULL) {
        _MUIPPWarning("Tried to dispose an object that has a parent object:\n"
            "Object not disposed\n");
        return;
    }
#endif
    MUI_DisposeObject(object);
    object = NULL;
}

// Coersion to BOOPSI objects and to Tags

Object *CMUI_Object::operator*() const {
    return object;
}

Tag CMUI_Object::operator()() const {
    return (Tag) object;
}

// Dynamically adding and removing objects

void CMUI_Object::AddMember(Object *child) {
    MDoMethod(OM_ADDMEMBER, child);
}

void CMUI_Object::RemMember(Object *child) {
    MDoMethod(OM_REMMEMBER, child);
}
