/* 
 * File:   CMUI_Numericbutton.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 2 grudnia 2015, 21:22
 */

#include "CMUI_Numericbutton.h"

CMUI_Numericbutton::CMUI_Numericbutton()
: CMUI_Numeric() {
}

CMUI_Numericbutton::CMUI_Numericbutton(TagItem* tags)
: CMUI_Numeric() {
    object = MUI_NewObjectA(MUIC_Numericbutton, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Numericbutton object\n");
#endif
}

CMUI_Numericbutton::CMUI_Numericbutton(Tag tag1, ...)
: CMUI_Numeric() {
    object = MUI_NewObjectA(MUIC_Numericbutton, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Numericbutton object\n");
#endif
}

CMUI_Numericbutton::CMUI_Numericbutton(Object* obj)
: CMUI_Numeric() {
    object = obj;
}

CMUI_Numericbutton::CMUI_Numericbutton(STRPTR label, LONG min, LONG max, STRPTR format)
: CMUI_Numeric() {
    object = MUI_MakeObject(MUIO_NumericButton, label, min, max, format);
}

CMUI_Numericbutton& CMUI_Numericbutton::operator=(Object* obj) {
    object = obj;
    return *this;
}
