/* 
 * File:   CMUI_Numeric.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 30 listopada 2015, 21:37
 */

#include "CMUI_Numeric.h"

BOOL CMUI_Numeric::CheckAllSizes(void) const {
    return (BOOL) MGetAttr(MUIA_Numeric_CheckAllSizes);
}

void CMUI_Numeric::SetCheckAllSizes(BOOL value) {
    SetAttr(MUIA_Numeric_CheckAllSizes, (IPTR) value);
}

LONG CMUI_Numeric::Default(void) const {
    return (LONG) MGetAttr(MUIA_Numeric_Default);
}

void CMUI_Numeric::SetDefault(LONG value) {
    SetAttr(MUIA_Numeric_Default, (IPTR) value);
}

STRPTR CMUI_Numeric::Format(void) const {
    return (STRPTR) MGetAttr(MUIA_Numeric_Format);
}

void CMUI_Numeric::SetFormat(STRPTR value) {
    SetAttr(MUIA_Numeric_Format, (IPTR) value);
}

LONG CMUI_Numeric::Max(void) const {
    return (LONG) MGetAttr(MUIA_Numeric_Max);
}

void CMUI_Numeric::SetMax(LONG value) {
    SetAttr(MUIA_Numeric_Max, (IPTR) value);
}

LONG CMUI_Numeric::Min(void) const {
    return (LONG) MGetAttr(MUIA_Numeric_Min);
}

void CMUI_Numeric::SetMin(LONG value) {
    SetAttr(MUIA_Numeric_Min, (IPTR) value);
}

BOOL CMUI_Numeric::Reverse(void) const {
    return (BOOL) MGetAttr(MUIA_Numeric_Reverse);
}

void CMUI_Numeric::SetReverse(BOOL value) {
    SetAttr(MUIA_Numeric_Reverse, (IPTR) value);
}

BOOL CMUI_Numeric::RevLeftRight(void) const {
    return (BOOL) MGetAttr(MUIA_Numeric_RevLeftRight);
}

void CMUI_Numeric::SetRevLeftRight(BOOL value) {
    SetAttr(MUIA_Numeric_RevLeftRight, (IPTR) value);
}

BOOL CMUI_Numeric::RevUpDown(void) const {
    return (BOOL) MGetAttr(MUIA_Numeric_RevUpDown);
}

void CMUI_Numeric::SetRevUpDown(BOOL value) {
    SetAttr(MUIA_Numeric_RevUpDown, (IPTR) value);
}

LONG CMUI_Numeric::Value(void) const {
    return (LONG) MGetAttr(MUIA_Numeric_Value);
}

void CMUI_Numeric::SetValue(LONG value) {
    SetAttr(MUIA_Numeric_Value, (IPTR) value);
}

IPTR CMUI_Numeric::Decrease(LONG amount) {
    return MDoMethod(MUIM_Numeric_Decrease, amount);
}

IPTR CMUI_Numeric::Increase(LONG amount) {
    return MDoMethod(MUIM_Numeric_Increase, amount);
}

IPTR CMUI_Numeric::ScaleToValue(LONG scalemin, LONG scalemax, LONG scale) {
    return MDoMethod(MUIM_Numeric_ScaleToValue, scalemin, scalemax, scale);
}

IPTR CMUI_Numeric::SetDefault(void) {
    return MDoMethod(MUIM_Numeric_SetDefault);
}

IPTR CMUI_Numeric::Stringify(LONG value) {
    return MDoMethod(MUIM_Numeric_Stringify, value);
}

IPTR CMUI_Numeric::ValueToScale(LONG scalemin, LONG scalemax) {
    return MDoMethod(MUIM_Numeric_ValueToScale, scalemin, scalemax);
}

//CMUI_Numeric::operator LONG() {
//    return Value();
//}

CMUI_Numeric::operator int () {
    return (int) Value();
}
//
//CMUI_Numeric & CMUI_Numeric::operator=(LONG value) {
//    SetValue(value);
//    return *this;
//}

CMUI_Numeric & CMUI_Numeric::operator=(int value) {
    SetValue((LONG) value);
    return *this;
}

CMUI_Numeric CMUI_Numeric::operator++() // prefix
{
    Increase(1);
    return *this;
}

CMUI_Numeric CMUI_Numeric::operator++(int dummy) // postfix
{
    Increase(1);
    return *this;
}

CMUI_Numeric & CMUI_Numeric::operator+=(LONG value) {
    Increase(value);
    return *this;
}

CMUI_Numeric CMUI_Numeric::operator--() // prefix
{
    Decrease(1);
    return *this;
}

CMUI_Numeric CMUI_Numeric::operator--(int dummy) // postfix
{
    Decrease(1);
    return *this;
}

CMUI_Numeric & CMUI_Numeric::operator-=(LONG value) {
    Decrease(value);
    return *this;
}

CMUI_Numeric::CMUI_Numeric()
: CMUI_Area() {
}
